/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputFileName;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterAttachNewFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fileName", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.jupyter.core"})
public final class JupyterAttachNewFileAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final JupyterDataInputFileName fileName;
    @NotNull
    private static final String[] SUPPORTED_EXTENSIONS;
    private static final FileChooserDescriptor tableDataFileChooserDescriptor;

    public JupyterAttachNewFileAction(@NotNull Editor editor, @NotNull JupyterDataInputFileName fileName) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        super(JupyterBundle.message("jupyter.data.input.toolbar.attach.new.file", new Object[0]), null, AllIcons.Actions.Upload);
        this.editor = editor;
        this.fileName = fileName;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Companion.attachNewFile$intellij_jupyter_core(project2, this.editor, this.fileName);
    }

    static {
        String[] stringArray = new String[]{"csv", "tsv", "xls", "xlsx", "xlsm"};
        SUPPORTED_EXTENSIONS = stringArray;
        stringArray = SUPPORTED_EXTENSIONS;
        tableDataFileChooserDescriptor = FileChooserDescriptorFactory.singleFile().withExtensionFilter(JupyterBundle.message("jupyter.data.input.data.files", new Object[0]), Arrays.copyOf(stringArray, stringArray.length));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001e\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterAttachNewFileAction$Companion;", "", "<init>", "()V", "attachNewFile", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fileName", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;", "attachNewFile$intellij_jupyter_core", "SUPPORTED_EXTENSIONS", "", "", "[Ljava/lang/String;", "tableDataFileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "kotlin.jvm.PlatformType", "getTableDataFileChooserDescriptor$intellij_jupyter_core", "()Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void attachNewFile$intellij_jupyter_core(@NotNull Project project, @NotNull Editor editor, @NotNull JupyterDataInputFileName fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Object object = FileChooser.chooseFile((FileChooserDescriptor)this.getTableDataFileChooserDescriptor$intellij_jupyter_core(), (Project)project, null);
            if (object == null || (object = object.toNioPath()) == null) {
                return;
            }
            Object file = object;
            Path relativePath = editor.getVirtualFile().getParent().toNioPath().toAbsolutePath().relativize(file.toAbsolutePath());
            fileName.set(((Object)relativePath).toString());
        }

        public final FileChooserDescriptor getTableDataFileChooserDescriptor$intellij_jupyter_core() {
            return tableDataFileChooserDescriptor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

