/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.lang.qml.lsp;

import com.intellij.clion.lang.qml.lsp.QmlServerDescriptor;
import com.intellij.lang.qml.QmlCommonIcons;
import com.intellij.lang.qml.QmlFileType;
import com.intellij.lang.qml.settings.QmlConfigurable;
import com.intellij.lang.qml.settings.QmlSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.lsWidget.LspServerWidgetItem;
import com.intellij.qt.common.settings.QtSettings;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QmlServerProvider
implements LspServerSupportProvider {
    public void fileOpened(@NotNull Project project, @NotNull VirtualFile file, @NotNull LspServerSupportProvider.LspServerStarter serverStarter) {
        LspServerDescriptor descriptor;
        if (project == null) {
            QmlServerProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            QmlServerProvider.$$$reportNull$$$0(1);
        }
        if (serverStarter == null) {
            QmlServerProvider.$$$reportNull$$$0(2);
        }
        if (file.getFileType() == QmlFileType.INSTANCE && (descriptor = QmlServerProvider.createDescriptor(project)) != null) {
            serverStarter.ensureServerStarted(descriptor);
        }
    }

    @NotNull
    public LspServerWidgetItem createLspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile) {
        if (lspServer == null) {
            QmlServerProvider.$$$reportNull$$$0(3);
        }
        return new LspServerWidgetItem(lspServer, currentFile, QmlCommonIcons.Qml, QmlConfigurable.class);
    }

    @Nullable
    public static LspServerDescriptor createDescriptor(@NotNull Project project) {
        if (project == null) {
            QmlServerProvider.$$$reportNull$$$0(4);
        }
        QtSettings qtSettings = QtSettings.getInstance((Project)project);
        QmlSettings qmlSettings = QmlSettings.getInstance(project);
        if (!qmlSettings.isQmlLSEnabledAndExists(qtSettings.getCurrentProfile())) {
            return null;
        }
        String qmlLSPath = qmlSettings.findQmlLanguageServerPath();
        String buildPath = PathUtil.toSystemDependentName((String)QmlServerProvider.getBuildPath(project));
        if (StringUtil.isNotEmpty((String)qmlLSPath) && StringUtil.isNotEmpty((String)buildPath)) {
            return new QmlServerDescriptor(project, qmlLSPath, buildPath);
        }
        return null;
    }

    @NotNull
    private static String getBuildPath(@NotNull Project project) {
        CMakeWorkspace cmakeWorkspace;
        if (project == null) {
            QmlServerProvider.$$$reportNull$$$0(5);
        }
        if (!(cmakeWorkspace = CMakeWorkspace.getInstance((Project)project)).isInitialized()) {
            return "";
        }
        String curProfileName = (String)ApplicationManager.getApplication().runReadAction(() -> {
            @Nullable CMakeBuildProfileExecutionTarget currentBuildProfile = CMakeAppRunConfiguration.getSelectedBuildProfile((Project)project);
            if (currentBuildProfile != null) {
                return currentBuildProfile.getProfileName();
            }
            return "";
        });
        if (curProfileName.isEmpty()) {
            return "";
        }
        CMakeProfileInfo profileInfo = cmakeWorkspace.getCMakeProfileInfoByName(curProfileName);
        String string = profileInfo == null ? "" : PathUtil.toSystemDependentName((String)profileInfo.getGenerationDir().getPath());
        if (string == null) {
            QmlServerProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverStarter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lspServer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/lang/qml/lsp/QmlServerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/lang/qml/lsp/QmlServerProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLspServerWidgetItem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBuildPath";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

