/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.math3;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H$J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H$\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/ContinuedFraction;", "", "()V", "evaluate", "", "x", "epsilon", "maxIterations", "", "getA", "n", "getB", "Companion", "plot-base"})
public abstract class ContinuedFraction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double DEFAULT_EPSILON = 1.0E-8;

    protected ContinuedFraction() {
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public final double evaluate(double x2, int maxIterations) {
        return this.evaluate(x2, DEFAULT_EPSILON, maxIterations);
    }

    @JvmOverloads
    public final double evaluate(double x2, double epsilon, int maxIterations) {
        double p0 = 1.0;
        double p1 = this.getA(0, x2);
        double q0 = 0.0;
        double q1 = 1.0;
        double c = p1 / q1;
        int n = 0;
        double relativeError = Double.MAX_VALUE;
        while (n < maxIterations && relativeError > epsilon) {
            double a2 = this.getA(++n, x2);
            double b2 = this.getB(n, x2);
            double p2 = a2 * p1 + b2 * p0;
            double q2 = a2 * q1 + b2 * q0;
            boolean infinite = false;
            if (Double.isInfinite(p2) || Double.isInfinite(q2)) {
                double scaleFactor = 1.0;
                double lastScaleFactor = 1.0;
                int maxPower = 5;
                double scale = Math.max(a2, b2);
                if (scale <= 0.0) {
                    throw new IllegalStateException("ConvergenceException".toString());
                }
                infinite = true;
                for (int i = 0; i < maxPower; ++i) {
                    lastScaleFactor = scaleFactor;
                    scaleFactor *= scale;
                    if (!(a2 == 0.0) && a2 > b2) {
                        p2 = p1 / lastScaleFactor + b2 / scaleFactor * p0;
                        q2 = q1 / lastScaleFactor + b2 / scaleFactor * q0;
                    } else if (!(b2 == 0.0)) {
                        p2 = a2 / scaleFactor * p1 + p0 / lastScaleFactor;
                        q2 = a2 / scaleFactor * q1 + q0 / lastScaleFactor;
                    }
                    boolean bl = infinite = Double.isInfinite(p2) || Double.isInfinite(q2);
                    if (!infinite) break;
                }
            }
            if (infinite) {
                throw new IllegalStateException("ConvergenceException".toString());
            }
            double r = p2 / q2;
            if (Double.isNaN(r)) {
                throw new IllegalStateException("ConvergenceException".toString());
            }
            relativeError = Math.abs(r / c - 1.0);
            c = p2 / q2;
            p0 = p1;
            p1 = p2;
            q0 = q1;
            q1 = q2;
        }
        if (n >= maxIterations) {
            throw new IllegalStateException("MaxCountExceeded".toString());
        }
        return c;
    }

    public static /* synthetic */ double evaluate$default(ContinuedFraction continuedFraction, double d, double d2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: evaluate");
        }
        if ((n2 & 2) != 0) {
            d2 = DEFAULT_EPSILON;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return continuedFraction.evaluate(d, d2, n);
    }

    @JvmOverloads
    public final double evaluate(double x2, double epsilon) {
        return ContinuedFraction.evaluate$default(this, x2, epsilon, 0, 4, null);
    }

    @JvmOverloads
    public final double evaluate(double x2) {
        return ContinuedFraction.evaluate$default(this, x2, 0.0, 0, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/ContinuedFraction$Companion;", "", "()V", "DEFAULT_EPSILON", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

