/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.coord;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapperKt;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 \"2\u00020\u0001:\u0001\"BU\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001c\u001a\u00020\u0000J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u0010J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0002R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;", "", "hScaleMapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "", "hScaleInverseMapper", "vScaleMapper", "vScaleInverseMapper", "clientBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "flipAxis", "", "(Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;Z)V", "cachedUnitSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getClientBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getHScaleInverseMapper", "()Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "getHScaleMapper", "isLinear", "()Z", "getProjection$plot_base", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "getVScaleInverseMapper", "getVScaleMapper", "flip", "fromClient", "p", "toClient", "unitSize", "unitSizeIntern", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nCoordinatesMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinatesMapper.kt\norg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public final class CoordinatesMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScaleMapper<Double> hScaleMapper;
    @NotNull
    private final ScaleMapper<Double> hScaleInverseMapper;
    @NotNull
    private final ScaleMapper<Double> vScaleMapper;
    @NotNull
    private final ScaleMapper<Double> vScaleInverseMapper;
    @NotNull
    private final DoubleRectangle clientBounds;
    @NotNull
    private final Projection projection;
    private final boolean flipAxis;
    @Nullable
    private DoubleVector cachedUnitSize;
    private final boolean isLinear;

    public CoordinatesMapper(@NotNull ScaleMapper<Double> hScaleMapper, @NotNull ScaleMapper<Double> hScaleInverseMapper, @NotNull ScaleMapper<Double> vScaleMapper, @NotNull ScaleMapper<Double> vScaleInverseMapper, @NotNull DoubleRectangle clientBounds, @NotNull Projection projection, boolean flipAxis) {
        Intrinsics.checkNotNullParameter(hScaleMapper, (String)"hScaleMapper");
        Intrinsics.checkNotNullParameter(hScaleInverseMapper, (String)"hScaleInverseMapper");
        Intrinsics.checkNotNullParameter(vScaleMapper, (String)"vScaleMapper");
        Intrinsics.checkNotNullParameter(vScaleInverseMapper, (String)"vScaleInverseMapper");
        Intrinsics.checkNotNullParameter((Object)clientBounds, (String)"clientBounds");
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        this.hScaleMapper = hScaleMapper;
        this.hScaleInverseMapper = hScaleInverseMapper;
        this.vScaleMapper = vScaleMapper;
        this.vScaleInverseMapper = vScaleInverseMapper;
        this.clientBounds = clientBounds;
        this.projection = projection;
        this.flipAxis = flipAxis;
        this.isLinear = !this.projection.getNonlinear();
    }

    @NotNull
    public final ScaleMapper<Double> getHScaleMapper() {
        return this.hScaleMapper;
    }

    @NotNull
    public final ScaleMapper<Double> getHScaleInverseMapper() {
        return this.hScaleInverseMapper;
    }

    @NotNull
    public final ScaleMapper<Double> getVScaleMapper() {
        return this.vScaleMapper;
    }

    @NotNull
    public final ScaleMapper<Double> getVScaleInverseMapper() {
        return this.vScaleInverseMapper;
    }

    @NotNull
    public final DoubleRectangle getClientBounds() {
        return this.clientBounds;
    }

    @NotNull
    public final Projection getProjection$plot_base() {
        return this.projection;
    }

    public final boolean isLinear() {
        return this.isLinear;
    }

    @Nullable
    public final DoubleVector toClient(@NotNull DoubleVector p) {
        DoubleVector doubleVector;
        DoubleVector doubleVector2;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector doubleVector3 = this.projection.project(p);
        if (doubleVector3 != null && (doubleVector2 = doubleVector3.flipIf(this.flipAxis)) != null) {
            DoubleVector doubleVector4 = doubleVector2;
            boolean bl = false;
            double projectedH = doubleVector4.component1();
            double projectedV = doubleVector4.component2();
            Double mappedH = this.hScaleMapper.invoke(projectedH);
            Double mappedV = this.vScaleMapper.invoke(projectedV);
            doubleVector = mappedH != null && mappedV != null ? new DoubleVector(mappedH, mappedV) : null;
        } else {
            doubleVector = null;
        }
        return doubleVector;
    }

    @Nullable
    public final DoubleVector fromClient(@NotNull DoubleVector p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double mappedH = p.component1();
        double mappedV = p.component2();
        Double d = this.hScaleInverseMapper.invoke(mappedH);
        if (d == null) {
            return null;
        }
        double projectedH = d;
        Double d2 = this.vScaleInverseMapper.invoke(mappedV);
        if (d2 == null) {
            return null;
        }
        double projectedV = d2;
        DoubleVector projected = new DoubleVector(projectedH, projectedV).flipIf(this.flipAxis);
        return this.projection.invert(projected);
    }

    @NotNull
    public final DoubleVector unitSize(@NotNull DoubleVector p) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.projection.getNonlinear()) {
            doubleVector = this.unitSizeIntern(p);
        } else {
            if (this.cachedUnitSize == null) {
                this.cachedUnitSize = this.unitSizeIntern(p);
            }
            DoubleVector doubleVector2 = this.cachedUnitSize;
            doubleVector = doubleVector2;
            Intrinsics.checkNotNull((Object)doubleVector2);
        }
        return doubleVector;
    }

    private final DoubleVector unitSizeIntern(DoubleVector p) {
        DoubleVector c = Companion.toValidUnitSquareCenter(p, this.projection);
        CoordinatesMapper $this$unitSizeIntern_u24lambda_u241 = this;
        boolean bl = false;
        DoubleVector doubleVector = $this$unitSizeIntern_u24lambda_u241.toClient(new DoubleVector(c.getX() - 0.5, c.getY()));
        Intrinsics.checkNotNull((Object)doubleVector);
        DoubleVector p0 = doubleVector;
        DoubleVector doubleVector2 = $this$unitSizeIntern_u24lambda_u241.toClient(new DoubleVector(c.getX() + 0.5, c.getY()));
        Intrinsics.checkNotNull((Object)doubleVector2);
        DoubleVector p1 = doubleVector2;
        double width2 = p1.subtract(p0).length();
        CoordinatesMapper $this$unitSizeIntern_u24lambda_u242 = this;
        boolean bl2 = false;
        DoubleVector doubleVector3 = $this$unitSizeIntern_u24lambda_u242.toClient(new DoubleVector(c.getX(), c.getY() - 0.5));
        Intrinsics.checkNotNull((Object)doubleVector3);
        DoubleVector p02 = doubleVector3;
        DoubleVector doubleVector4 = $this$unitSizeIntern_u24lambda_u242.toClient(new DoubleVector(c.getX(), c.getY() + 0.5));
        Intrinsics.checkNotNull((Object)doubleVector4);
        DoubleVector p12 = doubleVector4;
        double height = p12.subtract(p02).length();
        return new DoubleVector(width2, height);
    }

    @NotNull
    public final CoordinatesMapper flip() {
        return new CoordinatesMapper(this.hScaleMapper, this.hScaleInverseMapper, this.vScaleMapper, this.vScaleInverseMapper, this.clientBounds, this.projection, !this.flipAxis);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "clientSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "flipAxis", "", "toValidUnitSquareCenter", "p", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CoordinatesMapper create(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize, @NotNull Projection projection, boolean flipAxis) {
            Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
            Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
            Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
            DoubleRectangle domainProjected = CoordinatesMapperKt.projectDomain(projection, adjustedDomain);
            DoubleRectangle hvDomain = domainProjected.flipIf(flipAxis);
            if (!(!(hvDomain.xRange().getLength() == 0.0))) {
                boolean $i$a$-check-CoordinatesMapper$Companion$create$32 = false;
                String $i$a$-check-CoordinatesMapper$Companion$create$32 = "Can't create coordinates mapper: X-domain size is 0.0";
                throw new IllegalStateException($i$a$-check-CoordinatesMapper$Companion$create$32.toString());
            }
            if (!(!(hvDomain.yRange().getLength() == 0.0))) {
                boolean $i$a$-check-CoordinatesMapper$Companion$create$42 = false;
                String $i$a$-check-CoordinatesMapper$Companion$create$42 = "Can't create coordinates mapper: Y-domain size is 0.0";
                throw new IllegalStateException($i$a$-check-CoordinatesMapper$Companion$create$42.toString());
            }
            ScaleMapper<Double> hScaleMapper = Mappers.INSTANCE.mul(hvDomain.xRange(), clientSize.getX());
            ScaleMapper<Double> hScaleInverseMapper = Mappers.INSTANCE.mul(new DoubleSpan(0.0, clientSize.getX()), hvDomain.xRange().getLength());
            ScaleMapper<Double> vScaleMapper = Mappers.INSTANCE.mul(hvDomain.yRange(), clientSize.getY());
            ScaleMapper<Double> vScaleInverseMapper = Mappers.INSTANCE.mul(new DoubleSpan(0.0, clientSize.getY()), hvDomain.yRange().getLength());
            Double d = hScaleMapper.invoke(hvDomain.getOrigin().getX());
            Intrinsics.checkNotNull((Object)d);
            double d2 = ((Number)d).doubleValue();
            Double d3 = vScaleMapper.invoke(hvDomain.getOrigin().getY());
            Intrinsics.checkNotNull((Object)d3);
            DoubleVector clientOrigin = new DoubleVector(d2, ((Number)d3).doubleValue());
            DoubleRectangle clientBounds = new DoubleRectangle(clientOrigin, clientSize);
            return new CoordinatesMapper(hScaleMapper, hScaleInverseMapper, vScaleMapper, vScaleInverseMapper, clientBounds, projection, flipAxis);
        }

        @NotNull
        public final DoubleVector toValidUnitSquareCenter(@NotNull DoubleVector p, @NotNull Projection projection) {
            double x2;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
            DoubleRectangle validDomain = projection.validDomain();
            double d = p.getX() < validDomain.getLeft() + 0.5 ? validDomain.getLeft() + 0.5 : (x2 = p.getX() > validDomain.getRight() - 0.5 ? validDomain.getRight() - 0.5 : p.getX());
            double y2 = p.getY() < validDomain.getTop() + 0.5 ? validDomain.getTop() + 0.5 : (p.getY() > validDomain.getBottom() - 0.5 ? validDomain.getBottom() - 0.5 : p.getY());
            return new DoubleVector(x2, y2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

