/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExpandNodeAction
extends DumbAwareAction {
    private final V8ProfilingCallTreeTable myTable;

    public ExpandNodeAction(V8ProfilingCallTreeTable table) {
        super(NodeJSBundle.messagePointer("action.ExpandNodeAction.expand.node.text", new Object[0]), NodeJSBundle.messagePointer("action.ExpandNodeAction.expand.node.recursively.description", new Object[0]), AllIcons.Actions.Expandall);
        this.myTable = table;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ExpandNodeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExpandNodeAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.myTable.getSelectedRow() >= 0);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        int row;
        if (e == null) {
            ExpandNodeAction.$$$reportNull$$$0(2);
        }
        if ((row = this.myTable.getSelectedRow()) >= 0) {
            TreeTableWidthController widthController = this.myTable.getWidthController();
            if (widthController != null) {
                widthController.startBatchExpand();
            }
            this.expandRowRecursively(row);
            if (widthController != null) {
                widthController.stopBatchExpand();
            }
        }
    }

    private void expandRowRecursively(int row) {
        this.myTable.getTree().expandRow(row);
        TreePath parentPath = this.myTable.getTree().getPathForRow(row);
        Object component = parentPath.getLastPathComponent();
        TreeTableModel model = this.myTable.getTableModel();
        int count = model.getChildCount(component);
        Object[] pathComponents = parentPath.getPath();
        for (int i = 0; i < count; ++i) {
            Object child = model.getChild(component, i);
            if (child == null) continue;
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(pathComponents));
            list.add(child);
            int childRow = this.myTable.getTree().getRowForPath(new TreePath(ArrayUtil.toObjectArray(list)));
            if (childRow < 0) continue;
            this.expandRowRecursively(childRow);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/view/ExpandNodeAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/ExpandNodeAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

