/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TaskManagementUsageCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("task.management", 2);
    private static final ClassEventField REPOSITORY_TYPE = EventFields.Class((String)"repository_type");
    private static final EventId1<Class<?>> COLLECT_REMOTE_TASKS = GROUP.registerEvent("collect.remote.tasks", (EventField)REPOSITORY_TYPE);
    private static final EventId1<Class<?>> OPEN_REMOTE_TASK = GROUP.registerEvent("open.remote.task", (EventField)REPOSITORY_TYPE);
    private static final EventId CREATE_LOCAL_TASK_MANUALLY = GROUP.registerEvent("create.local.task.manually");
    private static final EventId EXPLICITLY_ACTIVATED_TASK = GROUP.registerEvent("explicitly.activated.task");

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logCollectRemoteTasks(@NotNull Project project2, @NotNull TaskRepository repository) {
        if (project2 == null) {
            TaskManagementUsageCollector.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            TaskManagementUsageCollector.$$$reportNull$$$0(1);
        }
        COLLECT_REMOTE_TASKS.log(project2, TaskManagementUsageCollector.getRepositoryType(repository));
    }

    public static void logOpenRemoteTask(@NotNull Project project2, @NotNull Task task) {
        if (project2 == null) {
            TaskManagementUsageCollector.$$$reportNull$$$0(2);
        }
        if (task == null) {
            TaskManagementUsageCollector.$$$reportNull$$$0(3);
        }
        OPEN_REMOTE_TASK.log(project2, TaskManagementUsageCollector.getRepositoryType(task));
    }

    public static void logCreateLocalTaskManually(@NotNull Project project2) {
        if (project2 == null) {
            TaskManagementUsageCollector.$$$reportNull$$$0(4);
        }
        CREATE_LOCAL_TASK_MANUALLY.log(project2);
    }

    @Nullable
    private static Class<?> getRepositoryType(@NotNull TaskRepository repository) {
        TaskRepositoryType repositoryType;
        if (repository == null) {
            TaskManagementUsageCollector.$$$reportNull$$$0(5);
        }
        return (repositoryType = repository.getRepositoryType()) != null ? repositoryType.getClass() : null;
    }

    @Nullable
    private static Class<?> getRepositoryType(@NotNull Task task) {
        TaskRepository repository;
        if (task == null) {
            TaskManagementUsageCollector.$$$reportNull$$$0(6);
        }
        return (repository = task.getRepository()) != null ? TaskManagementUsageCollector.getRepositoryType(repository) : null;
    }

    public static void logExplicitlyActivatedTask(@NotNull Project project2) {
        if (project2 == null) {
            TaskManagementUsageCollector.$$$reportNull$$$0(7);
        }
        EXPLICITLY_ACTIVATED_TASK.log(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tasks/impl/TaskManagementUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logCollectRemoteTasks";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logOpenRemoteTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "logCreateLocalTaskManually";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getRepositoryType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "logExplicitlyActivatedTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

