/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.units;

import org.locationtech.proj4j.units.DegreeUnit;
import org.locationtech.proj4j.units.Unit;

public class Units {
    public static final Unit DEGREES = new DegreeUnit();
    public static final Unit RADIANS = new Unit("radian", "radians", "rad", Math.toDegrees(1.0));
    public static final Unit ARC_MINUTES = new Unit("arc minute", "arc minutes", "min", 0.016666666666666666);
    public static final Unit ARC_SECONDS = new Unit("arc second", "arc seconds", "sec", 2.777777777777778E-4);
    public static final Unit KILOMETRES = new Unit("kilometre", "kilometres", "km", 1000.0);
    public static final Unit METRES = new Unit("metre", "metres", "m", 1.0);
    public static final Unit DECIMETRES = new Unit("decimetre", "decimetres", "dm", 0.1);
    public static final Unit CENTIMETRES = new Unit("centimetre", "centimetres", "cm", 0.01);
    public static final Unit MILLIMETRES = new Unit("millimetre", "millimetres", "mm", 0.001);
    public static final Unit NAUTICAL_MILES = new Unit("nautical mile", "nautical miles", "kmi", 1852.0);
    public static final Unit MILES = new Unit("mile", "miles", "mi", 1609.344);
    public static final Unit CHAINS = new Unit("chain", "chains", "ch", 20.1168);
    public static final Unit YARDS = new Unit("yard", "yards", "yd", 0.9144);
    public static final Unit FEET = new Unit("foot", "feet", "ft", 0.3048);
    public static final Unit INCHES = new Unit("inch", "inches", "in", 0.0254);
    public static final Unit US_MILES = new Unit("U.S. mile", "U.S. miles", "us-mi", 1609.347218694437);
    public static final Unit US_CHAINS = new Unit("U.S. chain", "U.S. chains", "us-ch", 20.11684023368047);
    public static final Unit US_YARDS = new Unit("U.S. yard", "U.S. yards", "us-yd", 0.914401828803658);
    public static final Unit US_FEET = new Unit("U.S. foot", "U.S. feet", "us-ft", 0.304800609601219);
    public static final Unit US_INCHES = new Unit("U.S. inch", "U.S. inches", "us-in", 0.025400050800101603);
    public static final Unit FATHOMS = new Unit("fathom", "fathoms", "fath", 1.8288);
    public static final Unit LINKS = new Unit("link", "links", "link", 0.201168);
    public static final Unit POINTS = new Unit("point", "points", "point", 3.5145980351459805E-4);
    public static Unit[] units = new Unit[]{DEGREES, KILOMETRES, METRES, DECIMETRES, CENTIMETRES, MILLIMETRES, MILES, YARDS, FEET, INCHES, US_MILES, US_YARDS, US_FEET, US_INCHES, NAUTICAL_MILES};

    public static Unit findUnits(String name2) {
        for (int i2 = 0; i2 < units.length; ++i2) {
            if (!name2.equals(Units.units[i2].name) && !name2.equals(Units.units[i2].plural) && !name2.equals(Units.units[i2].abbreviation)) continue;
            return units[i2];
        }
        return METRES;
    }

    public static double convert(double value, Unit from, Unit to) {
        if (from == to) {
            return value;
        }
        return to.fromBase(from.toBase(value));
    }
}

