/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.couchbase.introspector.CouchbaseIntroQueries;
import com.intellij.database.dialects.couchbase.introspector.CouchbaseIntrospector;
import com.intellij.database.dialects.couchbase.introspector.CouchbaseIntrospector$applySchemas$lambda$3$;
import com.intellij.database.dialects.couchbase.model.CouchbaseIndex;
import com.intellij.database.dialects.couchbase.model.CouchbaseRoot;
import com.intellij.database.dialects.couchbase.model.CouchbaseSchema;
import com.intellij.database.dialects.couchbase.model.CouchbaseTable;
import com.intellij.database.dialects.couchbase.model.CouchbaseTableColumn;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003./0B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J4\u0010\u0019\u001a\u00020\u000b\"\b\b\u0000\u0010\u001a*\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001a0 H\u0002J1\u0010!\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0000\u0010\u001a*\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001a0 H\u0002\u00a2\u0006\u0002\u0010%J6\u0010&\u001a \u0012\u0006\b\u0001\u0012\u00020\u00020'R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030(2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u0002H\u0014J6\u0010+\u001a \u0012\u0006\b\u0001\u0012\u00020\u00030,R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030(2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u0003H\u0014\u00a8\u00061"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseRoot;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "retrieveAndApplySchemas", "", "introspectSchemasAuto", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schemas", "", "whole", "", "introspectNamespacesInTran", "applySchemas", "newSchemas", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneSchema;", "currentSchema", "", "buildObject", "T", "Lcom/intellij/sql/psi/SqlCreateStatement;", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "ddl", "statementClass", "Ljava/lang/Class;", "getStatement", "Lcom/intellij/sql/psi/SqlStatement;", "sql", "clazz", "(Ljava/lang/String;Ljava/lang/Class;)Lcom/intellij/sql/psi/SqlStatement;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "Factory", "Companion", "CouchbaseSchemaRetriever", "intellij.database.dialects.couchbase"})
@SourceDebugExtension(value={"SMAP\nCouchbaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CouchbaseIntrospector.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector\n+ 2 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 3 ElementCache.kt\ncom/intellij/database/model/FamilySearcher\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n417#2,10:270\n427#2,9:290\n436#2:300\n428#2:301\n429#2,9:303\n438#2,3:313\n430#2:316\n431#2:318\n189#3,10:280\n202#3:317\n1863#4:299\n1864#4:312\n1#5:302\n*S KotlinDebug\n*F\n+ 1 CouchbaseIntrospector.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector\n*L\n76#1:270,10\n76#1:290,9\n76#1:300\n76#1:301\n76#1:303,9\n76#1:313,3\n76#1:316\n76#1:318\n76#1:280,10\n76#1:317\n76#1:299\n76#1:312\n76#1:302\n*E\n"})
public final class CouchbaseIntrospector
extends BaseSingleDatabaseIntrospector<CouchbaseRoot, CouchbaseSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CouchbaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.COUCHBASE_QUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"COUCHBASE_QUERY");
        super(context, nature, dbms, modelFactory);
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemas = (List)this.inTransaction(CouchbaseIntrospector::retrieveAndApplySchemas$lambda$0);
        this.applySchemas(schemas, this.getDbConnectionInfo().schemaName);
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CouchbaseSchema> schemas, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        for (CouchbaseSchema couchbaseSchema : schemas) {
            this.handleErrors("Introspect schema " + couchbaseSchema.getName(), (Function0<Unit>)((Function0)() -> CouchbaseIntrospector.introspectSchemasAuto$lambda$1(this, tran, couchbaseSchema)));
        }
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        List<CouchbaseIntroQueries.OneSchema> schemas = CouchbaseIntroQueries.INSTANCE.retrieveSchemas(tran);
        this.applySchemas(schemas, this.getDbConnectionInfo().schemaName);
    }

    private final void applySchemas(List<CouchbaseIntroQueries.OneSchema> newSchemas, String currentSchema) {
        this.inModel(arg_0 -> CouchbaseIntrospector.applySchemas$lambda$3(newSchemas, currentSchema, arg_0));
    }

    private final <T extends SqlCreateStatement> void buildObject(BasicModElement obj2, String ddl, Class<T> statementClass) {
        if (obj2 == null) {
            return;
        }
        SqlCreateStatement sqlCreateStatement = (SqlCreateStatement)this.getStatement(ddl, statementClass);
        if (sqlCreateStatement == null) {
            return;
        }
        SqlCreateStatement statement2 = sqlCreateStatement;
        this.getSqlHelper().getBuilder().build(obj2, (DasObject)statement2, this.getSqlHelper().getBuilderContext());
    }

    private final <T extends SqlStatement> T getStatement(String sql, Class<T> clazz) {
        if (sql == null) {
            return null;
        }
        try {
            return (T)((SqlStatement)this.getSqlHelper().statements(sql, clazz).first());
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.log.error((Throwable)e);
            }
            this.log.warn("Failed to parse sources", (Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<? extends CouchbaseRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CouchbaseRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new BaseNativeIntrospector.AbstractDatabaseRetriever<CouchbaseRoot>(this, transaction, database){};
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<? extends CouchbaseSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CouchbaseSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new CouchbaseSchemaRetriever(transaction, schema);
    }

    private static final List retrieveAndApplySchemas$lambda$0(DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CouchbaseIntroQueries.INSTANCE.retrieveSchemas(it);
    }

    private static final Unit introspectSchemasAuto$lambda$1(CouchbaseIntrospector this$0, DBTransaction $tran, CouchbaseSchema $schema) {
        BaseNativeIntrospector.AbstractSchemaRetriever<? extends CouchbaseSchema> retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applySchemas$lambda$3(List $newSchemas, String $currentSchema, CouchbaseRoot root) {
        void $this$iv$iv$iv;
        void $this$applySchemasNamed$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        NamingFamily namingFamily = root.getSchemas();
        Intrinsics.checkNotNullExpressionValue((Object)namingFamily, (String)"getSchemas(...)");
        NamingFamily $this$applySchemasNamed$iv = namingFamily;
        boolean $i$f$applySchemasNamed = false;
        NamingFamily namingFamily2 = $this$applySchemasNamed$iv;
        ElementSearchCache searchCache$iv$iv = new ElementSearchCache();
        boolean $i$f$applySchemasNamed2 = false;
        FamilySearcher familySearcher = ElementCacheOptimizersKt.byName(ElementCacheKt.searchElement(searchCache$iv$iv), (Function1)new Function1<CouchbaseIntroQueries.OneSchema, String>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final String invoke(Object $this$byName) {
                CouchbaseIntroQueries.OneSchema p0 = (CouchbaseIntroQueries.OneSchema)$this$byName;
                boolean bl = false;
                return p0.id;
            }
        }).inFamily((Family)$this$applySchemasNamed$iv$iv);
        Function2 filler$iv$iv$iv = applySchemas$lambda$3$$inlined$applySchemasNamed$2.INSTANCE;
        boolean $i$f$orCreateBulk = false;
        ArrayList items$iv$iv$iv = new ArrayList();
        ElementSearcherNN searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)$this$iv$iv$iv, (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
            final /* synthetic */ FamilySearcher this$0;
            final /* synthetic */ Function2 $filler;
            final /* synthetic */ ArrayList $items;
            {
                this.this$0 = $receiver;
                this.$filler = $filler;
                this.$items = $items;
            }

            public final T invoke(D it) {
                T t = BasicMetaUtils.getMetaObject(this.this$0.getFamily()).newDataObject();
                Intrinsics.checkNotNullExpressionValue(t, (String)"newDataObject(...)");
                T t2 = t;
                FamilySearcher familySearcher = this.this$0;
                Function2 function2 = this.$filler;
                ArrayList arrayList = this.$items;
                T $this$invoke_u24lambda_u240 = t2;
                boolean bl = false;
                familySearcher.fillImpl($this$invoke_u24lambda_u240, it, function2);
                ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                return t2;
            }
        });
        try {
            ElementSearcherNN schemas$iv$iv = searcher$iv$iv$iv;
            boolean bl = false;
            void $this$applySchemasImpl$iv$iv$iv = $this$applySchemasNamed$iv$iv;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv$iv$iv = $newSchemas;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void s;
                void sc$iv$iv;
                Object element$iv$iv$iv$iv;
                Object sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object t = sc$iv$iv$iv;
                void $this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                boolean bl3 = false;
                BasicModMateNamespace $this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find(sc$iv$iv);
                boolean bl4 = false;
                CouchbaseIntroQueries.OneSchema oneSchema = (CouchbaseIntroQueries.OneSchema)sc$iv$iv;
                CouchbaseSchema $this$applySchemas_u24lambda_u243_u24lambda_u242 = (CouchbaseSchema)$this$applySchemasNamed_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418$iv$iv;
                boolean bl5 = false;
                $this$applySchemas_u24lambda_u243_u24lambda_u242.setCurrent(Intrinsics.areEqual((Object)s.name, (Object)$currentSchema));
            }
            $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv$iv$iv.sort();
        }
        finally {
            Family family = $this$iv$iv$iv.getFamily();
            Intrinsics.checkNotNull(family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
            BaseModel.createBulk(family, items$iv$iv$iv);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConnectionInfo access$getDbConnectionInfo(CouchbaseIntrospector $this) {
        return $this.getDbConnectionInfo();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$Companion;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "<init>", "()V", "supportServerObjects", "", "getSupportServerObjects", "()Z", "supportFragmentIntrospection", "getSupportFragmentIntrospection", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "intellij.database.dialects.couchbase"})
    public static final class Companion
    implements BaseIntrospector.Nature {
        private Companion() {
        }

        @Override
        public boolean getSupportServerObjects() {
            return false;
        }

        @Override
        public boolean getSupportFragmentIntrospection() {
            return false;
        }

        @Override
        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return SetsKt.emptySet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J<\u0010\u0012\u001a\u00020\u000e2\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00180\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0002J-\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u001b\u0010#\u001a\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u0004\u0012\u00020\u000e0$\u00a2\u0006\u0002\b&H\u0002J@\u0010'\u001a\u00020\u000e2'\u0010(\u001a#\u0012\u0019\u0012\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u0004\u0012\u00020\u000e0$\u00a2\u0006\u0002\b&\u0012\u0004\u0012\u00020\u000e0$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0*H\u0082\bJ\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006,"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$CouchbaseSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/couchbase/model/CouchbaseSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "retrieveMainContent", "", "retrieveTables", "retrieveColumnsWithSampling", "retrieveColumnsWithInfer", "processProperties", "properties", "", "nameToTypes", "", "", "", "prefix", "retrieveIndices", "populateIndexColumns", "schemaIndex", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseIndex;", "dbIndex", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndex;", "unquoteIndexColumnName", "name", "doForEachIndex", "f", "Lkotlin/Function1;", "Lcom/intellij/database/model/families/ModFamily;", "Lkotlin/ExtensionFunctionType;", "cleanupFamiliesWithoutSort", "v", "action", "Lkotlin/Function0;", "sortIndices", "intellij.database.dialects.couchbase"})
    @SourceDebugExtension(value={"SMAP\nCouchbaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CouchbaseIntrospector.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$CouchbaseSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,269:1\n255#1,8:347\n178#2,8:270\n303#2,4:282\n307#2:290\n198#2,5:291\n204#2,5:301\n308#2:306\n303#2,4:311\n307#2:319\n198#2,5:320\n204#2,5:328\n308#2:333\n1557#3:278\n1628#3,3:279\n1863#3:296\n1053#3:297\n1863#3,2:298\n1864#3:300\n1557#3:307\n1628#3,3:308\n1863#3:325\n1053#3:326\n1864#3:327\n1863#3:334\n808#3,11:335\n1864#3:346\n1863#3,2:355\n37#4:286\n36#4,3:287\n37#4:315\n36#4,3:316\n*S KotlinDebug\n*F\n+ 1 CouchbaseIntrospector.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$CouchbaseSchemaRetriever\n*L\n198#1:347,8\n125#1:270,8\n146#1:282,4\n146#1:290\n146#1:291,5\n146#1:301,5\n146#1:306\n162#1:311,4\n162#1:319\n162#1:320,5\n162#1:328,5\n162#1:333\n146#1:278\n146#1:279,3\n147#1:296\n151#1:297\n152#1:298,2\n147#1:300\n162#1:307\n162#1:308,3\n163#1:325\n171#1:326\n163#1:327\n182#1:334\n188#1:335,11\n182#1:346\n252#1:355,2\n146#1:286\n146#1:287,3\n162#1:315\n162#1:316,3\n*E\n"})
    private final class CouchbaseSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<CouchbaseSchema> {
        public CouchbaseSchemaRetriever(@NotNull DBTransaction transaction, CouchbaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)CouchbaseIntrospector.this, transaction, (BasicModSchema)schema);
        }

        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CouchbaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        @Override
        protected void retrieveMainContent() {
            this.inSchema(arg_0 -> CouchbaseSchemaRetriever.retrieveMainContent$lambda$0(this, CouchbaseIntrospector.this, arg_0));
        }

        private final void retrieveTables(CouchbaseSchema schema) {
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            CouchbaseIntrospector.this.reportRetrieving(objectKind);
            ModFamily $this$modifyAndCleanup_u24default$iv = schema.getTables();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            boolean sysSchema = Intrinsics.areEqual((Object)schema.getName(), (Object)"system");
            CouchbaseIntroQueries.INSTANCE.processTables(this.getTransaction(), schema, (Function1<? super CouchbaseIntroQueries.OneTable, Unit>)((Function1)arg_0 -> CouchbaseSchemaRetriever.retrieveTables$lambda$2$lambda$1(schema, sysSchema, this, arg_0)));
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumnsWithSampling(CouchbaseSchema schema) {
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            CouchbaseIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CouchbaseTable couchbaseTable = (CouchbaseTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumns());
            }
            Collection families$iv = (List)destination$iv$iv;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingFamily2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Iterable $this$sortedBy$iv;
                CouchbaseTable t = (CouchbaseTable)element$iv;
                boolean bl2 = false;
                if (!t.isSystem() && t.getIndices().isEmpty()) continue;
                short position = 0;
                position = 1;
                DBTransaction dBTransaction = this.getTransaction();
                Intrinsics.checkNotNull((Object)t);
                Iterable iterable2 = CouchbaseIntroQueries.INSTANCE.retrieveTableColumns(dBTransaction, t);
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CouchbaseIntroQueries.OneTableColumns it = (CouchbaseIntroQueries.OneTableColumns)a;
                        boolean bl = false;
                        it = (CouchbaseIntroQueries.OneTableColumns)b;
                        Comparable comparable = (Comparable)((Object)it.name);
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)it.name)));
                    }
                });
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    CouchbaseIntroQueries.OneTableColumns c2 = (CouchbaseIntroQueries.OneTableColumns)element$iv2;
                    boolean bl3 = false;
                    short s = position;
                    position = (short)(s + 1);
                    CouchbaseTableColumn column2 = (CouchbaseTableColumn)t.getColumns().renewAt(s, c2.name);
                    DataType dataType = DataTypeFactory.of(c2.typeName);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    column2.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                }
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumnsWithInfer(CouchbaseSchema schema) {
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            CouchbaseIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CouchbaseTable couchbaseTable = (CouchbaseTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumns());
            }
            Collection families$iv = (List)destination$iv$iv;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            Collection $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            ModFamily[] families$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingFamily2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CouchbaseTable t = (CouchbaseTable)element$iv;
                boolean bl2 = false;
                Map nameToType = new LinkedHashMap();
                DBTransaction dBTransaction = this.getTransaction();
                Intrinsics.checkNotNull((Object)t);
                CouchbaseIntroQueries.INSTANCE.inferTableSchema(dBTransaction, t, (Function1<? super CouchbaseIntroQueries.OneInferTableInfo, Unit>)((Function1)arg_0 -> CouchbaseSchemaRetriever.retrieveColumnsWithInfer$lambda$13$lambda$12$lambda$10(this, nameToType, arg_0)));
                short position = 1;
                Iterable $this$sortedBy$iv = nameToType.entrySet();
                boolean $i$f$sortedBy = false;
                for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                    }
                })) {
                    String name2 = (String)entry.getKey();
                    Set types = (Set)entry.getValue();
                    short s = position;
                    position = (short)(s + 1);
                    CouchbaseTableColumn column2 = (CouchbaseTableColumn)t.getColumns().renewAt(s, name2);
                    DataType dataType = DataTypeFactory.of(CollectionsKt.joinToString$default((Iterable)types, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null));
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    column2.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                }
            }
            for (ModFamily f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processProperties(Map<?, ?> properties2, Map<String, Set<String>> nameToTypes, String prefix) {
            Iterable $this$forEach$iv = properties2.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Iterable<Object> iterable;
                Object newTypes;
                String shortName;
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Object key2 = entry.getKey();
                Object value = entry.getValue();
                Object k = key2;
                if (k == null || (k = k.toString()) == null) {
                    k = "unnamed";
                }
                char[] cArray = new char[]{'\\', '.'};
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.escapeChars(k, (char[])cArray), (String)"escapeChars(...)");
                String name2 = ((CharSequence)prefix).length() == 0 ? shortName : prefix + "." + shortName;
                Intrinsics.checkNotNullExpressionValue((Object)nameToTypes.computeIfAbsent(name2, arg_0 -> CouchbaseSchemaRetriever.processProperties$lambda$16$lambda$15(CouchbaseSchemaRetriever::processProperties$lambda$16$lambda$14, arg_0)), (String)"computeIfAbsent(...)");
                Map map2 = value instanceof Map ? (Map)value : null;
                Object object = newTypes = map2 != null ? map2.get("type") : null;
                if (newTypes instanceof String) {
                    v3 = types.add(newTypes);
                } else if (newTypes instanceof Collection) {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    iterable = (Iterable)newTypes;
                    Set set = types;
                    boolean $i$f$filterIsInstance = false;
                    void var19_19 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof String)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v3 = set.addAll((List)destination$iv$iv);
                } else {
                    v3 = types.add("unknown");
                }
                Map map3 = value instanceof Map ? (Map)value : null;
                iterable = map3 != null ? map3.get("properties") : null;
                Map subProperties = iterable instanceof Map ? (Map)((Object)iterable) : null;
                if (subProperties == null) continue;
                this.processProperties(subProperties, nameToTypes, name2);
            }
        }

        static /* synthetic */ void processProperties$default(CouchbaseSchemaRetriever couchbaseSchemaRetriever, Map map2, Map map3, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            couchbaseSchemaRetriever.processProperties(map2, map3, string);
        }

        private final void retrieveIndices(CouchbaseSchema schema) {
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            CouchbaseIntrospector.this.reportRetrieving(objectKind);
            CouchbaseSchemaRetriever couchbaseSchemaRetriever = this;
            CouchbaseIntrospector couchbaseIntrospector = CouchbaseIntrospector.this;
            boolean $i$f$cleanupFamiliesWithoutSort = false;
            Function1 it = cleanupFamiliesWithoutSort.1.INSTANCE;
            boolean bl = false;
            this.doForEachIndex(schema, it);
            boolean bl2 = false;
            CouchbaseIntroQueries.INSTANCE.processIndices(this.getTransaction(), schema, (Function1<? super CouchbaseIntroQueries.OneIndex, Unit>)((Function1)arg_0 -> CouchbaseSchemaRetriever.retrieveIndices$lambda$20$lambda$18(schema, this, arg_0)));
            if (schema.getTables().size() != 0) {
                CouchbaseIntroQueries.INSTANCE.processIndicesAdditional(this.getTransaction(), (Function1<? super CouchbaseIntroQueries.OneIndexAdditional, Unit>)((Function1)arg_0 -> CouchbaseSchemaRetriever.retrieveIndices$lambda$20$lambda$19(schema, couchbaseIntrospector, arg_0)));
            }
            it = cleanupFamiliesWithoutSort.2.INSTANCE;
            bl = false;
            this.doForEachIndex(schema, it);
        }

        private final void populateIndexColumns(CouchbaseIndex schemaIndex, CouchbaseIntroQueries.OneIndex dbIndex) {
            List<String> columns = dbIndex.index_key;
            LinkedHashSet<String> cols = new LinkedHashSet<String>();
            HashSet<String> revs = new HashSet<String>();
            Collection collection = columns;
            if (collection == null || collection.isEmpty()) {
                schemaIndex.setColNames(CollectionsKt.listOf((Object)"id"));
                schemaIndex.setReverseColNames(SetsKt.emptySet());
                return;
            }
            for (String col : columns) {
                String string;
                boolean isReverse = StringsKt.endsWith$default((String)col, (String)"DESC", (boolean)false, (int)2, null);
                if (isReverse) {
                    String string2 = col.substring(0, StringsKt.lastIndexOf$default((CharSequence)col, (String)"DESC", (int)0, (boolean)false, (int)6, null));
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = col;
                }
                String quotedName = string;
                String colName = this.unquoteIndexColumnName(((Object)StringsKt.trim((CharSequence)quotedName)).toString());
                cols.add(colName);
                if (!isReverse) continue;
                revs.add(colName);
            }
            schemaIndex.setColNames(CollectionsKt.toList((Iterable)cols));
            schemaIndex.setReverseColNames((Set<String>)revs);
        }

        private final String unquoteIndexColumnName(String name2) {
            if (StringsKt.startsWith$default((String)name2, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name2, (String)")", (boolean)false, (int)2, null)) {
                String string = name2.substring(1, StringsKt.getLastIndex((CharSequence)name2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return name2;
        }

        private final void doForEachIndex(CouchbaseSchema schema, Function1<? super ModFamily<?>, Unit> f) {
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CouchbaseTable t = (CouchbaseTable)element$iv;
                boolean bl = false;
                Family family = t.getIndices();
                Intrinsics.checkNotNullExpressionValue((Object)family, (String)"getIndices(...)");
                f.invoke((Object)family);
            }
        }

        private final void cleanupFamiliesWithoutSort(Function1<? super Function1<? super ModFamily<?>, Unit>, Unit> v, Function0<Unit> action) {
            boolean $i$f$cleanupFamiliesWithoutSort = false;
            v.invoke((Object)cleanupFamiliesWithoutSort.1.INSTANCE);
            action.invoke();
            v.invoke((Object)cleanupFamiliesWithoutSort.2.INSTANCE);
        }

        private final void sortIndices(CouchbaseSchema schema) {
            this.doForEachIndex(schema, CouchbaseSchemaRetriever::sortIndices$lambda$22);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveMainContent$lambda$0(CouchbaseSchemaRetriever this$0, CouchbaseIntrospector this$1, CouchbaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTables(schema);
            this$0.retrieveIndices(schema);
            if (Intrinsics.areEqual((Object)schema.getName(), (Object)"system")) ** GOTO lbl-1000
            var3_3 = new int[]{0, 5};
            if (CouchbaseIntrospector.access$getDbConnectionInfo((CouchbaseIntrospector)this$1).driverVersion.less(var3_3)) lbl-1000:
            // 2 sources

            {
                this$0.retrieveColumnsWithSampling(schema);
            } else {
                this$0.retrieveColumnsWithInfer(schema);
            }
            this$0.sortIndices(schema);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTables$lambda$2$lambda$1(CouchbaseSchema $schema, boolean $sysSchema, CouchbaseSchemaRetriever this$0, CouchbaseIntroQueries.OneTable t) {
            CouchbaseIntroQueries.OneTableSettings tableSettings;
            Object object;
            CouchbaseIntroQueries.OneTableSettings oneTableSettings;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily = $schema.getTables();
            String string = t.id;
            if (string == null) {
                string = t.name;
            }
            Intrinsics.checkNotNull((Object)string);
            CouchbaseTable table = modNamingFamily.createOrGet(string);
            table.setSystem($sysSchema);
            if ($sysSchema) {
                oneTableSettings = null;
            } else {
                DBTransaction dBTransaction = this$0.getTransaction();
                Intrinsics.checkNotNull((Object)table);
                oneTableSettings = CouchbaseIntroQueries.INSTANCE.retrieveTableAdditional(dBTransaction, table);
            }
            table.setFlushEnabled((object = (tableSettings = oneTableSettings)) != null && (object = ((CouchbaseIntroQueries.OneTableSettings)object).flushEnabled) != null ? (Boolean)object : false);
            Object object2 = tableSettings;
            table.setRamQuotaMB(object2 != null && (object2 = ((CouchbaseIntroQueries.OneTableSettings)object2).ramQuotaMB) != null ? (Long)object2 : 100L);
            Object object3 = tableSettings;
            table.setReplicaNumber(object3 != null && (object3 = ((CouchbaseIntroQueries.OneTableSettings)object3).replicaNumber) != null ? (Integer)object3 : 1);
            Object object4 = tableSettings;
            table.setReplicaIndexes(object4 != null && (object4 = ((CouchbaseIntroQueries.OneTableSettings)object4).replicaIndexes) != null ? (Boolean)object4 : false);
            Object object5 = tableSettings;
            table.setMaxTTL(object5 != null && (object5 = ((CouchbaseIntroQueries.OneTableSettings)object5).maxTTL) != null ? (Integer)object5 : 0);
            Object object6 = tableSettings;
            if (object6 == null || (object6 = ((CouchbaseIntroQueries.OneTableSettings)object6).compressionMode) == null) {
                object6 = "passive";
            }
            table.setCompressionMode((String)object6);
            Object object7 = tableSettings;
            if (object7 == null || (object7 = ((CouchbaseIntroQueries.OneTableSettings)object7).bucketType) == null) {
                object7 = "membase";
            }
            table.setBucketType((String)object7);
            Object object8 = tableSettings;
            if (object8 == null || (object8 = ((CouchbaseIntroQueries.OneTableSettings)object8).conflictResolutionType) == null) {
                object8 = "seqno";
            }
            table.setConflictResolutionType((String)object8);
            Object object9 = tableSettings;
            if (object9 == null || (object9 = ((CouchbaseIntroQueries.OneTableSettings)object9).evictionPolicy) == null) {
                object9 = "valueOnly";
            }
            table.setEvictionPolicy((String)object9);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnsWithInfer$lambda$13$lambda$12$lambda$10(CouchbaseSchemaRetriever this$0, Map $nameToType, CouchbaseIntroQueries.OneInferTableInfo info2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
                Map<Object, ? extends Object> map2 = info2.properties;
                if (map2 == null) break block0;
                Map<Object, ? extends Object> it = map2;
                boolean bl = false;
                CouchbaseSchemaRetriever.processProperties$default(this$0, it, $nameToType, null, 4, null);
            }
            return Unit.INSTANCE;
        }

        private static final Set processProperties$lambda$16$lambda$14(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set processProperties$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        private static final Unit retrieveIndices$lambda$20$lambda$18(CouchbaseSchema $schema, CouchbaseSchemaRetriever this$0, CouchbaseIntroQueries.OneIndex i2) {
            Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
            CouchbaseTable couchbaseTable = (CouchbaseTable)$schema.getTables().get(i2.keyspace_id);
            if (couchbaseTable == null) {
                return Unit.INSTANCE;
            }
            CouchbaseTable table = couchbaseTable;
            CouchbaseIndex index = (CouchbaseIndex)table.getIndices().createOrGet(i2.name);
            index.setCondition(i2.condition);
            index.setUnique(i2.is_primary);
            index.setUsing(i2.using);
            index.setPartition(i2.partition);
            Intrinsics.checkNotNull((Object)index);
            this$0.populateIndexColumns(index, i2);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveIndices$lambda$20$lambda$19(CouchbaseSchema $schema, CouchbaseIntrospector this$0, CouchbaseIntroQueries.OneIndexAdditional i2) {
            CouchbaseIndex index;
            Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
            String string = i2.bucket;
            if (string == null) {
                return Unit.INSTANCE;
            }
            String tableName = string;
            CouchbaseTable couchbaseTable = (CouchbaseTable)$schema.getTables().get(tableName);
            if (couchbaseTable == null) {
                return Unit.INSTANCE;
            }
            CouchbaseTable table = couchbaseTable;
            String string2 = i2.indexName;
            if (string2 == null) {
                return Unit.INSTANCE;
            }
            String indexName = string2;
            CouchbaseIndex couchbaseIndex = index = (CouchbaseIndex)table.getIndices().get(indexName);
            if (couchbaseIndex != null) {
                Integer n = i2.numReplica;
                couchbaseIndex.setNumReplica(n != null ? n : 0);
            }
            CouchbaseIndex couchbaseIndex2 = index;
            int defaultPartitions = (couchbaseIndex2 != null ? couchbaseIndex2.getPartition() : null) == null ? 1 : 8;
            CouchbaseIndex couchbaseIndex3 = index;
            if (couchbaseIndex3 != null) {
                Integer n = i2.numPartition;
                couchbaseIndex3.setNumPartition(n != null ? n : defaultPartitions);
            }
            this$0.buildObject(index, i2.definition, SqlCreateIndexStatement.class);
            return Unit.INSTANCE;
        }

        private static final Unit sortIndices$lambda$22(ModFamily $this$doForEachIndex) {
            Intrinsics.checkNotNullParameter((Object)$this$doForEachIndex, (String)"$this$doForEachIndex");
            $this$doForEachIndex.sort();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.couchbase"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{6, 5};
            return version.isOrGreater(nArray);
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new CouchbaseIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.couchbase"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

