/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.generator.dml.BaseSelectGenerator;
import com.intellij.database.dialects.base.generator.dml.UtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.CountAll;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DdlBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/couchbase/generator/dml/CouchbaseSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/BaseSelectGenerator;", "task", "Lcom/intellij/database/script/generator/dml/SelectTask;", "dbms", "Lcom/intellij/database/Dbms;", "helper", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "<init>", "(Lcom/intellij/database/script/generator/dml/SelectTask;Lcom/intellij/database/Dbms;Lcom/intellij/database/dialects/base/BaseDmlHelper;)V", "generate", "Lcom/intellij/database/script/generator/dml/SelectGenerationResult;", "intellij.database.dialects.couchbase"})
public final class CouchbaseSelectGenerator
extends BaseSelectGenerator {
    public CouchbaseSelectGenerator(@NotNull SelectTask task, @NotNull Dbms dbms, @NotNull BaseDmlHelper helper) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        super(task, dbms, helper);
    }

    @Override
    @NotNull
    public SelectGenerationResult generate() {
        Object it;
        DdlBuilder builder = ((SelectTask)this.getTask()).getOutput();
        DasObject table = ((SelectTask)this.getTask()).getTable();
        if (!((SelectTask)this.getTask()).getKeysOnly() || Intrinsics.areEqual((Object)((SelectTask)this.getTask()).getColumns(), (Object)CountAll.INSTANCE)) {
            return super.generate();
        }
        builder.plain("GET KEYS");
        DmlUtilKt.space(builder, ((SelectTask)this.getTask()).getInsertNewLines());
        builder.keyword("FROM").space().qualifiedRef(table);
        WhereClause whereClause = ((SelectTask)this.getTask()).getWhereClause();
        if (whereClause != null) {
            it = whereClause;
            boolean bl = false;
            DmlUtilKt.space(builder, ((SelectTask)this.getTask()).getInsertNewLines());
            UtilKt.generateWhere(this.getDbms(), (WhereClause)it, builder, this.getTask(), true);
        }
        OrderBy orderBy = ((SelectTask)this.getTask()).getOrderBy();
        if (orderBy != null) {
            it = orderBy;
            boolean bl = false;
            DmlUtilKt.space(builder, ((SelectTask)this.getTask()).getInsertNewLines());
            UtilKt.generateOrderBy((OrderBy)it, builder, true);
        }
        if (!GridUtilCore.isPageSizeUnlimited((int)((SelectTask)this.getTask()).getLimit())) {
            this.getHelper().appendNumericProperty(builder, "LIMIT", ((SelectTask)this.getTask()).getLimit());
        }
        if (((SelectTask)this.getTask()).getOffset() > 0) {
            this.getHelper().appendNumericProperty(builder, "OFFSET", ((SelectTask)this.getTask()).getOffset());
        }
        return new SelectGenerationResult(((SelectTask)this.getTask()).getOutput(), null, null, 6, null);
    }
}

