/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.dialects.bigquery.generator.BigQueryNamingServiceKt;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import com.intellij.sql.psi.SqlDbElementType;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/bigquery/generator/BigQueryNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "<init>", "()V", "closingQuotes", "", "getClosingQuotes", "()Ljava/lang/String;", "openingQuotes", "getOpeningQuotes", "getCasing", "Lcom/intellij/database/util/Casing;", "kind", "Lcom/intellij/database/model/ObjectKind;", "context", "Lcom/intellij/database/model/DasObject;", "Provider", "intellij.database.dialects.bigquery"})
public final class BigQueryNamingService
extends AbstractNamingService {
    @NotNull
    public static final BigQueryNamingService INSTANCE = new BigQueryNamingService();

    private BigQueryNamingService() {
        Dbms dbms = Dbms.BIGQUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"BIGQUERY");
        Pattern pattern = BigQueryNamingServiceKt.access$pattern("a-zA-Z}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"access$pattern(...)");
        Casing casing = CasingProvider.EXACT_CASING;
        Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"EXACT_CASING");
        super(dbms, pattern, casing);
    }

    @Override
    @NotNull
    public String getClosingQuotes() {
        return "`";
    }

    @Override
    @NotNull
    public String getOpeningQuotes() {
        return "`";
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        Casing casing;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN) || Intrinsics.areEqual((Object)objectKind, (Object)SqlDbElementType.LOCAL_ALIAS)) {
            Casing casing2 = CasingProvider.MIXED_CASING;
            casing = casing2;
            Intrinsics.checkNotNullExpressionValue((Object)casing2, (String)"MIXED_CASING");
        } else {
            casing = super.getCasing(kind, context);
        }
        return casing;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/bigquery/generator/BigQueryNamingService$Provider;", "Lcom/intellij/database/script/generator/NamingService$Provider;", "<init>", "()V", "getNamingService", "Lcom/intellij/database/script/generator/NamingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects.bigquery"})
    public static final class Provider
    implements NamingService.Provider {
        @Override
        @NotNull
        public NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
            return INSTANCE;
        }
    }
}

