/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.openapi.actionSystem.DataContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000f\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nH\u0016J\u000f\u0010\u000b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nH\u0016J\u0019\u0010\f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00142\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0012\u001a\u00020\u0002X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dataSource/ForbidFragmentOptionProvider;", "Lcom/intellij/database/dataSource/DbOptionProvider$LocalDataSourceOptionProvider;", "", "<init>", "()V", "isApplicable", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "getDisplayName", "", "Lorg/jetbrains/annotations/Nls;", "getDescription", "load", "(Lcom/intellij/database/dataSource/LocalDataSource;)Ljava/lang/Boolean;", "store", "", "value", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/Boolean;)V", "defaultValue", "getEditor", "Lcom/intellij/database/dataSource/DbOptionProvider$EditorDesc;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLocation", "Lcom/intellij/database/dataSource/DbOptionProvider$UiLocation;", "intellij.database.core.impl"})
public final class ForbidFragmentOptionProvider
extends DbOptionProvider.LocalDataSourceOptionProvider<Boolean> {
    private final boolean defaultValue;

    @Override
    public boolean isApplicable(@NotNull LocalDataSource target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Dbms dbms = target2.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return DBIntrospectorFactory.hasFragmentIntrospector(dbms);
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return DatabaseBundle.message("forbid.fragment.introspection", new Object[0]);
    }

    @Override
    @Nullable
    public String getDescription() {
        return DatabaseBundle.message("forbid.fragment.introspection.desc", new Object[0]);
    }

    @Override
    @Nullable
    public Boolean load(@Nullable LocalDataSource target2) {
        String v;
        LocalDataSource localDataSource = target2;
        String string = v = localDataSource != null ? localDataSource.getAdditionalProperty("database.forbid.fragment") : null;
        if (v == null) {
            return this.defaultValue;
        }
        return Intrinsics.areEqual((Object)v, (Object)"true");
    }

    @Override
    public void store(@NotNull LocalDataSource target2, @Nullable Boolean value) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        String valueStr = value != null && !Intrinsics.areEqual((Object)value, (Object)this.defaultValue) ? value.toString() : null;
        target2.setAdditionalProperty("database.forbid.fragment", valueStr);
    }

    @Override
    @NotNull
    public DbOptionProvider.EditorDesc<Boolean> getEditor(@Nullable LocalDataSource target2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DbOptionProvider.EditorDesc<Boolean> editorDesc = DbOptionProvider.getCheckBox(false);
        Intrinsics.checkNotNullExpressionValue(editorDesc, (String)"getCheckBox(...)");
        return editorDesc;
    }

    @Override
    @NotNull
    public DbOptionProvider.UiLocation getLocation() {
        return DbOptionProvider.UiLocation.EXPERT;
    }
}

