/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.intellij.jinja.template.DjangoTemplateFileViewProvider;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.jinja.template.tags.Jinja2BlockTag;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.extensions.FQNamesProviderExtKt;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoPsiUtil {
    private static final String[] TYPICAL_SETTINGS_PY_ATTRIBUTES = new String[]{"INSTALLED_APPS", "TEMPLATES", "DATABASES"};

    private DjangoPsiUtil() {
    }

    public static PsiFile getFile(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            DjangoPsiUtil.$$$reportNull$$$0(0);
        }
        if ((containingFile = element.getContainingFile()) == null) {
            return element.getOriginalElement().getContainingFile();
        }
        return containingFile.getOriginalFile();
    }

    @Nullable
    public static PsiFile findFileInRoots(@NotNull String path2, @NotNull PsiElement context) {
        QualifiedName qName;
        List results;
        PsiFile file;
        if (path2 == null) {
            DjangoPsiUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DjangoPsiUtil.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = file = !(results = PyResolveImportUtil.resolveQualifiedName((QualifiedName)(qName = QualifiedName.fromDottedString((String)path2)), (PyQualifiedNameResolveContext)PyResolveImportUtil.fromFoothold((PsiElement)context))).isEmpty() ? (PsiFile)PyUtil.as(results.get(0), PsiFile.class) : null;
        if (file != null && "__init__.py".equals(file.getName()) && !"__init__.py".equals(qName.getLastComponent())) {
            file = null;
        }
        return file;
    }

    @Nullable
    public static PsiFile findChild(PsiDirectory folder, String path2) {
        List pathElements = StringUtil.split((String)path2, (String)"/");
        for (int i = 0; i < pathElements.size(); ++i) {
            if (folder == null) {
                return null;
            }
            if (i >= pathElements.size() - 1) {
                return folder.findFile((String)pathElements.get(i));
            }
            folder = folder.findSubdirectory((String)pathElements.get(i));
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findFolder(PsiDirectory folder, String path2) {
        List pathElements = StringUtil.split((String)path2, (String)"/");
        for (String name : pathElements) {
            if (folder == null) {
                return null;
            }
            folder = folder.findSubdirectory(name);
        }
        return folder;
    }

    public static boolean isElementOfListOrTupleAssignedTo(PsiElement element, String ... assignedTo) {
        String referencedName;
        PyAugAssignmentStatement statement;
        PyExpression target;
        if (assignedTo == null) {
            DjangoPsiUtil.$$$reportNull$$$0(3);
        }
        PyElement assignment = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyAssignmentStatement.class, PyCallExpression.class, PyAugAssignmentStatement.class});
        Stream<String> stream = Arrays.stream(assignedTo);
        PySequenceExpression pySequenceExpression = null;
        if (assignment instanceof PyAssignmentStatement) {
            PyExpression assignedValue;
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)assignment;
            PyExpression lhs = assignmentStatement.getLeftHandSideExpression();
            if (lhs instanceof PyTargetExpression && lhs.getName() != null && stream.anyMatch(o -> lhs.getName().matches((String)o)) && PsiTreeUtil.isAncestor((PsiElement)(assignedValue = assignmentStatement.getAssignedValue()), (PsiElement)element, (boolean)true)) {
                pySequenceExpression = (PySequenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PySequenceExpression.class, (boolean)true, (Class[])new Class[]{PyAssignmentStatement.class});
            }
        } else if (assignment instanceof PyAugAssignmentStatement && (target = (statement = (PyAugAssignmentStatement)assignment).getTarget()) instanceof PyReferenceExpression && (referencedName = ((PyReferenceExpression)target).getReferencedName()) != null && stream.anyMatch(o -> referencedName.matches((String)o)) && PsiTreeUtil.isAncestor((PsiElement)statement.getValue(), (PsiElement)element, (boolean)true)) {
            pySequenceExpression = (PySequenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PySequenceExpression.class, (boolean)true, (Class[])new Class[]{PyAugAssignmentStatement.class});
        }
        return pySequenceExpression instanceof PyListLiteralExpression || pySequenceExpression instanceof PyTupleExpression;
    }

    public static boolean isElementOfListArgumentToCall(PsiElement element, String qualifier, String callName) {
        ASTNode elementNode = element.getNode();
        if (elementNode == null) {
            return false;
        }
        ASTNode node = elementNode.getTreeParent();
        if (node != null && node.getElementType() == PyElementTypes.TUPLE_EXPRESSION) {
            node = node.getTreeParent();
        }
        if (node != null && (node.getElementType() == PyElementTypes.PARENTHESIZED_EXPRESSION || node.getElementType() == PyElementTypes.LIST_LITERAL_EXPRESSION)) {
            PyQualifiedExpression expr;
            PyExpression pyExpression;
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
            return call != null && (pyExpression = call.getCallee()) instanceof PyQualifiedExpression && (expr = (PyQualifiedExpression)pyExpression).getQualifier() != null && callName.equals(expr.getReferencedName()) && qualifier.equals(expr.getQualifier().getName());
        }
        return false;
    }

    public static boolean isAssignedTo(ASTNode node, String targetName) {
        ASTNode _node = node.getTreeParent();
        if (!(_node == null || _node.getElementType() != PyElementTypes.ASSIGNMENT_STATEMENT && _node.getElementType() != PyElementTypes.AUG_ASSIGNMENT_STATEMENT || (_node = _node.getFirstChildNode()).getElementType() != PyElementTypes.TARGET_EXPRESSION && !PythonDialectsTokenSetProvider.getInstance().getReferenceExpressionTokens().contains(_node.getElementType()))) {
            String name = _node.getFirstChildNode().getText();
            return name.matches(targetName);
        }
        return false;
    }

    public static boolean isSettingsPy(PsiElement element) {
        PyFile file = (PyFile)ObjectUtils.tryCast((Object)element.getContainingFile(), PyFile.class);
        if (file == null) {
            return false;
        }
        return ContainerUtil.exists((Object[])TYPICAL_SETTINGS_PY_ATTRIBUTES, s -> !file.multiResolveName(s).isEmpty());
    }

    public static PsiElementPattern.Capture<PsiElement> keyValuePairWithKey(@NotNull String key) {
        if (key == null) {
            DjangoPsiUtil.$$$reportNull$$$0(4);
        }
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PyKeyValueExpression.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement(PyStringLiteralExpression.class).withText((ElementPattern)StandardPatterns.string().contains(key))));
    }

    public static PsiElementPattern.Capture<PsiElement> assignedTo(@NotNull String targetName) {
        if (targetName == null) {
            DjangoPsiUtil.$$$reportNull$$$0(5);
        }
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(PyAssignmentStatement.class)).withFirstChild((ElementPattern)PlatformPatterns.psiElement(PyTargetExpression.class).withText(targetName));
    }

    public static PsiElementPattern.Capture<PsiElement> valueInsideDictPattern(@NotNull String key, @NotNull String dictName) {
        if (key == null) {
            DjangoPsiUtil.$$$reportNull$$$0(6);
        }
        if (dictName == null) {
            DjangoPsiUtil.$$$reportNull$$$0(7);
        }
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(DjangoPsiUtil.keyValuePairWithKey(key))).inside((ElementPattern)PlatformPatterns.psiElement(PyAssignmentStatement.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement(PyTargetExpression.class).withText(dictName)))).afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PlatformPatterns.psiElement((IElementType)PyTokenTypes.COLON));
    }

    public static PsiElementPattern.Capture<PsiElement> valueInsideTupleOrList() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().andOr(new ElementPattern[]{PlatformPatterns.psiElement().withAncestor(2, (ElementPattern)PlatformPatterns.psiElement(PyParenthesizedExpression.class)), PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PyListLiteralExpression.class))});
    }

    public static PsiElementPattern.Capture<PsiElement> valueInsideTupleOrListAssignedTo(@NotNull String fieldName) {
        if (fieldName == null) {
            DjangoPsiUtil.$$$reportNull$$$0(8);
        }
        return (PsiElementPattern.Capture)DjangoPsiUtil.valueInsideTupleOrList().inside((ElementPattern)PlatformPatterns.psiElement(PyAssignmentStatement.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement(PyTargetExpression.class).withText(fieldName)));
    }

    public static boolean isTemplateResponseClass(PyClass cls) {
        return cls.isSubclass("django.views.generic.base.TemplateResponseMixin", null) || cls.isSubclass("django.forms.widgets.Widget", null);
    }

    public static boolean isWhitespace(IElementType tokenType1) {
        return tokenType1 == TokenType.WHITE_SPACE;
    }

    @Nullable
    public static PyCallExpression getPathCall(PsiElement element) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (call == null) {
            return null;
        }
        PyExpression callee = call.getCallee();
        if (callee == null) {
            return null;
        }
        String calleeName = callee.getName();
        if (calleeName == null) {
            return null;
        }
        if (NameResolverTools.isCalleeShortCut((PyCallExpression)call, (FQNamesProvider[])new FQNamesProvider[]{DjangoFQNamesProvider.URL_PATH_OR_RE_PATH_FUNCTION})) {
            return call;
        }
        if (NameResolverTools.isCalleeShortCut((PyCallExpression)call, (FQNamesProvider[])new FQNamesProvider[]{DjangoFQNamesProvider.INCLUDE_FUNCTION})) {
            return DjangoPsiUtil.getPathCall((PsiElement)call);
        }
        return null;
    }

    @Nullable
    public static PyCallExpression getIncludeCall(PsiElement element) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (call != null && DjangoPsiUtil.isIncludeCall(call)) {
            return call;
        }
        return null;
    }

    private static boolean isIncludeCall(@NotNull PyCallExpression call) {
        PyExpression callee;
        if (call == null) {
            DjangoPsiUtil.$$$reportNull$$$0(9);
        }
        if ((callee = call.getCallee()) == null) {
            return false;
        }
        if (!FQNamesProviderExtKt.shortNameMatches((FQNamesProvider)DjangoFQNamesProvider.INCLUDE_FUNCTION, (NavigationItem)callee)) {
            return false;
        }
        return call.multiResolveCalleeFunction(PyResolveContext.defaultContext((TypeEvalContext)TypeEvalContext.codeInsightFallback((Project)call.getProject()))).stream().map(PyQualifiedNameOwner::getQualifiedName).anyMatch(qName -> ArrayUtil.contains((String)qName, (String[])DjangoFQNamesProvider.INCLUDE_FUNCTION.getNames()));
    }

    @Nullable
    public static PyTupleExpression getTuple(PsiElement element) {
        PyTupleExpression tuple = (PyTupleExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyTupleExpression.class);
        if (tuple != null) {
            return tuple;
        }
        return null;
    }

    @Nullable
    public static PsiElement findContainingElementInBaseLanguage(PsiElement element) {
        DjangoTemplateFileViewProvider vProvider;
        PsiFile psi;
        FileViewProvider fileViewProvider = element.getContainingFile().getViewProvider();
        if (fileViewProvider instanceof DjangoTemplateFileViewProvider && (psi = (vProvider = (DjangoTemplateFileViewProvider)fileViewProvider).getPsi(vProvider.getBaseLanguage())) != null) {
            return vProvider.findElementAt(element.getTextRange().getStartOffset(), vProvider.getBaseLanguage());
        }
        return null;
    }

    @Nullable
    public static PsiElement findContainingElementInTemplateDataLanguage(PsiElement element) {
        DjangoTemplateFileViewProvider vProvider;
        PsiFile psi;
        FileViewProvider fileViewProvider = element.getContainingFile().getViewProvider();
        if (fileViewProvider instanceof DjangoTemplateFileViewProvider && (psi = (vProvider = (DjangoTemplateFileViewProvider)fileViewProvider).getPsi(vProvider.getTemplateDataLanguage())) != null) {
            return vProvider.findElementAt(element.getTextRange().getStartOffset(), vProvider.getTemplateDataLanguage());
        }
        return null;
    }

    public static Jinja2BlockTag findOpeningBlock(PsiElement tag) {
        while (tag != null) {
            Jinja2BlockTag block;
            if (PsiTreeUtil.getParentOfType((PsiElement)tag, DjangoTagElementImpl.class) != null) {
                tag = PsiTreeUtil.getParentOfType((PsiElement)tag, DjangoTagElementImpl.class);
            }
            if (tag instanceof DjangoTagElementImpl && (block = (Jinja2BlockTag)PsiTreeUtil.getChildOfType((PsiElement)tag, Jinja2BlockTag.class)) != null) {
                return block;
            }
            tag = tag.getPrevSibling();
        }
        return null;
    }

    @Nullable
    public static PsiElement prevFromTag(PsiElement el) {
        DjangoTagElementImpl element = (DjangoTagElementImpl)PsiTreeUtil.getParentOfType((PsiElement)el, DjangoTagElementImpl.class);
        if (element != null) {
            return element.getPrevSibling();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedTo";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/util/DjangoPsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileInRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isElementOfListOrTupleAssignedTo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "keyValuePairWithKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "assignedTo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "valueInsideDictPattern";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "valueInsideTupleOrListAssignedTo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncludeCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

