/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.SuggesterSupport;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.EditorFindAction;
import training.featuresSuggester.actions.EditorFocusGainedAction;
import training.featuresSuggester.suggesters.AbstractFeatureSuggester;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010!\u001a\u0004\u0018\u00010\"*\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ltraining/featuresSuggester/suggesters/FileStructureSuggester;", "Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "suggestingActionDisplayName", "getSuggestingActionDisplayName", "message", "getMessage", "suggestingActionId", "getSuggestingActionId", "suggestingTipId", "getSuggestingTipId", "minSuggestingIntervalDays", "", "getMinSuggestingIntervalDays", "()I", "languages", "", "getLanguages", "()Ljava/util/List;", "forceCheckForStatistics", "", "getForceCheckForStatistics", "()Z", "prevActionIsEditorFindAction", "getSuggestion", "Ltraining/featuresSuggester/Suggestion;", "action", "Ltraining/featuresSuggester/actions/Action;", "getDefinitionOnCaret", "Lcom/intellij/psi/PsiElement;", "Ltraining/featuresSuggester/SuggesterSupport;", "psiFile", "Lcom/intellij/psi/PsiFile;", "caretOffset", "getFindModel", "Lcom/intellij/find/FindModel;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.featuresTrainer"})
final class FileStructureSuggester
extends AbstractFeatureSuggester {
    @NotNull
    private final String id;
    @NotNull
    private final String suggestingActionDisplayName = FeatureSuggesterBundle.INSTANCE.message("file.structure.name", new Object[0]);
    @NotNull
    private final String message = FeatureSuggesterBundle.INSTANCE.message("file.structure.message", new Object[0]);
    @NotNull
    private final String suggestingActionId;
    @NotNull
    private final String suggestingTipId = this.getSuggestingActionId();
    private final int minSuggestingIntervalDays;
    @NotNull
    private final List<String> languages;
    private final boolean forceCheckForStatistics;
    private boolean prevActionIsEditorFindAction;

    public FileStructureSuggester() {
        this.id = "File structure";
        this.suggestingActionId = "FileStructurePopup";
        this.minSuggestingIntervalDays = 14;
        Object[] objectArray = new String[]{"JAVA", "kotlin", "Python", "JavaScript", "ECMAScript 6"};
        this.languages = CollectionsKt.listOf((Object[])objectArray);
        this.forceCheckForStatistics = true;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getSuggestingActionDisplayName() {
        return this.suggestingActionDisplayName;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    protected String getSuggestingActionId() {
        return this.suggestingActionId;
    }

    @Override
    @NotNull
    protected String getSuggestingTipId() {
        return this.suggestingTipId;
    }

    @Override
    public int getMinSuggestingIntervalDays() {
        return this.minSuggestingIntervalDays;
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    public boolean getForceCheckForStatistics() {
        return this.forceCheckForStatistics;
    }

    @Override
    @NotNull
    public Suggestion getSuggestion(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Language language = action.getLanguage();
        if (language == null) {
            return NoSuggestion.INSTANCE;
        }
        Language language2 = language;
        SuggesterSupport suggesterSupport = SuggesterSupport.Companion.getForLanguage(language2);
        if (suggesterSupport == null) {
            return NoSuggestion.INSTANCE;
        }
        SuggesterSupport langSupport = suggesterSupport;
        Action action2 = action;
        if (action2 instanceof EditorFindAction) {
            this.prevActionIsEditorFindAction = true;
        } else if (action2 instanceof EditorFocusGainedAction) {
            if (!this.prevActionIsEditorFindAction) {
                return NoSuggestion.INSTANCE;
            }
            PsiFile psiFile = ((EditorFocusGainedAction)action).getPsiFile();
            if (psiFile == null) {
                return NoSuggestion.INSTANCE;
            }
            PsiFile psiFile2 = psiFile;
            Project project = ((EditorFocusGainedAction)action).getProject();
            if (project == null) {
                return NoSuggestion.INSTANCE;
            }
            Project project2 = project;
            FindModel findModel = this.getFindModel(project2);
            String string = findModel.getStringToFind();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringToFind(...)");
            String textToFind = string;
            PsiElement definition = this.getDefinitionOnCaret(langSupport, psiFile2, ((EditorFocusGainedAction)action).getEditor().getCaretModel().getOffset());
            if (definition instanceof PsiNamedElement && langSupport.isFileStructureElement(definition)) {
                String string2 = ((PsiNamedElement)definition).getName();
                boolean bl = string2 != null ? StringsKt.contains((CharSequence)string2, (CharSequence)textToFind, (!findModel.isCaseSensitive() ? 1 : 0) != 0) : false;
                if (bl) {
                    this.prevActionIsEditorFindAction = false;
                    return this.createSuggestion();
                }
            }
        } else {
            this.prevActionIsEditorFindAction = false;
        }
        return NoSuggestion.INSTANCE;
    }

    private final PsiElement getDefinitionOnCaret(SuggesterSupport $this$getDefinitionOnCaret, PsiFile psiFile, int caretOffset) {
        int offset = caretOffset - 1;
        if (offset < 0) {
            return null;
        }
        PsiElement curElement = psiFile.findElementAt(offset);
        return curElement != null && $this$getDefinitionOnCaret.isIdentifier(curElement) ? curElement.getParent() : null;
    }

    private final FindModel getFindModel(Project project) {
        FindManager findManager = FindManager.getInstance((Project)project);
        FindModel findModel = new FindModel();
        findModel.copyFrom(findManager.getFindInFileModel());
        return findModel;
    }
}

