/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.markdown.processing;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.commonmark.node.Code;
import org.commonmark.node.Delimited;
import org.commonmark.node.Emphasis;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.parser.beta.ParsedInline;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;
import org.jetbrains.jewel.foundation.util.JewelLogger;
import org.jetbrains.jewel.markdown.InlineMarkdown;
import org.jetbrains.jewel.markdown.WithInlineMarkdown;
import org.jetbrains.jewel.markdown.WithTextContent;
import org.jetbrains.jewel.markdown.extensions.MarkdownDelimitedInlineProcessorExtension;
import org.jetbrains.jewel.markdown.processing.MarkdownProcessor;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0012\u0010\u0007\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"readInlineMarkdown", "", "Lorg/jetbrains/jewel/markdown/InlineMarkdown;", "Lorg/commonmark/node/Node;", "markdownProcessor", "Lorg/jetbrains/jewel/markdown/processing/MarkdownProcessor;", "toInlineMarkdownOrNull", "renderAsSimpleText", "", "intellij.platform.jewel.markdown.core"})
@SourceDebugExtension(value={"SMAP\nProcessingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessingUtil.kt\norg/jetbrains/jewel/markdown/processing/ProcessingUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class ProcessingUtilKt {
    @ExperimentalJewelApi
    @ApiStatus.Experimental
    @NotNull
    public static final List<InlineMarkdown> readInlineMarkdown(@NotNull Node $this$readInlineMarkdown, @NotNull MarkdownProcessor markdownProcessor) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$readInlineMarkdown, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)markdownProcessor, (String)"markdownProcessor");
        List $this$readInlineMarkdown_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Node current = $this$readInlineMarkdown.getFirstChild(); current != null; current = current.getNext()) {
            InlineMarkdown inline = ProcessingUtilKt.toInlineMarkdownOrNull(current, markdownProcessor);
            if (inline == null) continue;
            $this$readInlineMarkdown_u24lambda_u240.add(inline);
        }
        return CollectionsKt.build((List)list);
    }

    @ExperimentalJewelApi
    @ApiStatus.Experimental
    @Nullable
    public static final InlineMarkdown toInlineMarkdownOrNull(@NotNull Node $this$toInlineMarkdownOrNull, @NotNull MarkdownProcessor markdownProcessor) {
        InlineMarkdown inlineMarkdown;
        Intrinsics.checkNotNullParameter((Object)$this$toInlineMarkdownOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)markdownProcessor, (String)"markdownProcessor");
        Node node = $this$toInlineMarkdownOrNull;
        if (node instanceof Text) {
            String string = ((Text)$this$toInlineMarkdownOrNull).getLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
            inlineMarkdown = new InlineMarkdown.Text(string);
        } else if (node instanceof Link) {
            String string = ((Link)$this$toInlineMarkdownOrNull).getDestination();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDestination(...)");
            inlineMarkdown = new InlineMarkdown.Link(string, ((Link)$this$toInlineMarkdownOrNull).getTitle(), ProcessingUtilKt.readInlineMarkdown($this$toInlineMarkdownOrNull, markdownProcessor));
        } else if (node instanceof Emphasis) {
            String string = ((Emphasis)$this$toInlineMarkdownOrNull).getOpeningDelimiter();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOpeningDelimiter(...)");
            inlineMarkdown = new InlineMarkdown.Emphasis(string, ProcessingUtilKt.readInlineMarkdown($this$toInlineMarkdownOrNull, markdownProcessor));
        } else if (node instanceof StrongEmphasis) {
            String string = ((StrongEmphasis)$this$toInlineMarkdownOrNull).getOpeningDelimiter();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOpeningDelimiter(...)");
            inlineMarkdown = new InlineMarkdown.StrongEmphasis(string, ProcessingUtilKt.readInlineMarkdown($this$toInlineMarkdownOrNull, markdownProcessor));
        } else if (node instanceof Code) {
            String string = ((Code)$this$toInlineMarkdownOrNull).getLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
            inlineMarkdown = new InlineMarkdown.Code(string);
        } else if (node instanceof HtmlInline) {
            String string = ((HtmlInline)$this$toInlineMarkdownOrNull).getLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLiteral(...)");
            inlineMarkdown = new InlineMarkdown.HtmlInline(string);
        } else if (node instanceof Image) {
            List<InlineMarkdown> inlineContent = ProcessingUtilKt.readInlineMarkdown($this$toInlineMarkdownOrNull, markdownProcessor);
            String string = ((Image)$this$toInlineMarkdownOrNull).getDestination();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDestination(...)");
            inlineMarkdown = new InlineMarkdown.Image(string, ((Object)StringsKt.trim((CharSequence)ProcessingUtilKt.renderAsSimpleText(inlineContent))).toString(), ((Image)$this$toInlineMarkdownOrNull).getTitle(), inlineContent);
        } else if (node instanceof HardLineBreak) {
            inlineMarkdown = InlineMarkdown.HardLineBreak.INSTANCE;
        } else if (node instanceof SoftLineBreak) {
            inlineMarkdown = InlineMarkdown.SoftLineBreak.INSTANCE;
        } else if (node instanceof Delimited) {
            Object v6;
            block23: {
                Iterable iterable = markdownProcessor.getDelimitedInlineExtensions();
                for (Object t : iterable) {
                    MarkdownDelimitedInlineProcessorExtension it = (MarkdownDelimitedInlineProcessorExtension)t;
                    boolean bl = false;
                    if (!it.canProcess((Delimited)((Object)$this$toInlineMarkdownOrNull))) continue;
                    v6 = t;
                    break block23;
                }
                v6 = null;
            }
            MarkdownDelimitedInlineProcessorExtension markdownDelimitedInlineProcessorExtension = v6;
            inlineMarkdown = markdownDelimitedInlineProcessorExtension != null ? markdownDelimitedInlineProcessorExtension.processDelimitedInline((Delimited)((Object)$this$toInlineMarkdownOrNull), markdownProcessor) : null;
        } else if (node instanceof ParsedInline) {
            inlineMarkdown = null;
        } else {
            throw new IllegalStateException(("Unexpected block " + $this$toInlineMarkdownOrNull).toString());
        }
        return inlineMarkdown;
    }

    @NotNull
    public static final String renderAsSimpleText(@NotNull List<? extends InlineMarkdown> $this$renderAsSimpleText) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$renderAsSimpleText, (String)"<this>");
        StringBuilder $this$renderAsSimpleText_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (InlineMarkdown inlineMarkdown : $this$renderAsSimpleText) {
            StringBuilder stringBuilder2;
            InlineMarkdown inlineMarkdown2 = inlineMarkdown;
            if (inlineMarkdown2 instanceof WithInlineMarkdown) {
                stringBuilder2 = $this$renderAsSimpleText_u24lambda_u242.append(ProcessingUtilKt.renderAsSimpleText(((WithInlineMarkdown)((Object)inlineMarkdown)).getInlineContent()));
                continue;
            }
            if (inlineMarkdown2 instanceof WithTextContent) {
                stringBuilder2 = $this$renderAsSimpleText_u24lambda_u242.append(((WithTextContent)((Object)inlineMarkdown)).getContent());
                continue;
            }
            if (inlineMarkdown2 instanceof InlineMarkdown.HardLineBreak) {
                stringBuilder2 = $this$renderAsSimpleText_u24lambda_u242.append('\n');
                continue;
            }
            if (inlineMarkdown2 instanceof InlineMarkdown.SoftLineBreak) {
                stringBuilder2 = $this$renderAsSimpleText_u24lambda_u242.append(' ');
                continue;
            }
            JewelLogger.Companion.getInstance("MarkdownProcessingUtil").debug("Ignoring node " + inlineMarkdown.getClass().getSimpleName() + " for text rendering");
            stringBuilder2 = Unit.INSTANCE;
        }
        return stringBuilder.toString();
    }
}

