/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.psi.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssStubElementTypes;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSElementGenerator;
import org.jetbrains.plugins.sass.psi.SASSDeclarationBlock;
import org.jetbrains.plugins.sass.psi.SASSTokenTypes;

public class SASSDeclarationBlockImpl
extends LazyParseablePsiElement
implements SASSDeclarationBlock {
    private static final TokenSet DECLARATION_FILTER = TokenSet.create((IElementType[])new IElementType[]{CssStubElementTypes.CSS_DECLARATION});

    public SASSDeclarationBlockImpl(@NotNull IElementType elementType, CharSequence text) {
        if (elementType == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(0);
        }
        super(elementType, text);
    }

    @NotNull
    public Language getLanguage() {
        Language language = CssElement.getLanguageOf((CssElement)this);
        if (language == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(1);
        }
        return language;
    }

    public CssRuleset @NotNull [] getRulesets() {
        CssRuleset[] cssRulesetArray = (CssRuleset[])this.getChildrenAsPsiElements((IElementType)CssStubElementTypes.CSS_RULESET, CssRuleset.ARRAY_FACTORY);
        if (cssRulesetArray == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(2);
        }
        return cssRulesetArray;
    }

    public CssDeclaration @NotNull [] getDeclarations() {
        CssDeclaration[] cssDeclarationArray = (CssDeclaration[])this.getChildrenAsPsiElements(DECLARATION_FILTER, CssDeclaration.ARRAY_FACTORY);
        if (cssDeclarationArray == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(3);
        }
        return cssDeclarationArray;
    }

    @Nullable
    public PsiElement getLBrace() {
        ASTNode node;
        PsiElement firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)this);
        if (firstChild instanceof PsiWhiteSpace) {
            firstChild = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild);
        }
        if (firstChild != null && (node = firstChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_LBRACE) {
            return firstChild;
        }
        return null;
    }

    @Nullable
    public PsiElement getRBrace() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RBRACE) {
            return lastChild;
        }
        return null;
    }

    public boolean isEqualTo(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SASSDeclarationBlockImpl block = (SASSDeclarationBlockImpl)o;
        return Arrays.equals(this.getDeclarations(), block.getDeclarations());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssBlock((CssBlock)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public CssDeclaration addDeclaration(@NotNull String name, @NotNull String value, @Nullable CssDeclaration anchor) {
        if (name == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(5);
        }
        if (value == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(6);
        }
        assert (anchor == null || anchor.getParent() == this);
        CssDeclaration cssDeclaration = SASSElementGenerator.createSASSDeclaration(this.getProject(), name, value);
        PsiElement newLine = PsiParserFacade.getInstance((Project)this.getProject()).createWhiteSpaceFromText("\n");
        CssDeclaration _anchor = anchor == null ? this.getFirstChild() : anchor;
        CssDeclaration result = (CssDeclaration)this.addAfter((PsiElement)cssDeclaration, (PsiElement)_anchor);
        this.addAfter(newLine, (PsiElement)_anchor);
        return result;
    }

    public void removeDeclaration(@NotNull CssDeclaration declaration) throws IncorrectOperationException {
        if (declaration == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(7);
        }
        assert (declaration.getParent() == this);
        PsiElement nextSibling = declaration.getNextSibling();
        if (nextSibling != null && TokenSet.create((IElementType[])new IElementType[]{SASSTokenTypes.EOL, TokenType.WHITE_SPACE}).contains(nextSibling.getNode().getElementType())) {
            nextSibling.delete();
        }
        declaration.delete();
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName) {
        if (propertyName == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(8);
        }
        return this.findDeclaration(propertyName, true);
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName, boolean searchInShorthand) {
        if (propertyName == null) {
            SASSDeclarationBlockImpl.$$$reportNull$$$0(9);
        }
        return CssPsiUtil.findDeclaration((CssBlock)this, (String)propertyName, (boolean)searchInShorthand);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/psi/impl/SASSDeclarationBlockImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeDeclaration";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

