/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features.correctness;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004\"*\u0010\n\u001a\u001e\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"findTargetElements", "", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "currentChangedRange", "Lcom/intellij/openapi/util/TextRange;", "createExtendedTextRange", "range", "file", "brackets", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "intellij.fullLine.java"})
public final class JavaSuggestionEnricherKt {
    @NotNull
    private static final Map<IElementType, IElementType> brackets;

    @NotNull
    public static final List<PsiElement> findTargetElements(@NotNull PsiFile psiFile2, @NotNull TextRange currentChangedRange) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)currentChangedRange, (String)"currentChangedRange");
        PsiElement psiElement2 = psiFile2.findElementAt(currentChangedRange.getStartOffset());
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement startBoundaryElement = psiElement2;
        if (startBoundaryElement instanceof PsiWhiteSpace) {
            PsiElement psiElement3 = PsiTreeUtil.nextCodeLeaf((PsiElement)startBoundaryElement);
            if (psiElement3 == null) {
                return CollectionsKt.emptyList();
            }
            startBoundaryElement = psiElement3;
            startBoundaryElement = PsiTreeUtil.getDeepestFirst((PsiElement)startBoundaryElement);
        }
        if (currentChangedRange.getEndOffset() - 1 <= 0) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement4 = psiFile2.findElementAt(currentChangedRange.getEndOffset() - 1);
        if (psiElement4 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement endBoundaryElement = psiElement4;
        if (endBoundaryElement instanceof PsiWhiteSpace) {
            PsiElement psiElement5 = PsiTreeUtil.prevCodeLeaf((PsiElement)endBoundaryElement);
            if (psiElement5 == null) {
                return CollectionsKt.emptyList();
            }
            endBoundaryElement = psiElement5;
            endBoundaryElement = PsiTreeUtil.getDeepestLast((PsiElement)endBoundaryElement);
        }
        if (Intrinsics.areEqual((Object)startBoundaryElement, (Object)endBoundaryElement) ? (psiElement = startBoundaryElement.getParent()) == null : (psiElement = PsiTreeUtil.findCommonParent((PsiElement)startBoundaryElement, (PsiElement)endBoundaryElement)) == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement commonParent = psiElement;
        Object[] statements = null;
        if (commonParent instanceof PsiCodeBlock) {
            statements = ((PsiCodeBlock)commonParent).getStatements();
        } else if (commonParent instanceof PsiBlockStatement) {
            statements = ((PsiBlockStatement)commonParent).getCodeBlock().getStatements();
        }
        if (statements != null) {
            if (statements.length == 0) {
                return CollectionsKt.listOf((Object)commonParent);
            }
            if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)statements[0]), (PsiElement)startBoundaryElement, (boolean)false) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ArraysKt.last((Object[])statements)), (PsiElement)endBoundaryElement, (boolean)false)) {
                return CollectionsKt.listOf((Object)commonParent);
            }
        }
        PsiStatement startStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)startBoundaryElement, PsiStatement.class, (boolean)false);
        PsiStatement endStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)endBoundaryElement, PsiStatement.class, (boolean)false);
        if (startStatement != null && endStatement != null && Intrinsics.areEqual((Object)startStatement.getParent(), (Object)commonParent)) {
            List result2 = new ArrayList();
            PsiElement currentElement = (PsiElement)startStatement;
            while (true) {
                result2.add(currentElement);
                if (PsiTreeUtil.isAncestor((PsiElement)currentElement, (PsiElement)((PsiElement)endStatement), (boolean)false) || currentElement.getNextSibling() == null) break;
            }
            return result2;
        }
        Class[] classArray = new Class[]{PsiVariable.class, PsiStatement.class, PsiCodeBlock.class, PsiMember.class};
        PsiElement psiElement6 = PsiTreeUtil.getParentOfType((PsiElement)commonParent, (boolean)false, (Class[])classArray);
        if (psiElement6 == null) {
            psiElement6 = commonParent;
        }
        return CollectionsKt.listOf((Object)psiElement6);
    }

    @NotNull
    public static final TextRange createExtendedTextRange(@NotNull TextRange range, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PsiElement psiElement = file2.findElementAt(range.getStartOffset());
        if (psiElement == null) {
            return range;
        }
        PsiElement element = psiElement;
        Class[] classArray = new Class[]{PsiStatement.class};
        PsiStatement psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (boolean)false, (Class[])classArray);
        if (psiStatement == null) {
            return range;
        }
        PsiStatement parent = psiStatement;
        return new TextRange(parent.getTextRange().getStartOffset(), range.getEndOffset());
    }

    public static final /* synthetic */ Map access$getBrackets$p() {
        return brackets;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JavaTokenType.RPARENTH, (Object)JavaTokenType.LPARENTH), TuplesKt.to((Object)JavaTokenType.RBRACE, (Object)JavaTokenType.LBRACE), TuplesKt.to((Object)JavaTokenType.RBRACKET, (Object)JavaTokenType.LBRACKET)};
        brackets = MapsKt.mutableMapOf((Pair[])pairArray);
    }
}

