/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.actions.convert;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellsContents;
import com.intellij.jupyter.core.jupyter.actions.convert.ConvertAction;
import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguage;
import com.intellij.notebooks.visualization.IntervalsGenerator;
import com.intellij.notebooks.visualization.NotebookCellLinesProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.jetbrains.python.PythonLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/py/actions/convert/ConvertJupyterToPythonAction;", "Lcom/intellij/jupyter/core/jupyter/actions/convert/ConvertAction;", "<init>", "()V", "sourceLanguage", "Lcom/intellij/lang/Language;", "getSourceLanguage", "()Lcom/intellij/lang/Language;", "targetLanguage", "getTargetLanguage", "isSupported", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadContents", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellsContents;", "virtualFile", "writeContents", "", "content", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nConvertJupyterToPythonAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertJupyterToPythonAction.kt\ncom/intellij/jupyter/py/actions/convert/ConvertJupyterToPythonAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,48:1\n12364#2,2:49\n3829#2:51\n4344#2:52\n4345#2:54\n19#3:53\n*S KotlinDebug\n*F\n+ 1 ConvertJupyterToPythonAction.kt\ncom/intellij/jupyter/py/actions/convert/ConvertJupyterToPythonAction\n*L\n29#1:49,2\n34#1:51\n34#1:52\n34#1:54\n34#1:53\n*E\n"})
public final class ConvertJupyterToPythonAction
extends ConvertAction {
    @NotNull
    private final Language sourceLanguage = (Language)JupyterLanguage.INSTANCE;
    @NotNull
    private final Language targetLanguage;

    public ConvertJupyterToPythonAction() {
        PythonLanguage pythonLanguage = PythonLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)pythonLanguage, (String)"INSTANCE");
        this.targetLanguage = (Language)pythonLanguage;
    }

    @NotNull
    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    @NotNull
    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    protected boolean isSupported(@NotNull AnActionEvent e) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return false;
            }
            VirtualFile[] files = virtualFileArray;
            if (files.length == 0) {
                return false;
            }
            VirtualFile[] $this$all$iv = files;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getExtension(), (Object)JupyterFileType.INSTANCE.getDefaultExtension())) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected List<VirtualFile> getFile(@NotNull AnActionEvent e) {
        void $this$filterTo$iv$iv;
        VirtualFile[] virtualFiles;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return null;
        }
        VirtualFile[] $this$filter$iv = virtualFiles = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            FileType $this$asSafely$iv = it.getFileType();
            boolean $i$f$asSafely = false;
            FileType fileType = $this$asSafely$iv;
            if (!(fileType instanceof LanguageFileType)) {
                fileType = null;
            }
            LanguageFileType languageFileType = (LanguageFileType)fileType;
            if (!Intrinsics.areEqual((Object)(languageFileType != null ? languageFileType.getLanguage() : null), (Object)this.getSourceLanguage())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public NotebookCellsContents loadContents(@NotNull VirtualFile virtualFile) {
        Object object;
        Document document;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Document document2 = VirtualFileUtil.findDocument((VirtualFile)virtualFile);
        if (document2 == null) {
            document2 = document = (Document)new DocumentImpl(LoadTextUtil.loadText((VirtualFile)virtualFile));
        }
        if ((object = (NotebookCellLinesProvider)NotebookCellLinesProvider.Companion.forLanguage(this.getSourceLanguage())) == null || (object = IntervalsGenerator.makeIntervals$default((IntervalsGenerator)((IntervalsGenerator)object), (Document)document, null, (int)2, null)) == null) {
            return null;
        }
        Object intervals = object;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new NotebookCellsContents(string, (List)intervals, null, this.getSourceLanguage(), 4, null);
    }

    public void writeContents(@NotNull VirtualFile virtualFile, @NotNull NotebookCellsContents content, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = (NotebookCellLinesEditHelper)NotebookCellLinesEditHelper.Companion.forLanguage(this.getTargetLanguage());
        if (notebookCellLinesEditHelper == null) {
            return;
        }
        NotebookCellLinesEditHelper helper = notebookCellLinesEditHelper;
        String text = helper.makeInsertedCells(content, 0);
        VirtualFileUtil.writeText((VirtualFile)virtualFile, (String)text);
    }
}

