/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editing.JSStringLiteralCopyPasteProcessor;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSIntroducedExpressionUtil {
    private JSIntroducedExpressionUtil() {
    }

    @Nullable
    public static List<Pair<JSExpression, TextRange>> findExpressionsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(0);
        }
        if (startOffset > endOffset) {
            return ContainerUtil.emptyList();
        }
        PsiElement element1 = file.findElementAt(startOffset);
        if (startOffset == endOffset) {
            return JSIntroducedExpressionUtil.findExpressionsAtOffset(file, startOffset);
        }
        while (element1 instanceof PsiWhiteSpace || JSIntroducedExpressionUtil.isLDelimiter(element1)) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        }
        PsiElement element2 = file.findElementAt(endOffset - 1);
        while (element2 instanceof PsiWhiteSpace || JSIntroducedExpressionUtil.isRDelimiter(element2)) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = PsiTreeUtil.prevLeaf((PsiElement)element2);
        }
        TextRange range = new TextRange(startOffset, endOffset);
        JSExpression expression = (JSExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, JSExpression.class);
        if (expression != null && expression.getTextRange().getEndOffset() < range.getEndOffset()) {
            expression = null;
        }
        if (expression != null && JSIntroducedExpressionUtil.isInvalidExpression((PsiElement)expression)) {
            return null;
        }
        if (expression != null && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) != ReadWriteAccessDetector.Access.Read) {
            return null;
        }
        if (expression != null) {
            return Collections.singletonList(new Pair((Object)JSUtils.getTopmostParenthesizedOrSelf(expression), null));
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        JSExpression element1ExpressionParent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element1, JSExpression.class);
        JSExpression element2ExpressionParent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSExpression.class);
        if (element1ExpressionParent == null || element2ExpressionParent == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1ExpressionParent, (PsiElement)element2ExpressionParent);
        if (!(parent instanceof JSExpression)) {
            return null;
        }
        if (parent instanceof JSLiteralExpression) {
            if (parent instanceof JSXmlLiteralExpression && ((JSXmlLiteralExpression)parent).getValue().getTextRange().contains(range) || ((JSLiteralExpression)parent).isQuotedLiteral() && JSIntroducedExpressionUtil.isAcceptableQuotedLiteralRange((JSLiteralExpression)parent, range)) {
                return Collections.singletonList(Pair.create((Object)((JSLiteralExpression)parent), (Object)range));
            }
            return null;
        }
        if (range.contains(element1ExpressionParent.getTextRange()) && range.contains(element2ExpressionParent.getTextRange())) {
            PsiElement nextParent;
            while (!(parent instanceof JSBinaryExpression && parent.getTextRange().contains(range) || JSIntroducedExpressionUtil.elementNotAllowedInBinaryExpression(range, parent) || !((nextParent = parent.getParent()) instanceof JSExpression))) {
                parent = nextParent;
            }
            if (parent instanceof JSBinaryExpression) {
                if ((parent = JSIntroducedExpressionUtil.ensureNoIntersection(range, parent, element1ExpressionParent)) != null) {
                    parent = JSIntroducedExpressionUtil.ensureNoIntersection(range, parent, element2ExpressionParent);
                }
                if (parent != null) {
                    return Collections.singletonList(Pair.create((Object)((JSExpression)parent), (Object)range));
                }
            }
        }
        return null;
    }

    @NotNull
    private static List<Pair<JSExpression, TextRange>> findExpressionsAtOffset(@NotNull PsiFile file, int startOffset) {
        if (file == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(1);
        }
        ArrayList<Pair<JSExpression, TextRange>> result2 = new ArrayList<Pair<JSExpression, TextRange>>();
        HashSet<JSExpression> processed = new HashSet<JSExpression>();
        for (PsiElement element = JSIntroducedExpressionUtil.adjustElement(startOffset, file.findElementAt(startOffset - 1)); element != null && !(element instanceof JSStatement); element = element.getParent()) {
            if (element instanceof JSExpression) {
                JSExpression expression;
                if (JSIntroducedExpressionUtil.isInvalidExpression(element) || JSIntroducedExpressionUtil.isMethodExpression(element) || !processed.add(expression = JSUtils.getTopmostParenthesizedOrSelf((JSExpression)element))) continue;
                result2.add((Pair<JSExpression, TextRange>)new Pair((Object)expression, null));
                continue;
            }
            if (!(element instanceof JSArgumentList) && !result2.isEmpty()) break;
        }
        ArrayList<Pair<JSExpression, TextRange>> arrayList = result2;
        if (arrayList == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Contract(value="null -> false")
    private static boolean isRDelimiter(@Nullable PsiElement element2) {
        IElementType type2 = PsiUtilCore.getElementType((PsiElement)element2);
        return type2 == JSTokenTypes.SEMICOLON || type2 == JSTokenTypes.COMMA;
    }

    @Contract(value="null -> false")
    private static boolean isLDelimiter(@Nullable PsiElement element2) {
        IElementType type2 = PsiUtilCore.getElementType((PsiElement)element2);
        return type2 == JSTokenTypes.COMMA;
    }

    private static boolean isAcceptableQuotedLiteralRange(JSLiteralExpression parent, TextRange range) {
        char quote;
        if (parent instanceof JSStringTemplateExpression) {
            return JSStringLiteralCopyPasteProcessor.isInStringRange((JSStringTemplateExpression)parent, range.getStartOffset()) && JSStringLiteralCopyPasteProcessor.isInStringRange((JSStringTemplateExpression)parent, range.getEndOffset());
        }
        String text = parent.getText();
        int innerLength = StringUtil.endsWithChar((CharSequence)text, (char)(quote = text.charAt(0))) && text.length() >= 2 ? text.length() - 2 : text.length() - 1;
        TextRange valueRange = TextRange.from((int)(parent.getTextRange().getStartOffset() + 1), (int)innerLength);
        return valueRange.contains(range);
    }

    private static PsiElement ensureNoIntersection(TextRange range, PsiElement parent, JSExpression element2ExpressionParent) {
        for (JSExpression e = element2ExpressionParent; e != parent; e = e.getParent()) {
            if (!JSIntroducedExpressionUtil.elementNotAllowedInBinaryExpression(range, (PsiElement)e)) continue;
            parent = null;
            break;
        }
        return parent;
    }

    private static PsiElement adjustElement(int startOffset, PsiElement element1) {
        JSExpression returnedExpression;
        JSReturnStatement ret;
        IElementType element1NodeType;
        if (element1 instanceof PsiWhiteSpace && startOffset == element1.getTextRange().getEndOffset()) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        } else if (element1 != null && element1.getNode() != null && ((element1NodeType = element1.getNode().getElementType()) == JSTokenTypes.LPAR || element1NodeType == JSTokenTypes.LBRACKET || element1NodeType == JSTokenTypes.COMMA)) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && (element1.getNode().getElementType() == JSTokenTypes.SEMICOLON || element1.getNode().getElementType() == JSTokenTypes.RPAR)) {
            element1 = PsiTreeUtil.prevLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && element1.getNode().getElementType() == JSTokenTypes.RETURN_KEYWORD && (ret = (JSReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)element1, JSReturnStatement.class)) != null && (returnedExpression = ret.getExpression()) != null) {
            element1 = returnedExpression.getFirstChild();
        }
        if (element1 != null && element1.getNode() != null && element1.getNode().getElementType() == JSTokenTypes.LBRACE && element1.getParent() instanceof JSStringTemplateExpression) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && element1.getNode().getElementType() == JSTokenTypes.RBRACE && element1.getParent() instanceof JSStringTemplateExpression) {
            element1 = PsiTreeUtil.prevLeaf((PsiElement)element1);
        }
        return element1;
    }

    private static boolean elementNotAllowedInBinaryExpression(TextRange range, PsiElement parent) {
        return parent instanceof JSParenthesizedExpression && !range.contains(parent.getTextRange());
    }

    private static boolean isMethodExpression(PsiElement element1) {
        return element1 instanceof JSReferenceExpression && (element1.getParent() instanceof JSCallExpression || element1.getParent() instanceof ES6TaggedTemplateExpression);
    }

    private static boolean isInvalidExpression(PsiElement element) {
        return element instanceof JSReferenceExpression && JSIntroducedExpressionUtil.isInvalidRefExpr((JSReferenceExpression)element) || element instanceof JSDefinitionExpression || element instanceof JSLiteralExpression && element.getParent() instanceof TypeScriptModule || JSIntroducedExpressionUtil.isReferenceListMember(element) || JSIntroducedExpressionUtil.isInTypeContext(element) || element instanceof JSSpreadExpression || element instanceof JSArrayLiteralExpression && element.getParent() instanceof JSNewExpression || element instanceof JSStringTemplateExpression && element.getParent() instanceof ES6TaggedTemplateExpression || JSIntroducedExpressionUtil.isOverloadInExportDefault(element);
    }

    private static boolean isOverloadInExportDefault(PsiElement element) {
        if (element instanceof JSFunctionExpression && element instanceof TypeScriptFunction) {
            TypeScriptFunction typeScriptFunction = (TypeScriptFunction)element;
            if (element.getParent() instanceof ES6ExportDefaultAssignment && (typeScriptFunction.isOverloadDeclaration() || typeScriptFunction.isOverloadImplementation())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isReferenceListMember(PsiElement element) {
        return element instanceof JSExpression && element.getParent() instanceof JSReferenceListMember && !(element.getParent().getParent() instanceof ES6ReferenceList);
    }

    private static boolean isInTypeContext(PsiElement element) {
        return element instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)JSResolveUtil.getTopReferenceExpression(element));
    }

    private static boolean isInvalidRefExpr(JSReferenceExpression element1) {
        PsiElement element1Parent;
        if (element1 instanceof TypeScriptEntityName || (element1Parent = element1.getParent()) instanceof JSGenericSignature || element1Parent instanceof JSDefinitionExpression || element1Parent instanceof JSImportStatement || JSResolveUtil.isSelfReference((PsiElement)element1)) {
            return true;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)element1);
        if (element1.getQualifier() == null) {
            if (dialect != null && dialect.isTypeScript && element1.resolve() instanceof TypeScriptCompileTimeType) {
                return true;
            }
            if (dialect != null && dialect.isECMA4 && element1.resolve() instanceof JSClass) {
                return true;
            }
        }
        if (dialect != null && dialect.isECMA4) {
            return element1.resolve() instanceof JSPackage;
        }
        return false;
    }

    public static Replacer createReplacer(@NotNull Pair<? extends JSExpression, TextRange> expressionDescriptor) {
        if (expressionDescriptor == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(3);
        }
        return new Replacer(expressionDescriptor);
    }

    public static boolean willReplacePartOfExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        return JSIntroducedExpressionUtil.willReplacePartOfExpression(JSIntroducedExpressionUtil.isIntroducingPartOfExpression(expressionDescriptor), (JSExpression)expressionDescriptor.first);
    }

    private static boolean willReplacePartOfExpression(boolean partialRangeSelected, @NotNull JSExpression occurrence) {
        if (occurrence == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(4);
        }
        if (occurrence instanceof JSXmlLiteralExpression && (occurrence.getParent() instanceof JSXmlLiteralExpression || partialRangeSelected)) {
            return true;
        }
        if (!partialRangeSelected) {
            return false;
        }
        return occurrence instanceof JSStringTemplateExpression || occurrence instanceof JSLiteralExpression && ((JSLiteralExpression)occurrence).isQuotedLiteral() || occurrence instanceof JSBinaryExpression;
    }

    public static boolean isIntroducingPartOfExpression(@NotNull Pair<? extends JSExpression, TextRange> descriptor) {
        if (descriptor == null) {
            JSIntroducedExpressionUtil.$$$reportNull$$$0(5);
        }
        if (descriptor.second == null) {
            return false;
        }
        if (((TextRange)descriptor.second).equals((Object)((JSExpression)descriptor.first).getTextRange())) {
            return false;
        }
        if (descriptor.first instanceof JSLiteralExpression && ((JSLiteralExpression)descriptor.first).isQuotedLiteral()) {
            TextRange expressionRange = ((JSExpression)descriptor.first).getTextRange();
            if (((TextRange)descriptor.second).getStartOffset() == expressionRange.getStartOffset() + 1 && ((TextRange)descriptor.second).getEndOffset() == expressionRange.getEndOffset() - 1) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/JSIntroducedExpressionUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSIntroducedExpressionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionsAtOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionsInRange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionsAtOffset";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createReplacer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "willReplacePartOfExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIntroducingPartOfExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class Replacer {
        @NotNull
        private final JSExpression myExpression;
        private final String myExpressionText;
        private final TextRange myRelativeRange;
        private final boolean myIsIntroducingPartOfExpression;

        public Replacer(@NotNull Pair<? extends JSExpression, TextRange> expressionDescriptor) {
            if (expressionDescriptor == null) {
                Replacer.$$$reportNull$$$0(0);
            }
            this.myExpression = (JSExpression)expressionDescriptor.first;
            this.myIsIntroducingPartOfExpression = JSIntroducedExpressionUtil.isIntroducingPartOfExpression(expressionDescriptor);
            JSExpression expression = (JSExpression)expressionDescriptor.first;
            TextRange range = (TextRange)expressionDescriptor.second;
            if (range == null) {
                range = expression.getTextRange();
            }
            if (expression instanceof JSXmlLiteralExpression && (expression.getParent() instanceof JSXmlLiteralExpression || this.isIntroducingPartOfExpression())) {
                expression = Replacer.findTopXmlLiteralExpression(expression);
            }
            this.myExpressionText = expression.getText();
            this.myRelativeRange = range.shiftLeft(expression.getTextRange().getStartOffset());
        }

        @NotNull
        public JSExpression getOriginalExpression() {
            JSExpression jSExpression = this.myExpression;
            if (jSExpression == null) {
                Replacer.$$$reportNull$$$0(1);
            }
            return jSExpression;
        }

        public JSExpression replaceExpression(@NotNull JSExpression replacementExpression) {
            if (replacementExpression == null) {
                Replacer.$$$reportNull$$$0(2);
            }
            return this.replaceOccurrence(this.myExpression, replacementExpression);
        }

        @Nullable
        public JSExpression replaceOccurrence(@NotNull JSExpression toReplace, @NotNull JSExpression replacementExpression) {
            JSExpression replaced;
            if (toReplace == null) {
                Replacer.$$$reportNull$$$0(3);
            }
            if (replacementExpression == null) {
                Replacer.$$$reportNull$$$0(4);
            }
            if (JSIntroducedExpressionUtil.willReplacePartOfExpression(this.isIntroducingPartOfExpression(), toReplace) && (replaced = this.tryReplacePartOfExpression(toReplace, replacementExpression)) != null) {
                int offset = this.myRelativeRange.getStartOffset();
                return Replacer.findReferenceToIntroduced(replaced, replacementExpression, offset);
            }
            return toReplace.replace(replacementExpression);
        }

        public String getIntroducedExpressionText() {
            DialectOptionHolder holder;
            String text = this.myExpressionText;
            text = this.myRelativeRange.substring(text);
            JSExpression expression = this.myExpression;
            if (expression instanceof JSXmlLiteralExpression && ((holder = DialectDetector.dialectOfElement((PsiElement)expression)) != null && holder.hasE4XStandard() || !Replacer.hasSingleTag((JSXmlLiteralExpression)expression))) {
                return "<>" + text + "</>";
            }
            if (expression instanceof JSLiteralExpression) {
                if (((JSLiteralExpression)expression).isQuotedLiteral() && this.isIntroducingPartOfExpression()) {
                    String quote = this.myExpressionText.substring(0, 1);
                    return quote + text + quote;
                }
                return this.myExpressionText;
            }
            while (Replacer.isParenthesized(text, (PsiElement)expression)) {
                text = text.substring(1, text.length() - 1);
            }
            return text;
        }

        private static boolean isParenthesized(String text, PsiElement expression) {
            ASTNode context2 = JSChangeUtil.createExpressionWithContext(text, expression);
            if (context2 == null) {
                return false;
            }
            return context2.getPsi() instanceof JSParenthesizedExpression;
        }

        private static boolean hasSingleTag(JSXmlLiteralExpression expression) {
            if (expression.getSubTags().length != 1) {
                return false;
            }
            return SyntaxTraverser.psiTraverser((PsiElement)expression).children((Object)expression).filter(c -> !(c instanceof XmlToken) && !(c instanceof PsiWhiteSpace)).size() == 1;
        }

        private static JSExpression findTopXmlLiteralExpression(JSExpression expression) {
            PsiElement myParent;
            while ((myParent = expression.getParent()) instanceof JSXmlLiteralExpression) {
                expression = (JSExpression)myParent;
            }
            return expression;
        }

        private boolean isIntroducingPartOfExpression() {
            return this.myIsIntroducingPartOfExpression;
        }

        @Nullable
        private JSExpression tryReplacePartOfExpression(@NotNull JSExpression toReplace, @NotNull JSExpression replacementExpression) {
            if (toReplace == null) {
                Replacer.$$$reportNull$$$0(5);
            }
            if (replacementExpression == null) {
                Replacer.$$$reportNull$$$0(6);
            }
            if (toReplace instanceof JSXmlLiteralExpression && (toReplace.getParent() instanceof JSXmlLiteralExpression || this.isIntroducingPartOfExpression())) {
                toReplace = Replacer.findTopXmlLiteralExpression(toReplace);
                String prefix = replacementExpression instanceof JSXmlLiteralExpression ? "" : "{";
                String suffix = replacementExpression instanceof JSXmlLiteralExpression ? "" : "}";
                return toReplace.replace(this.buildTextForReplacement(replacementExpression, prefix, suffix));
            }
            if (this.isIntroducingPartOfExpression()) {
                if (toReplace instanceof JSStringTemplateExpression) {
                    String prefix = "${";
                    String replacementText = this.myExpressionText.substring(0, this.myRelativeRange.getStartOffset()) + prefix + replacementExpression.getText() + "}" + this.myExpressionText.substring(this.myRelativeRange.getEndOffset());
                    JSExpression replacement = JSPsiElementFactory.createJSExpression(replacementText, (PsiElement)replacementExpression);
                    return toReplace.replace(replacement);
                }
                if (toReplace instanceof JSLiteralExpression && ((JSLiteralExpression)toReplace).isQuotedLiteral()) {
                    String quote = toReplace.getText().substring(0, 1);
                    return toReplace.replace(this.buildTextForReplacement(replacementExpression, quote + " + ", " + " + quote));
                }
                if (toReplace instanceof JSBinaryExpression) {
                    return toReplace.replace(this.buildTextForReplacement(replacementExpression, "", ""));
                }
            }
            return null;
        }

        @NotNull
        private JSExpression buildTextForReplacement(JSExpression refExpr, String quote, String quote2) {
            Object text = "";
            if (this.myRelativeRange.getStartOffset() > 1) {
                text = (String)text + this.myExpressionText.substring(0, this.myRelativeRange.getStartOffset()) + quote;
            }
            text = (String)text + refExpr.getText();
            if (this.myRelativeRange.getEndOffset() < this.myExpressionText.length() - 1) {
                text = (String)text + quote2 + this.myExpressionText.substring(this.myRelativeRange.getEndOffset());
            }
            JSExpression jSExpression = JSPsiElementFactory.createJSExpression((String)text, (PsiElement)refExpr);
            if (jSExpression == null) {
                Replacer.$$$reportNull$$$0(7);
            }
            return jSExpression;
        }

        @Nullable
        private static JSExpression findReferenceToIntroduced(@NotNull JSExpression topExpression, @NotNull JSExpression toSearch, int startOffset) {
            if (topExpression == null) {
                Replacer.$$$reportNull$$$0(8);
            }
            if (toSearch == null) {
                Replacer.$$$reportNull$$$0(9);
            }
            Ref result2 = new Ref();
            PsiTreeUtil.processElements((PsiElement)topExpression, element -> {
                if (element instanceof JSExpression && element.getTextRange().getStartOffset() >= startOffset && StringUtil.equals((CharSequence)element.getText(), (CharSequence)toSearch.getText())) {
                    result2.set((Object)((JSExpression)element));
                    return false;
                }
                return true;
            });
            return (JSExpression)result2.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionDescriptor";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduce/JSIntroducedExpressionUtil$Replacer";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacementExpression";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toReplace";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topExpression";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toSearch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduce/JSIntroducedExpressionUtil$Replacer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTextForReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceOccurrence";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "tryReplacePartOfExpression";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findReferenceToIntroduced";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 7 -> new IllegalStateException(string);
            };
        }
    }
}

