/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import icons.JavaScriptLanguageIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSScriptingContextProvider
extends LangScriptingContextProvider {
    private static final Logger LOG = Logger.getInstance(JSScriptingContextProvider.class);
    private static final String[] EXTENSIONS = (String[])Stream.of(JSFileReferencesUtil.IMPLICIT_EXTENSIONS).map(dotExt -> dotExt.substring(1)).toArray(String[]::new);

    @NotNull
    public Language getLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(0);
        }
        return javascriptLanguage;
    }

    public PersistentLibraryKind<?> getLibraryKind() {
        return JSLibraryKind.INSTANCE;
    }

    public ScriptingLibraryManager getLibraryManager(Project project) {
        return JSLibraryManager.getInstance(project);
    }

    public String @NotNull [] getExtensions() {
        if (EXTENSIONS == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(1);
        }
        return EXTENSIONS;
    }

    public boolean acceptsExtension(@Nullable String fileExt) {
        return fileExt != null && ArrayUtil.contains((String)fileExt, (String[])EXTENSIONS);
    }

    public ScriptingLibraryMappings getLibraryMappings(Project project) {
        return JSLibraryMappings.getInstance(project);
    }

    public boolean isCompact(@NotNull VirtualFile file) {
        if (file == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(2);
        }
        return JSMinifiedFileUtil.isFileContentMinified(file);
    }

    @Nullable
    public String getLibraryTypeName(OrderRootType rootType) {
        if (rootType == OrderRootType.CLASSES) {
            return "Release";
        }
        if (rootType == OrderRootType.SOURCES) {
            return "Debug";
        }
        return null;
    }

    public String getDefaultDocUrl(@NotNull ScriptingFrameworkDescriptor framework) {
        String baseKey;
        if (framework == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(3);
        }
        if ((baseKey = JSExternalLibraryDocBundle.getBaseKey(framework.getFrameworkName(), framework.getFrameworkVersion())) != null) {
            return JSExternalLibraryDocBundle.getBaseUrl(baseKey);
        }
        return null;
    }

    @Nullable
    public ScriptingFrameworkDescriptor detectFramework(@NotNull VirtualFile file) {
        if (file == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(4);
        }
        return JSProjectUtil.detectFramework(file.getUrl());
    }

    @Nullable
    public String getOfflineDocUrl(String defaultDocUrl) {
        String baseKey = JSExternalLibraryDocBundle.getBaseURLKey(defaultDocUrl);
        if (baseKey != null) {
            return JSExternalLibraryDocBundle.getOfflineDocUrl(baseKey);
        }
        return null;
    }

    public void downloadOfflineDoc(@NotNull Project project, @NotNull String offlineDocUrl, @Nullable Component notificationAreaComponent, @NotNull Consumer<? super File> onDownloadedFile) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(5);
        }
        if (offlineDocUrl == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(6);
        }
        if (onDownloadedFile == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(7);
        }
        JSScriptingContextProvider.doDownload(project, List.of(offlineDocUrl), JavaScriptBundle.message("progress.title.downloading.documentation", new Object[0]), notificationAreaComponent, files -> onDownloadedFile.accept((File)ContainerUtil.getFirstItem((List)files)));
    }

    @NotNull
    public DownloadableFileSetVersions<DownloadableFileSetDescription> getDownloadableLibraryDescriptors(Project project) {
        URL localUrl = JSDownloadManager.class.getResource("jslibraries.xml");
        DownloadableFileSetVersions downloadableFileSetVersions = DownloadableFileService.getInstance().createFileSetVersions("javascript", new URL[]{localUrl});
        if (downloadableFileSetVersions == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(8);
        }
        return downloadableFileSetVersions;
    }

    public void downloadLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @Nullable Component notificationAreaComponent, @Nullable Runnable onLibraryCreated) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(9);
        }
        if (description == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ModalityState modalityState = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List urls = ContainerUtil.mapNotNull((Collection)description.getFiles(), DownloadableFileDescription::getDownloadUrl);
                ApplicationManager.getApplication().invokeLater(() -> JSScriptingContextProvider.doDownload(project, new ArrayList<String>(new LinkedHashSet(urls)), JavaScriptBundle.message("progress.title.downloading.library", new Object[0]), notificationAreaComponent, downloadedFiles -> {
                    boolean created = this.createLibrary(project, description, (List<? extends File>)downloadedFiles);
                    if (created && onLibraryCreated != null) {
                        onLibraryCreated.run();
                    }
                }), modalityState);
            }
            catch (Exception e) {
                LOG.warn("Cannot determine library URLs, no library created", (Throwable)e);
            }
        });
    }

    private boolean createLibrary(Project project, DownloadableFileSetDescription description, List<? extends File> libraryFiles) {
        ThreadingAssertions.assertEventDispatchThread();
        if (libraryFiles.isEmpty()) {
            return false;
        }
        return (Boolean)WriteAction.compute(() -> {
            String baseUrl;
            List files = ContainerUtil.mapNotNull((Collection)libraryFiles, file -> VfsUtil.findFileByIoFile((File)file, (boolean)true));
            if (files.isEmpty()) {
                return false;
            }
            String libName = JSScriptingContextProvider.getIdeLibraryName((DownloadableFileSetDescription)description);
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            Library library = libTable.getLibraryByName(libName);
            if (library != null) {
                return false;
            }
            ScriptingFrameworkDescriptor framework = this.detectFramework((VirtualFile)files.iterator().next());
            String[] docUrls = ArrayUtil.EMPTY_STRING_ARRAY;
            if (framework != null && (baseUrl = this.getDefaultDocUrl(framework)) != null) {
                docUrls = new String[]{baseUrl};
            }
            ScriptingLibraryModel libModel = libraryManager.createLibrary(libName, VfsUtilCore.toVirtualFileArray((Collection)files), VirtualFile.EMPTY_ARRAY, docUrls, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
            if (framework != null) {
                libModel.setFrameworkDescriptor(framework);
            }
            libraryManager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
            JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
            mappings.associate(null, libName);
            return true;
        });
    }

    @NotNull
    public Icon getFileIcon() {
        Icon icon = JavaScriptLanguageIcons.Library.JsLibrary;
        if (icon == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(11);
        }
        return icon;
    }

    public void filterExistingLibraries(@NotNull Project project, @NotNull List<? extends DownloadableFileSetDescription> descriptions) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(12);
        }
        if (descriptions == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(13);
        }
        JSScriptingContextProvider.doFilterExistingLibraries(project, descriptions);
    }

    private static void doDownload(@NotNull Project project, @NotNull List<String> urls, @NotNull @NlsContexts.ProgressTitle String progressTitle, @Nullable Component notificationAreaComponent, @NotNull Consumer<? super List<File>> downloadedFilesConsumer) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(14);
        }
        if (urls == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(15);
        }
        if (progressTitle == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(16);
        }
        if (downloadedFilesConsumer == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(17);
        }
        JSScriptingContextProvider.doDownload(project, urls, progressTitle, notificationAreaComponent, downloadedFilesConsumer, new JSDownloadManager(null));
    }

    public static void doDownload(final @NotNull Project project, final @NotNull List<String> urls, @NotNull @NlsContexts.ProgressTitle String progressTitle, final @Nullable Component notificationAreaComponent, final @NotNull Consumer<? super List<File>> downloadedFilesConsumer, final @NotNull JSDownloadManager downloadManager) {
        if (project == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(18);
        }
        if (urls == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(19);
        }
        if (progressTitle == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(20);
        }
        if (downloadedFilesConsumer == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(21);
        }
        if (downloadManager == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(22);
        }
        ThreadingAssertions.assertEventDispatchThread();
        final ModalityState modalityState = ModalityState.current();
        Task.Backgroundable task = new Task.Backgroundable(project, progressTitle, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<File> result2 = new ArrayList<File>();
                ArrayList<String> failedUrls = new ArrayList<String>();
                StepProgressIndicator stepIndicator = new StepProgressIndicator(indicator, urls.size());
                for (String url : urls) {
                    if (indicator.isCanceled()) {
                        return;
                    }
                    File file = JSScriptingContextProvider.doDownloadUrl(indicator, downloadManager, url);
                    stepIndicator.onStepDone();
                    if (file != null) {
                        result2.add(file);
                        continue;
                    }
                    failedUrls.add(url);
                    break;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (notificationAreaComponent != null) {
                        JSScriptingContextProvider.notifyAboutDownload(project, notificationAreaComponent, urls, failedUrls);
                    }
                    if (failedUrls.isEmpty()) {
                        downloadedFilesConsumer.accept(result2);
                    } else {
                        downloadedFilesConsumer.accept(Collections.emptyList());
                    }
                }, modalityState);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$1", "run"));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    @Nullable
    private static File doDownloadUrl(@Nullable ProgressIndicator progressIndicator, JSDownloadManager downloadManager, @NotNull String url) {
        if (url == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(23);
        }
        downloadManager.setProgressIndicator(progressIndicator);
        JSDownloadManager.JSDownloadException exception = null;
        boolean tryAgain = true;
        while (tryAgain) {
            downloadManager.downloadLibrary(url, JSExternalLibraryDocBundle.getOfflineDocExt(url));
            exception = downloadManager.getLastException();
            if (exception == null) {
                String targetFilePath = downloadManager.getTargetFilePath();
                return targetFilePath != null ? new File(targetFilePath) : null;
            }
            tryAgain = IOExceptionDialog.showErrorDialog((String)JavaScriptBundle.message("dialog.title.download.error", new Object[0]), (String)JavaScriptBundle.message("text.cannot.download", url, exception.getReason()));
        }
        LOG.info(exception);
        return null;
    }

    private static <T extends DownloadableFileSetDescription> void doFilterExistingLibraries(Project project, List<T> descriptions) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            ArrayList<DownloadableFileSetDescription> toRemove = new ArrayList<DownloadableFileSetDescription>();
            for (DownloadableFileSetDescription description : descriptions) {
                String ideLibName = JSScriptingContextProvider.getIdeLibraryName((DownloadableFileSetDescription)description);
                if (libraryManager.getLibraryByName(ideLibName) == null) continue;
                toRemove.add(description);
            }
            descriptions.removeAll(toRemove);
        });
    }

    public ScriptingFrameworkDescriptor @NotNull [] getSupportedFrameworks(Project project) {
        Set<String> keys = JSExternalLibraryDocBundle.getBasePatternKeys();
        ArrayList<ScriptingFrameworkDescriptor> descriptors = new ArrayList<ScriptingFrameworkDescriptor>();
        for (String key : keys) {
            String name = JSExternalLibraryDocBundle.getLibraryName(key);
            descriptors.add(new ScriptingFrameworkDescriptor(name, null));
        }
        descriptors.sort((d1, d2) -> {
            int nameResult;
            int n = nameResult = d1.getFrameworkName() != null ? d1.getFrameworkName().compareToIgnoreCase(d2.getFrameworkName()) : -1;
            if (nameResult != 0) {
                return nameResult;
            }
            return d1.getFrameworkVersion() != null ? d1.getFrameworkVersion().compareTo(d2.getFrameworkVersion()) : -1;
        });
        ScriptingFrameworkDescriptor[] scriptingFrameworkDescriptorArray = descriptors.toArray(new ScriptingFrameworkDescriptor[0]);
        if (scriptingFrameworkDescriptorArray == null) {
            JSScriptingContextProvider.$$$reportNull$$$0(24);
        }
        return scriptingFrameworkDescriptorArray;
    }

    private static void notifyAboutDownload(Project project, Component notificationAreaComponent, List<String> allUrls, List<String> failedUrls) {
        Object info;
        List<String> urls;
        if (allUrls.isEmpty()) {
            return;
        }
        boolean success = failedUrls.isEmpty();
        List<String> list = urls = success ? allUrls : failedUrls;
        if (urls.size() == 1) {
            info = urls.get(0);
        } else {
            List topUrls = ContainerUtil.getFirstItems(urls, (int)10);
            info = StringUtil.join((Collection)topUrls, url -> "<div>" + url + "</div>", (String)"");
            if (topUrls.size() < urls.size()) {
                info = (String)info + String.valueOf(HtmlChunk.div().child((HtmlChunk)HtmlChunk.link((String)"view_all", (String)JavaScriptBundle.message("notify.urls.more", urls.size() - topUrls.size()))));
            }
        }
        String downloadResult = success ? JavaScriptBundle.message("successfully.downloaded", new Object[0]) : JavaScriptBundle.message("failed.to.download", new Object[0]);
        final String titleHtml = new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)downloadResult).bold()).append((HtmlChunk)HtmlChunk.br()).toString();
        MessageType type2 = success ? MessageType.INFO : MessageType.ERROR;
        final JEditorPane viewer = SwingHelper.createHtmlViewer((boolean)false, null, (Color)type2.getPopupBackground(), null);
        viewer.setFocusable(true);
        SwingHelper.setHtml((JEditorPane)viewer, (String)(titleHtml + (String)info), null);
        viewer.setBorder(null);
        viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                String info = StringUtil.join((Collection)urls, url -> "<div>" + url + "</div>", (String)"");
                viewer.setText(titleHtml + info);
                viewer.setCaretPosition(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$2", "hyperlinkActivated"));
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)viewer);
        scrollPane.setBorder(null);
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)scrollPane);
        builder2.setShowCallout(false).setCloseButtonEnabled(true).setDisposable((Disposable)JSDisposable.getInstance(project));
        Rectangle bounds = notificationAreaComponent.getBounds();
        Point p = new Point(bounds.width / 2, bounds.height - JBUIScale.scale((int)40));
        RelativePoint point = new RelativePoint(notificationAreaComponent, p);
        Balloon balloon = builder2.createBalloon();
        balloon.show(point, Balloon.Position.below);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineDocUrl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDownloadedFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedFilesConsumer";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadManager";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadableLibraryDescriptors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIcon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCompact";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectFramework";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "downloadOfflineDoc";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "downloadLibrary";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingLibraries";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doDownload";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> new IllegalArgumentException(string);
        };
    }

    private static class StepProgressIndicator
    extends ProgressIndicatorBase {
        private final int myTotalSteps;
        private final AtomicInteger myFinishedSteps;
        private final ProgressIndicatorEx myRealIndicator;
        private boolean myUpdatingRealIndicatorFraction;

        StepProgressIndicator(@NotNull ProgressIndicator realIndicator, int totalSteps) {
            if (realIndicator == null) {
                StepProgressIndicator.$$$reportNull$$$0(0);
            }
            this.myFinishedSteps = new AtomicInteger(0);
            this.myUpdatingRealIndicatorFraction = false;
            this.myTotalSteps = totalSteps;
            this.myRealIndicator = (ProgressIndicatorEx)ObjectUtils.tryCast((Object)realIndicator, ProgressIndicatorEx.class);
            if (this.myRealIndicator != null) {
                this.myRealIndicator.addStateDelegate((ProgressIndicatorEx)this);
            }
        }

        public void setFraction(double stepFraction) {
            if (!this.myUpdatingRealIndicatorFraction) {
                stepFraction = MathUtil.clamp((double)stepFraction, (double)0.0, (double)1.0);
                double fraction = ((double)this.myFinishedSteps.get() + stepFraction) / (1.0 * (double)this.myTotalSteps);
                super.setFraction(fraction);
                this.myUpdatingRealIndicatorFraction = true;
                this.myRealIndicator.setFraction(fraction);
                this.myUpdatingRealIndicatorFraction = false;
            }
        }

        public void onStepDone() {
            this.myFinishedSteps.incrementAndGet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realIndicator", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$StepProgressIndicator", "<init>"));
        }
    }
}

