/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class JSUnusedLocalSymbolsInspection
extends JSInspection {
    public boolean myIgnoreUnusedFunctionParameters;
    public boolean myIgnoreParametersBeforeUsed = true;
    public boolean myIgnoreUnusedCatchParameters = true;
    public static final String SHORT_NAME = JSUnusedLocalSymbolsInspection.calcShortNameFromClass(JSUnusedLocalSymbolsInspection.class);

    protected boolean shouldVisitVariable(@NotNull JSVariable node) {
        PsiElement statement;
        PsiElement parent;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = parent = (statement = node.getParent()) != null ? statement.getParent() : null;
        if (parent instanceof JSForInStatement) {
            return ((JSForInStatement)parent).getVarDeclaration() != statement;
        }
        return true;
    }

    protected boolean shouldVisitParameter(@NotNull JSParameterListElement node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(3);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSVariable(@NotNull JSVariable node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JSUnusedLocalSymbolsInspection.this.shouldVisitVariable(node) && !(node instanceof JSParameter)) {
                    JSUnusedLocalSymbolsInspection.this.processNamedDeclaration(node, holder);
                }
            }

            @Override
            public void visitJSCatchBlock(@NotNull JSCatchBlock node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (JSUnusedLocalSymbolsInspection.this.myIgnoreUnusedCatchParameters || !node.hasParameter()) {
                    return;
                }
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)node, () -> {
                    JSParameter parameter = node.getParameter();
                    if (parameter != null && JSUnusedLocalSymbolsInspection.this.shouldVisitParameter(parameter) && JSUnusedLocalSymbolsInspection.this.isLocallyDefined(parameter) && !JSUnusedLocalSymbolsInspection.isReferencedOrIgnored(parameter, (PsiElement)node)) {
                        JSUnusedLocalSymbolsInspection.reportUnused((PsiElement)node, parameter, holder);
                    }
                });
            }

            @Override
            public void visitJSParameterList(@NotNull JSParameterList parameterList) {
                if (parameterList == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)parameterList, () -> {
                    boolean breakAfterUsed;
                    Object[] variables = parameterList.getParameters();
                    JSParameterListElement first = (JSParameterListElement)ContainerUtil.find((Object[])variables, p -> !TypeScriptPsiUtil.isThisParameter(p));
                    if (first == null || !JSUnusedLocalSymbolsInspection.this.shouldVisitParameter(first)) {
                        return;
                    }
                    JSFunction function = first.getDeclaringFunction();
                    if (function == null || function instanceof TypeScriptFunctionType) {
                        return;
                    }
                    Processor scopeSkipChecker = scopeNode -> scopeNode == null || scopeNode instanceof JSFunction && (JSUnusedLocalSymbolsInspection.this.myIgnoreUnusedFunctionParameters || JSPsiImplUtils.getFunctionBody(function) == null);
                    boolean isTypescript = DialectDetector.isTypeScript(function);
                    boolean bl = breakAfterUsed = JSUnusedLocalSymbolsInspection.this.myIgnoreParametersBeforeUsed && (!isTypescript || function.getAccessType() != JSAttributeList.AccessType.PRIVATE);
                    if (isTypescript && function.isConstructor()) {
                        Convertor scopeProvider = variable -> {
                            PsiElement varScope = JSUnusedLocalSymbolsInspection.getUseScopeElement(variable);
                            return scopeSkipChecker.process((Object)varScope) ? null : varScope;
                        };
                        this.checkFunctionParameters((JSParameterListElement[])variables, (Convertor<JSParameter, PsiElement>)scopeProvider, breakAfterUsed, false);
                        return;
                    }
                    if (scopeSkipChecker.process((Object)function)) {
                        return;
                    }
                    if (first instanceof JSParameter && !JSUnusedLocalSymbolsInspection.this.isLocallyDefined((JSNamedElement)((Object)first))) {
                        return;
                    }
                    this.checkFunctionParameters((JSParameterListElement[])variables, (Convertor<JSParameter, PsiElement>)((Convertor)variable -> function), breakAfterUsed, true);
                });
            }

            private void checkFunctionParameters(JSParameterListElement @NotNull [] variables, @NotNull Convertor<JSParameter, PsiElement> scopeProvider, boolean breakAfterUsed, boolean localityDefined) {
                if (scopeProvider == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (variables == null) {
                    1.$$$reportNull$$$0(4);
                }
                for (int i = variables.length - 1; i >= 0; --i) {
                    JSParameterListElement listElement = variables[i];
                    List params = listElement instanceof JSParameter ? Collections.singletonList((JSParameter)listElement) : ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)listElement).forceIgnore(e -> e instanceof JSParameterList)).filter(JSParameter.class).toList();
                    int unused = 0;
                    boolean hadUsed = false;
                    for (JSParameter variable : params) {
                        boolean isLocal;
                        PsiElement scopeNode = (PsiElement)scopeProvider.convert((Object)variable);
                        if (scopeNode == null || !(isLocal = localityDefined || JSUnusedLocalSymbolsInspection.this.isLocallyDefined(variable))) continue;
                        if (!JSUnusedLocalSymbolsInspection.isReferencedOrIgnored(variable, scopeNode)) {
                            JSUnusedLocalSymbolsInspection.reportUnused(scopeNode, variable, holder);
                            ++unused;
                            continue;
                        }
                        hadUsed = true;
                    }
                    if (hadUsed && unused != params.size() && breakAfterUsed) break;
                }
            }

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(5);
                }
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration(node, holder);
            }

            @Override
            public void visitJSNamespaceDeclaration(@NotNull JSNamespaceDeclaration node) {
                if (node == null) {
                    1.$$$reportNull$$$0(6);
                }
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration(node, holder);
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(7);
                }
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration(node, holder);
            }

            @Override
            public void visitJSClass(@NotNull JSClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(8);
                }
                JSUnusedLocalSymbolsInspection.this.processNamedDeclaration(aClass, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameterList";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scopeProvider";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variables";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSVariable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSCatchBlock";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSParameterList";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkFunctionParameters";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSNamespaceDeclaration";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isJSAbstractMethod(JSFunction function) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(function);
        boolean js = dialect != null && dialect.isJavaScript();
        JSElement body = JSPsiImplUtils.getFunctionBody(function);
        if (js && !function.isArrowFunction() && (body == null || body instanceof JSBlockStatement && PsiTreeUtil.findChildOfAnyType((PsiElement)body, (Class[])new Class[]{JSStatement.class, JSExpression.class}) == null)) {
            return true;
        }
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(function);
        return docComment instanceof JSDocComment && ((JSDocComment)docComment).hasAbstractTag();
    }

    private static boolean isSupportedFunction(JSFunction element) {
        return !(element instanceof JSFunctionExpression) && !(element.getContext() instanceof JSProperty);
    }

    private void processNamedDeclaration(@NotNull JSNamedElement node, @NotNull ProblemsHolder holder) {
        PsiElement scopeNode;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(5);
        }
        if ((scopeNode = JSUnusedLocalSymbolsInspection.getUseScopeElement(node)) == null) {
            return;
        }
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)node, () -> {
            if (this.isLocallyDefined(node) && !JSUnusedLocalSymbolsInspection.isReferencedOrIgnored(node, scopeNode)) {
                JSUnusedLocalSymbolsInspection.reportUnused(scopeNode, node, holder);
            }
        });
    }

    private static boolean isReferencedOrIgnored(@NotNull JSNamedElement node, @NotNull PsiElement scopeNode) {
        String name;
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(6);
        }
        if (scopeNode == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(7);
        }
        if ((name = node.getName()) != null && (name.startsWith("ignore") || name.startsWith("_") && (node instanceof JSParameter || node.getParent() instanceof JSDestructuringArray))) {
            return true;
        }
        if (RefUtil.isImplicitUsage((PsiElement)node)) {
            return true;
        }
        Predicate<PsiReference> filter = reference -> !JSUnusedLocalSymbolsInspection.isSelfReference(node, reference);
        return JSUnusedLocalSymbolsInspection.checkUsages(node, scopeNode, filter, 1);
    }

    private static boolean isSelfReference(@NotNull JSNamedElement node, PsiReference reference) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(8);
        }
        return reference instanceof PsiElement && (JSResolveUtil.isSelfReference((PsiElement)reference) || node instanceof JSFunction && PsiTreeUtil.isAncestor((PsiElement)node, (PsiElement)((PsiElement)reference), (boolean)false)) || reference instanceof JSDocParamReference;
    }

    public static boolean checkUsages(@NotNull JSNamedElement node, @NotNull PsiElement scopeNode, @NotNull Predicate<? super PsiReference> filter, int expectedNumber) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(9);
        }
        if (scopeNode == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(10);
        }
        if (filter == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(11);
        }
        PsiElement[] scopeNodes = new PsiElement[]{scopeNode};
        LocalSearchScope scope2 = new LocalSearchScope(scopeNodes, null, true);
        boolean ignoreAccessScope = true;
        IntRef count = new IntRef(0);
        Processor processor = reference -> {
            if (!filter.test((PsiReference)reference)) {
                return true;
            }
            int newValue = count.get() + 1;
            count.set(newValue);
            return newValue < expectedNumber;
        };
        PsiFile nodeFile = node.getContainingFile();
        if (!InjectedLanguageManager.getInstance((Project)nodeFile.getProject()).isInjectedFragment(nodeFile) && !ReferencesSearch.search((PsiElement)node, (SearchScope)scope2, (boolean)ignoreAccessScope).forEach(processor)) {
            return true;
        }
        count.set(0);
        LocalSearchScope scopeWithInjections = new LocalSearchScope(scopeNodes, null, false);
        return !ReferencesSearch.search((PsiElement)node, (SearchScope)scopeWithInjections, (boolean)ignoreAccessScope).forEach(processor);
    }

    private static void reportUnused(@NotNull PsiElement scope2, @NotNull JSNamedElement namedElement, @NotNull ProblemsHolder holder) {
        PsiElement highlightedElement;
        if (scope2 == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(12);
        }
        if (namedElement == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(14);
        }
        boolean asInfo = false;
        if (namedElement instanceof JSParameter) {
            if (namedElement.getName() == null) {
                return;
            }
            if (scope2 instanceof JSFunction) {
                boolean ecma;
                JSFunction fun = (JSFunction)scope2;
                boolean bl = ecma = scope2.getContainingFile().getLanguage() == FlexSupportLoader.ECMA_SCRIPT_L4;
                if (ecma && scope2 instanceof JSFunctionExpression) {
                    return;
                }
                JSDestructuringProperty[] attributeList = fun.getAttributeList();
                boolean bl2 = asInfo = holder.isOnTheFly() && (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || JSInheritanceUtil.participatesInHierarchy(fun) || JSUnusedLocalSymbolsInspection.isJSAbstractMethod(fun));
            }
        }
        if (namedElement instanceof JSVariable) {
            PsiElement parent;
            JSDestructuringProperty prop = (JSDestructuringProperty)ObjectUtils.tryCast((Object)namedElement.getParent(), JSDestructuringProperty.class);
            PsiElement psiElement = parent = prop == null || prop.isRest() ? null : prop.getParent();
            if (parent instanceof JSDestructuringObject) {
                for (JSDestructuringProperty property : ((JSDestructuringObject)parent).getProperties()) {
                    if (!property.isRest()) continue;
                    return;
                }
            }
        }
        if ((highlightedElement = namedElement.getNameIdentifier()) == null || highlightedElement.getTextRange().isEmpty()) {
            return;
        }
        SmartList fixes = new SmartList();
        if (!(asInfo || scope2 instanceof JSFunction && ((JSFunction)scope2).isSetProperty())) {
            FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(new JSNamedElementPresenter((PsiElement)namedElement).describeWithShortName());
            fix.registerElementRefForFix(highlightedElement, null);
            fixes.add(fix);
        }
        if (holder.isOnTheFly() && scope2 instanceof JSFunction && namedElement instanceof JSParameter) {
            JSFixFactory.getInstance().addFixesForFields((JSFunction)scope2, highlightedElement, namedElement.getName(), (List<? super LocalQuickFix>)fixes);
        }
        LocalQuickFix[] quickFixes = fixes.isEmpty() ? LocalQuickFix.EMPTY_ARRAY : fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        ProblemHighlightType highlightType = asInfo ? ProblemHighlightType.INFORMATION : ProblemHighlightType.LIKE_UNUSED_SYMBOL;
        holder.registerProblem(highlightedElement, JSUnusedLocalSymbolsInspection.unusedMessage((PsiElement)namedElement), highlightType, quickFixes);
    }

    @NotNull
    @InspectionMessage
    public static String unusedMessage(PsiElement element) {
        String string = JavaScriptBundle.message("js.unused.symbol", new JSNamedElementPresenter(element).describeElementKind());
        if (string == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static boolean isNotGloballyDefined(@NotNull JSNamedElement node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(16);
        }
        return JSUnusedLocalSymbolsInspection.isNonDefinitionExpression(node) || JSUnusedLocalSymbolsInspection.locallyDefinedInScope(node);
    }

    protected boolean isLocallyDefined(JSNamedElement node) {
        return JSUnusedLocalSymbolsInspection.locallyDefinedInScope(node) && !JSUnusedLocalSymbolsInspection.isNonDefinitionExpression(node);
    }

    private static boolean isNonDefinitionExpression(@NotNull JSNamedElement node) {
        if (node == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(17);
        }
        return node instanceof JSExpression && !(node instanceof JSDefinitionExpression);
    }

    private static boolean locallyDefinedInScope(JSNamedElement node) {
        if (node instanceof JSFunction && !JSUnusedLocalSymbolsInspection.isSupportedFunction((JSFunction)node)) {
            return false;
        }
        return JSUseScopeProvider.getUseScopeElement(node) != null;
    }

    private static PsiElement getUseScopeElement(JSNamedElement node) {
        if (node instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)node).getStub() != null) {
            return null;
        }
        return JSUseScopeProvider.getUseScopeElement(node);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"mode", (String)JavaScriptBundle.message("javascript.ignore.unused.function.parameters", new Object[0]), MyIgnoreUnusedParametersOption.class, MyIgnoreUnusedParametersOption::toString), OptPane.checkbox((String)"myIgnoreUnusedCatchParameters", (String)JavaScriptBundle.message("javascript.ignore.unused.catch.parameters", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(18);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValue("mode", () -> this.myIgnoreUnusedFunctionParameters ? MyIgnoreUnusedParametersOption.all : (this.myIgnoreParametersBeforeUsed ? MyIgnoreUnusedParametersOption.beforeUsed : MyIgnoreUnusedParametersOption.none), value -> {
            if (MyIgnoreUnusedParametersOption.all.equals(value)) {
                this.myIgnoreUnusedFunctionParameters = true;
                this.myIgnoreParametersBeforeUsed = false;
            } else {
                this.myIgnoreUnusedFunctionParameters = false;
                this.myIgnoreParametersBeforeUsed = MyIgnoreUnusedParametersOption.beforeUsed.equals(value);
            }
        });
        if (optionController == null) {
            JSUnusedLocalSymbolsInspection.$$$reportNull$$$0(19);
        }
        return optionController;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unusedMessage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldVisitVariable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldVisitParameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNamedDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedOrIgnored";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSelfReference";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkUsages";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportUnused";
                break;
            }
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNotGloballyDefined";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isNonDefinitionExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 18, 19 -> new IllegalStateException(string);
        };
    }

    private static enum MyIgnoreUnusedParametersOption {
        all("ignore.unused.option.all"),
        beforeUsed("ignore.unused.option.before.used"),
        none("ignore.unused.option.none");

        @PropertyKey(resourceBundle="messages.JavaScriptBundle")
        private final @PropertyKey(resourceBundle="messages.JavaScriptBundle") String myKey;

        private MyIgnoreUnusedParametersOption(String key) {
            if (key == null) {
                MyIgnoreUnusedParametersOption.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        @Nls
        public String toString() {
            return JavaScriptBundle.message(this.myKey, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection$MyIgnoreUnusedParametersOption", "<init>"));
        }
    }
}

