/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/highlighting/JsTextExtractor;", "Lcom/intellij/grazie/text/TextExtractor;", "<init>", "()V", "docMarkup", "", "Lcom/intellij/psi/tree/IElementType;", "commentBuilder", "Lcom/intellij/grazie/text/TextContentBuilder;", "kotlin.jvm.PlatformType", "Lcom/intellij/grazie/text/TextContentBuilder;", "buildTextContent", "Lcom/intellij/grazie/text/TextContent;", "element", "Lcom/intellij/psi/PsiElement;", "allowedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "isUnknownContent", "", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJsTextExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsTextExtractor.kt\ncom/intellij/lang/javascript/highlighting/JsTextExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1611#2,9:78\n1863#2:87\n1864#2:89\n1620#2:90\n1#3:88\n*S KotlinDebug\n*F\n+ 1 JsTextExtractor.kt\ncom/intellij/lang/javascript/highlighting/JsTextExtractor\n*L\n37#1:78,9\n37#1:87\n37#1:89\n37#1:90\n37#1:88\n*E\n"})
public final class JsTextExtractor
extends TextExtractor {
    @NotNull
    private final Set<IElementType> docMarkup;
    private final TextContentBuilder commentBuilder;

    public JsTextExtractor() {
        Object[] objectArray = new IElementType[]{JSDocTokenTypes.DOC_COMMENT_START, JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK, JSDocTokenTypes.DOC_COMMENT_END};
        this.docMarkup = SetsKt.setOf((Object[])objectArray);
        this.commentBuilder = TextContentBuilder.FromPsi.removingIndents(" \t").removingLineSuffixes(" \t");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected TextContent buildTextContent(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(allowedDomains, (String)"allowedDomains");
        if (element instanceof JSDocComment) {
            return this.commentBuilder.excluding(arg_0 -> JsTextExtractor.buildTextContent$lambda$0(this, arg_0)).withUnknown(JsTextExtractor::buildTextContent$lambda$1).build(element, TextContent.TextDomain.DOCUMENTATION);
        }
        if (element instanceof PsiComment) {
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)JSTokenTypes.C_STYLE_COMMENT) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)JSTokenTypes.END_OF_LINE_COMMENT)) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                List siblings = PsiUtilsKt.getNotSoDistantSimilarSiblings((PsiElement)element, arg_0 -> JsTextExtractor.buildTextContent$lambda$2(element, arg_0));
                Iterable iterable = siblings;
                char c = '\n';
                boolean $i$f$mapNotNull = false;
                void var6_7 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TextContent it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl2 = false;
                    if (this.commentBuilder.build(it, TextContent.TextDomain.COMMENTS) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                return TextContent.joinWithWhitespace((char)c, (List)list);
            }
            return this.commentBuilder.build(element, TextContent.TextDomain.COMMENTS);
        }
        if (element instanceof JSLiteralExpression) {
            return TextContentBuilder.FromPsi.withUnknown(this::isUnknownContent).excluding(JsTextExtractor::buildTextContent$lambda$4).build(element, TextContent.TextDomain.LITERALS);
        }
        return null;
    }

    private final boolean isUnknownContent(PsiElement element) {
        Object[] objectArray;
        return element.getParent() instanceof JSStringTemplateExpression && element instanceof LeafPsiElement ? !CollectionsKt.listOf((Object[])(objectArray = new IElementType[]{JSTokenTypes.BACKQUOTE, JSTokenTypes.STRING_TEMPLATE_PART, JSTokenTypes.STRING_LITERAL, JSTokenTypes.STRING_LITERAL_PART})).contains(((LeafPsiElement)element).getElementType()) : (element.getParent() instanceof JSStringTemplateExpression && !(element instanceof LeafPsiElement) ? true : element.getParent() instanceof JSXmlLiteralExpression && !(element instanceof JSXmlLiteralExpression) && !(element instanceof XmlText) && !(element instanceof PsiWhiteSpace));
    }

    private static final boolean buildTextContent$lambda$0(JsTextExtractor this$0, PsiElement it) {
        return this$0.docMarkup.contains(it.getNode().getElementType());
    }

    private static final boolean buildTextContent$lambda$1(PsiElement it) {
        return it instanceof JSDocTagType || it instanceof JSDocTagNamepath || Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)JSDocTokenTypes.DOC_TAG_NAME);
    }

    private static final boolean buildTextContent$lambda$2(PsiElement $element, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)PsiTreeUtilKt.getElementType((PsiElement)$element));
    }

    private static final boolean buildTextContent$lambda$4(PsiElement it) {
        return Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)JSTokenTypes.BACKQUOTE);
    }
}

