/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.GenericJdbcHelperBase;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManticoreJdbcHelper
extends GenericJdbcHelperBase {
    public ManticoreJdbcHelper(@Nullable String dbmsName, @Nullable String version, @Nullable Connection connection) {
        super(dbmsName == null ? "UNKNOWN" : dbmsName, version, connection);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return this.create(connection, this.getDbmsName(), version);
    }

    public ManticoreJdbcHelper() {
        this(null, null, null);
    }

    @Override
    @NotNull
    protected GenericJdbcHelperBase create(@Nullable Connection delegate, @Nullable String product, String version) {
        return new ManticoreJdbcHelper(product, version, delegate);
    }

    @Override
    public GenericJdbcHelperBase detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "MYSQL") && !JdbcNativeUtil.detectString(product, "MARIADB") || !JdbcNativeUtil.detectString(productVer, "columnar")) {
            return null;
        }
        return super.detect(delegate, "Manticore", productVer, connectHelper);
    }

    @Override
    public int relOrder(JdbcHelperImpl other) {
        return other instanceof MysqlBaseJdbcHelper ? -1 : 0;
    }
}

