/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.intl.DisplayNamesFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.DisplayNamesPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNamesObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.Locale;
import org.graalvm.shadowed.com.ibm.icu.text.DateTimePatternGenerator;
import org.graalvm.shadowed.com.ibm.icu.text.DisplayContext;
import org.graalvm.shadowed.com.ibm.icu.text.LocaleDisplayNames;
import org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public final class JSDisplayNames
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("DisplayNames");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("DisplayNames.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Intl.DisplayNames");
    public static final JSDisplayNames INSTANCE = new JSDisplayNames();

    private JSDisplayNames() {
    }

    public static boolean isJSDisplayNames(Object obj) {
        return obj instanceof JSDisplayNamesObject;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject displayNamesPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(displayNamesPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, displayNamesPrototype, DisplayNamesPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(displayNamesPrototype, TO_STRING_TAG);
        return displayNamesPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, DisplayNamesFunctionBuiltins.BUILTINS);
    }

    public static JSDisplayNamesObject create(JSContext context2, JSRealm realm, JSDynamicObject proto) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context2.getDisplayNamesFactory();
        Shape shape = factory.getShape(realm, proto);
        JSDisplayNamesObject newObj = factory.initProto(new JSDisplayNamesObject(shape, proto, state), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalState(JSContext ctx, InternalState state, String[] locales, String optStyle, String optType, String optFallback, String optLanguageDisplay) {
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        if (strippedLocale.toLanguageTag().equals("und")) {
            selectedLocale = ctx.getLocale();
            strippedLocale = selectedLocale.stripExtensions();
        }
        state.locale = strippedLocale.toLanguageTag();
        state.style = optStyle;
        state.type = optType;
        state.fallback = optFallback;
        String string = state.languageDisplay = "language".equals(optType) ? optLanguageDisplay : null;
        if ("dateTimeField".equals(optType)) {
            state.dateTimePatternGenerator = DateTimePatternGenerator.getInstance(strippedLocale);
            state.displayWidth = JSDisplayNames.styleDisplayWidth(optStyle);
        } else {
            DisplayContext fallbackCtx = JSDisplayNames.fallbackDisplayContext(optFallback);
            DisplayContext styleCtx = JSDisplayNames.styleDisplayContext(optStyle);
            DisplayContext languageDisplayCtx = JSDisplayNames.languageDisplayContext(optLanguageDisplay);
            state.displayNames = LocaleDisplayNames.getInstance(JSDisplayNames.convertOldISOCodes(strippedLocale), styleCtx, fallbackCtx, languageDisplayCtx);
        }
    }

    private static DisplayContext fallbackDisplayContext(String optFallback) {
        return "none".equals(optFallback) ? DisplayContext.NO_SUBSTITUTE : DisplayContext.SUBSTITUTE;
    }

    private static DisplayContext styleDisplayContext(String optStyle) {
        return "long".equals(optStyle) ? DisplayContext.LENGTH_FULL : DisplayContext.LENGTH_SHORT;
    }

    private static DisplayContext languageDisplayContext(String optLanguageDisplay) {
        return "dialect".equals(optLanguageDisplay) ? DisplayContext.DIALECT_NAMES : DisplayContext.STANDARD_NAMES;
    }

    private static DateTimePatternGenerator.DisplayWidth styleDisplayWidth(String optStyle) {
        return switch (optStyle) {
            case "long" -> DateTimePatternGenerator.DisplayWidth.WIDE;
            case "short" -> DateTimePatternGenerator.DisplayWidth.ABBREVIATED;
            case "narrow" -> DateTimePatternGenerator.DisplayWidth.NARROW;
            default -> throw Errors.shouldNotReachHere(optStyle);
        };
    }

    private static ULocale convertOldISOCodes(Locale locale) {
        ULocale.Builder builder = new ULocale.Builder();
        builder.setLocale(ULocale.forLocale(locale));
        switch (locale.getLanguage()) {
            case "iw": {
                builder.setLanguage("he");
                break;
            }
            case "ji": {
                builder.setLanguage("yi");
                break;
            }
            case "in": {
                builder.setLanguage("id");
            }
        }
        return builder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObject resolvedOptions(JSContext context2, JSRealm realm, JSDisplayNamesObject displayNamesObject) {
        InternalState state = displayNamesObject.getInternalState();
        return state.toResolvedOptionsObject(context2, realm);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object of(JSDisplayNamesObject displayNamesObject, String code) {
        String result2;
        InternalState state = displayNamesObject.getInternalState();
        String type = state.type;
        LocaleDisplayNames displayNames = state.displayNames;
        switch (type) {
            case "language": {
                IntlUtil.ensureIsStructurallyValidLanguageId(code);
                result2 = displayNames.localeDisplayName(IntlUtil.canonicalizeLanguageTag(code));
                break;
            }
            case "region": {
                IntlUtil.ensureIsStructurallyValidRegionSubtag(code);
                result2 = displayNames.regionDisplayName(code.toUpperCase());
                break;
            }
            case "script": {
                IntlUtil.ensureIsStructurallyValidScriptSubtag(code);
                String canonicalScript = Character.toUpperCase(code.charAt(0)) + code.substring(1).toLowerCase();
                result2 = displayNames.scriptDisplayName(canonicalScript);
                break;
            }
            case "calendar": {
                IntlUtil.ensureIsStructurallyValidCalendar(code);
                result2 = displayNames.keyValueDisplayName("calendar", JSDisplayNames.displayNamesFriendlyCalendar(code.toLowerCase()));
                break;
            }
            case "dateTimeField": {
                result2 = state.dateTimePatternGenerator.getFieldDisplayName(JSDisplayNames.toDateTimeFieldCode(code), state.displayWidth);
                break;
            }
            case "currency": {
                IntlUtil.ensureIsWellFormedCurrencyCode(code);
                String upperCaseCode = code.toUpperCase();
                result2 = displayNames.keyValueDisplayName("currency", upperCaseCode);
                if (!"none".equals(state.fallback) || !upperCaseCode.equals(result2)) break;
                result2 = null;
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(type);
            }
        }
        return result2 == null ? Undefined.instance : Strings.fromJavaString(result2);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getDisplayNamesPrototype();
    }

    private static int toDateTimeFieldCode(String code) {
        return switch (code) {
            case "era" -> 0;
            case "year" -> 1;
            case "quarter" -> 2;
            case "month" -> 3;
            case "weekOfYear" -> 4;
            case "weekday" -> 6;
            case "day" -> 7;
            case "dayPeriod" -> 10;
            case "hour" -> 11;
            case "minute" -> 12;
            case "second" -> 13;
            case "timeZoneName" -> 15;
            default -> throw Errors.createRangeErrorInvalidDateTimeField(code);
        };
    }

    private static String displayNamesFriendlyCalendar(String calendar) {
        if ("gregory".equals(calendar)) {
            return "gregorian";
        }
        if ("ethioaa".equals(calendar)) {
            return "ethiopic-amete-alem";
        }
        return calendar;
    }

    public static class InternalState {
        String locale;
        String style;
        String type;
        String fallback;
        String languageDisplay;
        LocaleDisplayNames displayNames;
        DateTimePatternGenerator dateTimePatternGenerator;
        DateTimePatternGenerator.DisplayWidth displayWidth;

        JSObject toResolvedOptionsObject(JSContext context2, JSRealm realm) {
            JSObject result2 = JSOrdinary.create(context2, realm);
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_LOCALE, Strings.fromJavaString(this.locale), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_STYLE, Strings.fromJavaString(this.style), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_TYPE, Strings.fromJavaString(this.type), JSAttributes.getDefault());
            JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_FALLBACK, Strings.fromJavaString(this.fallback), JSAttributes.getDefault());
            if (this.languageDisplay != null) {
                JSObjectUtil.putDataProperty(result2, IntlUtil.KEY_LANGUAGE_DISPLAY, Strings.fromJavaString(this.languageDisplay), JSAttributes.getDefault());
            }
            return result2;
        }
    }
}

