/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerThrowOnInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class TemporalCalendarGetterNode
extends JavaScriptBaseNode {
    @Node.Child
    private GetMethodNode getMethodNode;
    @Node.Child
    private JSFunctionCallNode callNode = JSFunctionCallNode.createCall();
    @Node.Child
    private JSToIntegerThrowOnInfinityNode toIntegerThrowOnInfinityNode;
    @Node.Child
    private JSToStringNode toStringNode;

    protected TemporalCalendarGetterNode() {
    }

    public abstract Object execute(JSDynamicObject var1, JSDynamicObject var2, TruffleString var3);

    public final Number executeInteger(JSDynamicObject calendar, JSDynamicObject dateLike, TruffleString name) {
        if (this.toIntegerThrowOnInfinityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toIntegerThrowOnInfinityNode = this.insert(JSToIntegerThrowOnInfinityNode.create());
        }
        return (Number)this.toIntegerThrowOnInfinityNode.execute(this.execute(calendar, dateLike, name));
    }

    public final TruffleString executeString(JSDynamicObject calendar, JSDynamicObject dateLike, TruffleString name) {
        if (this.toStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toStringNode = this.insert(JSToStringNode.create());
        }
        return this.toStringNode.executeString(this.execute(calendar, dateLike, name));
    }

    @Specialization
    protected Object calendarGetter(JSDynamicObject calendar, JSDynamicObject dateLike, TruffleString name, @Cached InlinedBranchProfile errorBranch) {
        Object fn = this.getMethod(calendar, name);
        Object result2 = this.callNode.executeCall(JSArguments.create(calendar, fn, dateLike));
        if (result2 == Undefined.instance) {
            errorBranch.enter(this);
            throw Errors.createRangeError("expected a value.");
        }
        return result2;
    }

    private Object getMethod(JSDynamicObject calendar, TruffleString name) {
        if (this.getMethodNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getMethodNode = this.insert(GetMethodNode.create(this.getLanguage().getJSContext(), name));
        }
        assert (this.getMethodNode.getKey().equals(name));
        return this.getMethodNode.executeWithTarget(calendar);
    }
}

