/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import com.jetbrains.python.venvReader.VirtualEnvReader;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCondaPackageManagerImpl
extends PyPackageManagerImpl {
    @Nullable
    private volatile List<PyPackage> mySideCache;
    public static final String PYTHON = "python";
    public boolean useConda;

    PyCondaPackageManagerImpl(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(0);
        }
        super(sdk2);
        this.mySideCache = null;
        this.useConda = true;
    }

    @Override
    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs) throws ExecutionException {
        if (extraArgs == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(1);
        }
        if (this.useConda) {
            if (requirements == null) {
                return;
            }
            ArrayList<String> arguments = new ArrayList<String>();
            for (PyRequirement requirement : requirements) {
                arguments.add(requirement.getPresentableText());
            }
            arguments.add("-y");
            if (!extraArgs.contains("-U")) {
                arguments.addAll(extraArgs);
            }
            this.getCondaOutput("install", arguments);
        } else {
            super.install(requirements, extraArgs);
        }
    }

    private ProcessOutput getCondaOutput(@NotNull String command, List<String> arguments) throws ExecutionException {
        if (command == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(2);
        }
        Sdk sdk2 = this.getSdk();
        String path2 = this.getCondaDirectory();
        if (path2 == null) {
            throw new PyExecutionException(PySdkBundle.message("python.sdk.conda.dialog.empty.conda.name", sdk2.getHomePath()), command, arguments);
        }
        ArrayList parameters = Lists.newArrayList((Object[])new String[]{command, "-p", path2});
        parameters.addAll(arguments);
        return PyCondaRunKt.runConda(sdk2, (List<String>)parameters);
    }

    @Nullable
    private String getCondaDirectory() {
        VirtualFile condaDirectory = PythonSdkUtil.getCondaDirectory(this.getSdk());
        return condaDirectory == null ? null : condaDirectory.getPath();
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(3);
        }
        if (this.useConda) {
            super.install(requirementString);
        } else {
            this.getCondaOutput("install", Lists.newArrayList((Object[])new String[]{requirementString, "-y"}));
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages2) throws ExecutionException {
        if (packages2 == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.useConda) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (PyPackage aPackage : packages2) {
                arguments.add(aPackage.getName());
            }
            arguments.add("-y");
            this.getCondaOutput("remove", arguments);
        } else {
            super.uninstall(packages2);
        }
    }

    @Override
    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        List<PyPackage> pipPackages = super.collectPackages();
        ProcessOutput output2 = this.getCondaOutput("list", List.of("-e"));
        List<PyPackage> condaPackages = this.parseCondaToolOutput(output2.getStdout());
        if (this.useConda) {
            this.mySideCache = pipPackages;
            List<PyPackage> list = condaPackages;
            if (list == null) {
                PyCondaPackageManagerImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        this.mySideCache = condaPackages;
        List<PyPackage> list = super.collectPackages();
        if (list == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean hasManagement() throws ExecutionException {
        return this.useConda || super.hasManagement();
    }

    @NotNull
    private List<PyPackage> parseCondaToolOutput(@NotNull String output2) throws PyExecutionException {
        if (output2 == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(7);
        }
        HashSet<PyPackage> packages2 = new HashSet<PyPackage>();
        for (String line : StringUtil.splitByLines((String)output2)) {
            PyPackage pkg;
            if (line.startsWith("#") || (pkg = this.parsePackaging(line, "=", false, PySdkBundle.message("python.sdk.conda.dialog.invalid.conda.output.format", new Object[0]), "conda")) == null) continue;
            packages2.add(pkg);
        }
        return new ArrayList<PyPackage>(packages2);
    }

    @NotNull
    public static String createVirtualEnv(@Nullable String condaExecutable, @NotNull String destinationDir, @NotNull String version2) throws ExecutionException {
        if (destinationDir == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(8);
        }
        if (version2 == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(9);
        }
        if (condaExecutable == null) {
            throw new PyExecutionException(PySdkBundle.message("python.sdk.conda.dialog.cannot.find.conda", new Object[0]), "Conda", Collections.emptyList(), new ProcessOutput());
        }
        ArrayList parameters = Lists.newArrayList((Object[])new String[]{"create", "-p", destinationDir, "-y", "python=" + version2});
        PyCondaRunKt.runConda(condaExecutable, (List<String>)parameters);
        Path binary = VirtualEnvReader.getInstance().findPythonInPythonRoot(Path.of(destinationDir, new String[0]));
        String binaryFallback = destinationDir + File.separator + "bin" + File.separator + PYTHON;
        Object object = binary != null ? binary.toString() : binaryFallback;
        if (object == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(10);
        }
        return object;
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List<PyPackage> packagesCache = this.mySideCache;
        if (packagesCache == null) {
            return null;
        }
        ArrayList packages2 = Lists.newArrayList(packagesCache);
        List<PyPackage> condaPackages = super.getPackages();
        if (condaPackages == null) {
            return null;
        }
        packages2.addAll(condaPackages);
        return Collections.unmodifiableList(packages2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyCondaPackageManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyCondaPackageManagerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCondaOutput";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uninstall";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseCondaToolOutput";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 10 -> new IllegalStateException(string);
        };
    }
}

