/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyDunderSlotsInspection$Visitor$visitPyClass$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "intellij.python.psi.impl"})
public final class PyDunderSlotsInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/inspections/PyDunderSlotsInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyClass", "", "node", "Lcom/jetbrains/python/psi/PyClass;", "visitPyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "findSlotsValue", "Lcom/jetbrains/python/psi/PyExpression;", "pyClass", "processSlot", "slot", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "checkAttributeExpression", "target", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyDunderSlotsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDunderSlotsInspection.kt\ncom/jetbrains/python/inspections/PyDunderSlotsInspection$Visitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,78:1\n477#2:79\n1317#2,2:80\n*S KotlinDebug\n*F\n+ 1 PyDunderSlotsInspection.kt\ncom/jetbrains/python/inspections/PyDunderSlotsInspection$Visitor\n*L\n31#1:79\n32#1:80,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyClass(node);
            if (!LanguageLevel.forElement((PsiElement)node).isPython2()) {
                PyExpression slots = this.findSlotsValue(node);
                if (slots instanceof PySequenceExpression) {
                    PyExpression[] pyExpressionArray = ((PySequenceExpression)slots).getElements();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getElements(...)");
                    Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])pyExpressionArray);
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$visitPyClass$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    Sequence $this$forEach$iv = sequence;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PyStringLiteralExpression it = (PyStringLiteralExpression)element$iv;
                        boolean bl = false;
                        this.processSlot(node, it);
                    }
                } else if (slots instanceof PyStringLiteralExpression) {
                    this.processSlot(node, (PyStringLiteralExpression)slots);
                }
            }
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyTargetExpression(node);
            this.checkAttributeExpression(node);
        }

        private final PyExpression findSlotsValue(PyClass pyClass) {
            PyTargetExpression target;
            PyTargetExpression pyTargetExpression = target = pyClass.findClassAttribute("__slots__", false, this.myTypeEvalContext);
            PyExpression value = pyTargetExpression != null ? pyTargetExpression.findAssignedValue() : null;
            return PyPsiUtils.flattenParens(value);
        }

        private final void processSlot(PyClass pyClass, PyStringLiteralExpression slot) {
            String string = slot.getStringValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
            String name2 = string;
            PyTargetExpression classAttribute = pyClass.findClassAttribute(name2, false, this.myTypeEvalContext);
            if (classAttribute != null && classAttribute.hasAssignedValue()) {
                Object[] objectArray = new Object[]{name2};
                this.registerProblem((PsiElement)slot, PyPsiBundle.message("INSP.dunder.slots.name.in.slots.conflicts.with.class.variable", objectArray));
            }
        }

        private final void checkAttributeExpression(PyTargetExpression target) {
            String targetName = target.getName();
            PyExpression qualifier = target.getQualifier();
            if (targetName == null || qualifier == null) {
                return;
            }
            PyType qualifierType = this.myTypeEvalContext.getType(qualifier);
            if (qualifierType instanceof PyClassType && !((PyClassType)qualifierType).isAttributeWritable(targetName, this.myTypeEvalContext)) {
                Object[] objectArray = new Object[]{((PyClassType)qualifierType).getName(), targetName};
                this.registerProblem(target, PyPsiBundle.message("INSP.dunder.slots.class.object.attribute.read.only", objectArray));
            }
        }
    }
}

