/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.impl.run;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.python.community.plugin.impl.run.PyPluginCommonOptionsPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPluginCommonOptionsForm
implements AbstractPyCommonOptionsForm {
    private final Project myProject;
    private final PyPluginCommonOptionsPanel content;
    private JComponent labelAnchor;
    @NotNull
    private List<String> myEnvPaths = Collections.emptyList();
    private final List<Consumer<Boolean>> myRemoteInterpreterModeListeners = new ArrayList<Consumer<Boolean>>();

    public PyPluginCommonOptionsForm(PyCommonOptionsFormData data) {
        this.myProject = data.getProject();
        this.content = new PyPluginCommonOptionsPanel();
        List<Module> validModules = data.getValidModules();
        validModules.sort((Comparator<Module>)new ModulesAlphaComparator());
        Module selection = !validModules.isEmpty() ? validModules.get(0) : null;
        this.content.moduleComboBox.setModules(validModules);
        this.content.moduleComboBox.setSelectedModule(selection);
        this.content.workingDirectoryTextField.addBrowseFolderListener(data.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(PyBundle.message("configurable.select.working.directory", new Object[0])));
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyPluginCommonOptionsForm.this.updateControls();
            }
        };
        this.content.useSpecifiedSdkRadioButton.addActionListener(listener2);
        this.content.useModuleSdkRadioButton.addActionListener(listener2);
        this.content.interpreterComboBox.addActionListener(listener2);
        this.content.moduleComboBox.addActionListener(listener2);
        this.updateControls();
        this.addInterpreterComboBoxActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Consumer<Boolean> f : PyPluginCommonOptionsForm.this.myRemoteInterpreterModeListeners) {
                    f.accept(PythonSdkUtil.isRemote(PyPluginCommonOptionsForm.this.getSelectedSdk()));
                }
            }
        });
    }

    private void updateControls() {
        this.content.pathMappingsRow.visible(PythonSdkUtil.isRemote(this.getSelectedSdk()));
    }

    @Override
    public JPanel getMainPanel() {
        return this.content.panel;
    }

    @Override
    public void subscribe() {
    }

    @Override
    public void addInterpreterComboBoxActionListener(ActionListener listener2) {
        this.content.interpreterComboBox.addActionListener(listener2);
    }

    @Override
    public void removeInterpreterComboBoxActionListener(ActionListener listener2) {
        this.content.interpreterComboBox.removeActionListener(listener2);
    }

    @Override
    public void addInterpreterModeListener(Consumer<Boolean> listener2) {
        this.myRemoteInterpreterModeListeners.add(listener2);
    }

    @Override
    public String getInterpreterOptions() {
        return this.content.interpreterOptionsTextField.getText().trim();
    }

    @Override
    public void setInterpreterOptions(String interpreterOptions) {
        this.content.interpreterOptionsTextField.setText(interpreterOptions);
    }

    @Override
    public String getWorkingDirectory() {
        return FileUtil.toSystemIndependentName((String)this.content.workingDirectoryTextField.getText().trim());
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.content.workingDirectoryTextField.setText(workingDirectory == null ? "" : FileUtil.toSystemDependentName((String)workingDirectory));
    }

    @Override
    @Nullable
    public String getSdkHome() {
        Sdk selectedSdk = (Sdk)this.content.interpreterComboBox.getSelectedItem();
        return selectedSdk == null ? null : selectedSdk.getHomePath();
    }

    @Override
    @Nullable
    public Sdk getSdk() {
        return (Sdk)this.content.interpreterComboBox.getSelectedItem();
    }

    @Override
    public void setSdkHome(String sdkHome) {
        ArrayList<Sdk> sdkList = new ArrayList<Sdk>();
        sdkList.add(null);
        List allSdks = ContainerUtil.sorted(PythonSdkUtil.getAllSdks(), (Comparator)new PreferredSdkComparator());
        Sdk selection = null;
        for (Sdk sdk2 : allSdks) {
            String homePath = sdk2.getHomePath();
            if (homePath != null && sdkHome != null && FileUtil.pathsEqual((String)homePath, (String)sdkHome)) {
                selection = sdk2;
            }
            sdkList.add(sdk2);
        }
        this.content.interpreterComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(sdkList, selection));
    }

    @Override
    public void setSdk(@Nullable Sdk sdk2) {
        List<Sdk> allSdks = PythonSdkUtil.getAllSdks();
        ArrayList<Sdk> sdkList = new ArrayList<Sdk>(allSdks);
        Sdk selection = null;
        for (Sdk curSdk : allSdks) {
            if (curSdk != sdk2) continue;
            selection = curSdk;
        }
        if (selection == null) {
            sdkList.add(sdk2);
            selection = sdk2;
        }
        this.content.interpreterComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(sdkList, (Object)selection));
    }

    @Override
    public Module getModule() {
        return this.content.moduleComboBox.getSelectedModule();
    }

    @Override
    public String getModuleName() {
        Module module = this.getModule();
        return module != null ? module.getName() : null;
    }

    @Override
    public void setModule(Module module) {
        this.content.moduleComboBox.setSelectedModule(module);
    }

    @Override
    public boolean isUseModuleSdk() {
        return this.content.useModuleSdkRadioButton.isSelected();
    }

    @Override
    public void setUseModuleSdk(boolean useModuleSdk) {
        if (useModuleSdk) {
            this.content.useModuleSdkRadioButton.setSelected(true);
        } else {
            this.content.useSpecifiedSdkRadioButton.setSelected(true);
        }
        this.updateControls();
    }

    @Override
    public boolean isPassParentEnvs() {
        return this.content.envsComponent.isPassParentEnvs();
    }

    @Override
    public void setPassParentEnvs(boolean passParentEnvs) {
        this.content.envsComponent.setPassParentEnvs(passParentEnvs);
    }

    @Override
    public Map<String, String> getEnvs() {
        return this.content.envsComponent.getEnvs();
    }

    @Override
    public void setEnvs(Map<String, String> envs) {
        this.content.envsComponent.setEnvs(envs);
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.content.pathMappingsComponent.getMappingSettings();
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.content.pathMappingsComponent.setMappingSettings(mappingSettings);
    }

    private Sdk getSelectedSdk() {
        if (this.isUseModuleSdk()) {
            Module module = this.getModule();
            return module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        }
        Sdk sdk2 = (Sdk)this.content.interpreterComboBox.getSelectedItem();
        if (sdk2 == null) {
            return ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        }
        return sdk2;
    }

    public JComponent getAnchor() {
        return this.labelAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.labelAnchor = anchor;
    }

    @Override
    public boolean shouldAddContentRoots() {
        return this.content.addContentRootsCheckbox.isSelected();
    }

    @Override
    public boolean shouldAddSourceRoots() {
        return this.content.addSourceRootsCheckbox.isSelected();
    }

    @Override
    public void setAddContentRoots(boolean flag) {
        this.content.addContentRootsCheckbox.setSelected(flag);
    }

    @Override
    public void setAddSourceRoots(boolean flag) {
        this.content.addSourceRootsCheckbox.setSelected(flag);
    }

    @NotNull
    public List<String> getEnvFilePaths() {
        List<String> list = this.myEnvPaths;
        if (list == null) {
            PyPluginCommonOptionsForm.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setEnvFilePaths(@NotNull List<String> strings) {
        if (strings == null) {
            PyPluginCommonOptionsForm.$$$reportNull$$$0(1);
        }
        this.myEnvPaths = strings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/community/plugin/impl/run/PyPluginCommonOptionsForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvFilePaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/community/plugin/impl/run/PyPluginCommonOptionsForm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvFilePaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

