/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.OpenActualScriptSourceAction;
import com.intellij.javascript.debugger.scripts.OpenScriptSourceAction;
import com.intellij.javascript.debugger.scripts.SetLocalPathForScriptAction;
import com.intellij.javascript.debugger.scripts.SourceTabManager;
import com.intellij.javascript.debugger.scripts.SourcesTreeStructure;
import com.intellij.javascript.debugger.scripts.VisualizeScriptSourcemap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0002R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "", "sourceTabManager", "Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "<init>", "(Lcom/intellij/javascript/debugger/scripts/SourceTabManager;)V", "edtDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "getEdtDisposable$intellij_javascript_debugger", "()Lcom/intellij/openapi/Disposable;", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "mainComponent", "Ljavax/swing/JScrollPane;", "getMainComponent", "()Ljavax/swing/JScrollPane;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "treeStructure", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeStructure;", "structureTreeModel", "Lcom/intellij/ui/tree/StructureTreeModel;", "getStructureTreeModel$intellij_javascript_debugger", "()Lcom/intellij/ui/tree/StructureTreeModel;", "selectedNode", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "getSelectedNode", "()Lcom/intellij/javascript/debugger/scripts/FileNode;", "getDefaultFocusedComponent", "Ljavax/swing/JComponent;", "createPopupGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "intellij.javascript.debugger"})
public final class SourcesTreeComponent {
    @NotNull
    private final Disposable edtDisposable;
    @NotNull
    private final SimpleTree tree;
    @NotNull
    private final JScrollPane mainComponent;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final SourcesTreeStructure treeStructure;
    @NotNull
    private final StructureTreeModel<SourcesTreeStructure> structureTreeModel;

    public SourcesTreeComponent(@NotNull SourceTabManager sourceTabManager) {
        Intrinsics.checkNotNullParameter((Object)sourceTabManager, (String)"sourceTabManager");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.edtDisposable = disposable;
        this.tree = new SimpleTree();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        this.mainComponent = jScrollPane;
        this.debugProcess = sourceTabManager.getDebugProcess();
        this.treeStructure = new SourcesTreeStructure(sourceTabManager);
        this.structureTreeModel = new StructureTreeModel((AbstractTreeStructure)this.treeStructure, (Comparator)new WeightBasedComparator(true), (Disposable)this.debugProcess);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setModel((TreeModel)new AsyncTreeModel((TreeModel)this.structureTreeModel, this.edtDisposable));
        sourceTabManager.setTreeModel(this.structureTreeModel, this.treeStructure);
        SetLocalPathForScriptAction setLocalPathForScriptAction = this.debugProcess.getSession().getRunProfile() instanceof JavaScriptDebugConfiguration ? new SetLocalPathForScriptAction(this) : null;
        final DefaultActionGroup fileGroup = this.createPopupGroup();
        final DefaultActionGroup dirGroup = null;
        if (setLocalPathForScriptAction != null) {
            dirGroup = new DefaultActionGroup();
            dirGroup.add((AnAction)setLocalPathForScriptAction);
            fileGroup.add((AnAction)setLocalPathForScriptAction);
        } else {
            dirGroup = null;
        }
        this.tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                block1: {
                    DefaultActionGroup group;
                    Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                    FileNode fileNode = this.getSelectedNode();
                    if (fileNode == null) break block1;
                    FileNode fileNode2 = fileNode;
                    DefaultActionGroup defaultActionGroup = fileGroup;
                    DefaultActionGroup defaultActionGroup2 = dirGroup;
                    FileNode it = fileNode2;
                    boolean bl = false;
                    DefaultActionGroup defaultActionGroup3 = group = it.getFileInfo().isFile() ? defaultActionGroup : defaultActionGroup2;
                    if (group != null) {
                        ActionManager.getInstance().createActionPopupMenu("SourcesTreeComponent", (ActionGroup)group).getComponent().show(comp, x, y);
                    }
                }
            }
        });
    }

    @NotNull
    public final Disposable getEdtDisposable$intellij_javascript_debugger() {
        return this.edtDisposable;
    }

    @NotNull
    public final JScrollPane getMainComponent() {
        return this.mainComponent;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final StructureTreeModel<SourcesTreeStructure> getStructureTreeModel$intellij_javascript_debugger() {
        return this.structureTreeModel;
    }

    @Nullable
    public final FileNode getSelectedNode() {
        SimpleNode simpleNode = this.tree.getSelectedNode();
        return simpleNode instanceof FileNode ? (FileNode)simpleNode : null;
    }

    @NotNull
    public final JComponent getDefaultFocusedComponent() {
        return (JComponent)this.tree;
    }

    private final DefaultActionGroup createPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new OpenScriptSourceAction(this));
        WebBrowser browser = this.debugProcess.getConnection().getBrowser();
        if (browser == null || browser.getFamily() == BrowserFamily.CHROME) {
            group.add((AnAction)new OpenActualScriptSourceAction(this));
            group.add((AnAction)new VisualizeScriptSourcemap(this));
        }
        return group;
    }
}

