/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.AnsiFragment;
import com.intellij.javascript.debugger.console.HasUrlFragment;
import com.intellij.javascript.debugger.console.MaybeUrlFragment;
import com.intellij.javascript.debugger.console.NoUrlFragment;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JZ\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2 \u0010\f\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u00070\r2 \u0010\u000f\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u00070\rJ\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/debugger/console/UrlsAndAnsiParser;", "", "<init>", "()V", "urlFilter", "Lcom/intellij/execution/filters/UrlFilter;", "parseAndPrint", "", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "printText", "Lkotlin/Function3;", "Lcom/intellij/ui/SimpleColoredText;", "printUrl", "Lcom/intellij/execution/filters/HyperlinkInfo;", "parseAnsiFragments", "Ljava/util/Deque;", "Lcom/intellij/javascript/debugger/console/AnsiFragment;", "parseMaybeUrlFragments", "Lkotlin/sequences/Sequence;", "Lcom/intellij/javascript/debugger/console/MaybeUrlFragment;", "pollFragmentsUntil", "ansiFragmentsQueue", "untilPos", "", "toSimpleColoredText", "fragments", "", "baseContentType", "getSimpleTextAttrs", "Lcom/intellij/ui/SimpleTextAttributes;", "fragment", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nUrlsAndAnsiParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlsAndAnsiParser.kt\ncom/intellij/javascript/debugger/console/UrlsAndAnsiParser\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1317#2:135\n1318#2:138\n1863#3,2:136\n1863#3,2:139\n*S KotlinDebug\n*F\n+ 1 UrlsAndAnsiParser.kt\ncom/intellij/javascript/debugger/console/UrlsAndAnsiParser\n*L\n28#1:135\n28#1:138\n31#1:136,2\n101#1:139,2\n*E\n"})
public final class UrlsAndAnsiParser {
    @NotNull
    public static final UrlsAndAnsiParser INSTANCE = new UrlsAndAnsiParser();
    @NotNull
    private static final UrlFilter urlFilter = new UrlFilter();

    private UrlsAndAnsiParser() {
    }

    /*
     * WARNING - void declaration
     */
    public final void parseAndPrint(@NotNull String text, @NotNull ConsoleViewContentType contentType, @NotNull Function3<? super String, ? super ConsoleViewContentType, ? super SimpleColoredText, Unit> printText, @NotNull Function3<? super String, ? super HyperlinkInfo, ? super SimpleColoredText, Unit> printUrl) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter(printText, (String)"printText");
        Intrinsics.checkNotNullParameter(printUrl, (String)"printUrl");
        Deque<AnsiFragment> ansiFragmentsQueue = this.parseAnsiFragments(text, contentType);
        String textWithoutAnsiEscapes = CollectionsKt.joinToString$default((Iterable)ansiFragmentsQueue, (CharSequence)"", null, null, (int)0, null, UrlsAndAnsiParser::parseAndPrint$lambda$0, (int)30, null);
        Sequence<MaybeUrlFragment> sequence = this.parseMaybeUrlFragments(textWithoutAnsiEscapes);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MaybeUrlFragment urlFragment = (MaybeUrlFragment)element$iv;
            boolean bl = false;
            List ansiFragsInThisUrlFrag = SequencesKt.toList(INSTANCE.pollFragmentsUntil(ansiFragmentsQueue, urlFragment.getUntilPos()));
            MaybeUrlFragment maybeUrlFragment = urlFragment;
            if (maybeUrlFragment instanceof NoUrlFragment) {
                Iterable $this$forEach$iv2 = ansiFragsInThisUrlFrag;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    AnsiFragment it = (AnsiFragment)element$iv2;
                    boolean bl2 = false;
                    printText.invoke((Object)it.getText(), (Object)contentType, (Object)INSTANCE.toSimpleColoredText(CollectionsKt.listOf((Object)it), contentType));
                }
                continue;
            }
            if (maybeUrlFragment instanceof HasUrlFragment) {
                String string = textWithoutAnsiEscapes.substring(((HasUrlFragment)urlFragment).getUrl().getHighlightStartOffset(), ((HasUrlFragment)urlFragment).getUrl().getHighlightEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                HyperlinkInfo hyperlinkInfo = ((HasUrlFragment)urlFragment).getUrl().getHyperlinkInfo();
                Intrinsics.checkNotNull((Object)hyperlinkInfo);
                printUrl.invoke((Object)string, (Object)hyperlinkInfo, (Object)INSTANCE.toSimpleColoredText(ansiFragsInThisUrlFrag, contentType));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final Deque<AnsiFragment> parseAnsiFragments(String text, ConsoleViewContentType contentType) {
        ArrayDeque ansiFragments = new ArrayDeque();
        new AnsiEscapeDecoder().escapeText(text, ProcessOutputTypes.STDOUT, (arg_0, arg_1) -> UrlsAndAnsiParser.parseAnsiFragments$lambda$3(contentType, ansiFragments, arg_0, arg_1));
        return ansiFragments;
    }

    private final Sequence<MaybeUrlFragment> parseMaybeUrlFragments(String text) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MaybeUrlFragment>, Continuation<? super Unit>, Object>(text, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $text;
            {
                this.$text = $text;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        pos = 0;
                        v0 = UrlsAndAnsiParser.access$getUrlFilter$p().applyFilter(this.$text, this.$text.length());
                        if (v0 == null || (v0 = v0.getResultItems()) == null) {
                            v0 = CollectionsKt.emptyList();
                        }
                        var4_5 = v0.iterator();
lbl11:
                        // 2 sources

                        while (var4_5.hasNext()) {
                            resItem = (Filter.ResultItem)var4_5.next();
                            if (resItem.getHighlightStartOffset() > pos) {
                                v1 = this.$text.substring(pos, resItem.getHighlightStartOffset());
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                                this.L$0 = $this$sequence;
                                this.L$1 = var4_5;
                                this.L$2 = resItem;
                                this.label = 1;
                                v2 = $this$sequence.yield((Object)new NoUrlFragment(pos, v1), (Continuation)this);
                                if (v2 == var6_2) {
                                    return var6_2;
                                }
                            }
                            ** GOTO lbl31
                        }
                        break;
                    }
                    case 1: {
                        resItem = (Filter.ResultItem)this.L$2;
                        var4_5 = (Iterator<E>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl31:
                        // 2 sources

                        Intrinsics.checkNotNull((Object)resItem);
                        this.L$0 = $this$sequence;
                        this.L$1 = var4_5;
                        this.L$2 = resItem;
                        this.label = 2;
                        v3 = $this$sequence.yield((Object)new HasUrlFragment(resItem), (Continuation)this);
                        if (v3 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl46
                    }
                    case 2: {
                        resItem = (Filter.ResultItem)this.L$2;
                        var4_5 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl46:
                        // 2 sources

                        pos = resItem.getHighlightEndOffset();
                        ** GOTO lbl11
                    }
                }
                if (pos < this.$text.length()) {
                    v4 = this.$text.substring(pos);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"substring(...)");
                    this.L$0 = null;
                    this.L$1 = null;
                    this.L$2 = null;
                    this.label = 3;
                    v5 = $this$sequence.yield((Object)new NoUrlFragment(pos, v4), (Continuation)this);
                    if (v5 == var6_2) {
                        return var6_2;
                    }
                }
                ** GOTO lbl62
                {
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl62:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super MaybeUrlFragment> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Sequence<AnsiFragment> pollFragmentsUntil(Deque<AnsiFragment> ansiFragmentsQueue, int untilPos) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super AnsiFragment>, Continuation<? super Unit>, Object>(ansiFragmentsQueue, untilPos, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Deque<AnsiFragment> $ansiFragmentsQueue;
            final /* synthetic */ int $untilPos;
            {
                this.$ansiFragmentsQueue = $ansiFragmentsQueue;
                this.$untilPos = $untilPos;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
lbl6:
                        // 2 sources

                        while (!this.$ansiFragmentsQueue.isEmpty()) {
                            fragment = this.$ansiFragmentsQueue.pollFirst();
                            if (fragment.getUntilPos() <= this.$untilPos) break block0;
                            var4_5 = fragment.split(this.$untilPos);
                            currFragment = (AnsiFragment)var4_5.component1();
                            nextFragment = (AnsiFragment)var4_5.component2();
                            this.$ansiFragmentsQueue.addFirst(nextFragment);
                            this.L$0 = null;
                            this.L$1 = null;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)currFragment, (Continuation)this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl24
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                Intrinsics.checkNotNull((Object)fragment);
                this.L$0 = $this$sequence;
                this.L$1 = fragment;
                this.label = 2;
                v1 = $this$sequence.yield((Object)fragment, (Continuation)this);
                if (v1 == var7_2) {
                    return var7_2;
                }
                ** GOTO lbl38
                {
                    case 2: {
                        fragment = (AnsiFragment)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl38:
                        // 2 sources

                        if (fragment.getUntilPos() != this.$untilPos) ** GOTO lbl6
                        return Unit.INSTANCE;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super AnsiFragment> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final SimpleColoredText toSimpleColoredText(List<AnsiFragment> fragments, ConsoleViewContentType baseContentType) {
        if (fragments.size() == 1 && fragments.get(0).getContentType().getAttributes().equals((Object)baseContentType.getAttributes())) {
            return null;
        }
        SimpleColoredText simpleColoredText = new SimpleColoredText();
        Iterable $this$forEach$iv = fragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnsiFragment fragment = (AnsiFragment)element$iv;
            boolean bl = false;
            simpleColoredText.append(fragment.getText(), INSTANCE.getSimpleTextAttrs(fragment, baseContentType));
        }
        return simpleColoredText;
    }

    private final SimpleTextAttributes getSimpleTextAttrs(AnsiFragment fragment, ConsoleViewContentType baseContentType) {
        SimpleTextAttributes simpleTextAttributes;
        TextAttributes attrs = fragment.getContentType().getAttributes();
        if (attrs.equals((Object)baseContentType.getAttributes())) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
        } else {
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.fromTextAttributes((TextAttributes)attrs);
            simpleTextAttributes = simpleTextAttributes3;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"fromTextAttributes(...)");
        }
        return simpleTextAttributes;
    }

    private static final CharSequence parseAndPrint$lambda$0(AnsiFragment it) {
        return it.getText();
    }

    private static final void parseAnsiFragments$lambda$3(ConsoleViewContentType $contentType, ArrayDeque $ansiFragments, String textChunk, Key attributes) {
        Intrinsics.checkNotNullParameter((Object)textChunk, (String)"textChunk");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
        ConsoleViewContentType fragmentContentType = consoleViewContentType;
        ConsoleViewContentType resultFragmentContentType = !Intrinsics.areEqual((Object)$contentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT) && Intrinsics.areEqual((Object)fragmentContentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT) ? $contentType : fragmentContentType;
        AnsiFragment ansiFragment = (AnsiFragment)CollectionsKt.lastOrNull((Iterable)$ansiFragments);
        int pos = ansiFragment != null ? ansiFragment.getUntilPos() : 0;
        ((Collection)$ansiFragments).add(new AnsiFragment(pos, textChunk, resultFragmentContentType));
    }

    public static final /* synthetic */ UrlFilter access$getUrlFilter$p() {
        return urlFilter;
    }
}

