/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pt_PT extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "arménio";
        final String metaValue_bn = "bengalês";
        final String metaValue_te = "telugu";
        final Object[][] data = new Object[][] {
            { "009", "Oceânia" },
            { "015", "Norte de África" },
            { "018", "África Austral" },
            { "029", "Caraíbas" },
            { "034", "Ásia do Sul" },
            { "039", "Europa do Sul" },
            { "154", "Europa do Norte" },
            { "202", "África subsariana" },
            { "AM", "Arménia" },
            { "AX", "Alanda" },
            { "BD", "Bangladeche" },
            { "BH", "Barém" },
            { "BJ", "Benim" },
            { "BS", "Baamas" },
            { "CC", "Ilhas dos Cocos (Keeling)" },
            { "CD", "Congo-Kinshasa" },
            { "CG", "Congo-Brazzaville" },
            { "CI", "Côte d’Ivoire (Costa do Marfim)" },
            { "CW", "Curaçau" },
            { "CX", "Ilha do Natal" },
            { "CZ", "Chéquia" },
            { "DJ", "Jibuti" },
            { "DM", "Domínica" },
            { "EA", "Ceuta e Melilha" },
            { "EE", "Estónia" },
            { "EH", "Sara Ocidental" },
            { "EZ", "Zona Euro" },
            { "FK", "Ilhas Falkland" },
            { "GG", "Guernesey" },
            { "GL", "Gronelândia" },
            { "GU", "Guame" },
            { "IR", "Irão" },
            { "KE", "Quénia" },
            { "KI", "Quiribáti" },
            { "KN", "São Cristóvão e Neves" },
            { "KW", "Koweit" },
            { "KY", "Ilhas Caimão" },
            { "LI", "Listenstaine" },
            { "LK", "Sri Lanca" },
            { "LV", "Letónia" },
            { "MC", "Mónaco" },
            { "MF", "São Martinho (Saint-Martin)" },
            { "MG", "Madagáscar" },
            { "MK", "Macedónia do Norte" },
            { "MS", "Monserrate" },
            { "MU", "Maurícia" },
            { "MW", "Maláui" },
            { "NC", "Nova Caledónia" },
            { "NU", "Niuê" },
            { "PL", "Polónia" },
            { "PS", "Territórios palestinianos" },
            { "QO", "Oceânia Insular" },
            { "RO", "Roménia" },
            { "SI", "Eslovénia" },
            { "SM", "São Marinho" },
            { "SV", "Salvador" },
            { "SX", "São Martinho (Sint Maarten)" },
            { "TF", "Territórios Austrais Franceses" },
            { "TJ", "Tajiquistão" },
            { "TK", "Toquelau" },
            { "TM", "Turquemenistão" },
            { "TT", "Trindade e Tobago" },
            { "UM", "Ilhas Menores Afastadas dos EUA" },
            { "UZ", "Usbequistão" },
            { "VI", "Ilhas Virgens dos EUA" },
            { "VN", "Vietname" },
            { "XA", "Pseudoacentos" },
            { "YE", "Iémen" },
            { "YT", "Maiote" },
            { "ZW", "Zimbabué" },
            { "af", "africanês" },
            { "av", "avar" },
            { "bn", metaValue_bn },
            { "co", "córsico" },
            { "cs", "checo" },
            { "cv", "chuvash" },
            { "et", "estónio" },
            { "fy", "frísico ocidental" },
            { "ha", "haúça" },
            { "hy", metaValue_hy },
            { "kl", "gronelandês" },
            { "lg", "ganda" },
            { "mk", "macedónio" },
            { "mr", "marata" },
            { "nb", "norueguês bokmål" },
            { "nl", "neerlandês" },
            { "nn", "norueguês nynorsk" },
            { "oc", "occitano" },
            { "os", "ossético" },
            { "pl", "polaco" },
            { "ps", "pastó" },
            { "se", "sami do norte" },
            { "sn", "shona" },
            { "st", "sesoto" },
            { "te", metaValue_te },
            { "tg", "tajique" },
            { "tk", "turcomano" },
            { "to", "tonga" },
            { "tt", "tatar" },
            { "uz", "usbeque" },
            { "wo", "uólofe" },
            { "xh", "xosa" },
            { "yo", "ioruba" },
            { "alt", "altai do sul" },
            { "ang", "inglês antigo" },
            { "arn", "mapuche" },
            { "ars", "árabe do Négede" },
            { "bax", "bamun" },
            { "bbj", "ghomala" },
            { "bua", "buriat" },
            { "ccp", "changma" },
            { "chk", "chuquês" },
            { "chn", "jargão chinook" },
            { "chr", "cherokee" },
            { "chy", "cheyenne" },
            { "crr", "algonquiano de Carolina" },
            { "crs", "francês crioulo seselwa" },
            { "efi", "efik" },
            { "egy", "egípcio clássico" },
            { "fon", "fon" },
            { "fro", "francês antigo" },
            { "frs", "frísio oriental" },
            { "gez", "geʼez" },
            { "goh", "alemão alto antigo" },
            { "grc", "grego clássico" },
            { "gsw", "alemão suíço" },
            { "ikt", "inuktitut canadiano ocidental" },
            { "kbd", "cabardiano" },
            { "krc", "carachaio-bálcaro" },
            { "lez", "lezghiano" },
            { "lou", "crioulo de Louisiana" },
            { "lrc", "luri do norte" },
            { "lus", "mizo" },
            { "mak", "makassarês" },
            { "mfe", "crioulo mauriciano" },
            { "moh", "mohawk" },
            { "mul", "vários idiomas" },
            { "nds", "baixo-alemão" },
            { "non", "nórdico antigo" },
            { "pag", "língua pangasinesa" },
            { "pam", "pampango" },
            { "peo", "persa antigo" },
            { "pon", "língua pohnpeica" },
            { "pro", "provençal antigo" },
            { "raj", "rajastanês" },
            { "rhg", "rohingya" },
            { "sga", "irlandês antigo" },
            { "shu", "árabe do Chade" },
            { "sma", "sami do sul" },
            { "smn", "inari sami" },
            { "str", "salish dos estreitos" },
            { "tem", "temne" },
            { "ttm", "tutchone do norte" },
            { "tzm", "tamazigue do Atlas Central" },
            { "vec", "véneto" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "zgh", "tamazight marroquino padrão" },
            { "zun", "zuni" },
            { "zza", "zaza" },
            { "Aran", "nasta’liq" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Cakm", "chakma" },
            { "Cans", "escrita silábica unificada dos aborígenes canadianos" },
            { "Egyd", "egípcio demótico" },
            { "Egyh", "egípcio hierático" },
            { "Ethi", "etíope" },
            { "Hanb", "han com bopomofo" },
            { "Inds", "indus" },
            { "Orya", "odia" },
            { "Sylo", "siloti nagri" },
            { "Tale", "tai le" },
            { "Telu", metaValue_te },
            { "Zsym", "símbolos" },
            { "Zxxx", "não escrito" },
            { "de_AT", "alemão austríaco" },
            { "de_CH", "alto alemão suíço" },
            { "en_AU", "inglês australiano" },
            { "en_CA", "inglês canadiano" },
            { "en_GB", "inglês britânico" },
            { "en_US", "inglês americano" },
            { "es_ES", "espanhol europeu" },
            { "es_MX", "espanhol mexicano" },
            { "fr_CA", "francês canadiano" },
            { "fr_CH", "francês suíço" },
            { "pt_BR", "português do Brasil" },
            { "pt_PT", "português europeu" },
            { "ar_001", "árabe moderno padrão" },
            { "es_419", "espanhol latino-americano" },
            { "key.cf", "Formato monetário" },
            { "key.hc", "Ciclo horário (12 vs. 24)" },
            { "key.ms", "Sistema de medida" },
            { "key.va", "Variante de região" },
            { "nds_NL", "baixo-saxão" },
            { "%%AREVELA", "arménio oriental" },
            { "%%AREVMDA", "arménio ocidental" },
            { "%%MONOTON", "monotónico" },
            { "%%POLYTON", "politónico" },
            { "type.co.eor", "Regras de ordenação europeias" },
            { "type.m0.bgn", "Transliteração BGN" },
            { "type.nu.armn", "Numeração arménia" },
            { "type.nu.beng", "Algarismos bengalis" },
            { "type.nu.deva", "Algarismos devanágaris" },
            { "type.nu.ethi", "Numeração etíope" },
            { "type.nu.geor", "Numeração georgiana" },
            { "type.nu.grek", "Numeração grega" },
            { "type.nu.gujr", "Algarismos de guzerate" },
            { "type.nu.guru", "Algarismos de gurmukhi" },
            { "type.nu.hans", "Numeração em chinês simplificado" },
            { "type.nu.hant", "Numeração em chinês tradicional" },
            { "type.nu.hebr", "Numeração hebraica" },
            { "type.nu.jpan", "Numeração japonesa" },
            { "type.nu.khmr", "Algarismos de khmer" },
            { "type.nu.knda", "Algarismos de canarim" },
            { "type.nu.mlym", "Algarismos de malaiala" },
            { "type.nu.mtei", "Algarismos de meetei mayek" },
            { "type.nu.mymr", "Algarismos birmaneses" },
            { "type.nu.olck", "Algarismos de ol chiki" },
            { "type.nu.orya", "Algarismos de odia" },
            { "type.nu.taml", "Numeração tâmil" },
            { "type.nu.telu", "Algarismos de telugu" },
            { "type.ca.dangi", "Calendário dangi" },
            { "type.lb.loose", "Estilo flexível de quebra de linha" },
            { "type.nu.roman", "Numeração romana" },
            { "type.ca.coptic", "Calendário copta" },
            { "type.ca.hebrew", "Calendário hebraico" },
            { "type.ca.indian", "Calendário nacional indiano" },
            { "type.co.pinyin", "Ordem de pinyin" },
            { "type.co.stroke", "Ordem por traços" },
            { "type.co.unihan", "Ordem por radical e traços" },
            { "type.co.zhuyin", "Ordem de zhuyin" },
            { "type.d0.fwidth", "Largura completa" },
            { "type.lb.normal", "Estilo padrão de quebra de linha" },
            { "type.lb.strict", "Estilo estrito de quebra de linha" },
            { "type.m0.ungegn", "Transliteração UNGEGN" },
            { "type.ca.chinese", "Calendário chinês" },
            { "type.ca.islamic", "Calendário hegírico" },
            { "type.ca.persian", "Calendário persa" },
            { "type.cf.account", "Formato monetário contabilístico" },
            { "type.nu.arabext", "Algarismos indo-arábicos expandidos" },
            { "type.nu.armnlow", "Numeração arménia minúscula" },
            { "type.nu.finance", "Algarismos financeiros" },
            { "type.nu.greklow", "Numeração grega minúscula" },
            { "type.nu.hanidec", "Numeração decimal chinesa" },
            { "type.nu.hansfin", "Numeração financeira em chinês simplificado" },
            { "type.nu.hantfin", "Numeração financeira em chinês tradicional" },
            { "type.nu.jpanfin", "Numeração financeira japonesa" },
            { "type.nu.tamldec", "Algarismos de tâmil" },
            { "type.ca.buddhist", "Calendário budista" },
            { "type.ca.ethiopic", "Calendário etíope" },
            { "type.ca.japanese", "Calendário japonês" },
            { "type.cf.standard", "Formato monetário padrão" },
            { "type.co.standard", "Ordenação padrão" },
            { "type.ms.uksystem", "Sistema de medida imperial" },
            { "type.ms.ussystem", "Sistema de medida americano" },
            { "type.nu.fullwide", "Algarismos de largura completa" },
            { "type.nu.romanlow", "Numeração romana minúscula" },
            { "type.ca.gregorian", "Calendário gregoriano" },
            { "type.co.phonebook", "Ordem da lista telefónica" },
            { "type.nu.traditional", "Algarismos tradicionais" },
            { "type.ca.islamic-civil", "Calendário hegírico (civil)" },
            { "type.ca.islamic-umalqura", "Calendário hegírico (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Calendário etíope Amete Alem" },
        };
        return data;
    }
}
