// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Bytes for a sample image.
 *
 * 225x225 blue square
 * https://screenshot.googleplex.com/98CQoeyE6ydqNP7
 */
export const IMAGE_BYTES = new Uint8Array([
  137, 80,  78,  71,  13,  10,  26,  10,  0,   0,   0,   13,  73,  72,  68,
  82,  0,   0,   0,   225, 0,   0,   0,   225, 8,   3,   0,   0,   0,   9,
  109, 34,  72,  0,   0,   0,   57,  80,  76,  84,  69,  0,   0,   255, 160,
  160, 255, 163, 163, 255, 171, 171, 255, 180, 180, 255, 191, 191, 255, 203,
  203, 255, 165, 165, 255, 188, 188, 255, 223, 223, 255, 154, 154, 255, 156,
  156, 255, 254, 254, 255, 243, 243, 255, 229, 229, 255, 217, 217, 255, 209,
  209, 255, 168, 168, 255, 174, 174, 255, 85,  123, 119, 229, 0,   0,   1,
  114, 73,  68,  65,  84,  120, 156, 237, 221, 73,  78,  196, 48,  0,   69,
  65,  187, 187, 3,   205, 60,  220, 255, 176, 176, 96,  3,   27,  16,  82,
  20,  85,  242, 202, 23,  248, 111, 105, 201, 146, 199, 227, 211, 243, 203,
  235, 205, 205, 178, 44,  215, 203, 167, 243, 151, 219, 211, 55,  243, 255,
  78,  191, 122, 59,  255, 193, 251, 229, 47,  150, 159, 174, 119, 227, 50,
  246, 237, 126, 247, 133, 179, 66,  222, 28,  231, 173, 39,  172, 172, 66,
  95,  133, 190, 10,  125, 21,  250, 42,  244, 29,  161, 240, 109, 235, 9,
  43,  155, 227, 180, 245, 132, 149, 85,  232, 171, 208, 87,  161, 175, 66,
  95,  133, 190, 10,  125, 21,  250, 42,  244, 85,  232, 171, 208, 87,  161,
  175, 66,  95,  133, 190, 10,  125, 21,  250, 42,  244, 205, 207, 179, 111,
  21,  250, 42,  244, 85,  232, 171, 208, 87,  161, 175, 66,  95,  133, 190,
  10,  125, 21,  250, 42,  244, 85,  232, 171, 208, 87,  161, 175, 66,  95,
  133, 190, 10,  125, 21,  250, 42,  244, 85,  232, 59,  66,  225, 254, 95,
  12,  85,  168, 171, 208, 87,  161, 175, 66,  95,  133, 190, 10,  125, 21,
  250, 42,  244, 85,  232, 171, 208, 87,  161, 175, 66,  95,  133, 190, 10,
  125, 21,  250, 42,  244, 85,  232, 171, 208, 87,  161, 239, 8,   133, 183,
  91,  79,  88,  217, 17,  254, 153, 169, 80,  87,  161, 175, 66,  95,  133,
  190, 10,  125, 21,  250, 42,  244, 85,  232, 171, 208, 87,  161, 175, 66,
  95,  133, 190, 10,  125, 21,  250, 42,  244, 85,  232, 171, 208, 87,  161,
  111, 142, 203, 214, 19,  86,  86,  161, 175, 66,  95,  133, 190, 10,  125,
  21,  250, 42,  244, 85,  232, 171, 208, 87,  161, 175, 66,  95,  133, 190,
  10,  125, 21,  250, 42,  244, 85,  232, 171, 208, 87,  161, 175, 66,  223,
  28,  215, 173, 39,  172, 108, 142, 101, 235, 9,   43,  171, 208, 87,  161,
  175, 66,  95,  133, 190, 10,  125, 21,  250, 42,  244, 29,  161, 112, 239,
  55,  224, 135, 113, 119, 63,  247, 236, 225, 245, 3,   164, 253, 7,   35,
  44,  106, 186, 180, 0,   0,   0,   0,   73,  69,  78,  68,  174, 66,  96,
  130,
]);

/** File for sample image. */
export const IMAGE_FILE =
    new File([IMAGE_BYTES], 'valid-image.png', {type: 'image/png'});

/** Generates an image with the given dimensions. */
export function generateTestImageFile(
    height: number, width: number, fileType: string): Promise<File> {
  const canvas = document.createElement('canvas');
  canvas.height = height;
  canvas.width = width;
  const context = canvas.getContext('2d')!;
  const imageData = context.createImageData(width, height);

  const data = imageData.data;
  for (let i = 0; i < height * width; i++) {
    // RGB values between 0 and 255.
    data[i * 4 + 0] = Math.random() * 256 | 0;  // Red
    data[i * 4 + 1] = Math.random() * 256 | 0;  // Green
    data[i * 4 + 2] = Math.random() * 256 | 0;  // Blue
    data[i * 4 + 3] = 90;                       // alpha (transparency)
  }
  context.putImageData(imageData, 0, 0);

  return new Promise((resolve) => {
    canvas.toBlob((blob) => {
      const file = new File([blob!], 'test-image', {type: fileType});
      resolve(file);
    }, fileType);
  });
}
