/*
 * Decompiled with CFR 0.152.
 */
package plan;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarContainer;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceAssignmentContainer;
import net.sf.mpxj.ResourceContainer;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.writer.AbstractProjectWriter;
import plan.schema.ActualEffort;
import plan.schema.Appointment;
import plan.schema.AppointmentInterval;
import plan.schema.Calendar;
import plan.schema.Calendars;
import plan.schema.CompletionEntry;
import plan.schema.Day;
import plan.schema.Estimate;
import plan.schema.Locale;
import plan.schema.ObjectFactory;
import plan.schema.Plan;
import plan.schema.Progress;
import plan.schema.Project;
import plan.schema.ProjectSchedule;
import plan.schema.ProjectSchedules;
import plan.schema.ProjectSettings;
import plan.schema.Relation;
import plan.schema.Relations;
import plan.schema.Resource;
import plan.schema.ResourceGroup;
import plan.schema.ResourceGroupRelation;
import plan.schema.ResourceGroupRelations;
import plan.schema.ResourceGroups;
import plan.schema.ResourceRequest;
import plan.schema.ResourceRequests;
import plan.schema.Resources;
import plan.schema.ScheduleManagement;
import plan.schema.StandardWorktime;
import plan.schema.Task;
import plan.schema.TaskSchedule;
import plan.schema.TaskSchedules;
import plan.schema.Tasks;
import plan.schema.TimeInterval;
import plan.schema.UsedEffort;
import plan.schema.Weekday;

public final class PlanWriter
extends AbstractProjectWriter {
    private String m_encoding;
    private ProjectFile m_projectFile;
    private ObjectFactory m_factory;
    private Plan m_plan;
    private Project m_planProject;
    private List<ResourceGroup> m_resourceGroups = new ArrayList<ResourceGroup>();
    private Map<String, List> m_groups = new HashMap<String, List>();
    private NumberFormat m_twoDigitFormat = new DecimalFormat("00");
    private NumberFormat m_fourDigitFormat = new DecimalFormat("0000");
    private static Map<RelationType, String> RELATIONSHIP_TYPES = new HashMap<RelationType, String>();
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            if (this.m_encoding != null) {
                marshaller.setProperty("jaxb.encoding", this.m_encoding);
            }
            this.m_factory = new ObjectFactory();
            this.m_plan = this.m_factory.createPlan();
            this.writePlan();
            marshaller.marshal((Object)this.m_plan, outputStream);
        }
        catch (JAXBException jAXBException) {
            throw new IOException(jAXBException.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_planProject = null;
            this.m_plan = null;
        }
    }

    private void writePlan() {
        this.m_plan.setEditor("planConverter");
        this.m_plan.setVersion("0.7.0");
        this.m_plan.setMime("application/x-vnd.kde.plan");
        this.writeProject();
        this.writeProjectSettings();
        this.writeCalendars();
        this.writeResources();
        this.writeResourceGroups();
        this.writeResourceGroupRelations();
        this.writeTasks();
        this.writeRelations();
        this.writeRequests();
        this.writeProjectSchedules();
        System.out.println("writePlan: finished");
    }

    private void writeProject() {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        this.m_planProject = this.m_factory.createProject();
        this.m_plan.setProject(this.m_planProject);
        this.m_planProject.setId(this.getProjectId());
        this.m_planProject.setName(projectProperties.getName());
        this.m_planProject.setLeader(projectProperties.getManager());
        this.m_planProject.setScheduling(this.getScheduleFromString(projectProperties.getScheduleFrom()));
        this.m_planProject.setStartTime(this.getDateTimeString(projectProperties.getStartDate()));
        this.m_planProject.setEndTime(this.getDateTimeString(projectProperties.getFinishDate()));
        this.m_planProject.setDescription(projectProperties.getComments());
    }

    private void writeProjectSettings() {
        ProjectSettings projectSettings = this.m_factory.createProjectSettings();
        this.m_planProject.setProjectSettings(projectSettings);
        this.writeStandardWorktime(projectSettings);
        this.writeLocale(projectSettings);
    }

    private void writeStandardWorktime(ProjectSettings projectSettings) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        StandardWorktime standardWorktime = this.m_factory.createStandardWorktime();
        projectSettings.setStandardWorktime(standardWorktime);
        standardWorktime.setDay(this.getMinutesString(projectProperties.getMinutesPerDay().longValue()));
        standardWorktime.setWeek(this.getMinutesString(projectProperties.getMinutesPerWeek().longValue()));
        standardWorktime.setMonth(this.getMinutesString(projectProperties.getMinutesPerDay().longValue() * (long)projectProperties.getDaysPerMonth().intValue()));
        standardWorktime.setYear(this.getMinutesString(projectProperties.getMinutesPerYear().intValue()));
    }

    private void writeLocale(ProjectSettings projectSettings) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        Locale locale = this.m_factory.createLocale();
        projectSettings.setLocale(locale);
        locale.setCurrencySymbol(projectProperties.getCurrencySymbol());
        locale.setCurrencyDigits(this.getIntegerString(projectProperties.getCurrencyDigits()));
    }

    private void writeCalendars() {
        System.out.println("writeCalendars:");
        Calendars calendars = this.m_factory.createCalendars();
        this.m_planProject.setCalendars(calendars);
        ProjectCalendarContainer projectCalendarContainer = this.m_projectFile.getCalendars();
        for (int i = 0; i < projectCalendarContainer.size(); ++i) {
            ProjectCalendar projectCalendar = (ProjectCalendar)projectCalendarContainer.get(i);
            Calendar calendar = this.m_factory.createCalendar();
            this.writeCalendar(projectCalendar, calendar);
            if (i == 0) {
                calendar.setDefault("1");
            }
            calendars.getCalendar().add(calendar);
        }
    }

    private void writeCalendar(ProjectCalendar projectCalendar, Calendar calendar) {
        try {
            Object object;
            System.out.println("writeCalendar: " + projectCalendar.getName() + ", id " + projectCalendar.getUniqueID());
            calendar.setId(this.getIntegerString(projectCalendar.getUniqueID()));
            calendar.setName(this.getString(projectCalendar.getName()));
            if (projectCalendar.getParent() != null) {
                calendar.setParent(this.getIntegerString(projectCalendar.getParent().getUniqueID()));
            }
            List<Weekday> list = calendar.getWeekday();
            Weekday weekday = this.m_factory.createWeekday();
            this.writeWeekday(projectCalendar, net.sf.mpxj.Day.MONDAY, weekday);
            list.add(weekday);
            weekday = this.m_factory.createWeekday();
            this.writeWeekday(projectCalendar, net.sf.mpxj.Day.TUESDAY, weekday);
            list.add(weekday);
            weekday = this.m_factory.createWeekday();
            this.writeWeekday(projectCalendar, net.sf.mpxj.Day.WEDNESDAY, weekday);
            list.add(weekday);
            weekday = this.m_factory.createWeekday();
            this.writeWeekday(projectCalendar, net.sf.mpxj.Day.THURSDAY, weekday);
            list.add(weekday);
            weekday = this.m_factory.createWeekday();
            this.writeWeekday(projectCalendar, net.sf.mpxj.Day.FRIDAY, weekday);
            list.add(weekday);
            weekday = this.m_factory.createWeekday();
            this.writeWeekday(projectCalendar, net.sf.mpxj.Day.SATURDAY, weekday);
            list.add(weekday);
            weekday = this.m_factory.createWeekday();
            this.writeWeekday(projectCalendar, net.sf.mpxj.Day.SUNDAY, weekday);
            list.add(weekday);
            for (ProjectCalendarException object2 : projectCalendar.getCalendarExceptions()) {
                object = object2.getFromDate();
                Date date = object2.getToDate();
                List<Day> list2 = calendar.getDay();
                while (((Date)object).getTime() == date.getTime()) {
                    System.out.println("Exception Day: " + object2);
                    Day day = this.m_factory.createDay();
                    list2.add(day);
                    day.setDate(this.getDateString(object2.getFromDate()));
                    day.setState(object2.getWorking() ? "2" : "1");
                }
            }
            for (ProjectCalendar projectCalendar2 : projectCalendar.getDerivedCalendars()) {
                if (projectCalendar2 == null) continue;
                object = this.m_factory.createCalendar();
                calendar.getCalendar().add((Calendar)object);
                this.writeCalendar(projectCalendar2, (Calendar)object);
            }
            System.out.println("writeCalendar: end " + projectCalendar.getUniqueID());
        }
        catch (Exception exception) {
            System.out.println("Calendar Exception");
            exception.printStackTrace(System.out);
        }
    }

    private void writeWeekday(ProjectCalendar projectCalendar, net.sf.mpxj.Day day, Weekday weekday) {
        int[] nArray = new int[]{-1, 6, 0, 1, 2, 3, 4, 5};
        weekday.setDayNumber(this.getIntegerString(nArray[day.getValue()]));
        weekday.setState(this.getWorkingDayString(projectCalendar, day));
        ProjectCalendarHours projectCalendarHours = projectCalendar.getHours(day);
        for (DateRange dateRange : projectCalendarHours) {
            TimeInterval timeInterval = this.m_factory.createTimeInterval();
            weekday.getTimeInterval().add(timeInterval);
            timeInterval.setStart(this.getTimeString(this.getTime(dateRange.getStart())));
            timeInterval.setLength(this.getIntegerString(dateRange.getEnd().getTime() - dateRange.getStart().getTime()));
        }
    }

    private void writeResources() {
        ResourceContainer resourceContainer = this.m_projectFile.getResources();
        if (resourceContainer.isEmpty()) {
            return;
        }
        Resources resources = this.m_factory.createResources();
        this.m_planProject.setResources(resources);
        for (int i = 0; i < resourceContainer.size(); ++i) {
            this.writeResource((net.sf.mpxj.Resource)resourceContainer.get(i), resources);
        }
    }

    private void writeResource(net.sf.mpxj.Resource resource, Resources resources) {
        String string;
        System.out.println("writeResource: " + resource);
        Resource resource2 = this.m_factory.createResource();
        resources.getResource().add(resource2);
        resource2.setId(this.getResourceId(resource));
        resource2.setEmail(resource.getEmailAddress());
        resource2.setName(this.getString(resource.getName()));
        resource2.setInitials(resource.getInitials());
        resource2.setType(resource.getType() == ResourceType.MATERIAL ? "Material" : "Work");
        resource2.setUnits("100");
        Rate rate = resource.getStandardRate();
        if (rate != null) {
            resource2.setNormalRate(Double.toString(rate.getAmount()));
        }
        if ((rate = resource.getOvertimeRate()) != null) {
            resource2.setOvertimeRate(Double.toString(rate.getAmount()));
        }
        if ((string = resource.getGroup()) != null && !string.isEmpty()) {
            System.out.println("writeResource: " + resource + " group: " + string);
            if (!this.m_groups.containsKey(string)) {
                this.m_groups.put(string, new ArrayList());
                this.m_groups.get(string).add(resource2);
                ResourceGroup resourceGroup = this.m_factory.createResourceGroup();
                this.m_resourceGroups.add(resourceGroup);
                resourceGroup.setId(string);
                resourceGroup.setName(string);
            }
            System.out.println("writeResource: " + resource + " group: " + resource.getGroup());
        }
    }

    private void writeResourceGroups() {
        System.out.println("writeResourceGroups: " + this.m_resourceGroups.size());
        if (this.m_resourceGroups.isEmpty()) {
            return;
        }
        ResourceGroups resourceGroups = this.m_factory.createResourceGroups();
        this.m_planProject.setResourceGroups(resourceGroups);
        for (int i = 0; i < this.m_resourceGroups.size(); ++i) {
            System.out.println("writeResourceGroup: " + this.m_resourceGroups.get(i).getName());
            resourceGroups.getResourceGroup().add(this.m_resourceGroups.get(i));
        }
    }

    private void writeResourceGroupRelations() {
        System.out.println("writeResourceGroupsRelations " + this.m_groups.size());
        ResourceGroupRelations resourceGroupRelations = this.m_factory.createResourceGroupRelations();
        this.m_planProject.setResourceGroupRelations(resourceGroupRelations);
        for (Map.Entry<String, List> entry : this.m_groups.entrySet()) {
            List list = entry.getValue();
            for (int i = 0; i < list.size(); ++i) {
                ResourceGroupRelation resourceGroupRelation = this.m_factory.createResourceGroupRelation();
                resourceGroupRelations.getResourceGroupRelation().add(resourceGroupRelation);
                resourceGroupRelation.setGroupId(entry.getKey());
                resourceGroupRelation.setResourceId(((Resource)list.get(i)).getId());
                System.out.println("writeResourceGroupRelation: " + resourceGroupRelation.getGroupId() + ", " + resourceGroupRelation.getResourceId());
            }
        }
    }

    private void writeTasks() {
        Tasks tasks = this.m_factory.createTasks();
        this.m_planProject.setTasks(tasks);
        for (net.sf.mpxj.Task task : this.m_projectFile.getChildTasks()) {
            Task task2 = this.m_factory.createTask();
            tasks.getTask().add(task2);
            this.writeTask(task, task2);
        }
    }

    private void writeTask(net.sf.mpxj.Task task, Task task2) {
        if (task.getName() == null && !task.hasChildTasks()) {
            System.out.println("writeTask: Task is probably a bogus task for internal use, add anyways: " + task);
        }
        task2.setId(this.getTaskId(task));
        task2.setWbs(task.getWBS());
        task2.setName(this.getString(task.getName()));
        this.setScheduling(task, task2);
        Priority priority = task.getPriority();
        System.out.println("writeTask: " + task + " prio: " + priority);
        if (priority != null) {
            task2.setPriority(this.getIntegerString(priority.getValue()));
        }
        this.writeEstimate(task, task2);
        this.writeTaskSchedules(task, task2);
        String string = task.getNotes();
        if (string != null) {
            task2.setDescription(string);
        }
        this.writeProgress(task, task2);
        for (net.sf.mpxj.Task task3 : task.getChildTasks()) {
            Task task4 = this.m_factory.createTask();
            task2.getTask().add(task4);
            this.writeTask(task3, task4);
        }
    }

    private void writeRequests() {
        ResourceRequests resourceRequests = this.m_factory.createResourceRequests();
        this.m_planProject.setResourceRequests(resourceRequests);
        for (net.sf.mpxj.Task task : this.m_projectFile.getTasks()) {
            if (task.getMilestone() || task.getSummary()) continue;
            this.writeRequests(task, resourceRequests);
        }
    }

    private void writeRequests(net.sf.mpxj.Task task, ResourceRequests resourceRequests) {
        int n = 1;
        for (ResourceAssignment resourceAssignment : task.getResourceAssignments()) {
            if (resourceAssignment.getResource() == null) continue;
            ResourceRequest resourceRequest = this.m_factory.createResourceRequest();
            resourceRequests.getResourceRequest().add(resourceRequest);
            resourceRequest.setRequestId(this.getIntegerString(n++));
            resourceRequest.setTaskId(this.getTaskId(task));
            resourceRequest.setResourceId(this.getResourceId(resourceAssignment.getResource()));
            resourceRequest.setUnits(this.getIntegerString(resourceAssignment.getUnits()));
        }
    }

    private void writeEstimate(net.sf.mpxj.Task task, Task task2) {
        if (task.getSummary()) {
            return;
        }
        Estimate estimate = this.m_factory.createEstimate();
        task2.setEstimate(estimate);
        estimate.setType(this.getEstimateType(task.getType()));
        if (task.getMilestone()) {
            estimate.setExpected("0");
            estimate.setOptimistic("0");
            estimate.setPessimistic("0");
        } else {
            Duration duration = task.getDuration();
            if (duration == null) {
                System.out.println("writeEstimate: " + task + " null duration");
                return;
            }
            if (task.getType() == TaskType.FIXED_DURATION) {
                switch (duration.getUnits()) {
                    case MINUTES: 
                    case HOURS: 
                    case DAYS: 
                    case WEEKS: 
                    case MONTHS: 
                    case YEARS: {
                        estimate.setCalendarId(this.getIntegerString(this.m_projectFile.getDefaultCalendar().getUniqueID()));
                        break;
                    }
                }
            } else {
                switch (duration.getUnits()) {
                    case ELAPSED_MINUTES: {
                        duration = duration.convertUnits(TimeUnit.MINUTES, this.m_projectFile.getProjectProperties());
                        break;
                    }
                    case ELAPSED_HOURS: {
                        duration = duration.convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectProperties());
                        break;
                    }
                    case ELAPSED_DAYS: {
                        duration = duration.convertUnits(TimeUnit.DAYS, this.m_projectFile.getProjectProperties());
                        break;
                    }
                    case ELAPSED_WEEKS: {
                        duration = duration.convertUnits(TimeUnit.WEEKS, this.m_projectFile.getProjectProperties());
                        break;
                    }
                    case ELAPSED_MONTHS: {
                        duration = duration.convertUnits(TimeUnit.MONTHS, this.m_projectFile.getProjectProperties());
                        break;
                    }
                    case ELAPSED_YEARS: {
                        duration = duration.convertUnits(TimeUnit.YEARS, this.m_projectFile.getProjectProperties());
                        break;
                    }
                }
            }
            System.out.println("writeEstimate: 2 " + task);
            estimate.setUnit(this.getUnitString(duration));
            String string = this.getEstimateString(duration);
            estimate.setExpected(string);
            estimate.setOptimistic(string);
            estimate.setPessimistic(string);
        }
    }

    private void writeProgress(net.sf.mpxj.Task task, Task task2) {
        System.out.println("writeProgress: " + task);
        if (task.getActualStart() == null) {
            Number number = task.getPercentageComplete();
            if (number == null || number.intValue() == 0) {
                return;
            }
            Progress progress = this.m_factory.createProgress();
            task2.setProgress(progress);
            progress.setStarted("1");
            Date date = task.getActualStart() == null ? task.getStart() : task.getActualStart();
            progress.setStartTime(this.getDateTimeString(date));
            if (task.getActualFinish() != null || number.intValue() == 100) {
                date = task.getActualFinish() == null ? task.getFinish() : task.getActualFinish();
                progress.setFinished("1");
                progress.setFinishTime(this.getDateTimeString(date));
            }
            CompletionEntry completionEntry = this.m_factory.createCompletionEntry();
            progress.getCompletionEntry().add(completionEntry);
            completionEntry.setDate(this.getDateTimeString(date));
            completionEntry.setPercentFinished(this.getIntegerString(number));
        } else {
            Progress progress = this.m_factory.createProgress();
            task2.setProgress(progress);
            progress.setStarted("1");
            progress.setStartTime(this.getDateTimeString(task.getActualStart()));
            if (task.getActualFinish() != null) {
                progress.setFinished("1");
                progress.setFinishTime(this.getDateTimeString(task.getActualFinish()));
            }
            this.writeCompletion(task, progress);
        }
    }

    private void writeCompletion(net.sf.mpxj.Task task, Progress progress) {
        Object object;
        progress.setEntrymode("EnterEffortPerTask");
        List<ResourceAssignment> list = task.getResourceAssignments();
        if (list.isEmpty()) {
            CompletionEntry completionEntry = this.m_factory.createCompletionEntry();
            progress.getCompletionEntry().add(completionEntry);
            Date date = task.getActualStart();
            if (task.getActualFinish() != null) {
                date = task.getActualFinish();
            }
            completionEntry.setDate(this.getDateTimeString(date));
            completionEntry.setPercentFinished(this.getIntegerString(task.getPercentageWorkComplete()));
            Duration duration = task.getActualWork();
            completionEntry.setPerformedEffort(this.getDurationString(duration));
            duration = task.getRemainingWork();
            completionEntry.setRemainingEffort(this.getDurationString(duration));
            return;
        }
        ArrayList<java.util.Calendar> arrayList = new ArrayList<java.util.Calendar>();
        ArrayList<CompletionEntry> arrayList2 = new ArrayList<CompletionEntry>();
        ArrayList<Duration> arrayList3 = new ArrayList<Duration>();
        for (ResourceAssignment object2 : list) {
            object = object2.getResource().getCalendar();
            for (TimephasedWork timephasedWork : object2.getTimephasedActualWork()) {
                java.util.Calendar calendar = this.getCalendarDate(timephasedWork.getStart());
                java.util.Calendar calendar2 = this.getCalendarDate(timephasedWork.getFinish());
                Duration duration = (Duration)timephasedWork.getAmountPerDay();
                while (!calendar.after(calendar2)) {
                    if (((ProjectCalendar)object).isWorkingDate(calendar.getTime())) {
                        int n = -1;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            if (((java.util.Calendar)arrayList.get(i)).compareTo(calendar) != 0) continue;
                            n = i;
                            break;
                        }
                        if (n >= 0) {
                            arrayList3.set(n, Duration.add((Duration)arrayList3.get(n), (Duration)timephasedWork.getAmountPerDay(), this.m_projectFile.getProjectProperties()));
                        } else {
                            arrayList.add((java.util.Calendar)calendar.clone());
                            arrayList2.add(this.m_factory.createCompletionEntry());
                            arrayList3.add((Duration)timephasedWork.getAmountPerDay());
                        }
                    }
                    calendar.add(5, 1);
                }
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            java.util.Calendar calendar = (java.util.Calendar)arrayList.get(i);
            object = (Duration)arrayList3.get(i);
            CompletionEntry completionEntry = (CompletionEntry)arrayList2.get(i);
            progress.getCompletionEntry().add(completionEntry);
            completionEntry.setDate(this.getDateTimeString(calendar.getTime()));
            completionEntry.setPerformedEffort(this.getDurationString((Duration)object));
        }
        Number number = task.getPercentageWorkComplete();
        if (number.intValue() == 0) {
            number = task.getPercentageComplete();
        }
        if (number.intValue() > 0) {
            if (arrayList2.isEmpty()) {
                arrayList2.add(this.m_factory.createCompletionEntry());
                progress.getCompletionEntry().add((CompletionEntry)arrayList2.get(0));
            }
            ((CompletionEntry)arrayList2.get(arrayList2.size() - 1)).setPercentFinished(this.getIntegerString(number));
        }
    }

    private void writeUsedEffort(net.sf.mpxj.Task task, Progress progress) {
        progress.setEntrymode("EnterEffortPerResource");
        List<ResourceAssignment> list = task.getResourceAssignments();
        if (list.isEmpty()) {
            return;
        }
        UsedEffort usedEffort = this.m_factory.createUsedEffort();
        progress.setUsedEffort(usedEffort);
        for (ResourceAssignment resourceAssignment : list) {
            net.sf.mpxj.Resource resource = resourceAssignment.getResource();
            Resource resource2 = this.m_factory.createResource();
            usedEffort.getResource().add(resource2);
            resource2.setId(this.getResourceId(resource));
            ProjectCalendar projectCalendar = resource.getCalendar();
            for (TimephasedWork timephasedWork : resourceAssignment.getTimephasedActualWork()) {
                java.util.Calendar calendar = this.getCalendarDate(timephasedWork.getStart());
                java.util.Calendar calendar2 = this.getCalendarDate(timephasedWork.getFinish());
                Duration duration = (Duration)timephasedWork.getAmountPerDay();
                while (!calendar.after(calendar2)) {
                    if (projectCalendar.isWorkingDate(calendar.getTime())) {
                        ActualEffort actualEffort = this.m_factory.createActualEffort();
                        resource2.getActualEffort().add(actualEffort);
                        actualEffort.setDate(this.getDateTimeString(calendar.getTime()));
                        actualEffort.setNormalEffort(this.getDurationString(duration));
                    } else {
                        System.out.println("writeUsedEffort: " + resourceAssignment.getResource() + "  Not working on " + calendar.getTime());
                    }
                    calendar.add(5, 1);
                }
            }
        }
    }

    private void writeTaskSchedules(net.sf.mpxj.Task task, Task task2) {
        TaskSchedules taskSchedules = this.m_factory.createTaskSchedules();
        task2.setTaskSchedules(taskSchedules);
        this.writeTaskSchedule(task, taskSchedules);
    }

    private void writeTaskSchedule(net.sf.mpxj.Task task, TaskSchedules taskSchedules) {
        TaskSchedule taskSchedule = this.m_factory.createTaskSchedule();
        taskSchedules.getTaskSchedule().add(taskSchedule);
        taskSchedule.setId("1");
        taskSchedule.setName("Plan");
        taskSchedule.setType("Expected");
        taskSchedule.setStart(this.getDateTimeString(task.getStart()));
        taskSchedule.setEnd(this.getDateTimeString(task.getFinish()));
        taskSchedule.setDuration(this.getDurationString(task.getStart(), task.getFinish()));
        taskSchedule.setEarlystart(this.getDateTimeString(task.getEarlyStart()));
        taskSchedule.setEarlyfinish(this.getDateTimeString(task.getEarlyFinish()));
        taskSchedule.setLatestart(this.getDateTimeString(task.getLateStart()));
        taskSchedule.setLatefinish(this.getDateTimeString(task.getLateFinish()));
        taskSchedule.setPositiveFloat(this.getDurationString(task.getTotalSlack()));
        taskSchedule.setFreeFloat(this.getDurationString(task.getFreeSlack()));
        taskSchedule.setNotScheduled("0");
        taskSchedule.setSchedulingConflict("0");
        taskSchedule.setResourceError("0");
        taskSchedule.setResourceOverbooked("0");
        taskSchedule.setResourceNotAvailable("0");
        taskSchedule.setInCriticalPath("0");
    }

    private void writeRelations() {
        Relations relations = this.m_factory.createRelations();
        this.m_planProject.setRelations(relations);
        for (net.sf.mpxj.Task task : this.m_projectFile.getTasks()) {
            List<net.sf.mpxj.Relation> list = task.getPredecessors();
            if (list == null) continue;
            for (net.sf.mpxj.Relation relation : list) {
                net.sf.mpxj.Task task2;
                net.sf.mpxj.Task task3 = relation.getSourceTask();
                if (task3.getName() == null || task3.getUniqueID() == 0) {
                    System.out.println("writeRelations: Bogus child task? " + task3);
                }
                if ((task2 = relation.getTargetTask()).getName() == null || task2.getUniqueID() == 0) {
                    System.out.println("writeRelations: Bogus parent task? " + task2);
                }
                Relation relation2 = this.m_factory.createRelation();
                relation2.setParentId(this.getTaskId(task2));
                relation2.setChildId(this.getTaskId(task3));
                relation2.setLag(this.getDurationString(relation.getLag()));
                relation2.setType(RELATIONSHIP_TYPES.get(relation.getType()));
                relations.getRelation().add(relation2);
            }
        }
    }

    private void writeProjectSchedules() {
        ProjectSchedules projectSchedules = this.m_factory.createProjectSchedules();
        this.m_planProject.setProjectSchedules(projectSchedules);
        this.writeScheduleManagement(projectSchedules);
    }

    private void writeScheduleManagement(ProjectSchedules projectSchedules) {
        ScheduleManagement scheduleManagement = this.m_factory.createScheduleManagement();
        projectSchedules.getScheduleManagement().add(scheduleManagement);
        scheduleManagement.setId("1");
        scheduleManagement.setName("Plan");
        this.writeProjectSchedule(scheduleManagement);
    }

    private void writeProjectSchedule(ScheduleManagement scheduleManagement) {
        ProjectSchedule projectSchedule = this.m_factory.createProjectSchedule();
        scheduleManagement.getProjectSchedule().add(projectSchedule);
        projectSchedule.setId("1");
        projectSchedule.setName("Plan");
        projectSchedule.setType("Expected");
        projectSchedule.setNotScheduled("0");
        projectSchedule.setSchedulingError("0");
        projectSchedule.setSchedulingConflict("0");
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        projectSchedule.setStart(this.getDateTimeString(projectProperties.getStartDate()));
        projectSchedule.setEnd(this.getDateTimeString(projectProperties.getFinishDate()));
        projectSchedule.setDuration(this.getDurationString(projectProperties.getDuration()));
        this.writeAppointments(projectSchedule);
    }

    private void writeAppointments(ProjectSchedule projectSchedule) {
        Date date = null;
        Date date2 = null;
        HashMap hashMap = new HashMap();
        ResourceAssignmentContainer resourceAssignmentContainer = this.m_projectFile.getResourceAssignments();
        for (int i = 0; i < resourceAssignmentContainer.size(); ++i) {
            ResourceAssignment resourceAssignment = (ResourceAssignment)resourceAssignmentContainer.get(i);
            net.sf.mpxj.Task task = resourceAssignment.getTask();
            net.sf.mpxj.Resource resource = resourceAssignment.getResource();
            if (task != null && resource != null) {
                Appointment appointment = this.m_factory.createAppointment();
                projectSchedule.getAppointment().add(appointment);
                appointment.setTaskId(this.getTaskId(task));
                appointment.setResourceId(this.getResourceId(resource));
                this.writeIntervals(appointment, resourceAssignment);
            }
            if (date == null || task.getStart().before(date)) {
                date = task.getStart();
            }
            if (date2 != null && !date2.before(task.getFinish())) continue;
            date2 = task.getFinish();
        }
        if (date == null) {
            date = this.m_projectFile.getProjectProperties().getStartDate();
        }
        if (date2 == null) {
            date2 = this.m_projectFile.getProjectProperties().getFinishDate();
        }
        projectSchedule.setStart(this.getDateTimeString(date));
        projectSchedule.setEnd(this.getDateTimeString(date2));
        projectSchedule.setDuration(this.getDurationString(date, date2));
    }

    private void writeIntervals(Appointment appointment, ResourceAssignment resourceAssignment) {
        System.out.println("writeIntervals: Assignment: " + resourceAssignment);
        if (resourceAssignment.getStart() == null) {
            System.out.println("writeIntervals: Assignment has no start time: " + resourceAssignment);
            return;
        }
        if (resourceAssignment.getFinish() == null) {
            System.out.println("writeIntervals: Assignment has no finish time " + resourceAssignment);
            return;
        }
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(resourceAssignment.getStart());
        java.util.Calendar calendar2 = java.util.Calendar.getInstance();
        calendar2.setTime(resourceAssignment.getFinish());
        ProjectCalendar projectCalendar = resourceAssignment.getCalendar();
        java.util.Calendar calendar3 = java.util.Calendar.getInstance();
        calendar3.clear();
        calendar3.set(calendar.get(1), calendar.get(2), calendar.get(5));
        while (calendar3.before(calendar2)) {
            net.sf.mpxj.Day day = net.sf.mpxj.Day.getInstance(calendar3.get(7));
            ProjectCalendarHours projectCalendarHours = projectCalendar.getHours(day);
            Boolean bl = true;
            for (DateRange dateRange : projectCalendarHours) {
                java.util.Calendar calendar4 = java.util.Calendar.getInstance();
                calendar4.setTime(this.getTime(dateRange.getStart()));
                calendar4.set(calendar3.get(1), calendar3.get(2), calendar3.get(5));
                java.util.Calendar calendar5 = java.util.Calendar.getInstance();
                calendar5.setTime(this.getTime(dateRange.getEnd()));
                calendar5.set(calendar3.get(1), calendar3.get(2), calendar3.get(5));
                if (calendar5.before(calendar4)) {
                    calendar5.add(5, 1);
                    if (!this.isMidnight(calendar5).booleanValue()) {
                        System.out.println("writeIntervals: Invalid. Range spans midnight: " + calendar4.getTime() + " - " + calendar5.getTime());
                        continue;
                    }
                }
                this.writeInterval(appointment, calendar4, calendar5, resourceAssignment.getUnits());
            }
            calendar3.add(5, 1);
        }
    }

    private void writeInterval(Appointment appointment, java.util.Calendar calendar, java.util.Calendar calendar2, Number number) {
        AppointmentInterval appointmentInterval = this.m_factory.createAppointmentInterval();
        appointment.getAppointmentInterval().add(appointmentInterval);
        appointmentInterval.setStart(this.getDateTimeString(calendar.getTime()));
        appointmentInterval.setEnd(this.getDateTimeString(calendar2.getTime()));
        appointmentInterval.setLoad(this.getIntegerString(number));
    }

    private Boolean isMidnight(java.util.Calendar calendar) {
        return calendar.get(10) == 0 || calendar.get(12) == 0 || calendar.get(13) == 0;
    }

    private Date getTime(Date date) {
        Date date2 = new Date();
        date2.setTime(0L);
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date2);
        calendar.set(10, date.getHours());
        calendar.set(12, date.getMinutes());
        calendar.set(13, date.getSeconds());
        return calendar.getTime();
    }

    private java.util.Calendar getCalendarDate(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private String getIntegerString(Number number) {
        return number == null ? null : Integer.toString(number.intValue());
    }

    private String getIntegerString(int n) {
        return Integer.toString(n);
    }

    private String getWorkingDayString(ProjectCalendar projectCalendar, net.sf.mpxj.Day day) {
        String string = null;
        switch (projectCalendar.getCalendarDayType(day)) {
            case WORKING: {
                string = "2";
                break;
            }
            case NON_WORKING: {
                string = "1";
                break;
            }
            case DEFAULT: {
                string = "0";
            }
        }
        return string;
    }

    private String getTimeString(Date date) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(this.m_twoDigitFormat.format(n));
        stringBuffer.append(':');
        stringBuffer.append(this.m_twoDigitFormat.format(n2));
        stringBuffer.append(':');
        stringBuffer.append(this.m_twoDigitFormat.format(n3));
        return stringBuffer.toString();
    }

    private String getDateString(Date date) {
        String string = "yyyy-MM-dd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    private String getDateTimeString(Date date) {
        if (date == null) {
            return new String();
        }
        String string = "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    private String getMinutesString(long l) {
        long l2 = l % 60L;
        long l3 = l / 60L;
        return Long.toString(l3) + "h" + Long.toString(l2) + "m";
    }

    private String getDurationString(long l) {
        long l2 = l % 1000L;
        long l3 = (l /= 1000L) % 60L;
        long l4 = (l /= 60L) % 60L;
        long l5 = (l /= 60L) % 24L;
        long l6 = l /= 24L;
        String string = Long.toString(l6) + " " + Long.toString(l5) + ":" + Long.toString(l4) + ":" + Long.toString(l3) + "." + Long.toString(l2);
        return string;
    }

    private String getDurationString(Date date, Date date2) {
        if (date == null || date2 == null) {
            return this.getDurationString(0L);
        }
        return this.getDurationString(date2.getTime() - date.getTime());
    }

    private String getDurationString(Duration duration) {
        double d = 0.0;
        if (duration != null) {
            switch (duration.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    d = duration.getDuration() * 60.0;
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    d = duration.getDuration() * 3600.0;
                    break;
                }
                case DAYS: {
                    double d2 = this.m_projectFile.getProjectProperties().getMinutesPerDay().doubleValue();
                    d = duration.getDuration() * (d2 * 60.0);
                    break;
                }
                case ELAPSED_DAYS: {
                    d = duration.getDuration() * 86400.0;
                    break;
                }
                case WEEKS: {
                    double d3 = this.m_projectFile.getProjectProperties().getMinutesPerWeek().doubleValue();
                    d = duration.getDuration() * (d3 * 60.0);
                    break;
                }
                case ELAPSED_WEEKS: {
                    d = duration.getDuration() * 604800.0;
                    break;
                }
                case MONTHS: {
                    double d4 = this.m_projectFile.getProjectProperties().getMinutesPerDay().doubleValue();
                    double d5 = this.m_projectFile.getProjectProperties().getDaysPerMonth().doubleValue();
                    d = duration.getDuration() * (d5 * d4 * 60.0);
                    break;
                }
                case ELAPSED_MONTHS: {
                    d = duration.getDuration() * 2592000.0;
                    break;
                }
                case YEARS: {
                    double d6 = this.m_projectFile.getProjectProperties().getMinutesPerDay().doubleValue();
                    double d7 = this.m_projectFile.getProjectProperties().getDaysPerMonth().doubleValue();
                    d = duration.getDuration() * (12.0 * d7 * d6 * 60.0);
                    break;
                }
                case ELAPSED_YEARS: {
                    d = duration.getDuration() * 3.1536E7;
                    break;
                }
            }
        }
        return this.getDurationString((long)(d * 1000.0));
    }

    private String getEstimateString(Duration duration) {
        double d = duration.getDuration();
        return "" + d;
    }

    private String getUnitString(Duration duration) {
        String string = "d";
        if (duration != null) {
            switch (duration.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    string = "m";
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    string = "h";
                    break;
                }
                case DAYS: 
                case ELAPSED_DAYS: {
                    string = "d";
                    break;
                }
                case WEEKS: 
                case ELAPSED_WEEKS: {
                    string = "w";
                    break;
                }
                case MONTHS: 
                case ELAPSED_MONTHS: {
                    string = "M";
                    break;
                }
                case YEARS: 
                case ELAPSED_YEARS: {
                    string = "Y";
                    break;
                }
            }
        }
        return string;
    }

    private String getEstimateType(TaskType taskType) {
        String string = "Effort";
        if (taskType != null && taskType == TaskType.FIXED_DURATION) {
            string = "Duration";
        }
        return string;
    }

    private String getString(String string) {
        return string == null ? "" : string;
    }

    private String getProjectId() {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        String string = projectProperties.getGUID() != null ? projectProperties.getGUID().toString() : this.getIntegerString(projectProperties.getUniqueID());
        if (string == null) {
            string = projectProperties.getProjectTitle();
        }
        return string;
    }

    private String getResourceId(net.sf.mpxj.Resource resource) {
        return resource.getGUID() == null ? this.getIntegerString(resource.getUniqueID()) : resource.getGUID().toString();
    }

    private String getTaskId(net.sf.mpxj.Task task) {
        return task.getGUID() == null ? this.getIntegerString(task.getUniqueID()) : task.getGUID().toString();
    }

    private String getScheduleFromString(ScheduleFrom scheduleFrom) {
        String string = "MustStartOn";
        if (scheduleFrom != null && scheduleFrom == ScheduleFrom.FINISH) {
            string = "MustFinishOn";
        }
        return string;
    }

    private void setScheduling(net.sf.mpxj.Task task, Task task2) {
        ConstraintType constraintType = task.getConstraintType();
        if (constraintType == null) {
            task2.setScheduling("ASAP");
        } else {
            switch (constraintType) {
                case AS_SOON_AS_POSSIBLE: {
                    task2.setScheduling("ASAP");
                    break;
                }
                case AS_LATE_AS_POSSIBLE: {
                    task2.setScheduling("ALAP");
                    break;
                }
                case MUST_START_ON: {
                    task2.setScheduling("MustStartOn");
                    task2.setConstraintStarttime(this.getDateTimeString(task.getConstraintDate()));
                    break;
                }
                case MUST_FINISH_ON: {
                    task2.setScheduling("MustFinishOn");
                    task2.setConstraintEndtime(this.getDateTimeString(task.getConstraintDate()));
                    break;
                }
                case START_NO_EARLIER_THAN: {
                    task2.setScheduling("StartNotEarlier");
                    task2.setConstraintStarttime(this.getDateTimeString(task.getConstraintDate()));
                    break;
                }
                case START_NO_LATER_THAN: {
                    task2.setScheduling("ASAP");
                    task2.setConstraintStarttime(this.getDateTimeString(task.getConstraintDate()));
                    break;
                }
                case FINISH_NO_EARLIER_THAN: {
                    task2.setScheduling("ALAP");
                    task2.setConstraintEndtime(this.getDateTimeString(task.getConstraintDate()));
                    break;
                }
                case FINISH_NO_LATER_THAN: {
                    task2.setScheduling("FinishNotLater");
                    task2.setConstraintEndtime(this.getDateTimeString(task.getConstraintDate()));
                    break;
                }
            }
        }
    }

    private Date setTime(Date date, Date date2) {
        Date date3;
        if (date == null) {
            return date;
        }
        if (date2 == null) {
            date3 = date;
        } else {
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.setTime(date2);
            calendar.set(6, 1);
            calendar.set(1, 1970);
            calendar.set(14, 0);
            Date date4 = calendar.getTime();
            String string = this.getDateString(date);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ParsePosition parsePosition = new ParsePosition(0);
            date3 = simpleDateFormat.parse(string, parsePosition);
            long l = date4.getTime();
            date3 = new Date(date3.getTime() + l);
        }
        return date3;
    }

    static {
        RELATIONSHIP_TYPES.put(RelationType.FINISH_FINISH, "Finish-Finish");
        RELATIONSHIP_TYPES.put(RelationType.FINISH_START, "Finish-Start");
        RELATIONSHIP_TYPES.put(RelationType.START_FINISH, "Finish-Start");
        RELATIONSHIP_TYPES.put(RelationType.START_START, "Start-Start");
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("plan.schema", PlanWriter.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
    }
}

