/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.tree;

import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.actions.DataKeysKt;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.packageChecker.toolwindow.ModuleWithPackage;
import com.intellij.packageChecker.toolwindow.ProjectDependencyView;
import com.intellij.packageChecker.toolwindow.controller.PackageCheckerViewService;
import com.intellij.packageChecker.toolwindow.tree.DependencyTreePanelKt;
import com.intellij.packageChecker.toolwindow.tree.VulnerableDependenciesTreeStructure;
import com.intellij.packageChecker.toolwindow.tree.filter.ShowSafeFilter;
import com.intellij.packageChecker.toolwindow.tree.nodes.DependencyNode;
import com.intellij.packageChecker.toolwindow.tree.nodes.ModuleNode;
import com.intellij.packageChecker.toolwindow.tree.nodes.RootNode;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004BI\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010,\u001a\f0)\u00a2\u0006\u0002\b*\u00a2\u0006\u0002\b+2\u0006\u0010-\u001a\u00020)H\u0003J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\rH\u0016J\u0010\u00103\u001a\u00020\r2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\rH\u0016J\u0016\u00107\u001a\b\u0018\u000108R\u00020#2\b\u00109\u001a\u0004\u0018\u00010:J\u001a\u0010;\u001a\u00020<2\n\u0010=\u001a\u000608R\u00020#2\u0006\u00109\u001a\u00020:J\u0018\u0010>\u001a\u0004\u0018\u00010:2\u0006\u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020)J\b\u0010G\u001a\u00020\rH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\f0)\u00a2\u0006\u0002\b*\u00a2\u0006\u0002\b+8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010C\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010F\u00a8\u0006H"}, d2={"Lcom/intellij/packageChecker/toolwindow/tree/DependencyTreePanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/packageChecker/toolwindow/ProjectDependencyView;", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "treeStructure", "Lcom/intellij/packageChecker/toolwindow/tree/VulnerableDependenciesTreeStructure;", "showSafeFilter", "Lcom/intellij/packageChecker/toolwindow/tree/filter/ShowSafeFilter;", "updateTreeChannel", "Lkotlinx/coroutines/channels/Channel;", "", "updatePreviewPanel", "Lkotlinx/coroutines/channels/SendChannel;", "countUpdateChannel", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/packageChecker/toolwindow/tree/VulnerableDependenciesTreeStructure;Lcom/intellij/packageChecker/toolwindow/tree/filter/ShowSafeFilter;Lkotlinx/coroutines/channels/Channel;Lkotlinx/coroutines/channels/SendChannel;Lkotlinx/coroutines/channels/SendChannel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getShowSafeFilter", "()Lcom/intellij/packageChecker/toolwindow/tree/filter/ShowSafeFilter;", "job", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "selectedPackage", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/packageChecker/toolwindow/ModuleWithPackage;", "getSelectedPackage", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "treeModel", "Lcom/intellij/ui/tree/StructureTreeModel;", "Lcom/intellij/ui/treeStructure/filtered/FilteringTreeStructure;", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "treeExpander", "Lcom/intellij/ide/DefaultTreeExpander;", "popupGroupId", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getFailedToEmitMessage", "packageCoordinates", "findModule", "Lcom/intellij/packageChecker/model/ModuleModel;", "node", "Lcom/intellij/ui/treeStructure/SimpleNode;", "dispose", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "vulnerabilityUpdate", "getVisibleNodeFor", "Lcom/intellij/ui/treeStructure/filtered/FilteringTreeStructure$FilteringNode;", "dependencyNode", "Lcom/intellij/packageChecker/toolwindow/tree/nodes/DependencyNode;", "selectTreeNode", "", "visibleNode", "getDependencyNodeByCoordinates", "moduleId", "coordinates", "_numberOfVulnerableDependencies", "Ljava/util/concurrent/atomic/AtomicInteger;", "numberOfVulnerableDependencies", "", "getNumberOfVulnerableDependencies", "()I", "updateNumberOfVulnerableDependencies", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nDependencyTreePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTreePanel.kt\ncom/intellij/packageChecker/toolwindow/tree/DependencyTreePanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n10135#2:219\n10557#2,5:220\n1617#3,9:225\n1869#3:234\n1870#3:236\n1626#3:237\n1869#3,2:238\n1#4:235\n*S KotlinDebug\n*F\n+ 1 DependencyTreePanel.kt\ncom/intellij/packageChecker/toolwindow/tree/DependencyTreePanel\n*L\n205#1:219\n205#1:220,5\n206#1:225,9\n206#1:234\n206#1:236\n206#1:237\n207#1:238,2\n206#1:235\n*E\n"})
public final class DependencyTreePanel
extends SimpleToolWindowPanel
implements Disposable,
ProjectDependencyView,
CoroutineScope {
    @NotNull
    private final Project project;
    @NotNull
    private final VulnerableDependenciesTreeStructure treeStructure;
    @NotNull
    private final ShowSafeFilter showSafeFilter;
    @NotNull
    private final Channel<Unit> updateTreeChannel;
    @NotNull
    private final SendChannel<Unit> updatePreviewPanel;
    @NotNull
    private final SendChannel<Unit> countUpdateChannel;
    @NotNull
    private final CoroutineContext job;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final MutableStateFlow<ModuleWithPackage> selectedPackage;
    @NotNull
    private final StructureTreeModel<FilteringTreeStructure> treeModel;
    @NotNull
    private final SimpleTree tree;
    @NotNull
    private final DefaultTreeExpander treeExpander;
    @NlsSafe
    @NotNull
    private final String popupGroupId;
    @NotNull
    private final AtomicInteger _numberOfVulnerableDependencies;

    public DependencyTreePanel(@NotNull Project project, @NotNull VulnerableDependenciesTreeStructure treeStructure, @NotNull ShowSafeFilter showSafeFilter, @NotNull Channel<Unit> updateTreeChannel, @NotNull SendChannel<? super Unit> updatePreviewPanel, @NotNull SendChannel<? super Unit> countUpdateChannel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)treeStructure), (String)"treeStructure");
        Intrinsics.checkNotNullParameter((Object)showSafeFilter, (String)"showSafeFilter");
        Intrinsics.checkNotNullParameter(updateTreeChannel, (String)"updateTreeChannel");
        Intrinsics.checkNotNullParameter(updatePreviewPanel, (String)"updatePreviewPanel");
        Intrinsics.checkNotNullParameter(countUpdateChannel, (String)"countUpdateChannel");
        super(false);
        this.project = project;
        this.treeStructure = treeStructure;
        this.showSafeFilter = showSafeFilter;
        this.updateTreeChannel = updateTreeChannel;
        this.updatePreviewPanel = updatePreviewPanel;
        this.countUpdateChannel = countUpdateChannel;
        this.coroutineContext = this.job = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)new CoroutineName("PackageChecker.DependencyTreePanel"));
        this.selectedPackage = StateFlowKt.MutableStateFlow(null);
        this.treeModel = new StructureTreeModel((AbstractTreeStructure)this.treeStructure, (Disposable)this);
        this.tree = new SimpleTree((TreeModel)new AsyncTreeModel((TreeModel)this.treeModel, (Disposable)this));
        this.treeExpander = new DefaultTreeExpander((JTree)this.tree);
        String string = PackageCheckerBundle.message("dependency.tree.popup.groupid", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.popupGroupId = string;
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
        this.tree.setRootVisible(false);
        this.tree.setRowHeight(JBUI.scale((int)24));
        EditSourceOnDoubleClickHandler.install$default((JTree)((JTree)this.tree), null, (int)2, null);
        EditSourceOnEnterKeyHandler.install((JTree)((JTree)this.tree));
        this.tree.putClientProperty((Object)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        FlowKt.launchIn((Flow)FlowKt.catch((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)FlowKt.flowOn((Flow)FlowKt.onEach((Flow)FlowKt.debounce((Flow)FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.updateTreeChannel)), (long)100L), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DependencyTreePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ApplicationManager.getApplication().assertIsNonDispatchThread();
                        this.this$0.treeStructure.rebuild();
                        this.this$0.treeStructure.refilter();
                        this.this$0.updateNumberOfVulnerableDependencies();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DependencyTreePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ThreadingAssertions.assertEventDispatchThread();
                        this.this$0.treeModel.invalidateAsync();
                        if (this.this$0.tree.getSelectedNode() != null) return Unit.INSTANCE;
                        this.label = 1;
                        Object object2 = this.this$0.updatePreviewPanel.send((Object)Unit.INSTANCE, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)Dispatchers.getMain())), (Function3)((Function3)new Function3<FlowCollector<? super Unit>, Throwable, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Throwable throwable = (Throwable)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        DependencyTreePanelKt.access$getLogger$p().info((Throwable)it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(FlowCollector<? super Unit> p1, Throwable p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this);
        this.tree.addTreeSelectionListener(arg_0 -> DependencyTreePanel._init_$lambda$0(this, arg_0));
        Disposer.register((Disposable)PackageCheckerViewService.Companion.getInstance(this.project), (Disposable)this);
        JComponent jComponent = this.getComponent();
        if (jComponent != null) {
            jComponent.add((Component)this.tree);
        }
        PopupHandler.installPopupMenu((JComponent)((JComponent)this.tree), (String)this.popupGroupId, (String)"ToolwindowContent");
        this.vulnerabilityUpdate();
        this._numberOfVulnerableDependencies = new AtomicInteger(0);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public ShowSafeFilter getShowSafeFilter() {
        return this.showSafeFilter;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Override
    @NotNull
    public MutableStateFlow<ModuleWithPackage> getSelectedPackage() {
        return this.selectedPackage;
    }

    @NlsSafe
    private final String getFailedToEmitMessage(String packageCoordinates) {
        Object[] objectArray = new Object[]{packageCoordinates};
        String string = PackageCheckerBundle.message("dependency.tree.failed.to.emit.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final ModuleModel findModule(SimpleNode node) {
        if (node.getParent() == null || node.getParent() instanceof RootNode) {
            return null;
        }
        if (node.getParent() != null && node.getParent() instanceof ModuleNode) {
            SimpleNode simpleNode = node.getParent();
            Intrinsics.checkNotNull((Object)simpleNode, (String)"null cannot be cast to non-null type com.intellij.packageChecker.toolwindow.tree.nodes.ModuleNode");
            return ((ModuleNode)simpleNode).getModuleModel();
        }
        SimpleNode simpleNode = node.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)simpleNode, (String)"getParent(...)");
        return this.findModule(simpleNode);
    }

    public void dispose() {
        JobKt.cancel$default((CoroutineContext)this.job, null, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void uiDataSnapshot(@NotNull DataSink sink) {
        void $this$uiDataSnapshot_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        sink.set(DependencyTreePanelKt.getDEPENDENCY_VIEW_HOLDER(), (Object)this);
        DataKey dataKey = PlatformDataKeys.TREE_EXPANDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"TREE_EXPANDER");
        sink.set(dataKey, (Object)this.treeExpander);
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        sink.set(dataKey2, (Object)this.project);
        DependencyTreePanel dependencyTreePanel = this;
        DataKey<List<Dependency>> dataKey3 = DataKeysKt.getDEPENDENCY_LIST();
        DataSink dataSink = sink;
        boolean bl = false;
        Object[] objectArray = $this$uiDataSnapshot_u24lambda_u244.tree.getSelectedNodes(DefaultMutableTreeNode.class, arg_0 -> DependencyTreePanel.uiDataSnapshot$lambda$4$lambda$2(DependencyTreePanel::uiDataSnapshot$lambda$4$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
        Object[] selectedNodes = (DefaultMutableTreeNode[])objectArray;
        List list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])selectedNodes), DependencyTreePanel::uiDataSnapshot$lambda$4$lambda$3));
        dataSink.set(dataKey3, (Object)list);
        dependencyTreePanel = this.tree.getSelectedNode();
        FilteringTreeStructure.FilteringNode filteringNode = dependencyTreePanel instanceof FilteringTreeStructure.FilteringNode ? (FilteringTreeStructure.FilteringNode)dependencyTreePanel : null;
        DataSink.Companion.uiDataSnapshot(sink, filteringNode != null ? filteringNode.getDelegate() : null);
    }

    @Override
    public void vulnerabilityUpdate() {
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DependencyTreePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DependencyTreePanel.access$getUpdateTreeChannel$p(this.this$0).send((Object)Unit.INSTANCE, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final FilteringTreeStructure.FilteringNode getVisibleNodeFor(@Nullable DependencyNode dependencyNode) {
        return ((FilteringTreeStructure)this.treeModel.getTreeStructure()).getVisibleNodeFor((Object)dependencyNode);
    }

    public final boolean selectTreeNode(@NotNull FilteringTreeStructure.FilteringNode visibleNode, @NotNull DependencyNode dependencyNode) {
        Integer selectedRow;
        Intrinsics.checkNotNullParameter((Object)visibleNode, (String)"visibleNode");
        Intrinsics.checkNotNullParameter((Object)((Object)dependencyNode), (String)"dependencyNode");
        TreePath treePath = this.tree.getPathFor((SimpleNode)visibleNode);
        this.tree.setSelectionPath(treePath);
        int[] nArray = this.tree.getSelectionRows();
        Integer n = selectedRow = nArray != null ? ArraysKt.firstOrNull((int[])nArray) : null;
        if (selectedRow == null) {
            Object[] objectArray = new Object[]{dependencyNode.getDependency().getPkg().getHumanReadableCoordinates(), ", treePath: ", treePath};
            DependencyTreePanelKt.access$getLogger$p().debug("cannot find selected row, coordinates: ", objectArray);
            return false;
        }
        this.tree.scrollRowToVisible(selectedRow.intValue());
        return true;
    }

    @Nullable
    public final DependencyNode getDependencyNodeByCoordinates(@NotNull String moduleId, @NotNull String coordinates) {
        Intrinsics.checkNotNullParameter((Object)moduleId, (String)"moduleId");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        return this.treeStructure.getDependencyNodeByCoordinates(moduleId, coordinates);
    }

    public final int getNumberOfVulnerableDependencies() {
        return this._numberOfVulnerableDependencies.get();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateNumberOfVulnerableDependencies() {
        int oldCount;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Set distinctVulnerablePackages = new LinkedHashSet();
        SimpleNode[] simpleNodeArray = this.treeStructure.getRootElement().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)simpleNodeArray, (String)"getChildren(...)");
        Object[] $this$flatMap$iv = simpleNodeArray;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            SimpleNode it = (SimpleNode)element$iv$iv;
            boolean bl = false;
            SimpleNode[] simpleNodeArray2 = it.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)simpleNodeArray2, (String)"getChildren(...)");
            Iterable list$iv$iv = ArraysKt.toList((Object[])simpleNodeArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DependencyNode it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SimpleNode it = (SimpleNode)element$iv$iv;
            boolean bl2 = false;
            FilteringTreeStructure.FilteringNode filteringNode = it instanceof FilteringTreeStructure.FilteringNode ? (FilteringTreeStructure.FilteringNode)it : null;
            Object object = filteringNode != null ? filteringNode.getDelegate() : null;
            if ((object instanceof DependencyNode ? (DependencyNode)((Object)object) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyNode it = (DependencyNode)((Object)element$iv);
            boolean bl = false;
            it.distinctVulnerablePackages(distinctVulnerablePackages);
        }
        int newCount = distinctVulnerablePackages.size();
        if (newCount != (oldCount = this._numberOfVulnerableDependencies.getAndSet(newCount))) {
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DependencyTreePanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DependencyTreePanel.access$getCountUpdateChannel$p(this.this$0).send((Object)Unit.INSTANCE, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private static final void _init_$lambda$0(DependencyTreePanel this$0, TreeSelectionEvent it) {
        DependencyNode dependencyNode;
        SimpleNode simpleNode = this$0.tree.getSelectedNode();
        FilteringTreeStructure.FilteringNode filteringNode = simpleNode instanceof FilteringTreeStructure.FilteringNode ? (FilteringTreeStructure.FilteringNode)simpleNode : null;
        Object delegate = filteringNode != null ? filteringNode.getDelegate() : null;
        DependencyNode dependencyNode2 = dependencyNode = delegate instanceof DependencyNode ? (DependencyNode)((Object)delegate) : null;
        if (dependencyNode != null) {
            BuildersKt.launch$default((CoroutineScope)this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dependencyNode, this$0, null){
                int label;
                final /* synthetic */ DependencyNode $dependencyNode;
                final /* synthetic */ DependencyTreePanel this$0;
                {
                    this.$dependencyNode = $dependencyNode;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Package selectedDependency = this.$dependencyNode.getDependency().getPkg();
                            ModuleModel selectedModule = DependencyTreePanel.access$findModule(this.this$0, (SimpleNode)this.$dependencyNode);
                            boolean bl = this.this$0.getSelectedPackage().tryEmit((Object)new ModuleWithPackage(selectedModule, selectedDependency));
                            DependencyTreePanel dependencyTreePanel = this.this$0;
                            boolean it = bl;
                            boolean bl2 = false;
                            if (!it) {
                                DependencyTreePanelKt.access$getLogger$p().warn(DependencyTreePanel.access$getFailedToEmitMessage(dependencyTreePanel, selectedDependency.getHumanReadableCoordinates()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else if ((delegate instanceof ModuleNode ? (ModuleNode)((Object)delegate) : null) != null) {
            this$0.getSelectedPackage().tryEmit(null);
        }
    }

    private static final boolean uiDataSnapshot$lambda$4$lambda$1(DefaultMutableTreeNode it) {
        Object object = it.getUserObject();
        FilteringTreeStructure.FilteringNode filteringNode = object instanceof FilteringTreeStructure.FilteringNode ? (FilteringTreeStructure.FilteringNode)object : null;
        if (filteringNode == null) {
            return false;
        }
        FilteringTreeStructure.FilteringNode filteringNode2 = filteringNode;
        return filteringNode2.getDelegate() instanceof DependencyNode;
    }

    private static final boolean uiDataSnapshot$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Dependency uiDataSnapshot$lambda$4$lambda$3(DefaultMutableTreeNode it) {
        Object object = it.getUserObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ui.treeStructure.filtered.FilteringTreeStructure.FilteringNode");
        Object object2 = ((FilteringTreeStructure.FilteringNode)object).getDelegate();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.packageChecker.toolwindow.tree.nodes.DependencyNode");
        return ((DependencyNode)((Object)object2)).getDependency();
    }

    public static final /* synthetic */ Channel access$getUpdateTreeChannel$p(DependencyTreePanel $this) {
        return $this.updateTreeChannel;
    }

    public static final /* synthetic */ SendChannel access$getCountUpdateChannel$p(DependencyTreePanel $this) {
        return $this.countUpdateChannel;
    }

    public static final /* synthetic */ ModuleModel access$findModule(DependencyTreePanel $this, SimpleNode node) {
        return $this.findModule(node);
    }

    public static final /* synthetic */ String access$getFailedToEmitMessage(DependencyTreePanel $this, String packageCoordinates) {
        return $this.getFailedToEmitMessage(packageCoordinates);
    }
}

