/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.util;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.TerminalStartupKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bJ<\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bH\u0007J&\u0010\u0015\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/util/TerminalEnvironment;", "", "<init>", "()V", "TERMINAL_EMULATOR", "", "TERM_SESSION_ID", "COLON", "setCharacterEncoding", "", "env", "", "LC_CTYPE", "setWslEnv", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "shellCommand", "", "userDefinedEnvData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "envs", "doSetWslEnv", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEnvironment.kt\norg/jetbrains/plugins/terminal/util/TerminalEnvironment\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n14#2:74\n1669#3,8:75\n774#3:83\n865#3,2:84\n1563#3:86\n1634#3,3:87\n*S KotlinDebug\n*F\n+ 1 TerminalEnvironment.kt\norg/jetbrains/plugins/terminal/util/TerminalEnvironment\n*L\n30#1:74\n66#1:75,8\n68#1:83\n68#1:84,2\n68#1:86\n68#1:87,3\n*E\n"})
public final class TerminalEnvironment {
    @NotNull
    public static final TerminalEnvironment INSTANCE = new TerminalEnvironment();
    @NotNull
    public static final String TERMINAL_EMULATOR = "TERMINAL_EMULATOR";
    @NotNull
    public static final String TERM_SESSION_ID = "TERM_SESSION_ID";
    @NotNull
    private static final String COLON = ":";
    @NotNull
    private static final String LC_CTYPE = "LC_CTYPE";

    private TerminalEnvironment() {
    }

    public final void setCharacterEncoding(@NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter(env, (String)"env");
        if (SystemInfo.isMac) {
            Charset charset;
            String charsetName = AdvancedSettings.Companion.getString("terminal.character.encoding");
            try {
                Charset charset2 = Charset.forName(charsetName);
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
                charset = charset2;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalEnvironment.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Cannot find " + charsetName + " encoding", (Throwable)e);
                charset = Charsets.UTF_8;
            }
            Charset charset3 = charset;
            env.put(LC_CTYPE, charset3.name());
        }
    }

    @JvmStatic
    public static final void setWslEnv(@NotNull EelDescriptor eelDescriptor, @NotNull List<String> shellCommand, @Nullable EnvironmentVariablesData userDefinedEnvData, @NotNull Map<String, String> envs) {
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        Intrinsics.checkNotNullParameter(shellCommand, (String)"shellCommand");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        if (EelPlatformKt.isWindows((EelOsFamily)eelDescriptor.getOsFamily()) && Intrinsics.areEqual((Object)eelDescriptor, (Object)LocalEelDescriptor.INSTANCE) && TerminalStartupKt.isWslCommand(shellCommand)) {
            INSTANCE.doSetWslEnv(userDefinedEnvData, envs);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void doSetWslEnv(@Nullable EnvironmentVariablesData userDefinedEnvData, @NotNull Map<String, String> envs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        void $this$distinctBy$iv;
        Set set;
        Iterable iterable;
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        List $this$doSetWslEnv_u24lambda_u240 = iterable = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object object = userDefinedEnvData;
        if ((object != null && (object = object.getEnvs()) != null ? object.keySet() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        $this$doSetWslEnv_u24lambda_u240.addAll(set);
        $this$doSetWslEnv_u24lambda_u240.add(TERMINAL_EMULATOR);
        $this$doSetWslEnv_u24lambda_u240.add(TERM_SESSION_ID);
        iterable = CollectionsKt.build((List)iterable);
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        Iterable list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String key$iv;
            String it2 = (String)e$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            Intrinsics.checkNotNullExpressionValue((Object)it2.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (!set$iv.add(key$iv)) continue;
            ((ArrayList)list$iv).add(e$iv);
        }
        List envNamesToPass = (List)list$iv;
        Iterable $this$filter$iv = envNamesToPass;
        boolean $i$f$filter = false;
        list$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"WSLENV"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(it + "/u");
        }
        List newItems = (List)destination$iv$iv;
        String string = envs.get("WSLENV");
        List allItems = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)(string != null ? StringsKt.removeSuffix((String)string, (CharSequence)COLON) : null)), (Iterable)newItems);
        envs.put("WSLENV", CollectionsKt.joinToString$default((Iterable)allItems, (CharSequence)COLON, null, null, (int)0, null, null, (int)62, null));
    }
}

