/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.hunspell;

import dumonts.hunspell.Hunspell;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.languagetool.rules.spelling.hunspell.HunspellDictionary;

public class DumontsHunspellDictionary
implements HunspellDictionary {
    private final Hunspell hunspell;
    private boolean closed = false;

    public DumontsHunspellDictionary(Path dictionary, Path affix) {
        try {
            this.hunspell = new Hunspell(dictionary, affix);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("Could not create hunspell instance. Please note that LanguageTool supports only 64-bit platforms (Linux, Windows, Mac) and that it requires a 64-bit JVM (Java).", e);
        }
    }

    @Override
    public boolean spell(String word) {
        if (this.closed) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        return this.hunspell.spell(word);
    }

    @Override
    public void add(String word) {
        if (this.closed) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        this.hunspell.add(word);
    }

    @Override
    public List<String> suggest(String word) {
        if (this.closed) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        return Arrays.asList(this.hunspell.suggest(word));
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.hunspell.close();
    }
}

