/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split.diff;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.editor.ChainDiffVirtualFile;
import com.intellij.diff.editor.DiffEditorViewerFileEditor;
import com.intellij.diff.editor.DiffViewerVirtualFile;
import com.intellij.diff.editor.DiffVirtualFileWithProducers;
import com.intellij.diff.editor.SimpleDiffVirtualFile;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.util.side.OnesideTextDiffViewer;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChainBackedDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.DiffPreviewProvider;
import com.intellij.openapi.vcs.changes.PreviewDiffVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.vcs.backend.split.DiffRequestChainModelHandler;
import com.intellij.platform.vcs.backend.split.diff.BackendDiffFileEditorNavigatable;
import com.intellij.platform.vcs.backend.split.diff.DiffRequestRemoteEditor;
import com.jetbrains.rd.ide.model.diffViewer.DiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.OneSideDiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.OneSideState;
import com.jetbrains.rd.ide.model.diffViewer.TwoSideDiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.TwoSideState;
import com.jetbrains.rd.util.string.IPrintable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\nH\u0002\u001a\u001a\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u000b\u0010\u0010\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0000\u00a8\u0006\u0011"}, d2={"createDiffNavigatable", "Lcom/intellij/openapi/fileEditor/FileEditorNavigatable;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/diff/editor/DiffViewerVirtualFile;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "canExtractRequestChain", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "extractRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "getDiffEditorTabName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "tabName", "intellij.platform.vcs.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendServerDiffManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendServerDiffManager.kt\ncom/intellij/platform/vcs/backend/split/diff/BackendServerDiffManagerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1#2:308\n*E\n"})
public final class BackendServerDiffManagerKt {
    @Nullable
    public static final FileEditorNavigatable createDiffNavigatable(@NotNull Project project, @NotNull DiffViewerVirtualFile file, @NotNull FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int chainIndex = 0;
        IPrintable state = null;
        FileEditor fileEditor = editor;
        if (fileEditor instanceof DiffRequestRemoteEditor) {
            DiffRequestChainModelHandler diffRequestChainModelHandler = ((DiffRequestRemoteEditor)editor).getHandler();
            if (diffRequestChainModelHandler == null || (diffRequestChainModelHandler = diffRequestChainModelHandler.getChainModel()) == null) {
                return null;
            }
            DiffRequestChainModelHandler chainModel = diffRequestChainModelHandler;
            Integer n = (Integer)chainModel.getIndex().getValueOrNull();
            if (n == null) {
                return null;
            }
            chainIndex = n;
            DiffViewerModel diffViewerModel = (DiffViewerModel)chainModel.getViewer().getValueOrNull();
            if (diffViewerModel == null) {
                return null;
            }
            DiffViewerModel viewerModel = diffViewerModel;
            DiffViewerModel diffViewerModel2 = viewerModel;
            state = diffViewerModel2 instanceof OneSideDiffViewerModel ? (IPrintable)((OneSideDiffViewerModel)viewerModel).getState().getValueOrNull() : (diffViewerModel2 instanceof TwoSideDiffViewerModel ? (IPrintable)((TwoSideDiffViewerModel)viewerModel).getState().getValueOrNull() : null);
        } else if (fileEditor instanceof DiffEditorViewerFileEditor) {
            DiffEditorViewer diffEditorViewer = ((DiffEditorViewerFileEditor)editor).getEditorViewer();
            ChangeViewDiffRequestProcessor changeViewDiffRequestProcessor = diffEditorViewer instanceof ChangeViewDiffRequestProcessor ? (ChangeViewDiffRequestProcessor)diffEditorViewer : null;
            if (changeViewDiffRequestProcessor == null) {
                return null;
            }
            ChangeViewDiffRequestProcessor processor = changeViewDiffRequestProcessor;
            Iterable iterable = processor.iterateAllChanges();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"iterateAllChanges(...)");
            chainIndex = CollectionsKt.indexOf((Iterable)iterable, (Object)processor.getCurrentChange());
            FrameDiffTool.DiffViewer diffViewer = processor.getActiveViewer();
            if (diffViewer == null) {
                return null;
            }
            FrameDiffTool.DiffViewer viewer = diffViewer;
            diffEditorViewer = viewer;
            state = diffEditorViewer instanceof OnesideTextDiffViewer ? (IPrintable)new OneSideState(((OnesideTextDiffViewer)viewer).getEditor().getCaretModel().getOffset()) : (diffEditorViewer instanceof TwosideTextDiffViewer ? (IPrintable)new TwoSideState(((TwosideTextDiffViewer)viewer).getCurrentSide().getIndex(), ((TwosideTextDiffViewer)viewer).getCurrentEditor().getCaretModel().getOffset()) : null);
        } else {
            return null;
        }
        return new BackendDiffFileEditorNavigatable(project, file, chainIndex, state);
    }

    private static final boolean canExtractRequestChain(VirtualFile file) {
        return file instanceof SimpleDiffVirtualFile || file instanceof ChainDiffVirtualFile || file instanceof DiffVirtualFileWithProducers || file instanceof PreviewDiffVirtualFile;
    }

    private static final DiffRequestChain extractRequestChain(VirtualFile file) {
        Object object;
        VirtualFile virtualFile = file;
        if (virtualFile instanceof SimpleDiffVirtualFile) {
            object = (DiffRequestChain)new SimpleDiffRequestChain(((SimpleDiffVirtualFile)file).getRequest());
        } else if (virtualFile instanceof ChainDiffVirtualFile) {
            object = ((ChainDiffVirtualFile)file).getChain();
        } else if (virtualFile instanceof DiffVirtualFileWithProducers) {
            SimpleDiffRequestChain simpleDiffRequestChain;
            ListSelection listSelection = ((DiffVirtualFileWithProducers)file).collectDiffProducers(false);
            if (listSelection != null) {
                ListSelection it = listSelection;
                boolean bl = false;
                simpleDiffRequestChain = SimpleDiffRequestChain.fromProducers((ListSelection)it);
            } else {
                simpleDiffRequestChain = null;
            }
            object = (DiffRequestChain)simpleDiffRequestChain;
        } else if (virtualFile instanceof PreviewDiffVirtualFile) {
            DiffPreviewProvider diffPreviewProvider = ((PreviewDiffVirtualFile)file).getProvider();
            ChainBackedDiffPreviewProvider chainBackedDiffPreviewProvider = diffPreviewProvider instanceof ChainBackedDiffPreviewProvider ? (ChainBackedDiffPreviewProvider)diffPreviewProvider : null;
            object = chainBackedDiffPreviewProvider != null ? chainBackedDiffPreviewProvider.createDiffRequestChain() : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public static final String getDiffEditorTabName(@NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        int maxLength = 30;
        if (tabName.length() < maxLength) {
            return tabName;
        }
        int index = StringsKt.indexOf$default((CharSequence)tabName, (char)' ', (int)0, (boolean)false, (int)6, null);
        boolean bl = 1 <= index ? index < maxLength : false;
        if (bl) {
            String string = tabName.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        String string = StringUtil.shortenTextWithEllipsis((String)tabName, (int)maxLength, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        return string;
    }

    public static final /* synthetic */ boolean access$canExtractRequestChain(VirtualFile file) {
        return BackendServerDiffManagerKt.canExtractRequestChain(file);
    }

    public static final /* synthetic */ DiffRequestChain access$extractRequestChain(VirtualFile file) {
        return BackendServerDiffManagerKt.extractRequestChain(file);
    }
}

