module.exports = grammar({
  name: "csv",

  rules: {
    csv: ($) => repeat($.row),

    row: ($) =>
      seq(
        repeat(
          choice(
            $.cycle7,
            $.cycle6,
            $.cycle5,
            $.cycle4,
            $.cycle3,
            $.cycle2,
            $.cycle,
          ),
        ),
        $.remainder,
        "\n",
      ),

    cycle: ($) => seq($.first),
    cycle2: ($) => seq($.first, choice(",", ";", "|"), $.second),
    cycle3: ($) =>
      seq(
        $.first,
        choice(",", ";", "|"),
        $.second,
        choice(",", ";", "|"),
        $.third,
      ),
    cycle4: ($) =>
      seq(
        $.first,
        choice(",", ";", "|"),
        $.second,
        choice(",", ";", "|"),
        $.third,
        choice(",", ";", "|"),
        $.fourth,
      ),
    cycle5: ($) =>
      seq(
        $.first,
        choice(",", ";", "|"),
        $.second,
        choice(",", ";", "|"),
        $.third,
        choice(",", ";", "|"),
        $.fourth,
        choice(",", ";", "|"),
        $.fifth,
      ),
    cycle6: ($) =>
      seq(
        $.first,
        choice(",", ";", "|"),
        $.second,
        choice(",", ";", "|"),
        $.third,
        choice(",", ";", "|"),
        $.fourth,
        choice(",", ";", "|"),
        $.fifth,
        choice(",", ";", "|"),
        $.sixth,
      ),
    cycle7: ($) =>
      seq(
        $.first,
        choice(",", ";", "|"),
        $.second,
        choice(",", ";", "|"),
        $.third,
        choice(",", ";", "|"),
        $.fourth,
        choice(",", ";", "|"),
        $.fifth,
        choice(",", ";", "|"),
        $.sixth,
        choice(",", ";", "|"),
        $.seventh,
      ),

    remainder: ($) =>
      choice(
        $.first,
        seq($.first, choice(",", ";", "|"), $.second),
        seq(
          $.first,
          choice(",", ";", "|"),
          $.second,
          choice(",", ";", "|"),
          $.third,
        ),
        seq(
          $.first,
          choice(",", ";", "|"),
          $.second,
          choice(",", ";", "|"),
          $.third,
          choice(",", ";", "|"),
          $.fourth,
        ),
        seq(
          $.first,
          choice(",", ";", "|"),
          $.second,
          choice(",", ";", "|"),
          $.third,
          choice(",", ";", "|"),
          $.fourth,
          choice(",", ";", "|"),
          $.fifth,
        ),
        seq(
          $.first,
          choice(",", ";", "|"),
          $.second,
          choice(",", ";", "|"),
          $.third,
          choice(",", ";", "|"),
          $.fourth,
          choice(",", ";", "|"),
          $.fifth,
          choice(",", ";", "|"),
          $.sixth,
        ),
        seq(
          $.first,
          choice(",", ";", "|"),
          $.second,
          choice(",", ";", "|"),
          $.third,
          choice(",", ";", "|"),
          $.fourth,
          choice(",", ";", "|"),
          $.fifth,
          choice(",", ";", "|"),
          $.sixth,
          choice(",", ";", "|"),
          $.seventh,
        ),
      ),

    // first, second, third and other define
    first: ($) => choice(/"[^"]*"/, /[^,;|\n\r]+/),
    second: ($) => choice(/"[^"]*"/, /[^,;|\n\r]+/),
    third: ($) => choice(/"[^"]*"/, /[^,;|\n\r]+/),
    fourth: ($) => choice(/"[^"]*"/, /[^,;|\n\r]+/),
    fifth: ($) => choice(/"[^"]*"/, /[^,;|\n\r]+/),
    sixth: ($) => choice(/"[^"]*"/, /[^,;|\n\r]+/),
    seventh: ($) => choice(/"[^"]*"/, /[^,;|\n\r]+/),
  },
});
