﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codepipeline/model/Condition.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CodePipeline {
namespace Model {

Condition::Condition(JsonView jsonValue) { *this = jsonValue; }

Condition& Condition::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("result")) {
    m_result = ResultMapper::GetResultForName(jsonValue.GetString("result"));
    m_resultHasBeenSet = true;
  }
  if (jsonValue.ValueExists("rules")) {
    Aws::Utils::Array<JsonView> rulesJsonList = jsonValue.GetArray("rules");
    for (unsigned rulesIndex = 0; rulesIndex < rulesJsonList.GetLength(); ++rulesIndex) {
      m_rules.push_back(rulesJsonList[rulesIndex].AsObject());
    }
    m_rulesHasBeenSet = true;
  }
  return *this;
}

JsonValue Condition::Jsonize() const {
  JsonValue payload;

  if (m_resultHasBeenSet) {
    payload.WithString("result", ResultMapper::GetNameForResult(m_result));
  }

  if (m_rulesHasBeenSet) {
    Aws::Utils::Array<JsonValue> rulesJsonList(m_rules.size());
    for (unsigned rulesIndex = 0; rulesIndex < rulesJsonList.GetLength(); ++rulesIndex) {
      rulesJsonList[rulesIndex].AsObject(m_rules[rulesIndex].Jsonize());
    }
    payload.WithArray("rules", std::move(rulesJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace CodePipeline
}  // namespace Aws
