﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudhsmv2/model/RestoreBackupRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CloudHSMV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String RestoreBackupRequest::SerializePayload() const {
  JsonValue payload;

  if (m_backupIdHasBeenSet) {
    payload.WithString("BackupId", m_backupId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection RestoreBackupRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "BaldrApiService.RestoreBackup"));
  return headers;
}
