/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.SessionKey;

public class OpenPgpMetadata {
    private final Set<Long> recipientKeyIds;
    private final SubkeyIdentifier decryptionKey;
    private final List<SignatureVerification> verifiedInbandSignatures;
    private final List<SignatureVerification.Failure> invalidInbandSignatures;
    private final List<SignatureVerification> verifiedDetachedSignatures;
    private final List<SignatureVerification.Failure> invalidDetachedSignatures;
    private final SessionKey sessionKey;
    private final CompressionAlgorithm compressionAlgorithm;
    private final String fileName;
    private final Date modificationDate;
    private final StreamEncoding fileEncoding;
    private final boolean cleartextSigned;

    public OpenPgpMetadata(Set<Long> recipientKeyIds, SubkeyIdentifier decryptionKey, SessionKey sessionKey, CompressionAlgorithm algorithm, List<SignatureVerification> verifiedInbandSignatures, List<SignatureVerification.Failure> invalidInbandSignatures, List<SignatureVerification> verifiedDetachedSignatures, List<SignatureVerification.Failure> invalidDetachedSignatures, String fileName, Date modificationDate, StreamEncoding fileEncoding, boolean cleartextSigned) {
        this.recipientKeyIds = Collections.unmodifiableSet(recipientKeyIds);
        this.decryptionKey = decryptionKey;
        this.sessionKey = sessionKey;
        this.compressionAlgorithm = algorithm;
        this.verifiedInbandSignatures = Collections.unmodifiableList(verifiedInbandSignatures);
        this.invalidInbandSignatures = Collections.unmodifiableList(invalidInbandSignatures);
        this.verifiedDetachedSignatures = Collections.unmodifiableList(verifiedDetachedSignatures);
        this.invalidDetachedSignatures = Collections.unmodifiableList(invalidDetachedSignatures);
        this.fileName = fileName;
        this.modificationDate = modificationDate;
        this.fileEncoding = fileEncoding;
        this.cleartextSigned = cleartextSigned;
    }

    @Nonnull
    public Set<Long> getRecipientKeyIds() {
        return this.recipientKeyIds;
    }

    public boolean isEncrypted() {
        return this.sessionKey != null && this.sessionKey.getAlgorithm() != SymmetricKeyAlgorithm.NULL;
    }

    @Nullable
    public SubkeyIdentifier getDecryptionKey() {
        return this.decryptionKey;
    }

    @Nullable
    public SymmetricKeyAlgorithm getSymmetricKeyAlgorithm() {
        return this.sessionKey == null ? null : this.sessionKey.getAlgorithm();
    }

    @Nullable
    public SessionKey getSessionKey() {
        return this.sessionKey;
    }

    @Nullable
    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @Nonnull
    public Set<PGPSignature> getSignatures() {
        HashSet<PGPSignature> signatures = new HashSet<PGPSignature>();
        for (SignatureVerification v : this.getVerifiedDetachedSignatures()) {
            signatures.add(v.getSignature());
        }
        for (SignatureVerification v : this.getVerifiedInbandSignatures()) {
            signatures.add(v.getSignature());
        }
        for (SignatureVerification.Failure f : this.getInvalidDetachedSignatures()) {
            signatures.add(f.getSignatureVerification().getSignature());
        }
        for (SignatureVerification.Failure f : this.getInvalidInbandSignatures()) {
            signatures.add(f.getSignatureVerification().getSignature());
        }
        return signatures;
    }

    public boolean isSigned() {
        return !this.getSignatures().isEmpty();
    }

    public Map<SubkeyIdentifier, PGPSignature> getVerifiedSignatures() {
        ConcurrentHashMap<SubkeyIdentifier, PGPSignature> verifiedSignatures = new ConcurrentHashMap<SubkeyIdentifier, PGPSignature>();
        for (SignatureVerification detachedSignature : this.getVerifiedDetachedSignatures()) {
            verifiedSignatures.put(detachedSignature.getSigningKey(), detachedSignature.getSignature());
        }
        for (SignatureVerification inbandSignatures : this.verifiedInbandSignatures) {
            verifiedSignatures.put(inbandSignatures.getSigningKey(), inbandSignatures.getSignature());
        }
        return verifiedSignatures;
    }

    public List<SignatureVerification> getVerifiedInbandSignatures() {
        return this.verifiedInbandSignatures;
    }

    public List<SignatureVerification> getVerifiedDetachedSignatures() {
        return this.verifiedDetachedSignatures;
    }

    public List<SignatureVerification.Failure> getInvalidInbandSignatures() {
        return this.invalidInbandSignatures;
    }

    public List<SignatureVerification.Failure> getInvalidDetachedSignatures() {
        return this.invalidDetachedSignatures;
    }

    public boolean isVerified() {
        return !this.getVerifiedSignatures().isEmpty();
    }

    public boolean containsVerifiedSignatureFrom(PGPPublicKeyRing certificate) {
        for (PGPPublicKey key : certificate) {
            OpenPgpFingerprint fingerprint = OpenPgpFingerprint.of(key);
            if (!this.containsVerifiedSignatureFrom(fingerprint)) continue;
            return true;
        }
        return false;
    }

    public boolean containsVerifiedSignatureFrom(OpenPgpFingerprint fingerprint) {
        for (SubkeyIdentifier verifiedSigningKey : this.getVerifiedSignatures().keySet()) {
            if (!verifiedSigningKey.getPrimaryKeyFingerprint().equals(fingerprint) && !verifiedSigningKey.getSubkeyFingerprint().equals(fingerprint)) continue;
            return true;
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isForYourEyesOnly() {
        return "_CONSOLE".equals(this.getFileName());
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public StreamEncoding getFileEncoding() {
        return this.fileEncoding;
    }

    public boolean isCleartextSigned() {
        return this.cleartextSigned;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Long> recipientFingerprints = new HashSet<Long>();
        private SessionKey sessionKey;
        private SubkeyIdentifier decryptionKey;
        private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
        private String fileName;
        private StreamEncoding fileEncoding;
        private Date modificationDate;
        private boolean cleartextSigned = false;
        private final List<SignatureVerification> verifiedInbandSignatures = new ArrayList<SignatureVerification>();
        private final List<SignatureVerification> verifiedDetachedSignatures = new ArrayList<SignatureVerification>();
        private final List<SignatureVerification.Failure> invalidInbandSignatures = new ArrayList<SignatureVerification.Failure>();
        private final List<SignatureVerification.Failure> invalidDetachedSignatures = new ArrayList<SignatureVerification.Failure>();

        public Builder addRecipientKeyId(Long keyId) {
            this.recipientFingerprints.add(keyId);
            return this;
        }

        public Builder setDecryptionKey(SubkeyIdentifier decryptionKey) {
            this.decryptionKey = decryptionKey;
            return this;
        }

        public Builder setSessionKey(SessionKey sessionKey) {
            this.sessionKey = sessionKey;
            return this;
        }

        public Builder setCompressionAlgorithm(CompressionAlgorithm algorithm) {
            this.compressionAlgorithm = algorithm;
            return this;
        }

        public Builder setFileName(@Nullable String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setModificationDate(Date modificationDate) {
            this.modificationDate = modificationDate;
            return this;
        }

        public Builder setFileEncoding(StreamEncoding encoding) {
            this.fileEncoding = encoding;
            return this;
        }

        public Builder addVerifiedInbandSignature(SignatureVerification signatureVerification) {
            this.verifiedInbandSignatures.add(signatureVerification);
            return this;
        }

        public Builder addVerifiedDetachedSignature(SignatureVerification signatureVerification) {
            this.verifiedDetachedSignatures.add(signatureVerification);
            return this;
        }

        public Builder addInvalidInbandSignature(SignatureVerification signatureVerification, SignatureValidationException e) {
            this.invalidInbandSignatures.add(new SignatureVerification.Failure(signatureVerification, e));
            return this;
        }

        public Builder addInvalidDetachedSignature(SignatureVerification signatureVerification, SignatureValidationException e) {
            this.invalidDetachedSignatures.add(new SignatureVerification.Failure(signatureVerification, e));
            return this;
        }

        public Builder setCleartextSigned() {
            this.cleartextSigned = true;
            return this;
        }

        public OpenPgpMetadata build() {
            return new OpenPgpMetadata(this.recipientFingerprints, this.decryptionKey, this.sessionKey, this.compressionAlgorithm, this.verifiedInbandSignatures, this.invalidInbandSignatures, this.verifiedDetachedSignatures, this.invalidDetachedSignatures, this.fileName, this.modificationDate, this.fileEncoding, this.cleartextSigned);
        }
    }
}

