/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Date;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.pgpainless.algorithm.RevocationStateType;
import org.pgpainless.util.DateUtil;

public final class RevocationState
implements Comparable<RevocationState> {
    private final RevocationStateType type;
    private final Date date;

    private RevocationState(RevocationStateType type) {
        this(type, null);
    }

    private RevocationState(RevocationStateType type, Date date) {
        this.type = type;
        if (type == RevocationStateType.softRevoked && date == null) {
            throw new NullPointerException("If type is 'softRevoked' then date cannot be null.");
        }
        this.date = date;
    }

    public static RevocationState notRevoked() {
        return new RevocationState(RevocationStateType.notRevoked);
    }

    public static RevocationState softRevoked(@Nonnull Date date) {
        return new RevocationState(RevocationStateType.softRevoked, date);
    }

    public static RevocationState hardRevoked() {
        return new RevocationState(RevocationStateType.hardRevoked);
    }

    public RevocationStateType getType() {
        return this.type;
    }

    @Nonnull
    public Date getDate() {
        if (!this.isSoftRevocation()) {
            throw new NoSuchElementException("RevocationStateType is not equal to 'softRevoked'. Cannot extract date.");
        }
        return this.date;
    }

    public boolean isHardRevocation() {
        return this.getType() == RevocationStateType.hardRevoked;
    }

    public boolean isSoftRevocation() {
        return this.getType() == RevocationStateType.softRevoked;
    }

    public boolean isNotRevoked() {
        return this.getType() == RevocationStateType.notRevoked;
    }

    public String toString() {
        String out = this.getType().toString();
        if (this.isSoftRevocation()) {
            out = out + " (" + DateUtil.formatUTCDate(this.date) + ")";
        }
        return out;
    }

    @Override
    public int compareTo(@Nonnull RevocationState o) {
        switch (this.getType()) {
            case notRevoked: {
                if (o.isNotRevoked()) {
                    return 0;
                }
                return -1;
            }
            case softRevoked: {
                if (o.isNotRevoked()) {
                    return 1;
                }
                if (o.isSoftRevocation()) {
                    return o.getDate().compareTo(this.getDate());
                }
                return -1;
            }
            case hardRevoked: {
                if (o.isHardRevocation()) {
                    return 0;
                }
                return 1;
            }
        }
        throw new AssertionError((Object)("Unknown type: " + (Object)((Object)this.type)));
    }

    public int hashCode() {
        return this.type.hashCode() * 31 + (this.isSoftRevocation() ? this.getDate().hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RevocationState)) {
            return false;
        }
        RevocationState other = (RevocationState)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.isSoftRevocation()) {
            return DateUtil.toSecondsPrecision(this.getDate()).getTime() == DateUtil.toSecondsPrecision(other.getDate()).getTime();
        }
        return true;
    }
}

