/*
 * Decompiled with CFR 0.152.
 */
package geny;

import geny.Internal$;
import geny.Readable;
import geny.Writable$;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public interface Writable {
    public static ByteArrayWritable ByteArrayWritable(byte[] byArray) {
        return Writable$.MODULE$.ByteArrayWritable(byArray);
    }

    public static ByteBufferWritable ByteBufferWritable(ByteBuffer byteBuffer) {
        return Writable$.MODULE$.ByteBufferWritable(byteBuffer);
    }

    public static StringWritable StringWritable(String string2) {
        return Writable$.MODULE$.StringWritable(string2);
    }

    public static <T> Writable readableWritable(T t, Function1<T, Readable> function1) {
        return Writable$.MODULE$.readableWritable((Object)t, (Function1)function1);
    }

    public void writeBytesTo(OutputStream var1);

    public static Option httpContentType$(Writable $this) {
        return $this.httpContentType();
    }

    default public Option<String> httpContentType() {
        return None$.MODULE$;
    }

    public static Option contentLength$(Writable $this) {
        return $this.contentLength();
    }

    default public Option<Object> contentLength() {
        return None$.MODULE$;
    }

    public static class ByteArrayWritable
    implements Writable {
        private final byte[] a;

        public ByteArrayWritable(byte[] a) {
            this.a = a;
        }

        @Override
        public void writeBytesTo(OutputStream out) {
            out.write(this.a);
        }

        @Override
        public Option<String> httpContentType() {
            return Some$.MODULE$.apply("application/octet-stream");
        }

        @Override
        public Option<Object> contentLength() {
            return Some$.MODULE$.apply(BoxesRunTime.boxToLong(Int$.MODULE$.int2long(this.a.length)));
        }
    }

    public static class ByteBufferWritable
    implements Writable {
        private final ByteBuffer buffer;

        public ByteBufferWritable(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void writeBytesTo(OutputStream out) {
            int l;
            ByteBuffer bb = this.buffer.duplicate().order(this.buffer.order());
            byte[] tmp = new byte[8192];
            int length = bb.remaining();
            for (int count = 0; count < length; count += l) {
                Object object = Predef$.MODULE$.byteArrayOps(tmp);
                l = package$.MODULE$.min(ArrayOps$.MODULE$.size$extension(object), length - count);
                bb.get(tmp, 0, l);
                out.write(tmp, 0, l);
            }
        }

        @Override
        public Option<String> httpContentType() {
            return Some$.MODULE$.apply("application/octet-stream");
        }

        @Override
        public Option<Object> contentLength() {
            return Some$.MODULE$.apply(BoxesRunTime.boxToLong(Int$.MODULE$.int2long(this.buffer.remaining())));
        }
    }

    public static class StringWritable
    implements Writable {
        private final String s;

        public StringWritable(String s) {
            this.s = s;
        }

        @Override
        public void writeBytesTo(OutputStream out) {
            StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(this.s), 8192).foreach(ss -> out.write(ss.getBytes(StandardCharsets.UTF_8)));
        }

        @Override
        public Option<String> httpContentType() {
            return Some$.MODULE$.apply("text/plain; charset=utf-8");
        }

        @Override
        public Option<Object> contentLength() {
            return Some$.MODULE$.apply(BoxesRunTime.boxToLong(Int$.MODULE$.int2long(Internal$.MODULE$.encodedLength(this.s))));
        }
    }
}

