/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file defines the globals used for various files across the tree.
 *
 * Generally, most globals should be automatically set up. If you think you are
 * missing some globals, and they are in one of the defined sections, you can
 * generally add the file here.
 *
 * However, please use the defined patterns as follows:
 *
 * - ES modules should always use `.mjs` extensions.
 * - System modules (accessed from privileged scope) should use `.sys.mjs`.
 * - Workers should use `<name>.worker.js` or `<name>.worker.mjs`.
 *
 * Please also note the patters for tests - see the top of `.eslintrc-test-paths.js`.
 *
 */

import globals from "globals";
import mozilla from "eslint-plugin-mozilla";

export default [
  {
    name: "globals-amd",
    files: ["devtools/shared/worker/helper.js"],
    languageOptions: { globals: globals.amd },
  },
  {
    name: "globals-browser",
    files: [
      "devtools/client/aboutdebugging/test/browser/head.js",
      "devtools/client/aboutdebugging/test/browser/resources/test-temporary-extension/script.js",
      "devtools/client/application/test/browser/head.js",
      "devtools/client/framework/toolbox-init.js",
      "devtools/client/memory/components/tree-map/canvas-utils.js",
      "devtools/client/responsive/actions/screenshot.js",
      "devtools/client/responsive/actions/viewports.js",
      "devtools/client/responsive/components/App.js",
      "devtools/client/responsive/components/Device.js",
      "devtools/client/responsive/components/DeviceAdder.js",
      "devtools/client/responsive/components/DeviceForm.js",
      "devtools/client/responsive/components/DeviceList.js",
      "devtools/client/responsive/components/DeviceModal.js",
      "devtools/client/responsive/components/DevicePixelRatioMenu.js",
      "devtools/client/responsive/index.js",
      "devtools/client/shared/components/HSplitBox.js",
      "devtools/client/shared/components/menu/MenuButton.js",
      "devtools/client/shared/components/menu/MenuItem.js",
      "devtools/client/shared/components/menu/MenuList.js",
      "devtools/client/shared/components/tabs/TabBar.js",
      "devtools/client/shared/components/VirtualizedTree.js",
      "devtools/client/shared/stylesheet-utils.js",
      "devtools/client/shared/theme-switching.js",
      "devtools/client/shared/vendor/fluent-react.js",
      "devtools/startup/tests/browser/browser_command_line_urls.js",
      "devtools/startup/tests/browser/browser_shim_disable_devtools.js",
    ],
    languageOptions: { globals: globals.browser },
  },
  {
    name: "globals-commonjs",
    files: [
      "browser/components/uitour/UITour-lib.js",
      "mobile/shared/modules/dbg-browser-actors.js",
      "toolkit/components/promiseworker/worker/PromiseWorker.template.worker.js",
      "toolkit/components/workerloader/tests/moduleA-depends.js",
      "toolkit/components/workerloader/tests/moduleB-dependency.js",
      "toolkit/components/workerloader/tests/moduleC-circular.js",
      "toolkit/components/workerloader/tests/moduleD-circular.js",
      "toolkit/components/workerloader/tests/moduleE-throws-during-require.js",
      "toolkit/components/workerloader/tests/moduleG-throws-later.js",
      "toolkit/components/workerloader/tests/moduleH-module-dot-exports.js",
      "toolkit/components/workerloader/tests/moduleI-depends.js",
      "toolkit/components/workerloader/tests/moduleJ-dependency.js",
    ],
    languageOptions: { globals: globals.commonjs },
  },
  {
    name: "globals-jest",
    files: ["tools/ts/test/dom.test.js", "tools/ts/test/xpcom.test.js"],
    languageOptions: { globals: globals.jest },
  },
  {
    name: "globals-browser-window",
    files: [
      "browser/actors/ScreenshotsComponentChild.sys.mjs",
      "browser/base/content/browser-a11yUtils.js",
      "browser/base/content/browser-addons.js",
      "browser/base/content/browser-commands.js",
      "browser/base/content/browser-context.js",
      "browser/base/content/browser-customization.js",
      "browser/base/content/browser-fullScreenAndPointerLock.js",
      "browser/base/content/browser-gestureSupport.js",
      "browser/base/content/browser-graphics-utils.js",
      "browser/base/content/browser-main.js",
      "browser/base/content/browser-menubar.js",
      "browser/base/content/browser-pagestyle.js",
      "browser/base/content/browser-places.js",
      "browser/base/content/browser-profiles.js",
      "browser/base/content/browser-safebrowsing.js",
      "browser/base/content/browser-siteIdentity.js",
      "browser/base/content/browser-sitePermissionPanel.js",
      "browser/base/content/browser-siteProtections.js",
      "browser/base/content/browser-sync.js",
      "browser/base/content/browser-thumbnails.js",
      "browser/base/content/browser-toolbarKeyNav.js",
      "browser/base/content/browser-unified-extensions.js",
      "browser/base/content/browser-webrtc.js",
      "browser/base/content/global-scripts.js",
      "browser/base/content/main-popupset.js",
      "browser/base/content/navigator-toolbox.js",
      "browser/base/content/nonbrowser-mac.js",
      "browser/components/downloads/content/allDownloadsView.js",
      "browser/components/downloads/content/downloads.js",
      "browser/components/downloads/content/indicator.js",
      "browser/components/places/content/browserPlacesViews.js",
      "browser/components/places/content/places-commands.js",
      "browser/components/places/content/places-menupopup.js",
      "browser/components/places/content/placesContextMenu.js",
      "browser/components/pocket/content/pktUI.js",
      "browser/components/screenshots/screenshots-buttons.js",
      "browser/components/tabbrowser/content/browser-allTabsMenu.js",
      "browser/components/tabbrowser/content/browser-ctrlTab.js",
      "browser/components/tabbrowser/content/browser-fullZoom.js",
      "browser/components/tabbrowser/content/tabbrowser.js",
      "browser/components/tabbrowser/content/tabs.js",
      "browser/components/translations/content/fullPageTranslationsPanel.js",
      "browser/components/translations/content/selectTranslationsPanel.js",
      "browser/fxr/content/fxr-fullScreen.js",
      "testing/mochitest/browser-test.js",
      "toolkit/components/printing/content/printPreviewPagination.js",
      "toolkit/components/printing/content/printUtils.js",
    ],
    languageOptions: {
      globals: mozilla.environments["browser-window"].globals,
    },
  },
  {
    name: "globals-chrome-script",
    files: [
      "browser/extensions/formautofill/test/mochitest/formautofill_parent_utils.js",
      "browser/tools/mozscreenshots/mozscreenshots/extension/configurations/PermissionPrompts.sys.mjs",
      "docshell/test/mochitest/test_bug509055.html",
      "docshell/test/navigation/test_bug1300461.html",
      "docshell/test/navigation/test_bug1375833.html",
      "docshell/test/navigation/test_online_offline_bfcache.html",
      "docshell/test/navigation/test_online_offline_bfcache.html",
      "dom/base/test/bug403852_fileOpener.js",
      "dom/base/test/bug578096LoadChromeScript.js",
      "dom/base/test/file_bug1198095.js",
      "dom/base/test/script_bug1238440.js",
      "dom/base/test/script_postmessages_fileList.js",
      "dom/base/test/test_bug375314-2.html",
      "dom/base/test/test_input_vsync_alignment_input_while_vsync.html",
      "dom/events/test/file_coalesce_touchmove_browserchild.html",
      "dom/events/test/file_coalesce_touchmove_browserchild2.html",
      "dom/events/test/file_coalesce_touchmove_browserchild2.html",
      "dom/events/test/file_coalesce_touchmove_browserchild2.html",
      "dom/events/test/file_coalesce_touchmove_ipc.html",
      "dom/events/test/file_coalesce_touchmove_ipc.html",
      "dom/events/test/file_coalesce_touchmove_ipc.html",
      "dom/events/test/test_bug574663.html",
      "dom/events/test/window_wheel_default_action.html",
      "dom/file/ipc/tests/script_file.js",
      "dom/file/tests/create_file_objects.js",
      "dom/file/tests/fileapi_chromeScript.js",
      "dom/filesystem/compat/tests/script_entries.js",
      "dom/filesystem/tests/script_fileList.js",
      "dom/filesystem/tests/script_promptHandler.js",
      "dom/html/test/file_cookiemanager.js",
      "dom/html/test/formSubmission_chrome.js",
      "dom/html/test/script_fakepath.js",
      "dom/html/test/simpleFileOpener.js",
      "dom/ipc/tests/test_Preallocated.html",
      "dom/media/autoplay/test/mochitest/file_autoplay_policy_key_blacklist.html",
      "dom/media/test/chromeHelper.js",
      "dom/media/webrtc/tests/mochitests/addTurnsSelfsignedCert.js",
      "dom/notification/test/mochitest/MockAlertsService.js",
      "dom/notification/test/mochitest/test_notification_insecure_context.html",
      "dom/notification/test/mochitest/test_notification_tag.html",
      "dom/payments/test/BasiccardChromeScript.js",
      "dom/payments/test/BasicCardErrorsChromeScript.js",
      "dom/payments/test/Bug1478740ChromeScript.js",
      "dom/payments/test/Bug1490698ChromeScript.js",
      "dom/payments/test/ClosePaymentChromeScript.js",
      "dom/payments/test/ConstructorChromeScript.js",
      "dom/payments/test/CurrencyAmountValidationChromeScript.js",
      "dom/payments/test/GeneralChromeScript.js",
      "dom/payments/test/PayerDetailsChromeScript.js",
      "dom/payments/test/PMIValidationChromeScript.js",
      "dom/payments/test/RequestShippingChromeScript.js",
      "dom/payments/test/RetryPaymentChromeScript.js",
      "dom/payments/test/ShippingOptionsChromeScript.js",
      "dom/payments/test/ShowPaymentChromeScript.js",
      "dom/payments/test/UpdateErrorsChromeScript.js",
      "dom/push/test/mockpushserviceparent.js",
      "dom/push/test/test_try_registering_offline_disabled.html",
      "dom/security/test/csp/file_report_chromescript.js",
      "dom/security/test/csp/test_ignore_xfo.html",
      "dom/security/test/general/test_contentpolicytype_targeted_link_iframe.html",
      "dom/security/test/general/test_meta_referrer.html",
      "dom/security/test/general/test_same_site_cookies_laxByDefault.html",
      "dom/security/test/mixedcontentblocker/file_main_bug803225.html",
      "dom/security/test/sec-fetch/test_iframe_history_manipulation.html",
      "dom/security/test/sec-fetch/test_iframe_src_metaRedirect.html",
      "dom/security/test/sec-fetch/test_iframe_srcdoc_metaRedirect.html",
      "dom/security/test/sec-fetch/test_iframe_window_open_metaRedirect.html",
      "dom/security/test/sec-fetch/test_trustworthy_loopback.html",
      "dom/security/test/sec-fetch/test_websocket.html",
      "dom/security/test/sec-fetch/test_window_open_popupBlockerEnabled.html",
      "dom/serviceworkers/test/console_monitor.js",
      "dom/serviceworkers/test/script_file_upload.js",
      "dom/serviceworkers/test/test_scopes.html",
      "dom/serviceworkers/test/test_third_party_iframes.html",
      "dom/tests/mochitest/bugs/test_no_find_showDialog.html",
      "dom/workers/test/script_createFile.js",
      "dom/xhr/tests/file_sync_xhr_event_handling_helper.html",
      "dom/xhr/tests/file_sync_xhr_nested_helper.html",
      "editor/libeditor/tests/test_bug569988.html",
      "editor/spellchecker/tests/test_bug1200533.html",
      "editor/spellchecker/tests/test_bug1204147.html",
      "editor/spellchecker/tests/test_bug1205983.html",
      "editor/spellchecker/tests/test_bug1209414.html",
      "editor/spellchecker/tests/test_bug1402822.html",
      "editor/spellchecker/tests/test_bug1761273.html",
      "editor/spellchecker/tests/test_bug1773802.html",
      "editor/spellchecker/tests/test_bug678842.html",
      "editor/spellchecker/tests/test_bug697981.html",
      "editor/spellchecker/tests/test_bug717433.html",
      "editor/spellchecker/tests/test_multiple_content_languages.html",
      "extensions/spellcheck/tests/mochitest/helper_bug1170484.js",
      "extensions/spellcheck/tests/mochitest/test_bug1272623.html",
      "gfx/layers/apz/test/mochitest/apz_test_utils.js",
      "gfx/layers/apz/test/mochitest/helper_hittest_overscroll_contextmenu.html",
      "gfx/layers/apz/test/mochitest/helper_hittest_overscroll.html",
      "gfx/layers/apz/test/mochitest/helper_touch_action_regions.html",
      "mobile/shared/actors/tests/mochitests/test_geckoview_experiment_delegate.html",
      "mobile/shared/modules/geckoview/test/mochitest/test_geckoview_translations.html",
      "netwerk/cookie/test/mochitest/cookiesHelper.js",
      "netwerk/test/mochitests/file_1331680.js",
      "netwerk/test/mochitests/file_chromecommon.js",
      "netwerk/test/mochitests/file_documentcookie_maxage_chromescript.js",
      "netwerk/test/mochitests/file_testloadflags_chromescript.js",
      "netwerk/test/mochitests/test_1396395.html",
      "security/manager/ssl/tests/mochitest/mixedcontent/test_bug383369.html",
      "testing/mochitest/tests/Harness_sanity/specialPowers_framescript.js",
      "testing/mochitest/tests/Harness_sanity/SpecialPowersLoadChromeScript.js",
      "testing/mochitest/tests/Harness_sanity/test_SpecialPowersLoadChromeScript_function.html",
      "testing/mochitest/tests/Harness_sanity/test_SpecialPowersLoadChromeScript.html",
      "testing/mochitest/tests/Harness_sanity/test_SpecialPowersSandbox.html",
      "testing/mochitest/tests/Harness_sanity/test_SpecialPowersSandbox.js",
      "testing/mochitest/tests/SimpleTest/ChromeTask.js",
      "toolkit/components/alerts/test/chrome/test_alerts_noobserve.html",
      "toolkit/components/alerts/test/chrome/test_alerts_requireinteraction.html",
      "toolkit/components/alerts/test/chrome/test_multiple_alerts.html",
      "toolkit/components/alerts/test/chrome/test_principal.html",
      "toolkit/components/antitracking/test/browser/browser_permissionInNormalWindows.js",
      "toolkit/components/extensions/test/mochitest/chrome_cleanup_script.js",
      "toolkit/components/extensions/test/mochitest/mochitest_console.js",
      "toolkit/components/extensions/test/mochitest/test_ext_browsingData_localStorage.html",
      "toolkit/components/extensions/test/mochitest/test_ext_contentscript_cache.html",
      "toolkit/components/extensions/test/mochitest/test_ext_cookies_incognito.html",
      "toolkit/components/extensions/test/mochitest/test_ext_protocolHandlers.html",
      "toolkit/components/extensions/test/mochitest/test_ext_protocolHandlers.html",
      "toolkit/components/extensions/test/mochitest/test_ext_protocolHandlers.html",
      "toolkit/components/extensions/test/mochitest/test_ext_protocolHandlers.html",
      "toolkit/components/extensions/test/mochitest/test_ext_protocolHandlers.html",
      "toolkit/components/extensions/test/mochitest/test_ext_request_urlClassification.html",
      "toolkit/components/extensions/test/mochitest/test_ext_request_urlClassification.html",
      "toolkit/components/extensions/test/mochitest/test_ext_unlimitedStorage.html",
      "toolkit/components/extensions/test/mochitest/test_ext_webrequest_auth.html",
      "toolkit/components/extensions/test/mochitest/test_ext_webrequest_auth.html",
      "toolkit/components/extensions/test/mochitest/test_verify_non_remote_mode.html",
      "toolkit/components/passwordmgr/test/mochitest/chrome_timeout.js",
      "toolkit/components/passwordmgr/test/mochitest/pwmgr_common_parent.js",
      "toolkit/components/passwordmgr/test/mochitest/pwmgr_common.js",
      "toolkit/components/passwordmgr/test/mochitest/pwmgr_common.js",
      "toolkit/components/passwordmgr/test/mochitest/pwmgr_common.js",
      "toolkit/components/passwordmgr/test/mochitest/pwmgr_common.js",
      "toolkit/components/prompts/test/chromeScript.js",
      "toolkit/components/satchel/test/parent_utils.js",
      "toolkit/components/url-classifier/tests/mochitest/classifierCommon.js",
      "toolkit/components/url-classifier/tests/mochitest/features.js",
      "toolkit/components/url-classifier/tests/mochitest/test_classify_top_sandboxed.html",
      "toolkit/components/url-classifier/tests/mochitest/test_cryptomining.html",
      "toolkit/components/url-classifier/tests/mochitest/test_emailtracking.html",
      "toolkit/components/url-classifier/tests/mochitest/test_fingerprinting.html",
      "toolkit/components/url-classifier/tests/mochitest/test_socialtracking.html",
      "toolkit/content/tests/chrome/test_autocomplete_with_composition_on_input.html",
      "toolkit/content/tests/chrome/test_editor_for_input_with_autocomplete.html",
      "toolkit/content/tests/mochitest/test_autocomplete_change_after_focus.html",
      "toolkit/content/tests/mochitest/test_autocomplete_change_after_focus.html",
      "uriloader/exthandler/tests/mochitest/HelperAppLauncherDialog_chromeScript.js",
    ],
    languageOptions: { globals: mozilla.environments["chrome-script"].globals },
  },
  {
    name: "globals-frame-script",
    files: [
      "browser/base/content/test/performance/browser_startup_content.js",
      "devtools/server/startup/frame.js",
      "docshell/test/browser/file_bug1328501_framescript.js",
      "dom/indexedDB/test/test_message_manager_ipc.html",
      "dom/ipc/tests/test_blob_sliced_from_child_process.js",
      "dom/ipc/tests/test_blob_sliced_from_parent_process.js",
      "dom/ipc/tests/test_bug1086684.js",
      "dom/ipc/tests/test_child_docshell.js",
      "dom/messagechannel/tests/mm_messageChannel.js",
      "layout/tools/reftest/reftest-content.js",
      "mobile/shared/chrome/geckoview/SessionStateAggregator.js",
      "netwerk/test/browser/browser_nsIFormPOSTActionChannel.js",
      "remote/cdp/sessions/frame-script.js",
      "remote/marionette/reftest-content.js",
      "testing/mochitest/BrowserTestUtils/content/content-task.js",
      "testing/mochitest/shutdown-leaks-collector.js",
      "testing/talos/talos/pageloader/chrome/a11y.js",
      "testing/talos/talos/pageloader/chrome/lh_dummy.js",
      "testing/talos/talos/pageloader/chrome/lh_fnbpaint.js",
      "testing/talos/talos/pageloader/chrome/lh_hero.js",
      "testing/talos/talos/pageloader/chrome/lh_moz.js",
      "testing/talos/talos/pageloader/chrome/lh_pdfpaint.js",
      "testing/talos/talos/pageloader/chrome/Profiler.js",
      "testing/talos/talos/pageloader/chrome/talos-content.js",
      "testing/talos/talos/pageloader/chrome/tscroll.js",
      "testing/talos/talos/pageloader/chrome/utils.js",
      "testing/talos/talos/talos-powers/chrome/talos-powers-content.js",
      "testing/talos/talos/talos-powers/content/TalosContentProfiler.js",
      "testing/talos/talos/tests/cpstartup/extension/framescript.js",
      "testing/talos/talos/tests/tabpaint/framescript.js",
      "testing/talos/talos/tests/tart/addon/content/framescript.js",
      "testing/talos/talos/tests/tresize/addon/content/framescript.js",
      "toolkit/components/extensions/ext-browser-content.js",
      "toolkit/components/gfx/content/gfxFrameScript.js",
    ],
    languageOptions: { globals: mozilla.environments["frame-script"].globals },
  },
  {
    name: "globals-process-script",
    files: [
      "browser/extensions/webcompat/about-compat/aboutPageProcessScript.js",
      "devtools/client/shared/test/shared-head.js",
      "devtools/server/startup/content-process-script.js",
      "devtools/server/startup/content-process.js",
      "devtools/server/tests/browser/browser_getProcess.js",
      "dom/base/test/browser_messagemanager_loadprocessscript.js",
      "dom/base/test/browser_messagemanager_loadprocessscript.js",
      "dom/base/test/chrome/file_bug1139964.xhtml",
      "dom/security/test/mixedcontentblocker/file_main_bug803225.html",
      "testing/mochitest/BrowserTestUtils/content/content-about-page-utils.js",
      "testing/talos/talos/tests/tabswitch/content/tabswitch-content-process.js",
      "toolkit/components/extensions/extensionProcessScriptLoader.js",
      "toolkit/content/process-content.js",
    ],
    languageOptions: {
      globals: mozilla.environments["process-script"].globals,
    },
  },
  {
    name: "globals-remote-page",
    files: [
      "browser/base/content/aboutRestartRequired.js",
      "browser/base/content/aboutTabCrashed.js",
      "browser/components/privatebrowsing/content/aboutPrivateBrowsing.js",
      "browser/components/profiles/content/delete-profile-card.mjs",
      "browser/components/profiles/content/edit-profile-card.mjs",
      "browser/components/profiles/content/new-profile-card.mjs",
      "browser/components/protections/content/lockwise-card.mjs",
      "browser/components/protections/content/monitor-card.mjs",
      "browser/components/protections/content/protections.mjs",
      "browser/components/protections/content/proxy-card.mjs",
      "browser/components/protections/content/vpn-card.mjs",
      "browser/components/shopping/content/settings.mjs",
      "browser/components/shopping/content/shopping-container.mjs",
      "browser/components/shopping/content/shopping-message-bar.mjs",
      "browser/extensions/newtab/content-src/lib/init-store.mjs",
      "browser/extensions/newtab/data/content/activity-stream.bundle.js",
      "toolkit/components/certviewer/content/certviewer.mjs",
      "toolkit/components/certviewer/content/components/about-certificate-items.mjs",
      "toolkit/components/certviewer/content/components/about-certificate-section.mjs",
      "toolkit/components/httpsonlyerror/content/errorpage.js",
      "toolkit/content/aboutNetError.mjs",
      "toolkit/content/aboutNetErrorHelpers.mjs",
      "toolkit/content/net-error-card.mjs",
    ],
    languageOptions: { globals: mozilla.environments["remote-page"].globals },
  },
  {
    name: "globals-simpletest",
    files: [
      "dom/quota/test/modules/content/Assert.mjs",
      "netwerk/test/browser/cookie_filtering_helper.sys.mjs",
      "xpcom/ioutils/tests/file_ioutils_test_fixtures.js",
    ],
    languageOptions: { globals: mozilla.environments.simpletest.globals },
  },
  {
    name: "globals-testharness",
    files: [
      "dom/encoding/test/test_BOMEncoding.js",
      "dom/encoding/test/test_TextDecoder.js",
      "dom/encoding/test/test_TextEncoder.js",
    ],
    languageOptions: { globals: mozilla.environments.testharness.globals },
  },
  {
    name: "globals-node",
    files: [
      "browser/base/content/test/perftest_browser_xhtml_dom.js",
      "browser/components/storybook/.storybook/addon-component-status/index.js",
      "browser/components/storybook/.storybook/addon-fluent/index.js",
      "browser/components/storybook/.storybook/chrome-styles-loader.js",
      "browser/components/storybook/.storybook/chrome-uri-utils.js",
      "browser/components/storybook/.storybook/main.js",
      "browser/components/storybook/.storybook/markdown-story-indexer.js",
      "browser/components/storybook/.storybook/markdown-story-loader.js",
      "browser/components/storybook/.storybook/markdown-story-utils.js",
      "browser/tools/mozsrcUriPlugin.js",
      "browser/tools/resourceUriPlugin.js",
      "dom/media/webrtc/tests/mochitests/helpers_from_wpt/sdp.js",
      "dom/media/webvtt/update-webvtt.js",
      "netwerk/test/perf/perftest_http3_cloudflareblog.js",
      "netwerk/test/perf/perftest_http3_controlled.js",
      "netwerk/test/perf/perftest_http3_facebook_scroll.js",
      "netwerk/test/perf/perftest_http3_google_image.js",
      "netwerk/test/perf/perftest_http3_google_search.js",
      "netwerk/test/perf/perftest_http3_lucasquicfetch.js",
      "netwerk/test/perf/perftest_http3_youtube_watch_scroll.js",
      "netwerk/test/perf/perftest_http3_youtube_watch.js",
      "netwerk/test/unit/test_http_server_timing.js",
      "netwerk/test/unit/test_http2-proxy-failing.js",
      "netwerk/test/unit/test_http2-proxy.js",
      "python/mozperftest/mozperftest/tests/data/failing-samples/perftest_doc_failure_example.js",
      "python/mozperftest/mozperftest/tests/data/samples/perftest_example.js",
      "python/mozperftest/mozperftest/tests/data/samples/test_perftest_WPT_init_file.js",
      "testing/performance/perftest_record.js",
      "testing/performance/perftest_WPT_chrome_init_file.js",
      "testing/performance/perftest_WPT_firefox_init_file.js",
      "testing/raptor/browsertime/browsertime_benchmark.js",
      "testing/raptor/browsertime/browsertime_interactive.js",
      "testing/raptor/browsertime/browsertime_pageload.js",
      "testing/raptor/browsertime/browsertime_scenario.js",
      "testing/raptor/browsertime/browsertime_tp6_bench.js",
      "testing/raptor/browsertime/constant_regression_test.js",
      "testing/raptor/browsertime/indexeddb_getkeyrange.js",
      "testing/raptor/browsertime/indexeddb_open.js",
      "testing/raptor/browsertime/indexeddb_write.js",
      "testing/raptor/browsertime/jetstream3.js",
      "testing/raptor/browsertime/motionmark-1-3.js",
      "testing/raptor/browsertime/network_bench.js",
      "testing/raptor/browsertime/process_switch.js",
      "testing/raptor/browsertime/speculative-connect.js",
      "testing/raptor/browsertime/speedometer3.js",
      "testing/raptor/browsertime/throttled_pageload.js",
      "testing/raptor/browsertime/trr_performance.js",
      "testing/raptor/browsertime/utils/profiling.js",
      "testing/raptor/browsertime/utils/support_measurements.js",
      "testing/raptor/browsertime/welcome.js",
      "testing/web-platform/tests/webrtc/third_party/sdp/sdp.js",
      "testing/xpcshell/moz-http2/moz-http2-child.js",
      "testing/xpcshell/moz-http2/moz-http2.js",
      "toolkit/components/normandy/actions/schemas/export_json.js",
      "toolkit/themes/shared/design-system/figma-tokens-config.js",
      "toolkit/themes/shared/design-system/tests/try-runner.js",
      "toolkit/themes/shared/design-system/tokens-config.js",
      "tools/lint/stylelint/stylelint-plugin-mozilla/helpers.mjs",
      "tools/lint/stylelint/stylelint-plugin-mozilla/index.mjs",
      "tools/lint/stylelint/stylelint-plugin-mozilla/reporters/mozilla-format.mjs",
      "tools/lint/stylelint/stylelint-plugin-mozilla/rules/index.mjs",
      "tools/lint/stylelint/stylelint-plugin-mozilla/rules/no-base-design-tokens.mjs",
      "tools/lint/stylelint/stylelint-plugin-mozilla/tests/no-base-design-tokens.mjs",
      "tools/ts/plugins/checkRootOnly.js",
      "tools/ts/test/dom.test.js",
      "tools/ts/test/xpcom.test.js",
    ],
    languageOptions: { globals: globals.node },
  },
  {
    name: "globals-serviceworker",
    files: [
      "dom/notification/test/browser/file_userContextId_openWindow.js",
      "dom/notification/test/mochitest/notification_openWindow_worker.js",
      "dom/notification/test/mochitest/notificationclick_focus.js",
      "dom/notification/test/mochitest/notificationclick.js",
      "dom/notification/test/mochitest/notificationclose.js",
      "dom/notification/test/mochitest/openWindow_worker.js",
      "dom/security/test/general/file_block_script_wrong_mime_sw.js",
    ],
    languageOptions: { globals: globals.serviceworker },
  },
  {
    name: "globals-webextensions",
    files: [
      "browser/components/preferences/tests/browser_contentblocking_categories.js",
      "browser/components/preferences/tests/browser_contentblocking.js",
      "browser/components/preferences/tests/browser_extension_controlled.js",
      "browser/extensions/formautofill/background.js",
      "browser/extensions/newtab/webext-glue/background.js",
      "devtools/client/responsive/test/browser/browser_ext_messaging.js",
      "dom/fetch/tests/test_ext_response_constructor.html",
      "mobile/android/android-components/components/browser/icons/src/main/assets/extensions/browser-icons/icons.js",
      "mobile/android/android-components/components/feature/accounts/src/main/assets/extensions/fxawebchannel/background.js",
      "mobile/android/android-components/components/feature/accounts/src/main/assets/extensions/fxawebchannel/fxawebchannel.js",
      "mobile/android/android-components/components/feature/readerview/src/main/assets/extensions/readerview/readerview-background.js",
      "mobile/android/android-components/components/feature/readerview/src/main/assets/extensions/readerview/readerview-content.js",
      "mobile/android/android-components/components/feature/readerview/src/main/assets/extensions/readerview/readerview.js",
      "mobile/android/android-components/components/feature/search/src/main/assets/extensions/ads/adsTelemetry.js",
      "mobile/android/android-components/components/feature/search/src/main/assets/extensions/search/searchTelemetry.js",
      "mobile/android/android-components/samples/browser/src/main/assets/extensions/test/background.js",
      "testing/talos/talos/tests/devtools/addon/driver.js",
      "testing/talos/talos/tests/twinopen/driver.js",
      "testing/talos/talos/webextensions/dummy/background.js",
      "testing/talos/talos/webextensions/dummy/content.js",
      "toolkit/components/ml/docs/extensions-api-example/background.js",
      "toolkit/components/ml/docs/extensions-api-example/contextmenu-shim.js",
      "toolkit/components/remotebrowserutils/tests/browser/browser_documentChannel.js",
    ],
    languageOptions: { globals: globals.webextensions },
  },
  {
    name: "globals-worker",
    files: [
      "devtools/shared/heapsnapshot/tests/xpcshell/dominator-tree-worker.js",
      "devtools/shared/heapsnapshot/tests/xpcshell/heap-snapshot-worker.js",
      "dom/broadcastchannel/tests/broadcastchannel_sharedWorker.js",
      "dom/cache/test/mochitest/worker_wrapper.js",
      "dom/crypto/test/test-worker.js",
      "dom/filesystem/tests/worker_basic.js",
      "dom/indexedDB/test/blob_worker_crash_iframe.html",
      "dom/indexedDB/test/browser_private_idb.js",
      "dom/indexedDB/test/test_blob_simple.html",
      "dom/indexedDB/test/test_blob_worker_xhr_post_multifile.html",
      "dom/indexedDB/test/test_blob_worker_xhr_post.html",
      "dom/indexedDB/test/test_blob_worker_xhr_read_slice.html",
      "dom/indexedDB/test/test_blob_worker_xhr_read.html",
      "dom/messagechannel/tests/sharedWorker_messageChannel.js",
      "dom/messagechannel/tests/sharedWorker2_messageChannel.js",
      "dom/quota/test/modules/content/worker/head.js",
      "dom/url/tests/esm_url_worker.js",
      "dom/url/tests/url_worker.js",
      "dom/url/tests/urlApi_worker.js",
      "dom/url/tests/urlSearchParams_worker.js",
      "dom/xhr/tests/relativeLoad_worker.js",
      "dom/xhr/tests/relativeLoad_worker2.js",
      "dom/xhr/tests/subdir/relativeLoad_sub_worker.js",
      "dom/xhr/tests/subdir/relativeLoad_sub_worker2.js",
      "dom/xhr/tests/worker_temporaryFileBlob.js",
      "dom/xhr/tests/xhr_sharedworker.js",
      "dom/xhr/tests/xhr2_worker.js",
      "dom/xhr/tests/xhrAbort_worker.js",
      "xpcom/ioutils/tests/file_ioutils_worker.js",
      "xpcom/ioutils/tests/pathutils_worker.js",
    ],
    languageOptions: { globals: globals.worker },
  },
];
