/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.sort.LFUCache;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.lib.URIChecker;
import net.sf.saxon.str.StringView;
import net.sf.saxon.value.Whitespace;

public class StandardURIChecker
implements URIChecker {
    private static final StandardURIChecker THE_INSTANCE = new StandardURIChecker();
    private static final ThreadLocal<LFUCache<String, URI>> caches = new ThreadLocal();

    public static StandardURIChecker getInstance() {
        return THE_INSTANCE;
    }

    protected StandardURIChecker() {
    }

    @Override
    public boolean isValidURI(String value) {
        URI uri2;
        LFUCache<String, URI> cache = caches.get();
        if (cache == null) {
            cache = new LFUCache(50);
            caches.set(cache);
        }
        if (cache.containsKey(value)) {
            return true;
        }
        String sv = Whitespace.trim(value);
        if (sv.isEmpty()) {
            return true;
        }
        try {
            uri2 = new URI(sv);
            if (this.passesAdditionalChecks(uri2)) {
                cache.put(value, uri2);
                return true;
            }
        }
        catch (URISyntaxException uri2) {
            // empty catch block
        }
        sv = IriToUri.iriToUri(StringView.tidy(sv)).toString();
        try {
            uri2 = new URI(sv);
            if (this.passesAdditionalChecks(uri2)) {
                cache.put(value, uri2);
                return true;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return false;
    }

    public boolean passesAdditionalChecks(URI uri) {
        return true;
    }

    public void checkThoroughly(URI uri) throws URISyntaxException {
        if (!this.passesAdditionalChecks(uri)) {
            throw new URISyntaxException(uri.toString(), "Fails detailed checking");
        }
    }

    public static void main(String[] args) {
        System.err.println(args[0] + " is valid? - " + StandardURIChecker.getInstance().isValidURI(args[0]));
    }
}

