// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

export interface PageElementTypes {
  content: HTMLElement;
  status: HTMLElement;
  pageHeader: HTMLElement;
  focusedFavicon: HTMLImageElement;
  focusedUrl: HTMLInputElement;
  contextAccessIndicator: HTMLInputElement;
  panelActiveCheckbox: HTMLInputElement;
  focusedTabLogs: HTMLSpanElement;
  focusedFaviconV2: HTMLImageElement;
  focusedUrlV2: HTMLInputElement;
  contextAccessIndicatorV2: HTMLInputElement;
  focusedTabLogsV2: HTMLSpanElement;
  syncCookiesBn: HTMLButtonElement;
  testLogsBn: HTMLButtonElement;
  syncCookieStatus: HTMLSpanElement;
  getUserProfileInfoBn: HTMLButtonElement;
  getUserProfileInfoStatus: HTMLSpanElement;
  getUserProfileInfoImg: HTMLImageElement;
  changeProfileBn: HTMLButtonElement;
  testPermissionSwitch: HTMLButtonElement;
  openGlicSettings: HTMLButtonElement;
  openGlicSettingsHighlight: HTMLSelectElement;
  microphoneSwitch: HTMLInputElement;
  geolocationSwitch: HTMLInputElement;
  tabContextSwitch: HTMLInputElement;
  newtabbn: HTMLButtonElement;
  reloadpage: HTMLButtonElement;
  getpagecontext: HTMLButtonElement;
  getPageContextResult: HTMLSpanElement;
  getPageContextStatus: HTMLSpanElement;
  URL: HTMLInputElement;
  innerTextCheckbox: HTMLInputElement;
  innerTextBytesLimit: HTMLInputElement;
  viewportScreenshotCheckbox: HTMLInputElement;
  pdfDataCheckbox: HTMLInputElement;
  annotatedPageContentCheckbox: HTMLInputElement;
  screenshotImg: HTMLImageElement;
  faviconImg: HTMLImageElement;
  getlocation: HTMLButtonElement;
  location: HTMLElement;
  locationStatus: HTMLDivElement;
  locationOsErrorUI: HTMLDivElement;
  locationGlicErrorUI: HTMLDivElement;
  openOsLocationSettingsButton: HTMLButtonElement;
  openOsMicrophoneSettings: HTMLButtonElement;
  openOsLocationSettings: HTMLButtonElement;
  openGlicLocationSettingsButton: HTMLButtonElement;
  permissionSelect: HTMLSelectElement;
  enabledSelect: HTMLSelectElement;
  closebn: HTMLButtonElement;
  shutdownbn: HTMLButtonElement;
  attachpanelbn: HTMLButtonElement;
  detachpanelbn: HTMLButtonElement;
  refreshbn: HTMLButtonElement;
  navigateWebviewUrl: HTMLInputElement;
  audioCapStop: HTMLButtonElement;
  audioCapStart: HTMLButtonElement;
  audioStatus: HTMLElement;
  mic: HTMLAudioElement;
  audioDuckingOn: HTMLButtonElement;
  audioDuckingOff: HTMLButtonElement;
  desktopScreenshot: HTMLButtonElement;
  desktopScreenshotImg: HTMLImageElement;
  desktopScreenshotErrorReason: HTMLSpanElement;
  panelScreenshot: HTMLButtonElement;
  createTabInBackground: HTMLInputElement;
  canAttachCheckbox: HTMLInputElement;
  scrollToDocumentId: HTMLSpanElement;
  scrollToExactText: HTMLInputElement;
  scrollToExactTextSearchStart: HTMLSelectElement;
  scrollToFetchAPCBn: HTMLButtonElement;
  scrollToTextFragmentTextStart: HTMLInputElement;
  scrollToTextFragmentTextEnd: HTMLInputElement;
  scrollToTextFragmentSearchStart: HTMLSelectElement;
  scrollToNode: HTMLSelectElement;
  scrollToBn: HTMLButtonElement;
  fileDrop: HTMLDivElement;
  fileDropList: HTMLDivElement;
  showDirectoryPicker: HTMLButtonElement;
  failInitializationCheckbox: HTMLInputElement;
  screenWakeLockSwitch: HTMLInputElement;
  screenWakeLockStatus: HTMLLabelElement;
  setExperiment: HTMLButtonElement;
  trialName: HTMLInputElement;
  groupName: HTMLInputElement;
  setExperimentStatus: HTMLSpanElement;
  testClipboardSave: HTMLButtonElement;
  hangDuration: HTMLInputElement;
  hang: HTMLButtonElement;
  contentSizingTest: HTMLElement;
  enableTestSizingMode: HTMLButtonElement;
  disableTestSizingMode: HTMLButtonElement;
  enableDragResizeCheckbox: HTMLInputElement;
  growHeight: HTMLButtonElement;
  resetHeight: HTMLButtonElement;
  dump: HTMLElement;
  fitWindow: HTMLInputElement;
  naturalSizing: HTMLInputElement;
  startMic: HTMLButtonElement;
  successUI: HTMLDivElement;
  localDenialUI: HTMLDivElement;
  osDenialUI: HTMLDivElement;
  openLocalSettingsButton: HTMLButtonElement;
  openOsSettingsButton: HTMLButtonElement;
  osGeolocationPermissionSwitch: HTMLInputElement;
  getOsMicrophonePermissionButton: HTMLButtonElement;
  osMicrophonePermissionResult: HTMLSpanElement;
  osGlicHotkey: HTMLInputElement;
  executeAction: HTMLButtonElement;
  actionProtoEncodedText: HTMLInputElement;
  actionStatus: HTMLSpanElement;
  actionUpdatedContextResult: HTMLSpanElement;
  actionUpdatedScreenshotImg: HTMLImageElement;
  macOsPermissionsFieldset: HTMLFieldSetElement;
  attachmentControlsFieldset: HTMLFieldSetElement;
  closedCaptioningSwitch: HTMLInputElement;
  setClosedCaptioningTrue: HTMLButtonElement;
  setClosedCaptioningFalse: HTMLButtonElement;
  dropScrollToHighlightBtn: HTMLButtonElement;
}

export const $: PageElementTypes = new Proxy({}, {
  get(_target: any, prop: string) {
    return document.getElementById(prop);
  },
});
