/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public class DestructuringDeclarationTranslator
extends AbstractTranslator {
    @NotNull
    private final KtDestructuringDeclaration multiDeclaration;
    @NotNull
    private final JsExpression multiObjectExpr;

    @NotNull
    public static JsVars translate(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull JsExpression multiObjectExpr, @NotNull TranslationContext context2) {
        if (multiDeclaration == null) {
            DestructuringDeclarationTranslator.$$$reportNull$$$0(0);
        }
        if (multiObjectExpr == null) {
            DestructuringDeclarationTranslator.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            DestructuringDeclarationTranslator.$$$reportNull$$$0(2);
        }
        JsVars jsVars = new DestructuringDeclarationTranslator(multiDeclaration, multiObjectExpr, context2).translate();
        if (jsVars == null) {
            DestructuringDeclarationTranslator.$$$reportNull$$$0(3);
        }
        return jsVars;
    }

    private DestructuringDeclarationTranslator(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull JsExpression multiObjectExpr, @NotNull TranslationContext context2) {
        if (multiDeclaration == null) {
            DestructuringDeclarationTranslator.$$$reportNull$$$0(4);
        }
        if (multiObjectExpr == null) {
            DestructuringDeclarationTranslator.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            DestructuringDeclarationTranslator.$$$reportNull$$$0(6);
        }
        super(context2);
        this.multiDeclaration = multiDeclaration;
        this.multiObjectExpr = multiObjectExpr;
    }

    private JsVars translate() {
        ArrayList<JsVars.JsVar> jsVars = new ArrayList<JsVars.JsVar>();
        for (KtDestructuringDeclarationEntry entry : this.multiDeclaration.getEntries()) {
            VariableDescriptor descriptor2 = BindingContextUtils.getNotNull(this.context().bindingContext(), BindingContext.VARIABLE, entry);
            if (descriptor2.getName().isSpecial()) continue;
            ResolvedCall<FunctionDescriptor> entryInitCall = this.context().bindingContext().get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            assert (entryInitCall != null) : "Entry init call must be not null";
            JsExpression entryInitializer = CallTranslator.translate(this.context(), entryInitCall, this.multiObjectExpr);
            FunctionDescriptor candidateDescriptor = entryInitCall.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(candidateDescriptor, this.context())) {
                InlineUtils.setInlineCallMetadata(entryInitializer, (KtElement)entry, entryInitCall, this.context());
            }
            entryInitializer = TranslationUtils.coerce(this.context(), entryInitializer, descriptor2.getType());
            JsName name2 = this.context().getNameForDescriptor(descriptor2);
            if (BindingContextUtils.isBoxedLocalCapturedInClosure(this.context().bindingContext(), descriptor2)) {
                JsNameRef alias = Namer.getCapturedVarAccessor(name2.makeRef());
                entryInitializer = JsAstUtils.wrapValue(alias, entryInitializer);
            }
            JsVars.JsVar jsVar = new JsVars.JsVar(name2, entryInitializer);
            jsVar.setSource(entry);
            jsVars.add(jsVar);
        }
        JsVars result2 = new JsVars(jsVars, true);
        result2.setSource(this.multiDeclaration);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiDeclaration";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiObjectExpr";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/DestructuringDeclarationTranslator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

