<!--
  SPDX-License-Identifier: Apache-2.0
  SPDX-FileCopyrightText: 2021 The Elixir Team
  SPDX-FileCopyrightText: 2012 Plataformatec
-->

# Code of Conduct

Contact: elixir-lang-conduct@googlegroups.com

## Why have a Code of Conduct?

As contributors and maintainers of this project, we are committed to providing a friendly, safe and welcoming environment for all, regardless of age, disability, gender, nationality, race, religion, sexuality, or similar personal characteristic.

The goal of the Code of Conduct is to specify a baseline standard of behavior so that people with different social values and communication styles can talk about Elixir effectively, productively, and respectfully, even in face of disagreements. The Code of Conduct also provides a mechanism for resolving conflicts in the community when they arise.

## Our Values

These are the values Elixir developers should aspire to:

  * Be friendly and welcoming
  * Be kind
    * Remember that people have varying communication styles and that not everyone is using their native language. (Meaning and tone can be lost in translation.)
    * Interpret the arguments of others in good faith, do not seek to disagree.
    * When we do disagree, try to understand why.
  * Be thoughtful
    * Productive communication requires effort. Think about how your words will be interpreted.
    * Remember that sometimes it is best to refrain entirely from commenting.
  * Be respectful
    * In particular, respect differences of opinion. It is important that we resolve disagreements and differing views constructively.
  * Be constructive
    * Avoid derailing: stay on topic; if you want to talk about something else, start a new conversation.
    * Avoid unconstructive criticism: don't merely decry the current state of affairs; offer — or at least solicit — suggestions as to how things may be improved.
    * Avoid harsh words and stern tone: we are all aligned towards the well-being of the community and the progress of the ecosystem. Harsh words exclude, demotivate, and lead to unnecessary conflict.
    * Avoid snarking (pithy, unproductive, sniping comments).
    * Avoid microaggressions (brief and commonplace verbal, behavioral and environmental indignities that communicate hostile, derogatory or negative slights and insults towards a project, person or group).
  * Be responsible
    * What you say and do matters. Take responsibility for your words and actions, including their consequences, whether intended or otherwise.

The following actions are explicitly forbidden:

  * Insulting, demeaning, hateful, or threatening remarks.
  * Discrimination based on age, disability, gender, nationality, race, religion, sexuality, or similar personal characteristic.
  * Bullying or systematic harassment.
  * Unwelcome sexual advances.
  * Incitement to any of these.

## Where does the Code of Conduct apply?

If you participate in or contribute to the Elixir ecosystem in any way, you are encouraged to follow the Code of Conduct while doing so.

Explicit enforcement of the Code of Conduct applies to the official mediums operated by the Elixir project:

* The [official GitHub projects][1] and code reviews.
* The official elixir-lang mailing lists.
* The **[#elixir][2]** IRC channel on [Libera.Chat][3].

Other Elixir activities (such as conferences, meetups, and unofficial forums) are encouraged to adopt this Code of Conduct. Such groups must provide their own contact information.

Project maintainers may block, remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct.

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by emailing: elixir-lang-conduct@googlegroups.com. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. **All reports will be kept confidential**.

**The goal of the Code of Conduct is to resolve conflicts in the most harmonious way possible**. We hope that in most cases issues may be resolved through polite discussion and mutual agreement. Bannings and other forceful measures are to be employed only as a last resort. **Do not** post about the issue publicly or try to rally sentiment against a particular individual or group.

## Acknowledgements

This document was based on the Code of Conduct from the Go project (dated Sep/2021) and the Contributor Covenant (v1.4).

[1]: https://github.com/elixir-lang/
[2]: https://web.libera.chat/#elixir
[3]: https://libera.chat/
