// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package dialogflow aliases all exported identifiers in package
// "cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb".
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package dialogflow

import (
	src "cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
const (
	AgentAssistantFeedback_ANSWER_RELEVANCE_UNSPECIFIED                                              = src.AgentAssistantFeedback_ANSWER_RELEVANCE_UNSPECIFIED
	AgentAssistantFeedback_CORRECT                                                                   = src.AgentAssistantFeedback_CORRECT
	AgentAssistantFeedback_DOCUMENT_CORRECTNESS_UNSPECIFIED                                          = src.AgentAssistantFeedback_DOCUMENT_CORRECTNESS_UNSPECIFIED
	AgentAssistantFeedback_DOCUMENT_EFFICIENCY_UNSPECIFIED                                           = src.AgentAssistantFeedback_DOCUMENT_EFFICIENCY_UNSPECIFIED
	AgentAssistantFeedback_EFFICIENT                                                                 = src.AgentAssistantFeedback_EFFICIENT
	AgentAssistantFeedback_INCORRECT                                                                 = src.AgentAssistantFeedback_INCORRECT
	AgentAssistantFeedback_INEFFICIENT                                                               = src.AgentAssistantFeedback_INEFFICIENT
	AgentAssistantFeedback_IRRELEVANT                                                                = src.AgentAssistantFeedback_IRRELEVANT
	AgentAssistantFeedback_RELEVANT                                                                  = src.AgentAssistantFeedback_RELEVANT
	Agent_API_VERSION_UNSPECIFIED                                                                    = src.Agent_API_VERSION_UNSPECIFIED
	Agent_API_VERSION_V1                                                                             = src.Agent_API_VERSION_V1
	Agent_API_VERSION_V2                                                                             = src.Agent_API_VERSION_V2
	Agent_API_VERSION_V2_BETA_1                                                                      = src.Agent_API_VERSION_V2_BETA_1
	Agent_MATCH_MODE_HYBRID                                                                          = src.Agent_MATCH_MODE_HYBRID
	Agent_MATCH_MODE_ML_ONLY                                                                         = src.Agent_MATCH_MODE_ML_ONLY
	Agent_MATCH_MODE_UNSPECIFIED                                                                     = src.Agent_MATCH_MODE_UNSPECIFIED
	Agent_TIER_ENTERPRISE                                                                            = src.Agent_TIER_ENTERPRISE
	Agent_TIER_ENTERPRISE_PLUS                                                                       = src.Agent_TIER_ENTERPRISE_PLUS
	Agent_TIER_STANDARD                                                                              = src.Agent_TIER_STANDARD
	Agent_TIER_UNSPECIFIED                                                                           = src.Agent_TIER_UNSPECIFIED
	AnswerFeedback_CORRECTNESS_LEVEL_UNSPECIFIED                                                     = src.AnswerFeedback_CORRECTNESS_LEVEL_UNSPECIFIED
	AnswerFeedback_FULLY_CORRECT                                                                     = src.AnswerFeedback_FULLY_CORRECT
	AnswerFeedback_NOT_CORRECT                                                                       = src.AnswerFeedback_NOT_CORRECT
	AnswerFeedback_PARTIALLY_CORRECT                                                                 = src.AnswerFeedback_PARTIALLY_CORRECT
	AudioEncoding_AUDIO_ENCODING_AMR                                                                 = src.AudioEncoding_AUDIO_ENCODING_AMR
	AudioEncoding_AUDIO_ENCODING_AMR_WB                                                              = src.AudioEncoding_AUDIO_ENCODING_AMR_WB
	AudioEncoding_AUDIO_ENCODING_FLAC                                                                = src.AudioEncoding_AUDIO_ENCODING_FLAC
	AudioEncoding_AUDIO_ENCODING_LINEAR_16                                                           = src.AudioEncoding_AUDIO_ENCODING_LINEAR_16
	AudioEncoding_AUDIO_ENCODING_MULAW                                                               = src.AudioEncoding_AUDIO_ENCODING_MULAW
	AudioEncoding_AUDIO_ENCODING_OGG_OPUS                                                            = src.AudioEncoding_AUDIO_ENCODING_OGG_OPUS
	AudioEncoding_AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE                                              = src.AudioEncoding_AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE
	AudioEncoding_AUDIO_ENCODING_UNSPECIFIED                                                         = src.AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
	AutomatedAgentReply_AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED                                       = src.AutomatedAgentReply_AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED
	AutomatedAgentReply_FINAL                                                                        = src.AutomatedAgentReply_FINAL
	AutomatedAgentReply_PARTIAL                                                                      = src.AutomatedAgentReply_PARTIAL
	ConversationEvent_CONVERSATION_FINISHED                                                          = src.ConversationEvent_CONVERSATION_FINISHED
	ConversationEvent_CONVERSATION_STARTED                                                           = src.ConversationEvent_CONVERSATION_STARTED
	ConversationEvent_HUMAN_INTERVENTION_NEEDED                                                      = src.ConversationEvent_HUMAN_INTERVENTION_NEEDED
	ConversationEvent_NEW_MESSAGE                                                                    = src.ConversationEvent_NEW_MESSAGE
	ConversationEvent_TYPE_UNSPECIFIED                                                               = src.ConversationEvent_TYPE_UNSPECIFIED
	ConversationEvent_UNRECOVERABLE_ERROR                                                            = src.ConversationEvent_UNRECOVERABLE_ERROR
	Conversation_COMPLETED                                                                           = src.Conversation_COMPLETED
	Conversation_CONVERSATION_STAGE_UNSPECIFIED                                                      = src.Conversation_CONVERSATION_STAGE_UNSPECIFIED
	Conversation_HUMAN_ASSIST_STAGE                                                                  = src.Conversation_HUMAN_ASSIST_STAGE
	Conversation_IN_PROGRESS                                                                         = src.Conversation_IN_PROGRESS
	Conversation_LIFECYCLE_STATE_UNSPECIFIED                                                         = src.Conversation_LIFECYCLE_STATE_UNSPECIFIED
	Conversation_VIRTUAL_AGENT_STAGE                                                                 = src.Conversation_VIRTUAL_AGENT_STAGE
	Document_ACTIVE                                                                                  = src.Document_ACTIVE
	Document_AGENT_FACING_SMART_REPLY                                                                = src.Document_AGENT_FACING_SMART_REPLY
	Document_ARTICLE_SUGGESTION                                                                      = src.Document_ARTICLE_SUGGESTION
	Document_CREATING                                                                                = src.Document_CREATING
	Document_DELETING                                                                                = src.Document_DELETING
	Document_EXTRACTIVE_QA                                                                           = src.Document_EXTRACTIVE_QA
	Document_FAQ                                                                                     = src.Document_FAQ
	Document_KNOWLEDGE_TYPE_UNSPECIFIED                                                              = src.Document_KNOWLEDGE_TYPE_UNSPECIFIED
	Document_RELOADING                                                                               = src.Document_RELOADING
	Document_SMART_REPLY                                                                             = src.Document_SMART_REPLY
	Document_STATE_UNSPECIFIED                                                                       = src.Document_STATE_UNSPECIFIED
	Document_UPDATING                                                                                = src.Document_UPDATING
	EntityType_AUTO_EXPANSION_MODE_DEFAULT                                                           = src.EntityType_AUTO_EXPANSION_MODE_DEFAULT
	EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED                                                       = src.EntityType_AUTO_EXPANSION_MODE_UNSPECIFIED
	EntityType_KIND_LIST                                                                             = src.EntityType_KIND_LIST
	EntityType_KIND_MAP                                                                              = src.EntityType_KIND_MAP
	EntityType_KIND_REGEXP                                                                           = src.EntityType_KIND_REGEXP
	EntityType_KIND_UNSPECIFIED                                                                      = src.EntityType_KIND_UNSPECIFIED
	Environment_LOADING                                                                              = src.Environment_LOADING
	Environment_RUNNING                                                                              = src.Environment_RUNNING
	Environment_STATE_UNSPECIFIED                                                                    = src.Environment_STATE_UNSPECIFIED
	Environment_STOPPED                                                                              = src.Environment_STOPPED
	Fulfillment_Feature_SMALLTALK                                                                    = src.Fulfillment_Feature_SMALLTALK
	Fulfillment_Feature_TYPE_UNSPECIFIED                                                             = src.Fulfillment_Feature_TYPE_UNSPECIFIED
	IntentView_INTENT_VIEW_FULL                                                                      = src.IntentView_INTENT_VIEW_FULL
	IntentView_INTENT_VIEW_UNSPECIFIED                                                               = src.IntentView_INTENT_VIEW_UNSPECIFIED
	Intent_Message_ACTIONS_ON_GOOGLE                                                                 = src.Intent_Message_ACTIONS_ON_GOOGLE
	Intent_Message_BrowseCarouselCard_BLURRED_BACKGROUND                                             = src.Intent_Message_BrowseCarouselCard_BLURRED_BACKGROUND
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_AMP_ACTION                = src.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_AMP_ACTION
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_AMP_CONTENT               = src.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_AMP_CONTENT
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_URL_TYPE_HINT_UNSPECIFIED = src.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_URL_TYPE_HINT_UNSPECIFIED
	Intent_Message_BrowseCarouselCard_CROPPED                                                        = src.Intent_Message_BrowseCarouselCard_CROPPED
	Intent_Message_BrowseCarouselCard_GRAY                                                           = src.Intent_Message_BrowseCarouselCard_GRAY
	Intent_Message_BrowseCarouselCard_IMAGE_DISPLAY_OPTIONS_UNSPECIFIED                              = src.Intent_Message_BrowseCarouselCard_IMAGE_DISPLAY_OPTIONS_UNSPECIFIED
	Intent_Message_BrowseCarouselCard_WHITE                                                          = src.Intent_Message_BrowseCarouselCard_WHITE
	Intent_Message_ColumnProperties_CENTER                                                           = src.Intent_Message_ColumnProperties_CENTER
	Intent_Message_ColumnProperties_HORIZONTAL_ALIGNMENT_UNSPECIFIED                                 = src.Intent_Message_ColumnProperties_HORIZONTAL_ALIGNMENT_UNSPECIFIED
	Intent_Message_ColumnProperties_LEADING                                                          = src.Intent_Message_ColumnProperties_LEADING
	Intent_Message_ColumnProperties_TRAILING                                                         = src.Intent_Message_ColumnProperties_TRAILING
	Intent_Message_FACEBOOK                                                                          = src.Intent_Message_FACEBOOK
	Intent_Message_GOOGLE_HANGOUTS                                                                   = src.Intent_Message_GOOGLE_HANGOUTS
	Intent_Message_KIK                                                                               = src.Intent_Message_KIK
	Intent_Message_LINE                                                                              = src.Intent_Message_LINE
	Intent_Message_MediaContent_AUDIO                                                                = src.Intent_Message_MediaContent_AUDIO
	Intent_Message_MediaContent_RESPONSE_MEDIA_TYPE_UNSPECIFIED                                      = src.Intent_Message_MediaContent_RESPONSE_MEDIA_TYPE_UNSPECIFIED
	Intent_Message_PLATFORM_UNSPECIFIED                                                              = src.Intent_Message_PLATFORM_UNSPECIFIED
	Intent_Message_RbmCardContent_RbmMedia_HEIGHT_UNSPECIFIED                                        = src.Intent_Message_RbmCardContent_RbmMedia_HEIGHT_UNSPECIFIED
	Intent_Message_RbmCardContent_RbmMedia_MEDIUM                                                    = src.Intent_Message_RbmCardContent_RbmMedia_MEDIUM
	Intent_Message_RbmCardContent_RbmMedia_SHORT                                                     = src.Intent_Message_RbmCardContent_RbmMedia_SHORT
	Intent_Message_RbmCardContent_RbmMedia_TALL                                                      = src.Intent_Message_RbmCardContent_RbmMedia_TALL
	Intent_Message_RbmCarouselCard_CARD_WIDTH_UNSPECIFIED                                            = src.Intent_Message_RbmCarouselCard_CARD_WIDTH_UNSPECIFIED
	Intent_Message_RbmCarouselCard_MEDIUM                                                            = src.Intent_Message_RbmCarouselCard_MEDIUM
	Intent_Message_RbmCarouselCard_SMALL                                                             = src.Intent_Message_RbmCarouselCard_SMALL
	Intent_Message_RbmStandaloneCard_CARD_ORIENTATION_UNSPECIFIED                                    = src.Intent_Message_RbmStandaloneCard_CARD_ORIENTATION_UNSPECIFIED
	Intent_Message_RbmStandaloneCard_HORIZONTAL                                                      = src.Intent_Message_RbmStandaloneCard_HORIZONTAL
	Intent_Message_RbmStandaloneCard_LEFT                                                            = src.Intent_Message_RbmStandaloneCard_LEFT
	Intent_Message_RbmStandaloneCard_RIGHT                                                           = src.Intent_Message_RbmStandaloneCard_RIGHT
	Intent_Message_RbmStandaloneCard_THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED                           = src.Intent_Message_RbmStandaloneCard_THUMBNAIL_IMAGE_ALIGNMENT_UNSPECIFIED
	Intent_Message_RbmStandaloneCard_VERTICAL                                                        = src.Intent_Message_RbmStandaloneCard_VERTICAL
	Intent_Message_SKYPE                                                                             = src.Intent_Message_SKYPE
	Intent_Message_SLACK                                                                             = src.Intent_Message_SLACK
	Intent_Message_TELEGRAM                                                                          = src.Intent_Message_TELEGRAM
	Intent_Message_TELEPHONY                                                                         = src.Intent_Message_TELEPHONY
	Intent_Message_VIBER                                                                             = src.Intent_Message_VIBER
	Intent_TrainingPhrase_EXAMPLE                                                                    = src.Intent_TrainingPhrase_EXAMPLE
	Intent_TrainingPhrase_TEMPLATE                                                                   = src.Intent_TrainingPhrase_TEMPLATE
	Intent_TrainingPhrase_TYPE_UNSPECIFIED                                                           = src.Intent_TrainingPhrase_TYPE_UNSPECIFIED
	Intent_WEBHOOK_STATE_ENABLED                                                                     = src.Intent_WEBHOOK_STATE_ENABLED
	Intent_WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING                                                    = src.Intent_WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING
	Intent_WEBHOOK_STATE_UNSPECIFIED                                                                 = src.Intent_WEBHOOK_STATE_UNSPECIFIED
	KnowledgeAnswers_Answer_HIGH                                                                     = src.KnowledgeAnswers_Answer_HIGH
	KnowledgeAnswers_Answer_LOW                                                                      = src.KnowledgeAnswers_Answer_LOW
	KnowledgeAnswers_Answer_MATCH_CONFIDENCE_LEVEL_UNSPECIFIED                                       = src.KnowledgeAnswers_Answer_MATCH_CONFIDENCE_LEVEL_UNSPECIFIED
	KnowledgeAnswers_Answer_MEDIUM                                                                   = src.KnowledgeAnswers_Answer_MEDIUM
	KnowledgeOperationMetadata_DONE                                                                  = src.KnowledgeOperationMetadata_DONE
	KnowledgeOperationMetadata_PENDING                                                               = src.KnowledgeOperationMetadata_PENDING
	KnowledgeOperationMetadata_RUNNING                                                               = src.KnowledgeOperationMetadata_RUNNING
	KnowledgeOperationMetadata_STATE_UNSPECIFIED                                                     = src.KnowledgeOperationMetadata_STATE_UNSPECIFIED
	NotificationConfig_JSON                                                                          = src.NotificationConfig_JSON
	NotificationConfig_MESSAGE_FORMAT_UNSPECIFIED                                                    = src.NotificationConfig_MESSAGE_FORMAT_UNSPECIFIED
	NotificationConfig_PROTO                                                                         = src.NotificationConfig_PROTO
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_LINEAR_16                                              = src.OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_LINEAR_16
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MP3                                                    = src.OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MP3
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MP3_64_KBPS                                            = src.OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MP3_64_KBPS
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MULAW                                                  = src.OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_MULAW
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_OGG_OPUS                                               = src.OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_OGG_OPUS
	OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED                                            = src.OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED
	Participant_AUTOMATED_AGENT                                                                      = src.Participant_AUTOMATED_AGENT
	Participant_END_USER                                                                             = src.Participant_END_USER
	Participant_HUMAN_AGENT                                                                          = src.Participant_HUMAN_AGENT
	Participant_ROLE_UNSPECIFIED                                                                     = src.Participant_ROLE_UNSPECIFIED
	SessionEntityType_ENTITY_OVERRIDE_MODE_OVERRIDE                                                  = src.SessionEntityType_ENTITY_OVERRIDE_MODE_OVERRIDE
	SessionEntityType_ENTITY_OVERRIDE_MODE_SUPPLEMENT                                                = src.SessionEntityType_ENTITY_OVERRIDE_MODE_SUPPLEMENT
	SessionEntityType_ENTITY_OVERRIDE_MODE_UNSPECIFIED                                               = src.SessionEntityType_ENTITY_OVERRIDE_MODE_UNSPECIFIED
	SpeechModelVariant_SPEECH_MODEL_VARIANT_UNSPECIFIED                                              = src.SpeechModelVariant_SPEECH_MODEL_VARIANT_UNSPECIFIED
	SpeechModelVariant_USE_BEST_AVAILABLE                                                            = src.SpeechModelVariant_USE_BEST_AVAILABLE
	SpeechModelVariant_USE_ENHANCED                                                                  = src.SpeechModelVariant_USE_ENHANCED
	SpeechModelVariant_USE_STANDARD                                                                  = src.SpeechModelVariant_USE_STANDARD
	SsmlVoiceGender_SSML_VOICE_GENDER_FEMALE                                                         = src.SsmlVoiceGender_SSML_VOICE_GENDER_FEMALE
	SsmlVoiceGender_SSML_VOICE_GENDER_MALE                                                           = src.SsmlVoiceGender_SSML_VOICE_GENDER_MALE
	SsmlVoiceGender_SSML_VOICE_GENDER_NEUTRAL                                                        = src.SsmlVoiceGender_SSML_VOICE_GENDER_NEUTRAL
	SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED                                                    = src.SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED
	StreamingRecognitionResult_DTMF_DIGITS                                                           = src.StreamingRecognitionResult_DTMF_DIGITS
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE                                               = src.StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED                                              = src.StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
	StreamingRecognitionResult_PARTIAL_DTMF_DIGITS                                                   = src.StreamingRecognitionResult_PARTIAL_DTMF_DIGITS
	StreamingRecognitionResult_TRANSCRIPT                                                            = src.StreamingRecognitionResult_TRANSCRIPT
	SuggestionFeature_ARTICLE_SUGGESTION                                                             = src.SuggestionFeature_ARTICLE_SUGGESTION
	SuggestionFeature_CONVERSATION_SUMMARIZATION                                                     = src.SuggestionFeature_CONVERSATION_SUMMARIZATION
	SuggestionFeature_FAQ                                                                            = src.SuggestionFeature_FAQ
	SuggestionFeature_SMART_REPLY                                                                    = src.SuggestionFeature_SMART_REPLY
	SuggestionFeature_TYPE_UNSPECIFIED                                                               = src.SuggestionFeature_TYPE_UNSPECIFIED
	TelephonyDtmf_DTMF_A                                                                             = src.TelephonyDtmf_DTMF_A
	TelephonyDtmf_DTMF_B                                                                             = src.TelephonyDtmf_DTMF_B
	TelephonyDtmf_DTMF_C                                                                             = src.TelephonyDtmf_DTMF_C
	TelephonyDtmf_DTMF_D                                                                             = src.TelephonyDtmf_DTMF_D
	TelephonyDtmf_DTMF_EIGHT                                                                         = src.TelephonyDtmf_DTMF_EIGHT
	TelephonyDtmf_DTMF_FIVE                                                                          = src.TelephonyDtmf_DTMF_FIVE
	TelephonyDtmf_DTMF_FOUR                                                                          = src.TelephonyDtmf_DTMF_FOUR
	TelephonyDtmf_DTMF_NINE                                                                          = src.TelephonyDtmf_DTMF_NINE
	TelephonyDtmf_DTMF_ONE                                                                           = src.TelephonyDtmf_DTMF_ONE
	TelephonyDtmf_DTMF_POUND                                                                         = src.TelephonyDtmf_DTMF_POUND
	TelephonyDtmf_DTMF_SEVEN                                                                         = src.TelephonyDtmf_DTMF_SEVEN
	TelephonyDtmf_DTMF_SIX                                                                           = src.TelephonyDtmf_DTMF_SIX
	TelephonyDtmf_DTMF_STAR                                                                          = src.TelephonyDtmf_DTMF_STAR
	TelephonyDtmf_DTMF_THREE                                                                         = src.TelephonyDtmf_DTMF_THREE
	TelephonyDtmf_DTMF_TWO                                                                           = src.TelephonyDtmf_DTMF_TWO
	TelephonyDtmf_DTMF_ZERO                                                                          = src.TelephonyDtmf_DTMF_ZERO
	TelephonyDtmf_TELEPHONY_DTMF_UNSPECIFIED                                                         = src.TelephonyDtmf_TELEPHONY_DTMF_UNSPECIFIED
	ValidationError_CRITICAL                                                                         = src.ValidationError_CRITICAL
	ValidationError_ERROR                                                                            = src.ValidationError_ERROR
	ValidationError_INFO                                                                             = src.ValidationError_INFO
	ValidationError_SEVERITY_UNSPECIFIED                                                             = src.ValidationError_SEVERITY_UNSPECIFIED
	ValidationError_WARNING                                                                          = src.ValidationError_WARNING
	Version_FAILED                                                                                   = src.Version_FAILED
	Version_IN_PROGRESS                                                                              = src.Version_IN_PROGRESS
	Version_READY                                                                                    = src.Version_READY
	Version_VERSION_STATUS_UNSPECIFIED                                                               = src.Version_VERSION_STATUS_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
var (
	AgentAssistantFeedback_AnswerRelevance_name                                              = src.AgentAssistantFeedback_AnswerRelevance_name
	AgentAssistantFeedback_AnswerRelevance_value                                             = src.AgentAssistantFeedback_AnswerRelevance_value
	AgentAssistantFeedback_DocumentCorrectness_name                                          = src.AgentAssistantFeedback_DocumentCorrectness_name
	AgentAssistantFeedback_DocumentCorrectness_value                                         = src.AgentAssistantFeedback_DocumentCorrectness_value
	AgentAssistantFeedback_DocumentEfficiency_name                                           = src.AgentAssistantFeedback_DocumentEfficiency_name
	AgentAssistantFeedback_DocumentEfficiency_value                                          = src.AgentAssistantFeedback_DocumentEfficiency_value
	Agent_ApiVersion_name                                                                    = src.Agent_ApiVersion_name
	Agent_ApiVersion_value                                                                   = src.Agent_ApiVersion_value
	Agent_MatchMode_name                                                                     = src.Agent_MatchMode_name
	Agent_MatchMode_value                                                                    = src.Agent_MatchMode_value
	Agent_Tier_name                                                                          = src.Agent_Tier_name
	Agent_Tier_value                                                                         = src.Agent_Tier_value
	AnswerFeedback_CorrectnessLevel_name                                                     = src.AnswerFeedback_CorrectnessLevel_name
	AnswerFeedback_CorrectnessLevel_value                                                    = src.AnswerFeedback_CorrectnessLevel_value
	AudioEncoding_name                                                                       = src.AudioEncoding_name
	AudioEncoding_value                                                                      = src.AudioEncoding_value
	AutomatedAgentReply_AutomatedAgentReplyType_name                                         = src.AutomatedAgentReply_AutomatedAgentReplyType_name
	AutomatedAgentReply_AutomatedAgentReplyType_value                                        = src.AutomatedAgentReply_AutomatedAgentReplyType_value
	ConversationEvent_Type_name                                                              = src.ConversationEvent_Type_name
	ConversationEvent_Type_value                                                             = src.ConversationEvent_Type_value
	Conversation_ConversationStage_name                                                      = src.Conversation_ConversationStage_name
	Conversation_ConversationStage_value                                                     = src.Conversation_ConversationStage_value
	Conversation_LifecycleState_name                                                         = src.Conversation_LifecycleState_name
	Conversation_LifecycleState_value                                                        = src.Conversation_LifecycleState_value
	Document_KnowledgeType_name                                                              = src.Document_KnowledgeType_name
	Document_KnowledgeType_value                                                             = src.Document_KnowledgeType_value
	Document_State_name                                                                      = src.Document_State_name
	Document_State_value                                                                     = src.Document_State_value
	EntityType_AutoExpansionMode_name                                                        = src.EntityType_AutoExpansionMode_name
	EntityType_AutoExpansionMode_value                                                       = src.EntityType_AutoExpansionMode_value
	EntityType_Kind_name                                                                     = src.EntityType_Kind_name
	EntityType_Kind_value                                                                    = src.EntityType_Kind_value
	Environment_State_name                                                                   = src.Environment_State_name
	Environment_State_value                                                                  = src.Environment_State_value
	File_google_cloud_dialogflow_v2beta1_agent_proto                                         = src.File_google_cloud_dialogflow_v2beta1_agent_proto
	File_google_cloud_dialogflow_v2beta1_answer_record_proto                                 = src.File_google_cloud_dialogflow_v2beta1_answer_record_proto
	File_google_cloud_dialogflow_v2beta1_audio_config_proto                                  = src.File_google_cloud_dialogflow_v2beta1_audio_config_proto
	File_google_cloud_dialogflow_v2beta1_context_proto                                       = src.File_google_cloud_dialogflow_v2beta1_context_proto
	File_google_cloud_dialogflow_v2beta1_conversation_event_proto                            = src.File_google_cloud_dialogflow_v2beta1_conversation_event_proto
	File_google_cloud_dialogflow_v2beta1_conversation_profile_proto                          = src.File_google_cloud_dialogflow_v2beta1_conversation_profile_proto
	File_google_cloud_dialogflow_v2beta1_conversation_proto                                  = src.File_google_cloud_dialogflow_v2beta1_conversation_proto
	File_google_cloud_dialogflow_v2beta1_document_proto                                      = src.File_google_cloud_dialogflow_v2beta1_document_proto
	File_google_cloud_dialogflow_v2beta1_entity_type_proto                                   = src.File_google_cloud_dialogflow_v2beta1_entity_type_proto
	File_google_cloud_dialogflow_v2beta1_environment_proto                                   = src.File_google_cloud_dialogflow_v2beta1_environment_proto
	File_google_cloud_dialogflow_v2beta1_fulfillment_proto                                   = src.File_google_cloud_dialogflow_v2beta1_fulfillment_proto
	File_google_cloud_dialogflow_v2beta1_gcs_proto                                           = src.File_google_cloud_dialogflow_v2beta1_gcs_proto
	File_google_cloud_dialogflow_v2beta1_human_agent_assistant_event_proto                   = src.File_google_cloud_dialogflow_v2beta1_human_agent_assistant_event_proto
	File_google_cloud_dialogflow_v2beta1_intent_proto                                        = src.File_google_cloud_dialogflow_v2beta1_intent_proto
	File_google_cloud_dialogflow_v2beta1_knowledge_base_proto                                = src.File_google_cloud_dialogflow_v2beta1_knowledge_base_proto
	File_google_cloud_dialogflow_v2beta1_participant_proto                                   = src.File_google_cloud_dialogflow_v2beta1_participant_proto
	File_google_cloud_dialogflow_v2beta1_session_entity_type_proto                           = src.File_google_cloud_dialogflow_v2beta1_session_entity_type_proto
	File_google_cloud_dialogflow_v2beta1_session_proto                                       = src.File_google_cloud_dialogflow_v2beta1_session_proto
	File_google_cloud_dialogflow_v2beta1_validation_result_proto                             = src.File_google_cloud_dialogflow_v2beta1_validation_result_proto
	File_google_cloud_dialogflow_v2beta1_version_proto                                       = src.File_google_cloud_dialogflow_v2beta1_version_proto
	File_google_cloud_dialogflow_v2beta1_webhook_proto                                       = src.File_google_cloud_dialogflow_v2beta1_webhook_proto
	Fulfillment_Feature_Type_name                                                            = src.Fulfillment_Feature_Type_name
	Fulfillment_Feature_Type_value                                                           = src.Fulfillment_Feature_Type_value
	IntentView_name                                                                          = src.IntentView_name
	IntentView_value                                                                         = src.IntentView_value
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_name  = src.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_name
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_value = src.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_value
	Intent_Message_BrowseCarouselCard_ImageDisplayOptions_name                               = src.Intent_Message_BrowseCarouselCard_ImageDisplayOptions_name
	Intent_Message_BrowseCarouselCard_ImageDisplayOptions_value                              = src.Intent_Message_BrowseCarouselCard_ImageDisplayOptions_value
	Intent_Message_ColumnProperties_HorizontalAlignment_name                                 = src.Intent_Message_ColumnProperties_HorizontalAlignment_name
	Intent_Message_ColumnProperties_HorizontalAlignment_value                                = src.Intent_Message_ColumnProperties_HorizontalAlignment_value
	Intent_Message_MediaContent_ResponseMediaType_name                                       = src.Intent_Message_MediaContent_ResponseMediaType_name
	Intent_Message_MediaContent_ResponseMediaType_value                                      = src.Intent_Message_MediaContent_ResponseMediaType_value
	Intent_Message_Platform_name                                                             = src.Intent_Message_Platform_name
	Intent_Message_Platform_value                                                            = src.Intent_Message_Platform_value
	Intent_Message_RbmCardContent_RbmMedia_Height_name                                       = src.Intent_Message_RbmCardContent_RbmMedia_Height_name
	Intent_Message_RbmCardContent_RbmMedia_Height_value                                      = src.Intent_Message_RbmCardContent_RbmMedia_Height_value
	Intent_Message_RbmCarouselCard_CardWidth_name                                            = src.Intent_Message_RbmCarouselCard_CardWidth_name
	Intent_Message_RbmCarouselCard_CardWidth_value                                           = src.Intent_Message_RbmCarouselCard_CardWidth_value
	Intent_Message_RbmStandaloneCard_CardOrientation_name                                    = src.Intent_Message_RbmStandaloneCard_CardOrientation_name
	Intent_Message_RbmStandaloneCard_CardOrientation_value                                   = src.Intent_Message_RbmStandaloneCard_CardOrientation_value
	Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_name                            = src.Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_name
	Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_value                           = src.Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment_value
	Intent_TrainingPhrase_Type_name                                                          = src.Intent_TrainingPhrase_Type_name
	Intent_TrainingPhrase_Type_value                                                         = src.Intent_TrainingPhrase_Type_value
	Intent_WebhookState_name                                                                 = src.Intent_WebhookState_name
	Intent_WebhookState_value                                                                = src.Intent_WebhookState_value
	KnowledgeAnswers_Answer_MatchConfidenceLevel_name                                        = src.KnowledgeAnswers_Answer_MatchConfidenceLevel_name
	KnowledgeAnswers_Answer_MatchConfidenceLevel_value                                       = src.KnowledgeAnswers_Answer_MatchConfidenceLevel_value
	KnowledgeOperationMetadata_State_name                                                    = src.KnowledgeOperationMetadata_State_name
	KnowledgeOperationMetadata_State_value                                                   = src.KnowledgeOperationMetadata_State_value
	NotificationConfig_MessageFormat_name                                                    = src.NotificationConfig_MessageFormat_name
	NotificationConfig_MessageFormat_value                                                   = src.NotificationConfig_MessageFormat_value
	OutputAudioEncoding_name                                                                 = src.OutputAudioEncoding_name
	OutputAudioEncoding_value                                                                = src.OutputAudioEncoding_value
	Participant_Role_name                                                                    = src.Participant_Role_name
	Participant_Role_value                                                                   = src.Participant_Role_value
	SessionEntityType_EntityOverrideMode_name                                                = src.SessionEntityType_EntityOverrideMode_name
	SessionEntityType_EntityOverrideMode_value                                               = src.SessionEntityType_EntityOverrideMode_value
	SpeechModelVariant_name                                                                  = src.SpeechModelVariant_name
	SpeechModelVariant_value                                                                 = src.SpeechModelVariant_value
	SsmlVoiceGender_name                                                                     = src.SsmlVoiceGender_name
	SsmlVoiceGender_value                                                                    = src.SsmlVoiceGender_value
	StreamingRecognitionResult_MessageType_name                                              = src.StreamingRecognitionResult_MessageType_name
	StreamingRecognitionResult_MessageType_value                                             = src.StreamingRecognitionResult_MessageType_value
	SuggestionFeature_Type_name                                                              = src.SuggestionFeature_Type_name
	SuggestionFeature_Type_value                                                             = src.SuggestionFeature_Type_value
	TelephonyDtmf_name                                                                       = src.TelephonyDtmf_name
	TelephonyDtmf_value                                                                      = src.TelephonyDtmf_value
	ValidationError_Severity_name                                                            = src.ValidationError_Severity_name
	ValidationError_Severity_value                                                           = src.ValidationError_Severity_value
	Version_VersionStatus_name                                                               = src.Version_VersionStatus_name
	Version_VersionStatus_value                                                              = src.Version_VersionStatus_value
)

// A Dialogflow agent is a virtual agent that handles conversations with your
// end-users. It is a natural language understanding module that understands
// the nuances of human language. Dialogflow translates end-user text or audio
// during a conversation to structured data that your apps and services can
// understand. You design and build a Dialogflow agent to handle the types of
// conversations required for your system. For more information about agents,
// see the [Agent
// guide](https://cloud.google.com/dialogflow/docs/agents-overview).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Agent = src.Agent

// Detail feedback of Agent Assistant result.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AgentAssistantFeedback = src.AgentAssistantFeedback

// Relevance of an answer.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AgentAssistantFeedback_AnswerRelevance = src.AgentAssistantFeedback_AnswerRelevance

// Correctness of document.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AgentAssistantFeedback_DocumentCorrectness = src.AgentAssistantFeedback_DocumentCorrectness

// Efficiency of document.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AgentAssistantFeedback_DocumentEfficiency = src.AgentAssistantFeedback_DocumentEfficiency

// Feedback for conversation summarization.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AgentAssistantFeedback_SummarizationFeedback = src.AgentAssistantFeedback_SummarizationFeedback

// Represents a record of a human agent assistant answer.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AgentAssistantRecord = src.AgentAssistantRecord
type AgentAssistantRecord_ArticleSuggestionAnswer = src.AgentAssistantRecord_ArticleSuggestionAnswer
type AgentAssistantRecord_FaqAnswer = src.AgentAssistantRecord_FaqAnswer

// API version for the agent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Agent_ApiVersion = src.Agent_ApiVersion

// Match mode determines how intents are detected from user queries.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Agent_MatchMode = src.Agent_MatchMode

// Represents the agent tier.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Agent_Tier = src.Agent_Tier

// AgentsClient is the client API for Agents service. For semantics around ctx
// use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AgentsClient = src.AgentsClient

// AgentsServer is the server API for Agents service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AgentsServer = src.AgentsServer

// The request message for
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AnalyzeContentRequest = src.AnalyzeContentRequest
type AnalyzeContentRequest_AudioInput = src.AnalyzeContentRequest_AudioInput
type AnalyzeContentRequest_EventInput = src.AnalyzeContentRequest_EventInput
type AnalyzeContentRequest_TextInput = src.AnalyzeContentRequest_TextInput

// The response message for
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AnalyzeContentResponse = src.AnalyzeContentResponse

// Represents a part of a message possibly annotated with an entity. The part
// can be an entity or purely a part of the message between two entities or
// message start/end.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AnnotatedMessagePart = src.AnnotatedMessagePart

// Represents feedback the customer has about the quality & correctness of a
// certain answer in a conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AnswerFeedback = src.AnswerFeedback
type AnswerFeedback_AgentAssistantDetailFeedback = src.AnswerFeedback_AgentAssistantDetailFeedback

// The correctness level of an answer.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AnswerFeedback_CorrectnessLevel = src.AnswerFeedback_CorrectnessLevel

// Answer records are records to manage answer history and feedbacks for
// Dialogflow. Currently, answer record includes: - human agent assistant
// article suggestion - human agent assistant faq article It doesn't include: -
// `DetectIntent` intent matching - `DetectIntent` knowledge Answer records are
// not related to the conversation history in the Dialogflow Console. A Record
// is generated even when the end-user disables conversation history in the
// console. Records are created when there's a human agent assistant suggestion
// generated. A typical workflow for customers provide feedback to an answer
// is: 1. For human agent assistant, customers get suggestion via
// ListSuggestions API. Together with the answers,
// [AnswerRecord.name][google.cloud.dialogflow.v2beta1.AnswerRecord.name] are
// returned to the customers. 2. The customer uses the
// [AnswerRecord.name][google.cloud.dialogflow.v2beta1.AnswerRecord.name] to
// call the [UpdateAnswerRecord][] method to send feedback about a specific
// answer that they believe is wrong.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AnswerRecord = src.AnswerRecord
type AnswerRecord_AgentAssistantRecord = src.AnswerRecord_AgentAssistantRecord

// AnswerRecordsClient is the client API for AnswerRecords service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AnswerRecordsClient = src.AnswerRecordsClient

// AnswerRecordsServer is the server API for AnswerRecords service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AnswerRecordsServer = src.AnswerRecordsServer

// Represents article answer.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ArticleAnswer = src.ArticleAnswer

// Represents the parameters of human assist query.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AssistQueryParameters = src.AssistQueryParameters

// Audio encoding of the audio content sent in the conversational query
// request. Refer to the [Cloud Speech API
// documentation](https://cloud.google.com/speech-to-text/docs/basics) for more
// details.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AudioEncoding = src.AudioEncoding

// Represents the natural language speech audio to be processed.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AudioInput = src.AudioInput

// Defines the Automated Agent to connect to a conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AutomatedAgentConfig = src.AutomatedAgentConfig

// Represents a response from an automated agent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AutomatedAgentReply = src.AutomatedAgentReply

// Represents different automated agent reply types.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type AutomatedAgentReply_AutomatedAgentReplyType = src.AutomatedAgentReply_AutomatedAgentReplyType
type AutomatedAgentReply_DetectIntentResponse = src.AutomatedAgentReply_DetectIntentResponse
type AutomatedAgentReply_Event = src.AutomatedAgentReply_Event
type AutomatedAgentReply_Intent = src.AutomatedAgentReply_Intent

// The request message for
// [EntityTypes.BatchCreateEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchCreateEntities].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchCreateEntitiesRequest = src.BatchCreateEntitiesRequest

// The request message for [Conversations.BatchCreateMessagesRequest][].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchCreateMessagesRequest = src.BatchCreateMessagesRequest

// The request message for [Conversations.BatchCreateMessagesResponse][].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchCreateMessagesResponse = src.BatchCreateMessagesResponse

// The request message for
// [EntityTypes.BatchDeleteEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchDeleteEntities].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchDeleteEntitiesRequest = src.BatchDeleteEntitiesRequest

// The request message for
// [EntityTypes.BatchDeleteEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchDeleteEntityTypes].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchDeleteEntityTypesRequest = src.BatchDeleteEntityTypesRequest

// The request message for
// [Intents.BatchDeleteIntents][google.cloud.dialogflow.v2beta1.Intents.BatchDeleteIntents].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchDeleteIntentsRequest = src.BatchDeleteIntentsRequest

// The request message for
// [EntityTypes.BatchUpdateEntities][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntities].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchUpdateEntitiesRequest = src.BatchUpdateEntitiesRequest

// The request message for
// [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchUpdateEntityTypesRequest = src.BatchUpdateEntityTypesRequest
type BatchUpdateEntityTypesRequest_EntityTypeBatchInline = src.BatchUpdateEntityTypesRequest_EntityTypeBatchInline
type BatchUpdateEntityTypesRequest_EntityTypeBatchUri = src.BatchUpdateEntityTypesRequest_EntityTypeBatchUri

// The response message for
// [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchUpdateEntityTypesResponse = src.BatchUpdateEntityTypesResponse

// The request message for
// [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchUpdateIntentsRequest = src.BatchUpdateIntentsRequest
type BatchUpdateIntentsRequest_IntentBatchInline = src.BatchUpdateIntentsRequest_IntentBatchInline
type BatchUpdateIntentsRequest_IntentBatchUri = src.BatchUpdateIntentsRequest_IntentBatchUri

// The response message for
// [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type BatchUpdateIntentsResponse = src.BatchUpdateIntentsResponse

// Metadata for a [ConversationProfile.ClearSuggestionFeatureConfig][]
// operation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ClearSuggestionFeatureConfigOperationMetadata = src.ClearSuggestionFeatureConfigOperationMetadata

// The request message for [ConversationProfiles.ClearFeature][].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ClearSuggestionFeatureConfigRequest = src.ClearSuggestionFeatureConfigRequest

// The request message for
// [Participants.CompileSuggestion][google.cloud.dialogflow.v2beta1.Participants.CompileSuggestion].
// Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CompileSuggestionRequest = src.CompileSuggestionRequest

// The response message for
// [Participants.CompileSuggestion][google.cloud.dialogflow.v2beta1.Participants.CompileSuggestion].
// Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CompileSuggestionResponse = src.CompileSuggestionResponse

// The request message for
// [Conversations.CompleteConversation][google.cloud.dialogflow.v2beta1.Conversations.CompleteConversation].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CompleteConversationRequest = src.CompleteConversationRequest

// Dialogflow contexts are similar to natural language context. If a person
// says to you "they are orange", you need context in order to understand what
// "they" is referring to. Similarly, for Dialogflow to handle an end-user
// expression like that, it needs to be provided with context in order to
// correctly match an intent. Using contexts, you can control the flow of a
// conversation. You can configure contexts for an intent by setting input and
// output contexts, which are identified by string names. When an intent is
// matched, any configured output contexts for that intent become active. While
// any contexts are active, Dialogflow is more likely to match intents that are
// configured with input contexts that correspond to the currently active
// contexts. For more information about context, see the [Contexts
// guide](https://cloud.google.com/dialogflow/docs/contexts-overview).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Context = src.Context

// ContextsClient is the client API for Contexts service. For semantics around
// ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ContextsClient = src.ContextsClient

// ContextsServer is the server API for Contexts service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ContextsServer = src.ContextsServer

// Represents a conversation. A conversation is an interaction between an
// agent, including live agents and Dialogflow agents, and a support customer.
// Conversations can include phone calls and text-based chat sessions.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Conversation = src.Conversation

// Represents a notification sent to Pub/Sub subscribers for conversation
// lifecycle events.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ConversationEvent = src.ConversationEvent
type ConversationEvent_NewMessagePayload = src.ConversationEvent_NewMessagePayload

// Enumeration of the types of events available.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ConversationEvent_Type = src.ConversationEvent_Type

// Represents a phone number for telephony integration. It allows for
// connecting a particular conversation over telephony.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ConversationPhoneNumber = src.ConversationPhoneNumber

// Defines the services to connect to incoming Dialogflow conversations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ConversationProfile = src.ConversationProfile

// ConversationProfilesClient is the client API for ConversationProfiles
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ConversationProfilesClient = src.ConversationProfilesClient

// ConversationProfilesServer is the server API for ConversationProfiles
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ConversationProfilesServer = src.ConversationProfilesServer

// Enumeration of the different conversation stages a conversation can be in.
// Reference:
// https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Conversation_ConversationStage = src.Conversation_ConversationStage

// Enumeration of the completion status of the conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Conversation_LifecycleState = src.Conversation_LifecycleState

// ConversationsClient is the client API for Conversations service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ConversationsClient = src.ConversationsClient

// ConversationsServer is the server API for Conversations service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ConversationsServer = src.ConversationsServer

// The request message for
// [Contexts.CreateContext][google.cloud.dialogflow.v2beta1.Contexts.CreateContext].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateContextRequest = src.CreateContextRequest

// The request message for
// [ConversationProfiles.CreateConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.CreateConversationProfile].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateConversationProfileRequest = src.CreateConversationProfileRequest

// The request message for
// [Conversations.CreateConversation][google.cloud.dialogflow.v2beta1.Conversations.CreateConversation].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateConversationRequest = src.CreateConversationRequest

// Request message for
// [Documents.CreateDocument][google.cloud.dialogflow.v2beta1.Documents.CreateDocument].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateDocumentRequest = src.CreateDocumentRequest

// The request message for
// [EntityTypes.CreateEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.CreateEntityType].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateEntityTypeRequest = src.CreateEntityTypeRequest

// The request message for
// [Environments.CreateEnvironment][google.cloud.dialogflow.v2beta1.Environments.CreateEnvironment].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateEnvironmentRequest = src.CreateEnvironmentRequest

// The request message for
// [Intents.CreateIntent][google.cloud.dialogflow.v2beta1.Intents.CreateIntent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateIntentRequest = src.CreateIntentRequest

// Request message for
// [KnowledgeBases.CreateKnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBases.CreateKnowledgeBase].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateKnowledgeBaseRequest = src.CreateKnowledgeBaseRequest

// The request message to create one Message. Currently it is only used in
// BatchCreateMessagesRequest.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateMessageRequest = src.CreateMessageRequest

// The request message for
// [Participants.CreateParticipant][google.cloud.dialogflow.v2beta1.Participants.CreateParticipant].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateParticipantRequest = src.CreateParticipantRequest

// The request message for
// [SessionEntityTypes.CreateSessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityTypes.CreateSessionEntityType].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateSessionEntityTypeRequest = src.CreateSessionEntityTypeRequest

// The request message for
// [Versions.CreateVersion][google.cloud.dialogflow.v2beta1.Versions.CreateVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type CreateVersionRequest = src.CreateVersionRequest

// The request message for
// [Agents.DeleteAgent][google.cloud.dialogflow.v2beta1.Agents.DeleteAgent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteAgentRequest = src.DeleteAgentRequest

// The request message for
// [Contexts.DeleteAllContexts][google.cloud.dialogflow.v2beta1.Contexts.DeleteAllContexts].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteAllContextsRequest = src.DeleteAllContextsRequest

// The request message for
// [Contexts.DeleteContext][google.cloud.dialogflow.v2beta1.Contexts.DeleteContext].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteContextRequest = src.DeleteContextRequest

// The request message for
// [ConversationProfiles.DeleteConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.DeleteConversationProfile].
// This operation fails if the conversation profile is still referenced from a
// phone number.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteConversationProfileRequest = src.DeleteConversationProfileRequest

// Request message for
// [Documents.DeleteDocument][google.cloud.dialogflow.v2beta1.Documents.DeleteDocument].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteDocumentRequest = src.DeleteDocumentRequest

// The request message for
// [EntityTypes.DeleteEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.DeleteEntityType].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteEntityTypeRequest = src.DeleteEntityTypeRequest

// The request message for
// [Environments.DeleteEnvironment][google.cloud.dialogflow.v2beta1.Environments.DeleteEnvironment].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteEnvironmentRequest = src.DeleteEnvironmentRequest

// The request message for
// [Intents.DeleteIntent][google.cloud.dialogflow.v2beta1.Intents.DeleteIntent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteIntentRequest = src.DeleteIntentRequest

// Request message for
// [KnowledgeBases.DeleteKnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBases.DeleteKnowledgeBase].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteKnowledgeBaseRequest = src.DeleteKnowledgeBaseRequest

// The request message for
// [SessionEntityTypes.DeleteSessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityTypes.DeleteSessionEntityType].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteSessionEntityTypeRequest = src.DeleteSessionEntityTypeRequest

// The request message for
// [Versions.DeleteVersion][google.cloud.dialogflow.v2beta1.Versions.DeleteVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DeleteVersionRequest = src.DeleteVersionRequest

// The request to detect user's intent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DetectIntentRequest = src.DetectIntentRequest

// The message returned from the DetectIntent method.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DetectIntentResponse = src.DetectIntentResponse

// A knowledge document to be used by a
// [KnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBase]. For more
// information, see the [knowledge base
// guide](https://cloud.google.com/dialogflow/docs/how/knowledge-bases). Note:
// The `projects.agent.knowledgeBases.documents` resource is deprecated; only
// use `projects.knowledgeBases.documents`.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Document = src.Document
type Document_Content = src.Document_Content
type Document_ContentUri = src.Document_ContentUri

// The knowledge type of document content.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Document_KnowledgeType = src.Document_KnowledgeType
type Document_RawContent = src.Document_RawContent

// The status of a reload attempt.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Document_ReloadStatus = src.Document_ReloadStatus

// Possible states of the document
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Document_State = src.Document_State

// DocumentsClient is the client API for Documents service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DocumentsClient = src.DocumentsClient

// DocumentsServer is the server API for Documents service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DocumentsServer = src.DocumentsServer

// The message in the response that indicates the parameters of DTMF.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type DtmfParameters = src.DtmfParameters

// Each intent parameter has a type, called the entity type, which dictates
// exactly how data from an end-user expression is extracted. Dialogflow
// provides predefined system entities that can match many common types of
// data. For example, there are system entities for matching dates, times,
// colors, email addresses, and so on. You can also create your own custom
// entities for matching custom data. For example, you could define a vegetable
// entity that can match the types of vegetables available for purchase with a
// grocery store agent. For more information, see the [Entity
// guide](https://cloud.google.com/dialogflow/docs/entities-overview).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EntityType = src.EntityType

// This message is a wrapper around a collection of entity types.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EntityTypeBatch = src.EntityTypeBatch

// Represents different entity type expansion modes. Automated expansion
// allows an agent to recognize values that have not been explicitly listed in
// the entity (for example, new kinds of shopping list items).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EntityType_AutoExpansionMode = src.EntityType_AutoExpansionMode

// An **entity entry** for an associated entity type.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EntityType_Entity = src.EntityType_Entity

// Represents kinds of entities.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EntityType_Kind = src.EntityType_Kind

// EntityTypesClient is the client API for EntityTypes service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EntityTypesClient = src.EntityTypesClient

// EntityTypesServer is the server API for EntityTypes service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EntityTypesServer = src.EntityTypesServer

// You can create multiple versions of your agent and publish them to separate
// environments. When you edit an agent, you are editing the draft agent. At
// any point, you can save the draft agent as an agent version, which is an
// immutable snapshot of your agent. When you save the draft agent, it is
// published to the default environment. When you create agent versions, you
// can publish them to custom environments. You can create a variety of custom
// environments for: - testing - development - production - etc. For more
// information, see the [versions and environments
// guide](https://cloud.google.com/dialogflow/docs/agents-versions).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Environment = src.Environment

// The response message for
// [Environments.GetEnvironmentHistory][google.cloud.dialogflow.v2beta1.Environments.GetEnvironmentHistory].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EnvironmentHistory = src.EnvironmentHistory

// Represents an environment history entry.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EnvironmentHistory_Entry = src.EnvironmentHistory_Entry

// Represents an environment state. When an environment is pointed to a new
// agent version, the environment is temporarily set to the `LOADING` state.
// During that time, the environment keeps on serving the previous version of
// the agent. After the new agent version is done loading, the environment is
// set back to the `RUNNING` state.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Environment_State = src.Environment_State

// EnvironmentsClient is the client API for Environments service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EnvironmentsClient = src.EnvironmentsClient

// EnvironmentsServer is the server API for Environments service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EnvironmentsServer = src.EnvironmentsServer

// Events allow for matching intents by event name instead of the natural
// language input. For instance, input `<event: { name: "welcome_event",
// parameters: { name: "Sam" } }>` can trigger a personalized welcome response.
// The parameter `name` may be used by the agent in the response: `"Hello
// #welcome_event.name! What can I do for you today?"`.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type EventInput = src.EventInput

// The request message for
// [Agents.ExportAgent][google.cloud.dialogflow.v2beta1.Agents.ExportAgent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ExportAgentRequest = src.ExportAgentRequest

// The response message for
// [Agents.ExportAgent][google.cloud.dialogflow.v2beta1.Agents.ExportAgent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ExportAgentResponse = src.ExportAgentResponse
type ExportAgentResponse_AgentContent = src.ExportAgentResponse_AgentContent
type ExportAgentResponse_AgentUri = src.ExportAgentResponse_AgentUri

// Metadata related to the Export Data Operations (e.g. ExportDocument).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ExportOperationMetadata = src.ExportOperationMetadata

// Represents answer from "frequently asked questions".
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type FaqAnswer = src.FaqAnswer

// By default, your agent responds to a matched intent with a static response.
// As an alternative, you can provide a more dynamic response by using
// fulfillment. When you enable fulfillment for an intent, Dialogflow responds
// to that intent by calling a service that you define. For example, if an
// end-user wants to schedule a haircut on Friday, your service can check your
// database and respond to the end-user with availability information for
// Friday. For more information, see the [fulfillment
// guide](https://cloud.google.com/dialogflow/docs/fulfillment-overview).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Fulfillment = src.Fulfillment

// Whether fulfillment is enabled for the specific feature.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Fulfillment_Feature = src.Fulfillment_Feature

// The type of the feature.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Fulfillment_Feature_Type = src.Fulfillment_Feature_Type

// Represents configuration for a generic web service. Dialogflow supports two
// mechanisms for authentications: - Basic authentication with username and
// password. - Authentication with additional authentication headers. More
// information could be found at:
// https://cloud.google.com/dialogflow/docs/fulfillment-configure.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Fulfillment_GenericWebService = src.Fulfillment_GenericWebService
type Fulfillment_GenericWebService_ = src.Fulfillment_GenericWebService_

// FulfillmentsClient is the client API for Fulfillments service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type FulfillmentsClient = src.FulfillmentsClient

// FulfillmentsServer is the server API for Fulfillments service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type FulfillmentsServer = src.FulfillmentsServer

// Google Cloud Storage location for the output.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GcsDestination = src.GcsDestination

// Google Cloud Storage location for single input.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GcsSource = src.GcsSource

// Google Cloud Storage locations for the inputs.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GcsSources = src.GcsSources

// The request message for
// [Agents.GetAgent][google.cloud.dialogflow.v2beta1.Agents.GetAgent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetAgentRequest = src.GetAgentRequest

// Request message for
// [AnswerRecords.GetAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.GetAnswerRecord].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetAnswerRecordRequest = src.GetAnswerRecordRequest

// The request message for
// [Contexts.GetContext][google.cloud.dialogflow.v2beta1.Contexts.GetContext].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetContextRequest = src.GetContextRequest

// The request message for
// [ConversationProfiles.GetConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.GetConversationProfile].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetConversationProfileRequest = src.GetConversationProfileRequest

// The request message for
// [Conversations.GetConversation][google.cloud.dialogflow.v2beta1.Conversations.GetConversation].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetConversationRequest = src.GetConversationRequest

// Request message for
// [Documents.GetDocument][google.cloud.dialogflow.v2beta1.Documents.GetDocument].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetDocumentRequest = src.GetDocumentRequest

// The request message for
// [EntityTypes.GetEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.GetEntityType].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetEntityTypeRequest = src.GetEntityTypeRequest

// The request message for
// [Environments.GetEnvironmentHistory][google.cloud.dialogflow.v2beta1.Environments.GetEnvironmentHistory].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetEnvironmentHistoryRequest = src.GetEnvironmentHistoryRequest

// The request message for
// [Environments.GetEnvironment][google.cloud.dialogflow.v2beta1.Environments.GetEnvironment].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetEnvironmentRequest = src.GetEnvironmentRequest

// The request message for
// [Fulfillments.GetFulfillment][google.cloud.dialogflow.v2beta1.Fulfillments.GetFulfillment].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetFulfillmentRequest = src.GetFulfillmentRequest

// The request message for
// [Intents.GetIntent][google.cloud.dialogflow.v2beta1.Intents.GetIntent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetIntentRequest = src.GetIntentRequest

// Request message for
// [KnowledgeBases.GetKnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBases.GetKnowledgeBase].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetKnowledgeBaseRequest = src.GetKnowledgeBaseRequest

// The request message for
// [Participants.GetParticipant][google.cloud.dialogflow.v2beta1.Participants.GetParticipant].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetParticipantRequest = src.GetParticipantRequest

// The request message for
// [SessionEntityTypes.GetSessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityTypes.GetSessionEntityType].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetSessionEntityTypeRequest = src.GetSessionEntityTypeRequest

// The request message for
// [Agents.GetValidationResult][google.cloud.dialogflow.v2beta1.Agents.GetValidationResult].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetValidationResultRequest = src.GetValidationResultRequest

// The request message for
// [Versions.GetVersion][google.cloud.dialogflow.v2beta1.Versions.GetVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type GetVersionRequest = src.GetVersionRequest

// Defines the Human Agent Assistant to connect to a conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig = src.HumanAgentAssistantConfig

// Custom conversation models used in agent assist feature. Supported feature:
// ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY, CONVERSATION_SUMMARIZATION.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_ConversationModelConfig = src.HumanAgentAssistantConfig_ConversationModelConfig

// Config to process conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_ConversationProcessConfig = src.HumanAgentAssistantConfig_ConversationProcessConfig

// Configuration for analyses to run on each conversation message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_MessageAnalysisConfig = src.HumanAgentAssistantConfig_MessageAnalysisConfig

// Detail human agent assistant config.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_SuggestionConfig = src.HumanAgentAssistantConfig_SuggestionConfig

// Config for suggestion features.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_SuggestionFeatureConfig = src.HumanAgentAssistantConfig_SuggestionFeatureConfig

// Config for suggestion query.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_SuggestionQueryConfig = src.HumanAgentAssistantConfig_SuggestionQueryConfig

// Settings that determine how to filter recent conversation context when
// generating suggestions.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings = src.HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings

// Dialogflow source setting. Supported feature: DIALOGFLOW_ASSIST.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource = src.HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource
type HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_ = src.HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_

// Document source settings. Supported features: SMART_REPLY, SMART_COMPOSE.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource = src.HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource
type HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_ = src.HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_

// Knowledge base source settings. Supported features: ARTICLE_SUGGESTION,
// FAQ.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource = src.HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource
type HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_ = src.HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_

// Settings of suggestion trigger.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantConfig_SuggestionTriggerSettings = src.HumanAgentAssistantConfig_SuggestionTriggerSettings

// Output only. Represents a notification sent to Pub/Sub subscribers for
// agent assistant events in a specific conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentAssistantEvent = src.HumanAgentAssistantEvent

// Defines the hand off to a live agent, typically on which external agent
// service provider to connect to a conversation. Currently, this feature is
// not general available, please contact Google to get access.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentHandoffConfig = src.HumanAgentHandoffConfig

// Configuration specific to LivePerson (https://www.liveperson.com).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentHandoffConfig_LivePersonConfig = src.HumanAgentHandoffConfig_LivePersonConfig
type HumanAgentHandoffConfig_LivePersonConfig_ = src.HumanAgentHandoffConfig_LivePersonConfig_

// Configuration specific to Salesforce Live Agent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type HumanAgentHandoffConfig_SalesforceLiveAgentConfig = src.HumanAgentHandoffConfig_SalesforceLiveAgentConfig
type HumanAgentHandoffConfig_SalesforceLiveAgentConfig_ = src.HumanAgentHandoffConfig_SalesforceLiveAgentConfig_

// The request message for
// [Agents.ImportAgent][google.cloud.dialogflow.v2beta1.Agents.ImportAgent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ImportAgentRequest = src.ImportAgentRequest
type ImportAgentRequest_AgentContent = src.ImportAgentRequest_AgentContent
type ImportAgentRequest_AgentUri = src.ImportAgentRequest_AgentUri

// The template used for importing documents.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ImportDocumentTemplate = src.ImportDocumentTemplate

// Request message for
// [Documents.ImportDocuments][google.cloud.dialogflow.v2beta1.Documents.ImportDocuments].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ImportDocumentsRequest = src.ImportDocumentsRequest
type ImportDocumentsRequest_GcsSource = src.ImportDocumentsRequest_GcsSource

// Response message for
// [Documents.ImportDocuments][google.cloud.dialogflow.v2beta1.Documents.ImportDocuments].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ImportDocumentsResponse = src.ImportDocumentsResponse

// Instructs the speech recognizer on how to process the audio content.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type InputAudioConfig = src.InputAudioConfig

// Defines the language used in the input text.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type InputTextConfig = src.InputTextConfig

// An intent categorizes an end-user's intention for one conversation turn.
// For each agent, you define many intents, where your combined intents can
// handle a complete conversation. When an end-user writes or says something,
// referred to as an end-user expression or end-user input, Dialogflow matches
// the end-user input to the best intent in your agent. Matching an intent is
// also known as intent classification. For more information, see the [intent
// guide](https://cloud.google.com/dialogflow/docs/intents-overview).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent = src.Intent

// This message is a wrapper around a collection of intents.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type IntentBatch = src.IntentBatch

// Represents the options for views of an intent. An intent can be a sizable
// object. Therefore, we provide a resource view that does not return training
// phrases in the response by default.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type IntentView = src.IntentView

// Represents a single followup intent in the chain.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_FollowupIntentInfo = src.Intent_FollowupIntentInfo

// Corresponds to the `Response` field in the Dialogflow console.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message = src.Intent_Message

// The basic card message. Useful for displaying information.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_BasicCard = src.Intent_Message_BasicCard
type Intent_Message_BasicCard_ = src.Intent_Message_BasicCard_

// The button object that appears at the bottom of a card.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_BasicCard_Button = src.Intent_Message_BasicCard_Button

// Opens the given URI.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_BasicCard_Button_OpenUriAction = src.Intent_Message_BasicCard_Button_OpenUriAction

// Browse Carousel Card for Actions on Google.
// https://developers.google.com/actions/assistant/responses#browsing_carousel
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_BrowseCarouselCard = src.Intent_Message_BrowseCarouselCard
type Intent_Message_BrowseCarouselCard_ = src.Intent_Message_BrowseCarouselCard_

// Browsing carousel tile
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem = src.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem

// Actions on Google action to open a given url.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction = src.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction

// Type of the URI.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint = src.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint

// Image display options for Actions on Google. This should be used for when
// the image's aspect ratio does not match the image container's aspect ratio.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_BrowseCarouselCard_ImageDisplayOptions = src.Intent_Message_BrowseCarouselCard_ImageDisplayOptions

// The card response message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_Card = src.Intent_Message_Card
type Intent_Message_Card_ = src.Intent_Message_Card_

// Optional. Contains information about a button.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_Card_Button = src.Intent_Message_Card_Button

// The card for presenting a carousel of options to select from.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_CarouselSelect = src.Intent_Message_CarouselSelect
type Intent_Message_CarouselSelect_ = src.Intent_Message_CarouselSelect_

// An item in the carousel.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_CarouselSelect_Item = src.Intent_Message_CarouselSelect_Item

// Column properties for
// [TableCard][google.cloud.dialogflow.v2beta1.Intent.Message.TableCard].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_ColumnProperties = src.Intent_Message_ColumnProperties

// Text alignments within a cell.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_ColumnProperties_HorizontalAlignment = src.Intent_Message_ColumnProperties_HorizontalAlignment

// The image response message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_Image = src.Intent_Message_Image
type Intent_Message_Image_ = src.Intent_Message_Image_

// The suggestion chip message that allows the user to jump out to the app or
// website associated with this agent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_LinkOutSuggestion = src.Intent_Message_LinkOutSuggestion
type Intent_Message_LinkOutSuggestion_ = src.Intent_Message_LinkOutSuggestion_

// The card for presenting a list of options to select from.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_ListSelect = src.Intent_Message_ListSelect
type Intent_Message_ListSelect_ = src.Intent_Message_ListSelect_

// An item in the list.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_ListSelect_Item = src.Intent_Message_ListSelect_Item

// The media content card for Actions on Google.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_MediaContent = src.Intent_Message_MediaContent
type Intent_Message_MediaContent_ = src.Intent_Message_MediaContent_

// Response media object for media content card.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_MediaContent_ResponseMediaObject = src.Intent_Message_MediaContent_ResponseMediaObject
type Intent_Message_MediaContent_ResponseMediaObject_Icon = src.Intent_Message_MediaContent_ResponseMediaObject_Icon
type Intent_Message_MediaContent_ResponseMediaObject_LargeImage = src.Intent_Message_MediaContent_ResponseMediaObject_LargeImage

// Format of response media type.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_MediaContent_ResponseMediaType = src.Intent_Message_MediaContent_ResponseMediaType
type Intent_Message_Payload = src.Intent_Message_Payload

// Represents different platforms that a rich message can be intended for.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_Platform = src.Intent_Message_Platform

// The quick replies response message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_QuickReplies = src.Intent_Message_QuickReplies
type Intent_Message_QuickReplies_ = src.Intent_Message_QuickReplies_

// Rich Business Messaging (RBM) Card content
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmCardContent = src.Intent_Message_RbmCardContent

// Rich Business Messaging (RBM) Media displayed in Cards The following
// media-types are currently supported: # Image Types * image/jpeg * image/jpg'
// * image/gif * image/png # Video Types * video/h263 * video/m4v * video/mp4 *
// video/mpeg * video/mpeg4 * video/webm
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmCardContent_RbmMedia = src.Intent_Message_RbmCardContent_RbmMedia

// Media height
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmCardContent_RbmMedia_Height = src.Intent_Message_RbmCardContent_RbmMedia_Height

// Carousel Rich Business Messaging (RBM) rich card. Rich cards allow you to
// respond to users with more vivid content, e.g. with media and suggestions.
// If you want to show a single card with more control over the layout, please
// use
// [RbmStandaloneCard][google.cloud.dialogflow.v2beta1.Intent.Message.RbmStandaloneCard]
// instead.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmCarouselCard = src.Intent_Message_RbmCarouselCard

// The width of the cards in the carousel.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmCarouselCard_CardWidth = src.Intent_Message_RbmCarouselCard_CardWidth
type Intent_Message_RbmCarouselRichCard = src.Intent_Message_RbmCarouselRichCard

// Standalone Rich Business Messaging (RBM) rich card. Rich cards allow you to
// respond to users with more vivid content, e.g. with media and suggestions.
// You can group multiple rich cards into one using
// [RbmCarouselCard][google.cloud.dialogflow.v2beta1.Intent.Message.RbmCarouselCard]
// but carousel cards will give you less control over the card layout.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmStandaloneCard = src.Intent_Message_RbmStandaloneCard

// Orientation of the card.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmStandaloneCard_CardOrientation = src.Intent_Message_RbmStandaloneCard_CardOrientation

// Thumbnail preview alignment for standalone cards with horizontal layout.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment = src.Intent_Message_RbmStandaloneCard_ThumbnailImageAlignment
type Intent_Message_RbmStandaloneRichCard = src.Intent_Message_RbmStandaloneRichCard

// Rich Business Messaging (RBM) suggested client-side action that the user
// can choose from the card.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmSuggestedAction = src.Intent_Message_RbmSuggestedAction
type Intent_Message_RbmSuggestedAction_Dial = src.Intent_Message_RbmSuggestedAction_Dial
type Intent_Message_RbmSuggestedAction_OpenUrl = src.Intent_Message_RbmSuggestedAction_OpenUrl

// Opens the user's default dialer app with the specified phone number but
// does not dial automatically.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial = src.Intent_Message_RbmSuggestedAction_RbmSuggestedActionDial

// Opens the user's default web browser app to the specified uri If the user
// has an app installed that is registered as the default handler for the URL,
// then this app will be opened instead, and its icon will be used in the
// suggested action UI.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri = src.Intent_Message_RbmSuggestedAction_RbmSuggestedActionOpenUri

// Opens the device's location chooser so the user can pick a location to send
// back to the agent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation = src.Intent_Message_RbmSuggestedAction_RbmSuggestedActionShareLocation
type Intent_Message_RbmSuggestedAction_ShareLocation = src.Intent_Message_RbmSuggestedAction_ShareLocation

// Rich Business Messaging (RBM) suggested reply that the user can click
// instead of typing in their own response.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmSuggestedReply = src.Intent_Message_RbmSuggestedReply

// Rich Business Messaging (RBM) suggestion. Suggestions allow user to easily
// select/click a predefined response or perform an action (like opening a web
// uri).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmSuggestion = src.Intent_Message_RbmSuggestion
type Intent_Message_RbmSuggestion_Action = src.Intent_Message_RbmSuggestion_Action
type Intent_Message_RbmSuggestion_Reply = src.Intent_Message_RbmSuggestion_Reply

// Rich Business Messaging (RBM) text response with suggestions.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_RbmText = src.Intent_Message_RbmText
type Intent_Message_RbmText_ = src.Intent_Message_RbmText_

// Additional info about the select item for when it is triggered in a dialog.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_SelectItemInfo = src.Intent_Message_SelectItemInfo

// The simple response message containing speech or text.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_SimpleResponse = src.Intent_Message_SimpleResponse

// The collection of simple response candidates. This message in
// `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_SimpleResponses = src.Intent_Message_SimpleResponses
type Intent_Message_SimpleResponses_ = src.Intent_Message_SimpleResponses_

// The suggestion chip message that the user can tap to quickly post a reply
// to the conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_Suggestion = src.Intent_Message_Suggestion

// The collection of suggestions.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_Suggestions = src.Intent_Message_Suggestions
type Intent_Message_Suggestions_ = src.Intent_Message_Suggestions_

// Table card for Actions on Google.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_TableCard = src.Intent_Message_TableCard

// Cell of
// [TableCardRow][google.cloud.dialogflow.v2beta1.Intent.Message.TableCardRow].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_TableCardCell = src.Intent_Message_TableCardCell

// Row of
// [TableCard][google.cloud.dialogflow.v2beta1.Intent.Message.TableCard].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_TableCardRow = src.Intent_Message_TableCardRow
type Intent_Message_TableCard_ = src.Intent_Message_TableCard_

// Plays audio from a file in Telephony Gateway.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_TelephonyPlayAudio = src.Intent_Message_TelephonyPlayAudio
type Intent_Message_TelephonyPlayAudio_ = src.Intent_Message_TelephonyPlayAudio_

// Synthesizes speech and plays back the synthesized audio to the caller in
// Telephony Gateway. Telephony Gateway takes the synthesizer settings from
// `DetectIntentResponse.output_audio_config` which can either be set at
// request-level or can come from the agent-level synthesizer config.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_TelephonySynthesizeSpeech = src.Intent_Message_TelephonySynthesizeSpeech
type Intent_Message_TelephonySynthesizeSpeech_ = src.Intent_Message_TelephonySynthesizeSpeech_
type Intent_Message_TelephonySynthesizeSpeech_Ssml = src.Intent_Message_TelephonySynthesizeSpeech_Ssml
type Intent_Message_TelephonySynthesizeSpeech_Text = src.Intent_Message_TelephonySynthesizeSpeech_Text

// Transfers the call in Telephony Gateway.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_TelephonyTransferCall = src.Intent_Message_TelephonyTransferCall
type Intent_Message_TelephonyTransferCall_ = src.Intent_Message_TelephonyTransferCall_

// The text response message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Message_Text = src.Intent_Message_Text
type Intent_Message_Text_ = src.Intent_Message_Text_

// Represents intent parameters.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_Parameter = src.Intent_Parameter

// Represents an example that the agent is trained on.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_TrainingPhrase = src.Intent_TrainingPhrase

// Represents a part of a training phrase.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_TrainingPhrase_Part = src.Intent_TrainingPhrase_Part

// Represents different types of training phrases.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_TrainingPhrase_Type = src.Intent_TrainingPhrase_Type

// Represents the different states that webhooks can be in.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Intent_WebhookState = src.Intent_WebhookState

// IntentsClient is the client API for Intents service. For semantics around
// ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type IntentsClient = src.IntentsClient

// IntentsServer is the server API for Intents service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type IntentsServer = src.IntentsServer

// Represents the result of querying a Knowledge base.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type KnowledgeAnswers = src.KnowledgeAnswers

// An answer from Knowledge Connector.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type KnowledgeAnswers_Answer = src.KnowledgeAnswers_Answer

// Represents the system's confidence that this knowledge answer is a good
// match for this conversational query.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type KnowledgeAnswers_Answer_MatchConfidenceLevel = src.KnowledgeAnswers_Answer_MatchConfidenceLevel

// A knowledge base represents a collection of knowledge documents that you
// provide to Dialogflow. Your knowledge documents contain information that may
// be useful during conversations with end-users. Some Dialogflow features use
// knowledge bases when looking for a response to an end-user input. For more
// information, see the [knowledge base
// guide](https://cloud.google.com/dialogflow/docs/how/knowledge-bases). Note:
// The `projects.agent.knowledgeBases` resource is deprecated; only use
// `projects.knowledgeBases`.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type KnowledgeBase = src.KnowledgeBase

// KnowledgeBasesClient is the client API for KnowledgeBases service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type KnowledgeBasesClient = src.KnowledgeBasesClient

// KnowledgeBasesServer is the server API for KnowledgeBases service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type KnowledgeBasesServer = src.KnowledgeBasesServer

// Metadata in google::longrunning::Operation for Knowledge operations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type KnowledgeOperationMetadata = src.KnowledgeOperationMetadata
type KnowledgeOperationMetadata_ExportOperationMetadata = src.KnowledgeOperationMetadata_ExportOperationMetadata

// States of the operation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type KnowledgeOperationMetadata_State = src.KnowledgeOperationMetadata_State

// Request message for
// [AnswerRecords.ListAnswerRecords][google.cloud.dialogflow.v2beta1.AnswerRecords.ListAnswerRecords].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListAnswerRecordsRequest = src.ListAnswerRecordsRequest

// Response message for
// [AnswerRecords.ListAnswerRecords][google.cloud.dialogflow.v2beta1.AnswerRecords.ListAnswerRecords].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListAnswerRecordsResponse = src.ListAnswerRecordsResponse

// The request message for
// [Contexts.ListContexts][google.cloud.dialogflow.v2beta1.Contexts.ListContexts].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListContextsRequest = src.ListContextsRequest

// The response message for
// [Contexts.ListContexts][google.cloud.dialogflow.v2beta1.Contexts.ListContexts].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListContextsResponse = src.ListContextsResponse

// The request message for
// [ConversationProfiles.ListConversationProfiles][google.cloud.dialogflow.v2beta1.ConversationProfiles.ListConversationProfiles].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListConversationProfilesRequest = src.ListConversationProfilesRequest

// The response message for
// [ConversationProfiles.ListConversationProfiles][google.cloud.dialogflow.v2beta1.ConversationProfiles.ListConversationProfiles].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListConversationProfilesResponse = src.ListConversationProfilesResponse

// The request message for
// [Conversations.ListConversations][google.cloud.dialogflow.v2beta1.Conversations.ListConversations].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListConversationsRequest = src.ListConversationsRequest

// The response message for
// [Conversations.ListConversations][google.cloud.dialogflow.v2beta1.Conversations.ListConversations].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListConversationsResponse = src.ListConversationsResponse

// Request message for
// [Documents.ListDocuments][google.cloud.dialogflow.v2beta1.Documents.ListDocuments].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListDocumentsRequest = src.ListDocumentsRequest

// Response message for
// [Documents.ListDocuments][google.cloud.dialogflow.v2beta1.Documents.ListDocuments].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListDocumentsResponse = src.ListDocumentsResponse

// The request message for
// [EntityTypes.ListEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.ListEntityTypes].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListEntityTypesRequest = src.ListEntityTypesRequest

// The response message for
// [EntityTypes.ListEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.ListEntityTypes].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListEntityTypesResponse = src.ListEntityTypesResponse

// The request message for
// [Environments.ListEnvironments][google.cloud.dialogflow.v2beta1.Environments.ListEnvironments].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListEnvironmentsRequest = src.ListEnvironmentsRequest

// The response message for
// [Environments.ListEnvironments][google.cloud.dialogflow.v2beta1.Environments.ListEnvironments].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListEnvironmentsResponse = src.ListEnvironmentsResponse

// The request message for
// [Intents.ListIntents][google.cloud.dialogflow.v2beta1.Intents.ListIntents].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListIntentsRequest = src.ListIntentsRequest

// The response message for
// [Intents.ListIntents][google.cloud.dialogflow.v2beta1.Intents.ListIntents].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListIntentsResponse = src.ListIntentsResponse

// Request message for
// [KnowledgeBases.ListKnowledgeBases][google.cloud.dialogflow.v2beta1.KnowledgeBases.ListKnowledgeBases].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListKnowledgeBasesRequest = src.ListKnowledgeBasesRequest

// Response message for
// [KnowledgeBases.ListKnowledgeBases][google.cloud.dialogflow.v2beta1.KnowledgeBases.ListKnowledgeBases].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListKnowledgeBasesResponse = src.ListKnowledgeBasesResponse

// The request message for
// [Conversations.ListMessages][google.cloud.dialogflow.v2beta1.Conversations.ListMessages].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListMessagesRequest = src.ListMessagesRequest

// The response message for
// [Conversations.ListMessages][google.cloud.dialogflow.v2beta1.Conversations.ListMessages].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListMessagesResponse = src.ListMessagesResponse

// The request message for
// [Participants.ListParticipants][google.cloud.dialogflow.v2beta1.Participants.ListParticipants].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListParticipantsRequest = src.ListParticipantsRequest

// The response message for
// [Participants.ListParticipants][google.cloud.dialogflow.v2beta1.Participants.ListParticipants].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListParticipantsResponse = src.ListParticipantsResponse

// The request message for
// [SessionEntityTypes.ListSessionEntityTypes][google.cloud.dialogflow.v2beta1.SessionEntityTypes.ListSessionEntityTypes].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListSessionEntityTypesRequest = src.ListSessionEntityTypesRequest

// The response message for
// [SessionEntityTypes.ListSessionEntityTypes][google.cloud.dialogflow.v2beta1.SessionEntityTypes.ListSessionEntityTypes].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListSessionEntityTypesResponse = src.ListSessionEntityTypesResponse

// The request message for
// [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions].
// Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListSuggestionsRequest = src.ListSuggestionsRequest

// The response message for
// [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions].
// Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListSuggestionsResponse = src.ListSuggestionsResponse

// The request message for
// [Versions.ListVersions][google.cloud.dialogflow.v2beta1.Versions.ListVersions].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListVersionsRequest = src.ListVersionsRequest

// The response message for
// [Versions.ListVersions][google.cloud.dialogflow.v2beta1.Versions.ListVersions].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ListVersionsResponse = src.ListVersionsResponse

// Defines logging behavior for conversation lifecycle events.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type LoggingConfig = src.LoggingConfig

// Represents a message posted into a conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Message = src.Message

// Represents the result of annotation for the message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type MessageAnnotation = src.MessageAnnotation

// Defines notification behavior.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type NotificationConfig = src.NotificationConfig

// Format of cloud pub/sub message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type NotificationConfig_MessageFormat = src.NotificationConfig_MessageFormat

// Represents the contents of the original request that was passed to the
// `[Streaming]DetectIntent` call.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type OriginalDetectIntentRequest = src.OriginalDetectIntentRequest

// Represents the natural language speech audio to be played to the end user.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type OutputAudio = src.OutputAudio

// Instructs the speech synthesizer how to generate the output audio content.
// If this audio config is supplied in a request, it overrides all existing
// text-to-speech settings applied to the agent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type OutputAudioConfig = src.OutputAudioConfig

// Audio encoding of the output audio format in Text-To-Speech.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type OutputAudioEncoding = src.OutputAudioEncoding

// Represents a conversation participant (human agent, virtual agent,
// end-user).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Participant = src.Participant

// Enumeration of the roles a participant can play in a conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Participant_Role = src.Participant_Role

// ParticipantsClient is the client API for Participants service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ParticipantsClient = src.ParticipantsClient

// ParticipantsServer is the server API for Participants service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ParticipantsServer = src.ParticipantsServer
type Participants_StreamingAnalyzeContentClient = src.Participants_StreamingAnalyzeContentClient
type Participants_StreamingAnalyzeContentServer = src.Participants_StreamingAnalyzeContentServer

// Represents the query input. It can contain either: 1. An audio config which
// instructs the speech recognizer how to process the speech audio. 2. A
// conversational query in the form of text. 3. An event that specifies which
// intent to trigger.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type QueryInput = src.QueryInput
type QueryInput_AudioConfig = src.QueryInput_AudioConfig
type QueryInput_Dtmf = src.QueryInput_Dtmf
type QueryInput_Event = src.QueryInput_Event
type QueryInput_Text = src.QueryInput_Text

// Represents the parameters of the conversational query.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type QueryParameters = src.QueryParameters

// Represents the result of conversational query or event processing.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type QueryResult = src.QueryResult

// Request message for
// [Documents.ReloadDocument][google.cloud.dialogflow.v2beta1.Documents.ReloadDocument].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ReloadDocumentRequest = src.ReloadDocumentRequest
type ReloadDocumentRequest_GcsSource = src.ReloadDocumentRequest_GcsSource

// Response messages from an automated agent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ResponseMessage = src.ResponseMessage

// Indicates that interaction with the Dialogflow agent has ended.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ResponseMessage_EndInteraction = src.ResponseMessage_EndInteraction
type ResponseMessage_EndInteraction_ = src.ResponseMessage_EndInteraction_

// Indicates that the conversation should be handed off to a human agent.
// Dialogflow only uses this to determine which conversations were handed off
// to a human agent for measurement purposes. What else to do with this signal
// is up to you and your handoff procedures. You may set this, for example: -
// In the entry fulfillment of a CX Page if entering the page indicates
// something went extremely wrong in the conversation. - In a webhook response
// when you determine that the customer issue can only be handled by a human.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ResponseMessage_LiveAgentHandoff = src.ResponseMessage_LiveAgentHandoff
type ResponseMessage_LiveAgentHandoff_ = src.ResponseMessage_LiveAgentHandoff_

// Represents an audio message that is composed of both segments synthesized
// from the Dialogflow agent prompts and ones hosted externally at the
// specified URIs.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ResponseMessage_MixedAudio = src.ResponseMessage_MixedAudio
type ResponseMessage_MixedAudio_ = src.ResponseMessage_MixedAudio_

// Represents one segment of audio.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ResponseMessage_MixedAudio_Segment = src.ResponseMessage_MixedAudio_Segment
type ResponseMessage_MixedAudio_Segment_Audio = src.ResponseMessage_MixedAudio_Segment_Audio
type ResponseMessage_MixedAudio_Segment_Uri = src.ResponseMessage_MixedAudio_Segment_Uri
type ResponseMessage_Payload = src.ResponseMessage_Payload

// Represents the signal that telles the client to transfer the phone call
// connected to the agent to a third-party endpoint.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ResponseMessage_TelephonyTransferCall = src.ResponseMessage_TelephonyTransferCall
type ResponseMessage_TelephonyTransferCall_ = src.ResponseMessage_TelephonyTransferCall_
type ResponseMessage_TelephonyTransferCall_PhoneNumber = src.ResponseMessage_TelephonyTransferCall_PhoneNumber
type ResponseMessage_TelephonyTransferCall_SipUri = src.ResponseMessage_TelephonyTransferCall_SipUri

// The text response message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ResponseMessage_Text = src.ResponseMessage_Text
type ResponseMessage_Text_ = src.ResponseMessage_Text_

// The request message for
// [Agents.RestoreAgent][google.cloud.dialogflow.v2beta1.Agents.RestoreAgent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type RestoreAgentRequest = src.RestoreAgentRequest
type RestoreAgentRequest_AgentContent = src.RestoreAgentRequest_AgentContent
type RestoreAgentRequest_AgentUri = src.RestoreAgentRequest_AgentUri

// The request message for
// [Agents.SearchAgents][google.cloud.dialogflow.v2beta1.Agents.SearchAgents].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SearchAgentsRequest = src.SearchAgentsRequest

// The response message for
// [Agents.SearchAgents][google.cloud.dialogflow.v2beta1.Agents.SearchAgents].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SearchAgentsResponse = src.SearchAgentsResponse

// The sentiment, such as positive/negative feeling or association, for a unit
// of analysis, such as the query text. See:
// https://cloud.google.com/natural-language/docs/basics#interpreting_sentiment_analysis_values
// for how to interpret the result.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Sentiment = src.Sentiment

// Configures the types of sentiment analysis to perform.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SentimentAnalysisRequestConfig = src.SentimentAnalysisRequestConfig

// The result of sentiment analysis. Sentiment analysis inspects user input
// and identifies the prevailing subjective opinion, especially to determine a
// user's attitude as positive, negative, or neutral. For
// [Participants.DetectIntent][], it needs to be configured in
// [DetectIntentRequest.query_params][google.cloud.dialogflow.v2beta1.DetectIntentRequest.query_params].
// For [Participants.StreamingDetectIntent][], it needs to be configured in
// [StreamingDetectIntentRequest.query_params][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.query_params].
// And for
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
// and
// [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent],
// it needs to be configured in
// [ConversationProfile.human_agent_assistant_config][google.cloud.dialogflow.v2beta1.ConversationProfile.human_agent_assistant_config]
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SentimentAnalysisResult = src.SentimentAnalysisResult

// A session represents a conversation between a Dialogflow agent and an
// end-user. You can create special entities, called session entities, during a
// session. Session entities can extend or replace custom entity types and only
// exist during the session that they were created for. All session data,
// including session entities, is stored by Dialogflow for 20 minutes. For more
// information, see the [session entity
// guide](https://cloud.google.com/dialogflow/docs/entities-session).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SessionEntityType = src.SessionEntityType

// The types of modifications for a session entity type.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SessionEntityType_EntityOverrideMode = src.SessionEntityType_EntityOverrideMode

// SessionEntityTypesClient is the client API for SessionEntityTypes service.
// For semantics around ctx use and closing/ending streaming RPCs, please refer
// to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SessionEntityTypesClient = src.SessionEntityTypesClient

// SessionEntityTypesServer is the server API for SessionEntityTypes service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SessionEntityTypesServer = src.SessionEntityTypesServer

// SessionsClient is the client API for Sessions service. For semantics around
// ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SessionsClient = src.SessionsClient

// SessionsServer is the server API for Sessions service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SessionsServer = src.SessionsServer
type Sessions_StreamingDetectIntentClient = src.Sessions_StreamingDetectIntentClient
type Sessions_StreamingDetectIntentServer = src.Sessions_StreamingDetectIntentServer

// The request message for
// [Agents.SetAgent][google.cloud.dialogflow.v2beta1.Agents.SetAgent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SetAgentRequest = src.SetAgentRequest

// Metadata for a [ConversationProfile.SetSuggestionFeatureConfig][]
// operation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SetSuggestionFeatureConfigOperationMetadata = src.SetSuggestionFeatureConfigOperationMetadata

// The request message for [ConversationProfiles.SetSuggestionFeature][].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SetSuggestionFeatureConfigRequest = src.SetSuggestionFeatureConfigRequest

// Represents a smart reply answer.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SmartReplyAnswer = src.SmartReplyAnswer

// Hints for the speech recognizer to help with recognition in a specific
// conversation state.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SpeechContext = src.SpeechContext

// Variant of the specified [Speech
// model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use. See
// the [Cloud Speech
// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
// for which models have different variants. For example, the "phone_call"
// model has both a standard and an enhanced variant. When you use an enhanced
// model, you will generally receive higher quality results than for a standard
// model.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SpeechModelVariant = src.SpeechModelVariant

// Configures speech transcription for
// [ConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfile].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SpeechToTextConfig = src.SpeechToTextConfig

// Information for a word recognized by the speech recognizer.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SpeechWordInfo = src.SpeechWordInfo

// Gender of the voice as described in [SSML voice
// element](https://www.w3.org/TR/speech-synthesis11/#edef_voice).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SsmlVoiceGender = src.SsmlVoiceGender

// The top-level message sent by the client to the
// [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
// method. Multiple request messages should be sent in order: 1. The first
// message must contain
// [participant][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.participant],
// [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
// and optionally
// [query_params][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.query_params].
// If you want to receive an audio response, it should also contain
// [reply_audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.reply_audio_config].
// The message must not contain
// [input][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input].
// 2. If
// [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
// in the first message was set to
// [audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.audio_config],
// all subsequent messages must contain
// [input_audio][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_audio]
// to continue with Speech recognition. If you decide to rather analyze text
// input after you already started Speech recognition, please send a message
// with
// [StreamingAnalyzeContentRequest.input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
// However, note that: * Dialogflow will bill you for the audio so far. *
// Dialogflow discards all Speech recognition results in favor of the text
// input. 3. If
// [StreamingAnalyzeContentRequest.config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
// in the first message was set to
// [StreamingAnalyzeContentRequest.text_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.text_config],
// then the second message must contain only
// [input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
// Moreover, you must not send more than two messages. After you sent all
// input, you must half-close or abort the request stream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type StreamingAnalyzeContentRequest = src.StreamingAnalyzeContentRequest
type StreamingAnalyzeContentRequest_AudioConfig = src.StreamingAnalyzeContentRequest_AudioConfig
type StreamingAnalyzeContentRequest_InputAudio = src.StreamingAnalyzeContentRequest_InputAudio
type StreamingAnalyzeContentRequest_InputDtmf = src.StreamingAnalyzeContentRequest_InputDtmf
type StreamingAnalyzeContentRequest_InputText = src.StreamingAnalyzeContentRequest_InputText
type StreamingAnalyzeContentRequest_TextConfig = src.StreamingAnalyzeContentRequest_TextConfig

// The top-level message returned from the `StreamingAnalyzeContent` method.
// Multiple response messages can be returned in order: 1. If the input was set
// to streaming audio, the first one or more messages contain
// `recognition_result`. Each `recognition_result` represents a more complete
// transcript of what the user said. The last `recognition_result` has
// `is_final` set to `true`. 2. In virtual agent stage: if
// `enable_partial_automated_agent_reply` is true, the following N (currently 1
// <= N <= 4) messages contain `automated_agent_reply` and optionally
// `reply_audio` returned by the virtual agent. The first (N-1)
// `automated_agent_reply`s will have `automated_agent_reply_type` set to
// `PARTIAL`. The last `automated_agent_reply` has `automated_agent_reply_type`
// set to `FINAL`. If `enable_partial_automated_agent_reply` is not enabled,
// response stream only contains the final reply. In human assist stage: the
// following N (N >= 1) messages contain `human_agent_suggestion_results`,
// `end_user_suggestion_results` or `message`.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type StreamingAnalyzeContentResponse = src.StreamingAnalyzeContentResponse

// The top-level message sent by the client to the
// [Sessions.StreamingDetectIntent][google.cloud.dialogflow.v2beta1.Sessions.StreamingDetectIntent]
// method. Multiple request messages should be sent in order: 1. The first
// message must contain
// [session][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.session],
// [query_input][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.query_input]
// plus optionally
// [query_params][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.query_params].
// If the client wants to receive an audio response, it should also contain
// [output_audio_config][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.output_audio_config].
// The message must not contain
// [input_audio][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.input_audio].
// 2. If
// [query_input][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.query_input]
// was set to
// [query_input.audio_config][google.cloud.dialogflow.v2beta1.InputAudioConfig],
// all subsequent messages must contain
// [input_audio][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.input_audio]
// to continue with Speech recognition. If you decide to rather detect an
// intent from text input after you already started Speech recognition, please
// send a message with
// [query_input.text][google.cloud.dialogflow.v2beta1.QueryInput.text].
// However, note that: * Dialogflow will bill you for the audio duration so
// far. * Dialogflow discards all Speech recognition results in favor of the
// input text. * Dialogflow will use the language code from the first message.
// After you sent all input, you must half-close or abort the request stream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type StreamingDetectIntentRequest = src.StreamingDetectIntentRequest

// The top-level message returned from the `StreamingDetectIntent` method.
// Multiple response messages can be returned in order: 1. If the
// `StreamingDetectIntentRequest.input_audio` field was set, the
// `recognition_result` field is populated for one or more messages. See the
// [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult]
// message for details about the result message sequence. 2. The next message
// contains `response_id`, `query_result`, `alternative_query_results` and
// optionally `webhook_status` if a WebHook was called. 3. If
// `output_audio_config` was specified in the request or agent-level speech
// synthesizer is configured, all subsequent messages contain `output_audio`
// and `output_audio_config`.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type StreamingDetectIntentResponse = src.StreamingDetectIntentResponse

// Contains a speech recognition result corresponding to a portion of the
// audio that is currently being processed or an indication that this is the
// end of the single requested utterance. While end-user audio is being
// processed, Dialogflow sends a series of results. Each result may contain a
// `transcript` value. A transcript represents a portion of the utterance.
// While the recognizer is processing audio, transcript values may be interim
// values or finalized values. Once a transcript is finalized, the `is_final`
// value is set to true and processing continues for the next transcript. If
// `StreamingDetectIntentRequest.query_input.audio_config.single_utterance` was
// true, and the recognizer has completed processing audio, the `message_type`
// value is set to `END_OF_SINGLE_UTTERANCE and the following (last) result
// contains the last finalized transcript. The complete end-user utterance is
// determined by concatenating the finalized transcript values received for the
// series of results. In the following example, single utterance is enabled. In
// the case where single utterance is not enabled, result 7 would not occur.
// ``` Num | transcript | message_type | is_final --- | -----------------------
// | ----------------------- | -------- 1 | "tube" | TRANSCRIPT | false 2 | "to
// be a" | TRANSCRIPT | false 3 | "to be" | TRANSCRIPT | false 4 | "to be or
// not to be" | TRANSCRIPT | true 5 | "that's" | TRANSCRIPT | false 6 | "that
// is | TRANSCRIPT | false 7 | unset | END_OF_SINGLE_UTTERANCE | unset 8 | "
// that is the question" | TRANSCRIPT | true ``` Concatenating the finalized
// transcripts with `is_final` set to true, the complete utterance becomes "to
// be or not to be that is the question".
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type StreamingRecognitionResult = src.StreamingRecognitionResult

// Type of the response message.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type StreamingRecognitionResult_MessageType = src.StreamingRecognitionResult_MessageType

// Contains basic configuration for a sub-agent.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SubAgent = src.SubAgent

// The request message for
// [Participants.SuggestArticles][google.cloud.dialogflow.v2beta1.Participants.SuggestArticles].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestArticlesRequest = src.SuggestArticlesRequest

// The response message for
// [Participants.SuggestArticles][google.cloud.dialogflow.v2beta1.Participants.SuggestArticles].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestArticlesResponse = src.SuggestArticlesResponse

// The request message for
// [Conversations.SuggestConversationSummary][google.cloud.dialogflow.v2beta1.Conversations.SuggestConversationSummary].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestConversationSummaryRequest = src.SuggestConversationSummaryRequest

// The response message for
// [Conversations.SuggestConversationSummary][google.cloud.dialogflow.v2beta1.Conversations.SuggestConversationSummary].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestConversationSummaryResponse = src.SuggestConversationSummaryResponse

// Generated summary for a conversation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestConversationSummaryResponse_Summary = src.SuggestConversationSummaryResponse_Summary

// The request message for
// [Participants.SuggestFaqAnswers][google.cloud.dialogflow.v2beta1.Participants.SuggestFaqAnswers].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestFaqAnswersRequest = src.SuggestFaqAnswersRequest

// The request message for
// [Participants.SuggestFaqAnswers][google.cloud.dialogflow.v2beta1.Participants.SuggestFaqAnswers].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestFaqAnswersResponse = src.SuggestFaqAnswersResponse

// The request message for
// [Participants.SuggestSmartReplies][google.cloud.dialogflow.v2beta1.Participants.SuggestSmartReplies].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestSmartRepliesRequest = src.SuggestSmartRepliesRequest

// The response message for
// [Participants.SuggestSmartReplies][google.cloud.dialogflow.v2beta1.Participants.SuggestSmartReplies].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestSmartRepliesResponse = src.SuggestSmartRepliesResponse

// Represents a suggestion for a human agent. Deprecated: Do not use.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Suggestion = src.Suggestion

// The type of Human Agent Assistant API suggestion to perform, and the
// maximum number of results to return for that type. Multiple `Feature`
// objects can be specified in the `features` list.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestionFeature = src.SuggestionFeature

// Defines the type of Human Agent Assistant feature.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestionFeature_Type = src.SuggestionFeature_Type

// One response of different type of suggestion response which is used in the
// response of
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
// and
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent],
// as well as
// [HumanAgentAssistantEvent][google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SuggestionResult = src.SuggestionResult
type SuggestionResult_Error = src.SuggestionResult_Error
type SuggestionResult_SuggestArticlesResponse = src.SuggestionResult_SuggestArticlesResponse
type SuggestionResult_SuggestFaqAnswersResponse = src.SuggestionResult_SuggestFaqAnswersResponse
type SuggestionResult_SuggestSmartRepliesResponse = src.SuggestionResult_SuggestSmartRepliesResponse

// Represents suggested article.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Suggestion_Article = src.Suggestion_Article

// Represents suggested answer from "frequently asked questions".
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Suggestion_FaqAnswer = src.Suggestion_FaqAnswer

// Configuration of how speech should be synthesized.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type SynthesizeSpeechConfig = src.SynthesizeSpeechConfig

// [DTMF](https://en.wikipedia.org/wiki/Dual-tone_multi-frequency_signaling)
// digit in Telephony Gateway.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type TelephonyDtmf = src.TelephonyDtmf

// A wrapper of repeated TelephonyDtmf digits.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type TelephonyDtmfEvents = src.TelephonyDtmfEvents

// Represents the natural language text to be processed.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type TextInput = src.TextInput

// Instructs the speech synthesizer on how to generate the output audio
// content.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type TextToSpeechSettings = src.TextToSpeechSettings

// The request message for
// [Agents.TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type TrainAgentRequest = src.TrainAgentRequest

// UnimplementedAgentsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedAgentsServer = src.UnimplementedAgentsServer

// UnimplementedAnswerRecordsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedAnswerRecordsServer = src.UnimplementedAnswerRecordsServer

// UnimplementedContextsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedContextsServer = src.UnimplementedContextsServer

// UnimplementedConversationProfilesServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedConversationProfilesServer = src.UnimplementedConversationProfilesServer

// UnimplementedConversationsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedConversationsServer = src.UnimplementedConversationsServer

// UnimplementedDocumentsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedDocumentsServer = src.UnimplementedDocumentsServer

// UnimplementedEntityTypesServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedEntityTypesServer = src.UnimplementedEntityTypesServer

// UnimplementedEnvironmentsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedEnvironmentsServer = src.UnimplementedEnvironmentsServer

// UnimplementedFulfillmentsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedFulfillmentsServer = src.UnimplementedFulfillmentsServer

// UnimplementedIntentsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedIntentsServer = src.UnimplementedIntentsServer

// UnimplementedKnowledgeBasesServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedKnowledgeBasesServer = src.UnimplementedKnowledgeBasesServer

// UnimplementedParticipantsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedParticipantsServer = src.UnimplementedParticipantsServer

// UnimplementedSessionEntityTypesServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedSessionEntityTypesServer = src.UnimplementedSessionEntityTypesServer

// UnimplementedSessionsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedSessionsServer = src.UnimplementedSessionsServer

// UnimplementedVersionsServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UnimplementedVersionsServer = src.UnimplementedVersionsServer

// Request message for
// [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateAnswerRecordRequest = src.UpdateAnswerRecordRequest

// The request message for
// [Contexts.UpdateContext][google.cloud.dialogflow.v2beta1.Contexts.UpdateContext].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateContextRequest = src.UpdateContextRequest

// The request message for
// [ConversationProfiles.UpdateConversationProfile][google.cloud.dialogflow.v2beta1.ConversationProfiles.UpdateConversationProfile].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateConversationProfileRequest = src.UpdateConversationProfileRequest

// Request message for
// [Documents.UpdateDocument][google.cloud.dialogflow.v2beta1.Documents.UpdateDocument].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateDocumentRequest = src.UpdateDocumentRequest

// The request message for
// [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2beta1.EntityTypes.UpdateEntityType].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateEntityTypeRequest = src.UpdateEntityTypeRequest

// The request message for
// [Environments.UpdateEnvironment][google.cloud.dialogflow.v2beta1.Environments.UpdateEnvironment].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateEnvironmentRequest = src.UpdateEnvironmentRequest

// The request message for
// [Fulfillments.UpdateFulfillment][google.cloud.dialogflow.v2beta1.Fulfillments.UpdateFulfillment].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateFulfillmentRequest = src.UpdateFulfillmentRequest

// The request message for
// [Intents.UpdateIntent][google.cloud.dialogflow.v2beta1.Intents.UpdateIntent].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateIntentRequest = src.UpdateIntentRequest

// Request message for
// [KnowledgeBases.UpdateKnowledgeBase][google.cloud.dialogflow.v2beta1.KnowledgeBases.UpdateKnowledgeBase].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateKnowledgeBaseRequest = src.UpdateKnowledgeBaseRequest

// The request message for
// [Participants.UpdateParticipant][google.cloud.dialogflow.v2beta1.Participants.UpdateParticipant].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateParticipantRequest = src.UpdateParticipantRequest

// The request message for
// [SessionEntityTypes.UpdateSessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityTypes.UpdateSessionEntityType].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateSessionEntityTypeRequest = src.UpdateSessionEntityTypeRequest

// The request message for
// [Versions.UpdateVersion][google.cloud.dialogflow.v2beta1.Versions.UpdateVersion].
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type UpdateVersionRequest = src.UpdateVersionRequest

// Represents a single validation error.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ValidationError = src.ValidationError

// Represents a level of severity.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ValidationError_Severity = src.ValidationError_Severity

// Represents the output of agent validation.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type ValidationResult = src.ValidationResult

// You can create multiple versions of your agent and publish them to separate
// environments. When you edit an agent, you are editing the draft agent. At
// any point, you can save the draft agent as an agent version, which is an
// immutable snapshot of your agent. When you save the draft agent, it is
// published to the default environment. When you create agent versions, you
// can publish them to custom environments. You can create a variety of custom
// environments for: - testing - development - production - etc. For more
// information, see the [versions and environments
// guide](https://cloud.google.com/dialogflow/docs/agents-versions).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Version = src.Version

// The status of a version.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type Version_VersionStatus = src.Version_VersionStatus

// VersionsClient is the client API for Versions service. For semantics around
// ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type VersionsClient = src.VersionsClient

// VersionsServer is the server API for Versions service.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type VersionsServer = src.VersionsServer

// Description of which voice to use for speech synthesis.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type VoiceSelectionParams = src.VoiceSelectionParams

// The request message for a webhook call.
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type WebhookRequest = src.WebhookRequest

// The response message for a webhook call. This response is validated by the
// Dialogflow server. If validation fails, an error will be returned in the
// [QueryResult.diagnostic_info][google.cloud.dialogflow.v2beta1.QueryResult.diagnostic_info]
// field. Setting JSON fields to an empty value with the wrong type is a common
// error. To avoid this error: - Use `""` for empty strings - Use `{}` or
// `null` for empty objects - Use `[]` or `null` for empty arrays For more
// information, see the [Protocol Buffers Language
// Guide](https://developers.google.com/protocol-buffers/docs/proto3#json).
//
// Deprecated: Please use types in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
type WebhookResponse = src.WebhookResponse

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewAgentsClient(cc grpc.ClientConnInterface) AgentsClient { return src.NewAgentsClient(cc) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewAnswerRecordsClient(cc grpc.ClientConnInterface) AnswerRecordsClient {
	return src.NewAnswerRecordsClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewContextsClient(cc grpc.ClientConnInterface) ContextsClient { return src.NewContextsClient(cc) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewConversationProfilesClient(cc grpc.ClientConnInterface) ConversationProfilesClient {
	return src.NewConversationProfilesClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewConversationsClient(cc grpc.ClientConnInterface) ConversationsClient {
	return src.NewConversationsClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewDocumentsClient(cc grpc.ClientConnInterface) DocumentsClient {
	return src.NewDocumentsClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewEntityTypesClient(cc grpc.ClientConnInterface) EntityTypesClient {
	return src.NewEntityTypesClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewEnvironmentsClient(cc grpc.ClientConnInterface) EnvironmentsClient {
	return src.NewEnvironmentsClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewFulfillmentsClient(cc grpc.ClientConnInterface) FulfillmentsClient {
	return src.NewFulfillmentsClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewIntentsClient(cc grpc.ClientConnInterface) IntentsClient { return src.NewIntentsClient(cc) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewKnowledgeBasesClient(cc grpc.ClientConnInterface) KnowledgeBasesClient {
	return src.NewKnowledgeBasesClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewParticipantsClient(cc grpc.ClientConnInterface) ParticipantsClient {
	return src.NewParticipantsClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewSessionEntityTypesClient(cc grpc.ClientConnInterface) SessionEntityTypesClient {
	return src.NewSessionEntityTypesClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewSessionsClient(cc grpc.ClientConnInterface) SessionsClient { return src.NewSessionsClient(cc) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func NewVersionsClient(cc grpc.ClientConnInterface) VersionsClient { return src.NewVersionsClient(cc) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterAgentsServer(s *grpc.Server, srv AgentsServer) { src.RegisterAgentsServer(s, srv) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterAnswerRecordsServer(s *grpc.Server, srv AnswerRecordsServer) {
	src.RegisterAnswerRecordsServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterContextsServer(s *grpc.Server, srv ContextsServer) { src.RegisterContextsServer(s, srv) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterConversationProfilesServer(s *grpc.Server, srv ConversationProfilesServer) {
	src.RegisterConversationProfilesServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterConversationsServer(s *grpc.Server, srv ConversationsServer) {
	src.RegisterConversationsServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterDocumentsServer(s *grpc.Server, srv DocumentsServer) {
	src.RegisterDocumentsServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterEntityTypesServer(s *grpc.Server, srv EntityTypesServer) {
	src.RegisterEntityTypesServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterEnvironmentsServer(s *grpc.Server, srv EnvironmentsServer) {
	src.RegisterEnvironmentsServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterFulfillmentsServer(s *grpc.Server, srv FulfillmentsServer) {
	src.RegisterFulfillmentsServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterIntentsServer(s *grpc.Server, srv IntentsServer) { src.RegisterIntentsServer(s, srv) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterKnowledgeBasesServer(s *grpc.Server, srv KnowledgeBasesServer) {
	src.RegisterKnowledgeBasesServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterParticipantsServer(s *grpc.Server, srv ParticipantsServer) {
	src.RegisterParticipantsServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterSessionEntityTypesServer(s *grpc.Server, srv SessionEntityTypesServer) {
	src.RegisterSessionEntityTypesServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) { src.RegisterSessionsServer(s, srv) }

// Deprecated: Please use funcs in: cloud.google.com/go/dialogflow/apiv2beta1/dialogflowpb
func RegisterVersionsServer(s *grpc.Server, srv VersionsServer) { src.RegisterVersionsServer(s, srv) }
