// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/engine/enginepb/mvcc3.proto

package enginepb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import bytes "bytes"

import binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// TODO(tschottdorf): Should not live in enginepb (but can't live in roachpb
// either).
type IsolationType int32

const (
	SERIALIZABLE IsolationType = 0
	SNAPSHOT     IsolationType = 1
)

var IsolationType_name = map[int32]string{
	0: "SERIALIZABLE",
	1: "SNAPSHOT",
}
var IsolationType_value = map[string]int32{
	"SERIALIZABLE": 0,
	"SNAPSHOT":     1,
}

func (x IsolationType) String() string {
	return proto.EnumName(IsolationType_name, int32(x))
}
func (IsolationType) EnumDescriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{0} }

// TxnMeta is the metadata of a Transaction record.
type TxnMeta struct {
	// id is a unique UUID value which identifies the transaction.
	// This field is always filled in.
	ID        github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=id,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"id"`
	Isolation IsolationType                                       `protobuf:"varint,2,opt,name=isolation,proto3,enum=cockroach.storage.engine.enginepb.IsolationType" json:"isolation,omitempty"`
	// key is the key which anchors the transaction. This is typically
	// the first key read or written during the transaction and
	// determines which range in the cluster will hold the transaction
	// record.
	Key []byte `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Incremented on txn retry.
	Epoch uint32 `protobuf:"varint,4,opt,name=epoch,proto3" json:"epoch,omitempty"`
	// The proposed timestamp for the transaction. This starts as the
	// current wall time on the txn coordinator. This is the timestamp
	// at which all of the transaction's writes are performed: even if
	// intents have been laid down at different timestamps, the process
	// of resolving them (e.g. when the txn commits) will bump them to
	// this timestamp. SERIALIZABLE transactions only commit when
	// timestamp == orig_timestamp. SNAPSHOT transactions can commit
	// even when they've performed their reads (at orig_timestamp) at a
	// different timestamp than their writes (at timestamp).
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=timestamp" json:"timestamp"`
	Priority  int32                        `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// A one-indexed sequence number which is increased on each request
	// sent as part of the transaction. When set in the header of a batch
	// of requests, the value will correspond to the sequence number of the
	// last request. Used to prevent replay and out-of-order application
	// protection (by means of a transaction retry).
	Sequence int32 `protobuf:"varint,7,opt,name=sequence,proto3" json:"sequence,omitempty"`
	// A zero-indexed sequence number indicating the index of a command
	// within a batch. This disambiguate Raft replays of a batch from
	// multiple commands in a batch which modify the same key. The field
	// has now been deprecated because each request in a batch is now
	// given its own sequence number.
	//
	// TODO(nvanbenschoten): Remove this field and its uses entirely
	// in 2.2. This is safe because the field is only set on pending
	// intents by transactions with 2.0 coordinators. 2.1 nodes need
	// to be able to handle the field so they can interop with 2.0 nodes.
	// However, 2.2 nodes will not, because all transactions started by
	// 2.0 nodes will necessarily be abandoned for 2.2 nodes to join a
	// cluster.
	DeprecatedBatchIndex int32 `protobuf:"varint,8,opt,name=deprecated_batch_index,json=deprecatedBatchIndex,proto3" json:"deprecated_batch_index,omitempty"`
}

func (m *TxnMeta) Reset()                    { *m = TxnMeta{} }
func (m *TxnMeta) String() string            { return proto.CompactTextString(m) }
func (*TxnMeta) ProtoMessage()               {}
func (*TxnMeta) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{0} }

// MVCCStatsDelta is convertible to MVCCStats, but uses signed variable width
// encodings for most fields that make it more efficient to store negative
// values. This makes the encodings incompatible.
type MVCCStatsDelta struct {
	// TODO(nvanbenschoten): now that we've split MVCCPersistentStats
	// from this MVCCStatsDelta type, we can turn contains_estimates
	// into a three-valued type ('UNCHANGED', 'NO', and 'YES').
	ContainsEstimates bool  `protobuf:"varint,14,opt,name=contains_estimates,json=containsEstimates,proto3" json:"contains_estimates,omitempty"`
	LastUpdateNanos   int64 `protobuf:"fixed64,1,opt,name=last_update_nanos,json=lastUpdateNanos,proto3" json:"last_update_nanos,omitempty"`
	IntentAge         int64 `protobuf:"fixed64,2,opt,name=intent_age,json=intentAge,proto3" json:"intent_age,omitempty"`
	GCBytesAge        int64 `protobuf:"fixed64,3,opt,name=gc_bytes_age,json=gcBytesAge,proto3" json:"gc_bytes_age,omitempty"`
	LiveBytes         int64 `protobuf:"zigzag64,4,opt,name=live_bytes,json=liveBytes,proto3" json:"live_bytes,omitempty"`
	LiveCount         int64 `protobuf:"zigzag64,5,opt,name=live_count,json=liveCount,proto3" json:"live_count,omitempty"`
	KeyBytes          int64 `protobuf:"zigzag64,6,opt,name=key_bytes,json=keyBytes,proto3" json:"key_bytes,omitempty"`
	KeyCount          int64 `protobuf:"zigzag64,7,opt,name=key_count,json=keyCount,proto3" json:"key_count,omitempty"`
	ValBytes          int64 `protobuf:"zigzag64,8,opt,name=val_bytes,json=valBytes,proto3" json:"val_bytes,omitempty"`
	ValCount          int64 `protobuf:"zigzag64,9,opt,name=val_count,json=valCount,proto3" json:"val_count,omitempty"`
	IntentBytes       int64 `protobuf:"zigzag64,10,opt,name=intent_bytes,json=intentBytes,proto3" json:"intent_bytes,omitempty"`
	IntentCount       int64 `protobuf:"zigzag64,11,opt,name=intent_count,json=intentCount,proto3" json:"intent_count,omitempty"`
	SysBytes          int64 `protobuf:"zigzag64,12,opt,name=sys_bytes,json=sysBytes,proto3" json:"sys_bytes,omitempty"`
	SysCount          int64 `protobuf:"zigzag64,13,opt,name=sys_count,json=sysCount,proto3" json:"sys_count,omitempty"`
}

func (m *MVCCStatsDelta) Reset()                    { *m = MVCCStatsDelta{} }
func (m *MVCCStatsDelta) String() string            { return proto.CompactTextString(m) }
func (*MVCCStatsDelta) ProtoMessage()               {}
func (*MVCCStatsDelta) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{1} }

// MVCCPersistentStats is convertible to MVCCStats, but uses signed variable
// width encodings for most fields that make it efficient to store positive
// values but inefficient to store negative values. This makes the encodings
// incompatible.
type MVCCPersistentStats struct {
	ContainsEstimates bool  `protobuf:"varint,14,opt,name=contains_estimates,json=containsEstimates,proto3" json:"contains_estimates,omitempty"`
	LastUpdateNanos   int64 `protobuf:"fixed64,1,opt,name=last_update_nanos,json=lastUpdateNanos,proto3" json:"last_update_nanos,omitempty"`
	IntentAge         int64 `protobuf:"fixed64,2,opt,name=intent_age,json=intentAge,proto3" json:"intent_age,omitempty"`
	GCBytesAge        int64 `protobuf:"fixed64,3,opt,name=gc_bytes_age,json=gcBytesAge,proto3" json:"gc_bytes_age,omitempty"`
	LiveBytes         int64 `protobuf:"varint,4,opt,name=live_bytes,json=liveBytes,proto3" json:"live_bytes,omitempty"`
	LiveCount         int64 `protobuf:"varint,5,opt,name=live_count,json=liveCount,proto3" json:"live_count,omitempty"`
	KeyBytes          int64 `protobuf:"varint,6,opt,name=key_bytes,json=keyBytes,proto3" json:"key_bytes,omitempty"`
	KeyCount          int64 `protobuf:"varint,7,opt,name=key_count,json=keyCount,proto3" json:"key_count,omitempty"`
	ValBytes          int64 `protobuf:"varint,8,opt,name=val_bytes,json=valBytes,proto3" json:"val_bytes,omitempty"`
	ValCount          int64 `protobuf:"varint,9,opt,name=val_count,json=valCount,proto3" json:"val_count,omitempty"`
	IntentBytes       int64 `protobuf:"varint,10,opt,name=intent_bytes,json=intentBytes,proto3" json:"intent_bytes,omitempty"`
	IntentCount       int64 `protobuf:"varint,11,opt,name=intent_count,json=intentCount,proto3" json:"intent_count,omitempty"`
	SysBytes          int64 `protobuf:"varint,12,opt,name=sys_bytes,json=sysBytes,proto3" json:"sys_bytes,omitempty"`
	SysCount          int64 `protobuf:"varint,13,opt,name=sys_count,json=sysCount,proto3" json:"sys_count,omitempty"`
}

func (m *MVCCPersistentStats) Reset()                    { *m = MVCCPersistentStats{} }
func (m *MVCCPersistentStats) String() string            { return proto.CompactTextString(m) }
func (*MVCCPersistentStats) ProtoMessage()               {}
func (*MVCCPersistentStats) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{2} }

// RangeAppliedState combines the raft and lease applied indices with
// mvcc stats. These are all persisted on each transition of the Raft
// state machine (i.e. on each Raft application), so they are stored
// in the same RocksDB key for efficiency.
type RangeAppliedState struct {
	// raft_applied_index is the highest (and last) index applied to the Raft
	// state machine.
	RaftAppliedIndex uint64 `protobuf:"varint,1,opt,name=raft_applied_index,json=raftAppliedIndex,proto3" json:"raft_applied_index,omitempty"`
	// lease_applied_index is the highest (and last) lease index applied to the
	// Raft state machine.
	LeaseAppliedIndex uint64 `protobuf:"varint,2,opt,name=lease_applied_index,json=leaseAppliedIndex,proto3" json:"lease_applied_index,omitempty"`
	// range_stats is the set of mvcc stats that accounts for the current value
	// of the Raft state machine.
	RangeStats MVCCPersistentStats `protobuf:"bytes,3,opt,name=range_stats,json=rangeStats" json:"range_stats"`
}

func (m *RangeAppliedState) Reset()                    { *m = RangeAppliedState{} }
func (m *RangeAppliedState) String() string            { return proto.CompactTextString(m) }
func (*RangeAppliedState) ProtoMessage()               {}
func (*RangeAppliedState) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{3} }

// MVCCWriteValueOp corresponds to a value being written outside of a
// transaction.
type MVCCWriteValueOp struct {
	Key       []byte                       `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
	Value     []byte                       `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *MVCCWriteValueOp) Reset()                    { *m = MVCCWriteValueOp{} }
func (m *MVCCWriteValueOp) String() string            { return proto.CompactTextString(m) }
func (*MVCCWriteValueOp) ProtoMessage()               {}
func (*MVCCWriteValueOp) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{4} }

// MVCCUpdateIntentOp corresponds to an intent being written for a given
// transaction.
type MVCCWriteIntentOp struct {
	TxnID     github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	TxnKey    []byte                                              `protobuf:"bytes,2,opt,name=txn_key,json=txnKey,proto3" json:"txn_key,omitempty"`
	Timestamp cockroach_util_hlc.Timestamp                        `protobuf:"bytes,3,opt,name=timestamp" json:"timestamp"`
}

func (m *MVCCWriteIntentOp) Reset()                    { *m = MVCCWriteIntentOp{} }
func (m *MVCCWriteIntentOp) String() string            { return proto.CompactTextString(m) }
func (*MVCCWriteIntentOp) ProtoMessage()               {}
func (*MVCCWriteIntentOp) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{5} }

// MVCCUpdateIntentOp corresponds to an intent being updates at a larger
// timestamp for a given transaction.
type MVCCUpdateIntentOp struct {
	TxnID     github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	Timestamp cockroach_util_hlc.Timestamp                        `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *MVCCUpdateIntentOp) Reset()                    { *m = MVCCUpdateIntentOp{} }
func (m *MVCCUpdateIntentOp) String() string            { return proto.CompactTextString(m) }
func (*MVCCUpdateIntentOp) ProtoMessage()               {}
func (*MVCCUpdateIntentOp) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{6} }

// MVCCCommitIntentOp corresponds to an intent being committed for a given
// transaction.
type MVCCCommitIntentOp struct {
	TxnID     github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	Key       []byte                                              `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Timestamp cockroach_util_hlc.Timestamp                        `protobuf:"bytes,3,opt,name=timestamp" json:"timestamp"`
	Value     []byte                                              `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *MVCCCommitIntentOp) Reset()                    { *m = MVCCCommitIntentOp{} }
func (m *MVCCCommitIntentOp) String() string            { return proto.CompactTextString(m) }
func (*MVCCCommitIntentOp) ProtoMessage()               {}
func (*MVCCCommitIntentOp) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{7} }

// MVCCAbortIntentOp corresponds to an intent being aborted for a given
// transaction.
type MVCCAbortIntentOp struct {
	TxnID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
}

func (m *MVCCAbortIntentOp) Reset()                    { *m = MVCCAbortIntentOp{} }
func (m *MVCCAbortIntentOp) String() string            { return proto.CompactTextString(m) }
func (*MVCCAbortIntentOp) ProtoMessage()               {}
func (*MVCCAbortIntentOp) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{8} }

// MVCCLogicalOp is a union of all logical MVCC operation types.
type MVCCLogicalOp struct {
	WriteValue   *MVCCWriteValueOp   `protobuf:"bytes,1,opt,name=write_value,json=writeValue" json:"write_value,omitempty"`
	WriteIntent  *MVCCWriteIntentOp  `protobuf:"bytes,2,opt,name=write_intent,json=writeIntent" json:"write_intent,omitempty"`
	UpdateIntent *MVCCUpdateIntentOp `protobuf:"bytes,3,opt,name=update_intent,json=updateIntent" json:"update_intent,omitempty"`
	CommitIntent *MVCCCommitIntentOp `protobuf:"bytes,4,opt,name=commit_intent,json=commitIntent" json:"commit_intent,omitempty"`
	AbortIntent  *MVCCAbortIntentOp  `protobuf:"bytes,5,opt,name=abort_intent,json=abortIntent" json:"abort_intent,omitempty"`
}

func (m *MVCCLogicalOp) Reset()                    { *m = MVCCLogicalOp{} }
func (m *MVCCLogicalOp) String() string            { return proto.CompactTextString(m) }
func (*MVCCLogicalOp) ProtoMessage()               {}
func (*MVCCLogicalOp) Descriptor() ([]byte, []int) { return fileDescriptorMvcc3, []int{9} }

func init() {
	proto.RegisterType((*TxnMeta)(nil), "cockroach.storage.engine.enginepb.TxnMeta")
	proto.RegisterType((*MVCCStatsDelta)(nil), "cockroach.storage.engine.enginepb.MVCCStatsDelta")
	proto.RegisterType((*MVCCPersistentStats)(nil), "cockroach.storage.engine.enginepb.MVCCPersistentStats")
	proto.RegisterType((*RangeAppliedState)(nil), "cockroach.storage.engine.enginepb.RangeAppliedState")
	proto.RegisterType((*MVCCWriteValueOp)(nil), "cockroach.storage.engine.enginepb.MVCCWriteValueOp")
	proto.RegisterType((*MVCCWriteIntentOp)(nil), "cockroach.storage.engine.enginepb.MVCCWriteIntentOp")
	proto.RegisterType((*MVCCUpdateIntentOp)(nil), "cockroach.storage.engine.enginepb.MVCCUpdateIntentOp")
	proto.RegisterType((*MVCCCommitIntentOp)(nil), "cockroach.storage.engine.enginepb.MVCCCommitIntentOp")
	proto.RegisterType((*MVCCAbortIntentOp)(nil), "cockroach.storage.engine.enginepb.MVCCAbortIntentOp")
	proto.RegisterType((*MVCCLogicalOp)(nil), "cockroach.storage.engine.enginepb.MVCCLogicalOp")
	proto.RegisterEnum("cockroach.storage.engine.enginepb.IsolationType", IsolationType_name, IsolationType_value)
}
func (this *TxnMeta) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TxnMeta)
	if !ok {
		that2, ok := that.(TxnMeta)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ID.Equal(that1.ID) {
		return false
	}
	if this.Isolation != that1.Isolation {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if this.Epoch != that1.Epoch {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	if this.Priority != that1.Priority {
		return false
	}
	if this.Sequence != that1.Sequence {
		return false
	}
	if this.DeprecatedBatchIndex != that1.DeprecatedBatchIndex {
		return false
	}
	return true
}
func (this *MVCCStatsDelta) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MVCCStatsDelta)
	if !ok {
		that2, ok := that.(MVCCStatsDelta)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ContainsEstimates != that1.ContainsEstimates {
		return false
	}
	if this.LastUpdateNanos != that1.LastUpdateNanos {
		return false
	}
	if this.IntentAge != that1.IntentAge {
		return false
	}
	if this.GCBytesAge != that1.GCBytesAge {
		return false
	}
	if this.LiveBytes != that1.LiveBytes {
		return false
	}
	if this.LiveCount != that1.LiveCount {
		return false
	}
	if this.KeyBytes != that1.KeyBytes {
		return false
	}
	if this.KeyCount != that1.KeyCount {
		return false
	}
	if this.ValBytes != that1.ValBytes {
		return false
	}
	if this.ValCount != that1.ValCount {
		return false
	}
	if this.IntentBytes != that1.IntentBytes {
		return false
	}
	if this.IntentCount != that1.IntentCount {
		return false
	}
	if this.SysBytes != that1.SysBytes {
		return false
	}
	if this.SysCount != that1.SysCount {
		return false
	}
	return true
}
func (this *MVCCPersistentStats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MVCCPersistentStats)
	if !ok {
		that2, ok := that.(MVCCPersistentStats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ContainsEstimates != that1.ContainsEstimates {
		return false
	}
	if this.LastUpdateNanos != that1.LastUpdateNanos {
		return false
	}
	if this.IntentAge != that1.IntentAge {
		return false
	}
	if this.GCBytesAge != that1.GCBytesAge {
		return false
	}
	if this.LiveBytes != that1.LiveBytes {
		return false
	}
	if this.LiveCount != that1.LiveCount {
		return false
	}
	if this.KeyBytes != that1.KeyBytes {
		return false
	}
	if this.KeyCount != that1.KeyCount {
		return false
	}
	if this.ValBytes != that1.ValBytes {
		return false
	}
	if this.ValCount != that1.ValCount {
		return false
	}
	if this.IntentBytes != that1.IntentBytes {
		return false
	}
	if this.IntentCount != that1.IntentCount {
		return false
	}
	if this.SysBytes != that1.SysBytes {
		return false
	}
	if this.SysCount != that1.SysCount {
		return false
	}
	return true
}
func (this *RangeAppliedState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeAppliedState)
	if !ok {
		that2, ok := that.(RangeAppliedState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RaftAppliedIndex != that1.RaftAppliedIndex {
		return false
	}
	if this.LeaseAppliedIndex != that1.LeaseAppliedIndex {
		return false
	}
	if !this.RangeStats.Equal(&that1.RangeStats) {
		return false
	}
	return true
}
func (m *TxnMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.ID.Size()))
	n1, err := m.ID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.Isolation != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.Isolation))
	}
	if len(m.Key) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.Epoch != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.Epoch))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n2, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.Priority != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.Priority))
	}
	if m.Sequence != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.Sequence))
	}
	if m.DeprecatedBatchIndex != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.DeprecatedBatchIndex))
	}
	return i, nil
}

func (m *MVCCStatsDelta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCStatsDelta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LastUpdateNanos != 0 {
		dAtA[i] = 0x9
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.LastUpdateNanos))
		i += 8
	}
	if m.IntentAge != 0 {
		dAtA[i] = 0x11
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.IntentAge))
		i += 8
	}
	if m.GCBytesAge != 0 {
		dAtA[i] = 0x19
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.GCBytesAge))
		i += 8
	}
	if m.LiveBytes != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.LiveBytes)<<1)^uint64((m.LiveBytes>>63))))
	}
	if m.LiveCount != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.LiveCount)<<1)^uint64((m.LiveCount>>63))))
	}
	if m.KeyBytes != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.KeyBytes)<<1)^uint64((m.KeyBytes>>63))))
	}
	if m.KeyCount != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.KeyCount)<<1)^uint64((m.KeyCount>>63))))
	}
	if m.ValBytes != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.ValBytes)<<1)^uint64((m.ValBytes>>63))))
	}
	if m.ValCount != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.ValCount)<<1)^uint64((m.ValCount>>63))))
	}
	if m.IntentBytes != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.IntentBytes)<<1)^uint64((m.IntentBytes>>63))))
	}
	if m.IntentCount != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.IntentCount)<<1)^uint64((m.IntentCount>>63))))
	}
	if m.SysBytes != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.SysBytes)<<1)^uint64((m.SysBytes>>63))))
	}
	if m.SysCount != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.SysCount)<<1)^uint64((m.SysCount>>63))))
	}
	if m.ContainsEstimates {
		dAtA[i] = 0x70
		i++
		if m.ContainsEstimates {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *MVCCPersistentStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCPersistentStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LastUpdateNanos != 0 {
		dAtA[i] = 0x9
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.LastUpdateNanos))
		i += 8
	}
	if m.IntentAge != 0 {
		dAtA[i] = 0x11
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.IntentAge))
		i += 8
	}
	if m.GCBytesAge != 0 {
		dAtA[i] = 0x19
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.GCBytesAge))
		i += 8
	}
	if m.LiveBytes != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.LiveBytes))
	}
	if m.LiveCount != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.LiveCount))
	}
	if m.KeyBytes != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.KeyBytes))
	}
	if m.KeyCount != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.KeyCount))
	}
	if m.ValBytes != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.ValBytes))
	}
	if m.ValCount != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.ValCount))
	}
	if m.IntentBytes != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.IntentBytes))
	}
	if m.IntentCount != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.IntentCount))
	}
	if m.SysBytes != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.SysBytes))
	}
	if m.SysCount != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.SysCount))
	}
	if m.ContainsEstimates {
		dAtA[i] = 0x70
		i++
		if m.ContainsEstimates {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RangeAppliedState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeAppliedState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftAppliedIndex != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.RaftAppliedIndex))
	}
	if m.LeaseAppliedIndex != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.LeaseAppliedIndex))
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.RangeStats.Size()))
	n3, err := m.RangeStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func (m *MVCCWriteValueOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCWriteValueOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n4, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if len(m.Value) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *MVCCWriteIntentOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCWriteIntentOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n5, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if len(m.TxnKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.TxnKey)))
		i += copy(dAtA[i:], m.TxnKey)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n6, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	return i, nil
}

func (m *MVCCUpdateIntentOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCUpdateIntentOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n7, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	dAtA[i] = 0x12
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n8, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	return i, nil
}

func (m *MVCCCommitIntentOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCCommitIntentOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n9, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	if len(m.Key) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n10, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if len(m.Value) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *MVCCAbortIntentOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCAbortIntentOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n11, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *MVCCLogicalOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCLogicalOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.WriteValue != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.WriteValue.Size()))
		n12, err := m.WriteValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.WriteIntent != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.WriteIntent.Size()))
		n13, err := m.WriteIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.UpdateIntent != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.UpdateIntent.Size()))
		n14, err := m.UpdateIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.CommitIntent != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.CommitIntent.Size()))
		n15, err := m.CommitIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.AbortIntent != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.AbortIntent.Size()))
		n16, err := m.AbortIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func encodeVarintMvcc3(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedTxnMeta(r randyMvcc3, easy bool) *TxnMeta {
	this := &TxnMeta{}
	v1 := github_com_cockroachdb_cockroach_pkg_util_uuid.NewPopulatedUUID(r)
	this.ID = *v1
	this.Isolation = IsolationType([]int32{0, 1}[r.Intn(2)])
	v2 := r.Intn(100)
	this.Key = make([]byte, v2)
	for i := 0; i < v2; i++ {
		this.Key[i] = byte(r.Intn(256))
	}
	this.Epoch = uint32(r.Uint32())
	v3 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v3
	this.Priority = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Priority *= -1
	}
	this.Sequence = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Sequence *= -1
	}
	this.DeprecatedBatchIndex = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.DeprecatedBatchIndex *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMVCCPersistentStats(r randyMvcc3, easy bool) *MVCCPersistentStats {
	this := &MVCCPersistentStats{}
	this.LastUpdateNanos = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LastUpdateNanos *= -1
	}
	this.IntentAge = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentAge *= -1
	}
	this.GCBytesAge = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.GCBytesAge *= -1
	}
	this.LiveBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LiveBytes *= -1
	}
	this.LiveCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LiveCount *= -1
	}
	this.KeyBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyBytes *= -1
	}
	this.KeyCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyCount *= -1
	}
	this.ValBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValBytes *= -1
	}
	this.ValCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValCount *= -1
	}
	this.IntentBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentBytes *= -1
	}
	this.IntentCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentCount *= -1
	}
	this.SysBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.SysBytes *= -1
	}
	this.SysCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.SysCount *= -1
	}
	this.ContainsEstimates = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedRangeAppliedState(r randyMvcc3, easy bool) *RangeAppliedState {
	this := &RangeAppliedState{}
	this.RaftAppliedIndex = uint64(uint64(r.Uint32()))
	this.LeaseAppliedIndex = uint64(uint64(r.Uint32()))
	v4 := NewPopulatedMVCCPersistentStats(r, easy)
	this.RangeStats = *v4
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyMvcc3 interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMvcc3(r randyMvcc3) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMvcc3(r randyMvcc3) string {
	v5 := r.Intn(100)
	tmps := make([]rune, v5)
	for i := 0; i < v5; i++ {
		tmps[i] = randUTF8RuneMvcc3(r)
	}
	return string(tmps)
}
func randUnrecognizedMvcc3(r randyMvcc3, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMvcc3(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMvcc3(dAtA []byte, r randyMvcc3, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(key))
		v6 := r.Int63()
		if r.Intn(2) == 0 {
			v6 *= -1
		}
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(v6))
	case 1:
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMvcc3(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *TxnMeta) Size() (n int) {
	var l int
	_ = l
	l = m.ID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	if m.Isolation != 0 {
		n += 1 + sovMvcc3(uint64(m.Isolation))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.Epoch != 0 {
		n += 1 + sovMvcc3(uint64(m.Epoch))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	if m.Priority != 0 {
		n += 1 + sovMvcc3(uint64(m.Priority))
	}
	if m.Sequence != 0 {
		n += 1 + sovMvcc3(uint64(m.Sequence))
	}
	if m.DeprecatedBatchIndex != 0 {
		n += 1 + sovMvcc3(uint64(m.DeprecatedBatchIndex))
	}
	return n
}

func (m *MVCCStatsDelta) Size() (n int) {
	var l int
	_ = l
	if m.LastUpdateNanos != 0 {
		n += 9
	}
	if m.IntentAge != 0 {
		n += 9
	}
	if m.GCBytesAge != 0 {
		n += 9
	}
	if m.LiveBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.LiveBytes))
	}
	if m.LiveCount != 0 {
		n += 1 + sozMvcc3(uint64(m.LiveCount))
	}
	if m.KeyBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.KeyBytes))
	}
	if m.KeyCount != 0 {
		n += 1 + sozMvcc3(uint64(m.KeyCount))
	}
	if m.ValBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.ValBytes))
	}
	if m.ValCount != 0 {
		n += 1 + sozMvcc3(uint64(m.ValCount))
	}
	if m.IntentBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.IntentBytes))
	}
	if m.IntentCount != 0 {
		n += 1 + sozMvcc3(uint64(m.IntentCount))
	}
	if m.SysBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.SysBytes))
	}
	if m.SysCount != 0 {
		n += 1 + sozMvcc3(uint64(m.SysCount))
	}
	if m.ContainsEstimates {
		n += 2
	}
	return n
}

func (m *MVCCPersistentStats) Size() (n int) {
	var l int
	_ = l
	if m.LastUpdateNanos != 0 {
		n += 9
	}
	if m.IntentAge != 0 {
		n += 9
	}
	if m.GCBytesAge != 0 {
		n += 9
	}
	if m.LiveBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.LiveBytes))
	}
	if m.LiveCount != 0 {
		n += 1 + sovMvcc3(uint64(m.LiveCount))
	}
	if m.KeyBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.KeyBytes))
	}
	if m.KeyCount != 0 {
		n += 1 + sovMvcc3(uint64(m.KeyCount))
	}
	if m.ValBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.ValBytes))
	}
	if m.ValCount != 0 {
		n += 1 + sovMvcc3(uint64(m.ValCount))
	}
	if m.IntentBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.IntentBytes))
	}
	if m.IntentCount != 0 {
		n += 1 + sovMvcc3(uint64(m.IntentCount))
	}
	if m.SysBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.SysBytes))
	}
	if m.SysCount != 0 {
		n += 1 + sovMvcc3(uint64(m.SysCount))
	}
	if m.ContainsEstimates {
		n += 2
	}
	return n
}

func (m *RangeAppliedState) Size() (n int) {
	var l int
	_ = l
	if m.RaftAppliedIndex != 0 {
		n += 1 + sovMvcc3(uint64(m.RaftAppliedIndex))
	}
	if m.LeaseAppliedIndex != 0 {
		n += 1 + sovMvcc3(uint64(m.LeaseAppliedIndex))
	}
	l = m.RangeStats.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCWriteValueOp) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	return n
}

func (m *MVCCWriteIntentOp) Size() (n int) {
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.TxnKey)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCUpdateIntentOp) Size() (n int) {
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCCommitIntentOp) Size() (n int) {
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	return n
}

func (m *MVCCAbortIntentOp) Size() (n int) {
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCLogicalOp) Size() (n int) {
	var l int
	_ = l
	if m.WriteValue != nil {
		l = m.WriteValue.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.WriteIntent != nil {
		l = m.WriteIntent.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.UpdateIntent != nil {
		l = m.UpdateIntent.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.CommitIntent != nil {
		l = m.CommitIntent.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.AbortIntent != nil {
		l = m.AbortIntent.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	return n
}

func sovMvcc3(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMvcc3(x uint64) (n int) {
	return sovMvcc3(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *MVCCLogicalOp) GetValue() interface{} {
	if this.WriteValue != nil {
		return this.WriteValue
	}
	if this.WriteIntent != nil {
		return this.WriteIntent
	}
	if this.UpdateIntent != nil {
		return this.UpdateIntent
	}
	if this.CommitIntent != nil {
		return this.CommitIntent
	}
	if this.AbortIntent != nil {
		return this.AbortIntent
	}
	return nil
}

func (this *MVCCLogicalOp) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *MVCCWriteValueOp:
		this.WriteValue = vt
	case *MVCCWriteIntentOp:
		this.WriteIntent = vt
	case *MVCCUpdateIntentOp:
		this.UpdateIntent = vt
	case *MVCCCommitIntentOp:
		this.CommitIntent = vt
	case *MVCCAbortIntentOp:
		this.AbortIntent = vt
	default:
		return false
	}
	return true
}
func (m *TxnMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Isolation", wireType)
			}
			m.Isolation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Isolation |= (IsolationType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedBatchIndex", wireType)
			}
			m.DeprecatedBatchIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DeprecatedBatchIndex |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCStatsDelta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCStatsDelta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCStatsDelta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateNanos", wireType)
			}
			m.LastUpdateNanos = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.LastUpdateNanos = int64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentAge", wireType)
			}
			m.IntentAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentAge = int64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCBytesAge", wireType)
			}
			m.GCBytesAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.GCBytesAge = int64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.LiveBytes = int64(v)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.LiveCount = int64(v)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.KeyBytes = int64(v)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.KeyCount = int64(v)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.ValBytes = int64(v)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.ValCount = int64(v)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.IntentBytes = int64(v)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.IntentCount = int64(v)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.SysBytes = int64(v)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.SysCount = int64(v)
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainsEstimates", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainsEstimates = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCPersistentStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCPersistentStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCPersistentStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateNanos", wireType)
			}
			m.LastUpdateNanos = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.LastUpdateNanos = int64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentAge", wireType)
			}
			m.IntentAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentAge = int64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCBytesAge", wireType)
			}
			m.GCBytesAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.GCBytesAge = int64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveBytes", wireType)
			}
			m.LiveBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LiveBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveCount", wireType)
			}
			m.LiveCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LiveCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyBytes", wireType)
			}
			m.KeyBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyCount", wireType)
			}
			m.KeyCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValBytes", wireType)
			}
			m.ValBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValCount", wireType)
			}
			m.ValCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentBytes", wireType)
			}
			m.IntentBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntentBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentCount", wireType)
			}
			m.IntentCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntentCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysBytes", wireType)
			}
			m.SysBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SysBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysCount", wireType)
			}
			m.SysCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SysCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainsEstimates", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainsEstimates = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeAppliedState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeAppliedState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeAppliedState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftAppliedIndex", wireType)
			}
			m.RaftAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseAppliedIndex", wireType)
			}
			m.LeaseAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RangeStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCWriteValueOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCWriteValueOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCWriteValueOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCWriteIntentOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCWriteIntentOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCWriteIntentOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TxnKey = append(m.TxnKey[:0], dAtA[iNdEx:postIndex]...)
			if m.TxnKey == nil {
				m.TxnKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCUpdateIntentOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCUpdateIntentOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCUpdateIntentOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCCommitIntentOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCCommitIntentOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCCommitIntentOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCAbortIntentOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCAbortIntentOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCAbortIntentOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCLogicalOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCLogicalOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCLogicalOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteValue == nil {
				m.WriteValue = &MVCCWriteValueOp{}
			}
			if err := m.WriteValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteIntent == nil {
				m.WriteIntent = &MVCCWriteIntentOp{}
			}
			if err := m.WriteIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateIntent == nil {
				m.UpdateIntent = &MVCCUpdateIntentOp{}
			}
			if err := m.UpdateIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommitIntent == nil {
				m.CommitIntent = &MVCCCommitIntentOp{}
			}
			if err := m.CommitIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AbortIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AbortIntent == nil {
				m.AbortIntent = &MVCCAbortIntentOp{}
			}
			if err := m.AbortIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMvcc3(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMvcc3
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMvcc3
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMvcc3(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMvcc3 = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMvcc3   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("storage/engine/enginepb/mvcc3.proto", fileDescriptorMvcc3) }

var fileDescriptorMvcc3 = []byte{
	// 1079 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0xaf, 0xe3, 0xa4, 0x4d, 0x5e, 0xd2, 0x92, 0xce, 0x56, 0x10, 0x15, 0x6d, 0x92, 0x0d, 0x97,
	0x68, 0x05, 0xce, 0xaa, 0xdd, 0xe5, 0xd0, 0x5b, 0xd2, 0x56, 0x10, 0xd1, 0x6d, 0x97, 0x69, 0xba,
	0x2b, 0x2d, 0x42, 0xd6, 0xc4, 0x19, 0x9c, 0x51, 0x1d, 0xdb, 0xd8, 0x93, 0x6e, 0x73, 0xe0, 0xce,
	0x0d, 0x3e, 0x42, 0x25, 0xbe, 0x02, 0x07, 0x3e, 0x42, 0x0f, 0x1c, 0xb8, 0x20, 0xa1, 0x15, 0xaa,
	0x20, 0x5c, 0xf8, 0x00, 0x5c, 0x91, 0xd0, 0xcc, 0xd8, 0x4e, 0xb2, 0x82, 0xf4, 0x9f, 0x54, 0x71,
	0x8a, 0xdf, 0xfb, 0xbd, 0xdf, 0x7b, 0xf3, 0xe6, 0xf7, 0xfc, 0x1c, 0x78, 0x2f, 0xe4, 0x5e, 0x40,
	0x6c, 0xda, 0xa0, 0xae, 0xcd, 0xdc, 0xf8, 0xc7, 0xef, 0x36, 0x06, 0x27, 0x96, 0xb5, 0x69, 0xf8,
	0x81, 0xc7, 0x3d, 0xf4, 0xc0, 0xf2, 0xac, 0xe3, 0xc0, 0x23, 0x56, 0xdf, 0x88, 0xc2, 0x0d, 0x15,
	0x67, 0xc4, 0xe1, 0xeb, 0xa5, 0x21, 0x67, 0x4e, 0xa3, 0xef, 0x58, 0x0d, 0xce, 0x06, 0x34, 0xe4,
	0x64, 0xe0, 0x2b, 0xf2, 0xfa, 0x9a, 0xed, 0xd9, 0x9e, 0x7c, 0x6c, 0x88, 0x27, 0xe5, 0xad, 0x7d,
	0xa3, 0xc3, 0x52, 0xe7, 0xd4, 0x7d, 0x4a, 0x39, 0x41, 0x9f, 0x42, 0x8a, 0xf5, 0x4a, 0x5a, 0x55,
	0xab, 0x17, 0x5a, 0xcd, 0xf3, 0x8b, 0xca, 0xc2, 0xeb, 0x8b, 0xca, 0xa6, 0xcd, 0x78, 0x7f, 0xd8,
	0x35, 0x2c, 0x6f, 0xd0, 0x48, 0xaa, 0xf7, 0xba, 0x93, 0xe7, 0x86, 0x7f, 0x6c, 0x37, 0x64, 0xd1,
	0xe1, 0x90, 0xf5, 0x8c, 0xa3, 0xa3, 0xf6, 0xce, 0xf8, 0xa2, 0x92, 0x6a, 0xef, 0xe0, 0x14, 0xeb,
	0xa1, 0x7d, 0xc8, 0xb1, 0xd0, 0x73, 0x08, 0x67, 0x9e, 0x5b, 0x4a, 0x55, 0xb5, 0xfa, 0xca, 0xc6,
	0x23, 0xe3, 0xd2, 0x2e, 0x8c, 0x76, 0xcc, 0xe9, 0x8c, 0x7c, 0x8a, 0x27, 0x29, 0x50, 0x11, 0xf4,
	0x63, 0x3a, 0x2a, 0xe9, 0xe2, 0x8c, 0x58, 0x3c, 0xa2, 0x35, 0xc8, 0x50, 0xdf, 0xb3, 0xfa, 0xa5,
	0x74, 0x55, 0xab, 0x2f, 0x63, 0x65, 0xa0, 0x26, 0xe4, 0x92, 0xfe, 0x4b, 0x99, 0xaa, 0x56, 0xcf,
	0x6f, 0xdc, 0x9f, 0xaa, 0x2b, 0xce, 0x6b, 0xf4, 0x1d, 0xcb, 0xe8, 0xc4, 0x41, 0xad, 0xb4, 0x68,
	0x18, 0x4f, 0x58, 0x68, 0x1d, 0xb2, 0x7e, 0xc0, 0xbc, 0x80, 0xf1, 0x51, 0x69, 0xb1, 0xaa, 0xd5,
	0x33, 0x38, 0xb1, 0x05, 0x16, 0xd2, 0x2f, 0x87, 0xd4, 0xb5, 0x68, 0x69, 0x49, 0x61, 0xb1, 0x8d,
	0x1e, 0xc3, 0xdb, 0x3d, 0xea, 0x07, 0xd4, 0x22, 0x9c, 0xf6, 0xcc, 0x2e, 0xe1, 0x56, 0xdf, 0x64,
	0x6e, 0x8f, 0x9e, 0x96, 0xb2, 0x32, 0x72, 0x6d, 0x82, 0xb6, 0x04, 0xd8, 0x16, 0xd8, 0x56, 0xf6,
	0x87, 0xb3, 0x8a, 0xf6, 0xe7, 0x59, 0x45, 0xab, 0xfd, 0xa5, 0xc3, 0xca, 0xd3, 0xe7, 0xdb, 0xdb,
	0x87, 0x9c, 0xf0, 0x70, 0x87, 0x3a, 0x9c, 0xa0, 0x87, 0xb0, 0xea, 0x90, 0x90, 0x9b, 0x43, 0xbf,
	0x47, 0x38, 0x35, 0x5d, 0xe2, 0x7a, 0xa1, 0xd4, 0xa9, 0x88, 0xdf, 0x12, 0xc0, 0x91, 0xf4, 0xef,
	0x0b, 0x37, 0xba, 0x0f, 0xc0, 0x5c, 0x4e, 0x5d, 0x6e, 0x12, 0x9b, 0xca, 0x2b, 0x2f, 0xe2, 0x9c,
	0xf2, 0x34, 0x6d, 0x8a, 0x1e, 0x41, 0xc1, 0xb6, 0xcc, 0xee, 0x88, 0xd3, 0x50, 0x06, 0x88, 0x9b,
	0x2c, 0xb6, 0x56, 0xc6, 0x17, 0x15, 0xf8, 0x68, 0xbb, 0x25, 0xdc, 0x4d, 0x9b, 0x62, 0xb0, 0xad,
	0xf8, 0x59, 0x24, 0x74, 0xd8, 0x09, 0x55, 0x1c, 0x79, 0xcb, 0x08, 0xe7, 0x84, 0x47, 0x46, 0x24,
	0xb0, 0xe5, 0x0d, 0x5d, 0x2e, 0xaf, 0x3a, 0x82, 0xb7, 0x85, 0x03, 0xbd, 0x0b, 0xb9, 0x63, 0x3a,
	0x8a, 0xc8, 0x8b, 0x12, 0xcd, 0x1e, 0xd3, 0x91, 0xe2, 0x46, 0xa0, 0xa2, 0x2e, 0x25, 0x60, 0xc2,
	0x3c, 0x21, 0x4e, 0xc4, 0xcc, 0x2a, 0xf0, 0x84, 0x38, 0x09, 0x53, 0x80, 0x8a, 0x99, 0x4b, 0x40,
	0xc5, 0x7c, 0x00, 0x85, 0xe8, 0x0a, 0x14, 0x19, 0x24, 0x9e, 0x57, 0x3e, 0xc5, 0x9f, 0x84, 0xa8,
	0x14, 0xf9, 0xe9, 0x90, 0xa4, 0x7e, 0x38, 0x0a, 0xa3, 0x14, 0x05, 0x55, 0x22, 0x1c, 0x85, 0x49,
	0x7d, 0x01, 0x2a, 0xf2, 0x72, 0x02, 0x2a, 0xe6, 0x07, 0x80, 0x2c, 0xcf, 0xe5, 0x84, 0xb9, 0xa1,
	0x49, 0x43, 0xce, 0x06, 0x44, 0xa4, 0x58, 0xa9, 0x6a, 0xf5, 0x2c, 0x5e, 0x8d, 0x91, 0xdd, 0x18,
	0xd8, 0x4a, 0x4b, 0xd9, 0xff, 0xd6, 0xe1, 0x9e, 0x90, 0xfd, 0x19, 0x0d, 0x42, 0x16, 0x8a, 0x63,
	0xc8, 0x01, 0xf8, 0xbf, 0x69, 0xaf, 0xcf, 0xd7, 0x5e, 0x9f, 0xab, 0xbd, 0x3e, 0x4f, 0x7b, 0x7d,
	0x9e, 0xf6, 0xfa, 0x3c, 0xed, 0xf5, 0x4b, 0xb4, 0xd7, 0x2f, 0xd7, 0x5e, 0xbf, 0x44, 0x7b, 0x7d,
	0x9e, 0xf6, 0xfa, 0xcd, 0xb5, 0x9f, 0xbc, 0xf6, 0xaf, 0x35, 0x58, 0xc5, 0xc4, 0xb5, 0x69, 0xd3,
	0xf7, 0x1d, 0x46, 0x7b, 0x42, 0x7d, 0x8a, 0xde, 0x07, 0x14, 0x90, 0x2f, 0xb8, 0x49, 0x94, 0x33,
	0x5a, 0x24, 0x42, 0xfe, 0x34, 0x2e, 0x0a, 0x24, 0x8a, 0x96, 0x4b, 0x04, 0x19, 0x70, 0xcf, 0xa1,
	0x24, 0xa4, 0x6f, 0x84, 0xa7, 0x64, 0xf8, 0xaa, 0x84, 0x66, 0xe2, 0x3f, 0x87, 0x7c, 0x20, 0x4a,
	0x9a, 0xa1, 0x18, 0x35, 0x39, 0x0f, 0xf9, 0x8d, 0x0f, 0xaf, 0xb0, 0x9f, 0xff, 0x65, 0x50, 0xa3,
	0x05, 0x0a, 0x32, 0xa1, 0xf4, 0x4c, 0x35, 0xf7, 0x15, 0x14, 0x05, 0xe5, 0x45, 0xc0, 0x38, 0x7d,
	0x4e, 0x9c, 0x21, 0x3d, 0xf0, 0xe3, 0x55, 0xae, 0x4d, 0x56, 0xf9, 0xcc, 0xd2, 0x4e, 0xdd, 0x68,
	0x69, 0xaf, 0x41, 0xe6, 0x44, 0xe4, 0x8f, 0xbe, 0x10, 0xca, 0xa8, 0xfd, 0xa8, 0xc1, 0x6a, 0x52,
	0xbf, 0x2d, 0x75, 0x3e, 0xf0, 0xd1, 0x67, 0xb0, 0xc8, 0x4f, 0x5d, 0x33, 0xf9, 0xe4, 0xed, 0xdc,
	0xee, 0x93, 0x97, 0xe9, 0x9c, 0xba, 0xed, 0x1d, 0x9c, 0xe1, 0xa7, 0x6e, 0xbb, 0x87, 0xde, 0x81,
	0x25, 0x91, 0x5c, 0x74, 0x98, 0x92, 0x47, 0x11, 0xb5, 0x3e, 0x79, 0xb3, 0x49, 0xfd, 0x26, 0x4d,
	0xd6, 0xbe, 0xd7, 0x00, 0x89, 0x76, 0xd4, 0xab, 0x7f, 0x37, 0xfd, 0xdc, 0x5e, 0x9b, 0xda, 0xaf,
	0xd1, 0xb1, 0xb7, 0xbd, 0xc1, 0x80, 0xf1, 0xbb, 0x39, 0x76, 0x34, 0x64, 0xa9, 0xff, 0x18, 0x32,
	0xfd, 0x76, 0x43, 0x96, 0x9e, 0x1e, 0x32, 0x5f, 0xcd, 0x58, 0xb3, 0xeb, 0x05, 0x77, 0xd3, 0x5c,
	0xed, 0x67, 0x1d, 0x96, 0x45, 0xc9, 0x3d, 0xcf, 0x66, 0x16, 0x71, 0x0e, 0x7c, 0xd4, 0x81, 0xfc,
	0x2b, 0x31, 0xe3, 0xa6, 0x3a, 0x9f, 0x26, 0xdb, 0xdb, 0xbc, 0xe2, 0x0b, 0x3d, 0xfd, 0x76, 0x62,
	0x78, 0x95, 0x58, 0xe8, 0x05, 0x14, 0x54, 0x56, 0xb5, 0x22, 0x23, 0xf9, 0x1f, 0x5f, 0x27, 0x6d,
	0x7c, 0x21, 0x58, 0x9d, 0x4f, 0x99, 0xe8, 0x25, 0x2c, 0x47, 0x9f, 0xb5, 0x28, 0xb3, 0xd2, 0xe3,
	0xc9, 0x15, 0x33, 0xcf, 0xce, 0x3f, 0x2e, 0x0c, 0xa7, 0x6c, 0x91, 0xdb, 0x92, 0x83, 0x16, 0xe7,
	0x4e, 0x5f, 0x2b, 0xf7, 0xec, 0x90, 0xe2, 0x82, 0x35, 0x65, 0x8b, 0x0b, 0x21, 0x42, 0xe6, 0x38,
	0x75, 0xe6, 0x5a, 0x17, 0x32, 0x33, 0x21, 0x38, 0x4f, 0x26, 0xe6, 0x56, 0xfa, 0xfc, 0xac, 0xa2,
	0x3d, 0x7c, 0x02, 0xcb, 0x33, 0x7f, 0x80, 0x51, 0x11, 0x0a, 0x87, 0xbb, 0xb8, 0xdd, 0xdc, 0x6b,
	0xbf, 0x6c, 0xb6, 0xf6, 0x76, 0x8b, 0x0b, 0xa8, 0x00, 0xd9, 0xc3, 0xfd, 0xe6, 0xb3, 0xc3, 0x8f,
	0x0f, 0x3a, 0x45, 0x6d, 0x3d, 0xfd, 0xf5, 0x77, 0xe5, 0x85, 0x56, 0xe9, 0xfc, 0xf7, 0xf2, 0xc2,
	0xf9, 0xb8, 0xac, 0xfd, 0x34, 0x2e, 0x6b, 0xbf, 0x8c, 0xcb, 0xda, 0x6f, 0xe3, 0xb2, 0xf6, 0xed,
	0x1f, 0xe5, 0x85, 0xee, 0xa2, 0xfc, 0xaf, 0xbf, 0xf9, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x53,
	0xce, 0xdc, 0x9b, 0x65, 0x0c, 0x00, 0x00,
}
