//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbinaryarchivedomain?language=objc)
    pub static MTLBinaryArchiveDomain: &'static NSErrorDomain;
}

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbinaryarchiveerror?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLBinaryArchiveError(pub NSUInteger);
impl MTLBinaryArchiveError {
    #[doc(alias = "MTLBinaryArchiveErrorNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "MTLBinaryArchiveErrorInvalidFile")]
    pub const InvalidFile: Self = Self(1);
    #[doc(alias = "MTLBinaryArchiveErrorUnexpectedElement")]
    pub const UnexpectedElement: Self = Self(2);
    #[doc(alias = "MTLBinaryArchiveErrorCompilationFailure")]
    pub const CompilationFailure: Self = Self(3);
    #[doc(alias = "MTLBinaryArchiveErrorInternalError")]
    pub const InternalError: Self = Self(4);
}

unsafe impl Encode for MTLBinaryArchiveError {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLBinaryArchiveError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A class used to indicate how an archive should be created
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbinaryarchivedescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLBinaryArchiveDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLBinaryArchiveDescriptor {}
);

unsafe impl CopyingHelper for MTLBinaryArchiveDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLBinaryArchiveDescriptor {}
);

impl MTLBinaryArchiveDescriptor {
    extern_methods!(
        /// The file URL from which to open a MTLBinaryArchive, or nil to create an empty MTLBinaryArchive.
        #[unsafe(method(url))]
        #[unsafe(method_family = none)]
        pub fn url(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`url`][Self::url].
        #[unsafe(method(setUrl:))]
        #[unsafe(method_family = none)]
        pub fn setUrl(&self, url: Option<&NSURL>);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLBinaryArchiveDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for MTLBinaryArchiveDescriptor {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_protocol!(
    /// A container of pipeline state descriptors and their associated compiled code.
    ///
    /// A MTLBinaryArchive allows to persist compiled pipeline state objects for a device, which can be used to skip recompilation on a subsequent run of the app.
    /// One or more archives may be supplied in the descriptor of a pipeline state, allowing the device to attempt to look up compiled code in them before performing compilation.
    /// If no archives are provided, or no archives contain the requested content, the pipeline state is created by compiling the code as usual.
    /// Note that software updates of the OS or device drivers may cause the archive to become outdated, causing the lookup to fail and the usual path performing on-demand compilation is taken.
    /// A MTLBinaryArchive is populated by adding functions from pipeline state descriptors to it, indicating which compiled code should be persisted in the archive.
    /// Once all desired pipeline state descriptors have been added, use serializeToURL:error: to write the contents for the current device to disk.
    /// MTLBinaryArchive files generated for multiple different devices can be combined using the "lipo" tool into a single archive, which can then be shipped with the application.
    /// It is possible to maintain different archive files for different contexts; for example each level in a game may use a different cache object.
    /// Note: Metal maintains a separate cache of pipeline states on behalf of each app that contains all compiled code; this cache is populated as compilation occurs.
    /// This cache will automatically accelerate pipeline state creation after a pipeline is created for the first time.
    /// Use MTLBinaryArchive to augment that cache by accelerating pipeline state creation even on the first run of an app.
    /// Updating a MTLBinaryArchive at runtime in a shipping app configuration is not recommended; such a scenario requires corruption resiliency, careful storage space management and may cache hard-to-reproduce errors.
    /// These kind of issues are handled transparently by the Metal maintained cache, therefore we recommend that MTLBinaryArchive is populated during development time and shipped as an asset.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbinaryarchive?language=objc)
    pub unsafe trait MTLBinaryArchive: NSObjectProtocol {
        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        fn setLabel(&self, label: Option<&NSString>);

        #[cfg(feature = "MTLDevice")]
        /// The device this resource was created against.  This resource can only be used with this device.
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        #[cfg(feature = "MTLComputePipeline")]
        /// Add the function(s) from a compute pipeline state to the archive.
        ///
        /// Parameter `descriptor`: The descriptor from which function(s) will be added.
        ///
        /// Parameter `error`: If the function fails, this will be set to describe the failure. This can be (but is not required to be) an error from the MTLBinaryArchiveDomain domain.
        ///
        /// Returns: Whether or not the addition succeeded. Functions referenced multiple times are silently accepted.
        #[unsafe(method(addComputePipelineFunctionsWithDescriptor:error:_))]
        #[unsafe(method_family = none)]
        fn addComputePipelineFunctionsWithDescriptor_error(
            &self,
            descriptor: &MTLComputePipelineDescriptor,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "MTLRenderPipeline")]
        /// Add the function(s) from a render pipeline state to the archive.
        ///
        /// Parameter `descriptor`: The descriptor from which function(s) will be added.
        ///
        /// Parameter `error`: If the function fails, this will be set to describe the failure. This can be (but is not required to be) an error from the MTLBinaryArchiveDomain domain.
        ///
        /// Returns: Whether or not the addition succeeded. Functions referenced multiple times are silently accepted.
        #[unsafe(method(addRenderPipelineFunctionsWithDescriptor:error:_))]
        #[unsafe(method_family = none)]
        fn addRenderPipelineFunctionsWithDescriptor_error(
            &self,
            descriptor: &MTLRenderPipelineDescriptor,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "MTLRenderPipeline")]
        /// Add the function(s) from a tile render pipeline state to the archive.
        ///
        /// Parameter `descriptor`: The descriptor from which function(s) will be added.
        ///
        /// Parameter `error`: If the function fails, this will be set to describe the failure. This can be (but is not required to be) an error from the MTLBinaryArchiveDomain domain.
        ///
        /// Returns: Whether or not the addition succeeded. Functions referenced multiple times are silently accepted.
        #[unsafe(method(addTileRenderPipelineFunctionsWithDescriptor:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn addTileRenderPipelineFunctionsWithDescriptor_error(
            &self,
            descriptor: &MTLTileRenderPipelineDescriptor,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "MTLRenderPipeline")]
        /// Add the function(s) from a mesh render pipeline state to the archive.
        ///
        /// Parameter `descriptor`: The descriptor from which function(s) will be added.
        ///
        /// Parameter `error`: If the function fails, this will be set to describe the failure. This can be (but is not required to be) an error from the MTLBinaryArchiveDomain domain.
        ///
        /// Returns: Whether or not the addition succeeded. Functions referenced multiple times are silently accepted.
        #[unsafe(method(addMeshRenderPipelineFunctionsWithDescriptor:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn addMeshRenderPipelineFunctionsWithDescriptor_error(
            &self,
            descriptor: &MTLMeshRenderPipelineDescriptor,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "MTLFunctionStitching")]
        /// Add the function(s) from a stitched library to the archive.
        ///
        /// Parameter `descriptor`: The stitched library descriptor from which function(s) will be added.
        ///
        /// Parameter `error`: If the function fails, this will be set to describe the failure. This can be (but is not required to be) an error from the MTLBinaryArchiveDomain domain.
        ///
        /// Returns: Whether or not the addition succeeded. Functions referenced multiple times are silently accepted.
        #[unsafe(method(addLibraryWithDescriptor:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn addLibraryWithDescriptor_error(
            &self,
            descriptor: &MTLStitchedLibraryDescriptor,
        ) -> Result<(), Retained<NSError>>;

        /// Write the contents of a MTLBinaryArchive to a file.
        ///
        /// Persisting the archive to a file allows opening the archive on a subsequent instance of the app, making available the contents without recompiling.
        ///
        /// Parameter `url`: The file URL to which to write the file
        ///
        /// Parameter `error`: If the function fails, this will be set to describe the failure. This can be (but is not required to be) an error from the MTLBinaryArchiveDomain domain. Other possible errors can be file access or I/O related.
        ///
        /// Returns: Whether or not the writing the file succeeded.
        #[unsafe(method(serializeToURL:error:_))]
        #[unsafe(method_family = none)]
        fn serializeToURL_error(&self, url: &NSURL) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "MTLFunctionDescriptor", feature = "MTLLibrary"))]
        /// Add a `visible` or `intersection` function to the archive.
        ///
        /// Parameter `descriptor`: The descriptor from which the function will be added.
        ///
        /// Parameter `library`: Library of functions to add the function from.
        ///
        /// Parameter `error`: If the function fails, this will be set to describe the failure. This can be (but is not required to be) an error from the MTLBinaryArchiveDomain domain. Other possible errors can be file access or I/O related.
        ///
        /// Returns: Whether or not the addition succeeded. Functions referenced multiple times are silently accepted.
        #[unsafe(method(addFunctionWithDescriptor:library:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn addFunctionWithDescriptor_library_error(
            &self,
            descriptor: &MTLFunctionDescriptor,
            library: &ProtocolObject<dyn MTLLibrary>,
        ) -> Result<(), Retained<NSError>>;
    }
);
